/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.set;

import com.google.common.collect.Sets;
import com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import dev.apexstudios.apexcore.lib.data.ProviderType;
import dev.apexstudios.apexcore.lib.data.ProviderTypes;
import dev.apexstudios.apexcore.lib.data.pack.PackGenerator;
import dev.apexstudios.apexcore.lib.data.provider.context.ProviderListenerContext;
import dev.apexstudios.apexcore.lib.data.provider.tag.IntrusiveTagBuilder;
import dev.apexstudios.fantasyfurniture.set.BlockTypeBuilder;
import dev.apexstudios.fantasyfurniture.set.BlockTypeCopier;
import dev.apexstudios.fantasyfurniture.set.BlockTypes;
import dev.apexstudios.fantasyfurniture.set.FurnitureSet;
import dev.apexstudios.fantasyfurniture.set.function.BlockFactory;
import dev.apexstudios.fantasyfurniture.set.function.ItemFactory;
import dev.apexstudios.fantasyfurniture.set.function.ProviderListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.mixins.BlockEntityTypeAccessor;
import org.apache.commons.lang3.function.Consumers;
import org.jetbrains.annotations.Nullable;

public sealed class BlockType<TBlock extends Block> {
    protected final String registryName;
    protected final BiFunction<FurnitureSet, BlockBehaviour.Properties, BlockBehaviour.Properties> blockPropertiesModifier;
    protected final BlockFactory<TBlock> blockFactory;
    @Nullable
    protected final Supplier<? extends BlockEntityType<?>> blockEntityType;
    protected final Map<ProviderType<?>, ProviderListener<?, TBlock>> providerListeners;
    protected final BiConsumer<FurnitureSet, TBlock> onRegister;
    protected final BiConsumer<FurnitureSet, TBlock> onRegisterEnqueued;
    @Nullable
    protected final Supplier<? extends BlockBehaviour> baseBlock;
    protected final boolean usesMineableTag;
    protected final Set<TagKey<Block>> blockTags;

    private BlockType(BlockTypeBuilder<TBlock, ? extends BlockType<TBlock>, ?> builder) {
        this.registryName = builder.registryName;
        this.blockPropertiesModifier = builder.blockPropertiesModifier;
        this.blockFactory = builder.blockFactory;
        this.blockEntityType = builder.blockEntityType;
        this.providerListeners = Collections.unmodifiableMap(builder.providerListeners);
        this.onRegister = builder.onRegister;
        this.onRegisterEnqueued = builder.onRegisterEnqueued;
        this.baseBlock = builder.baseBlock;
        this.usesMineableTag = builder.usesMineableTag;
        this.blockTags = Set.copyOf(builder.blockTags);
    }

    public String registryName() {
        return this.registryName;
    }

    public BlockBehaviour.Properties blockProperties(FurnitureSet furnitureSet) {
        Supplier<? extends BlockBehaviour> baseBlock = Objects.requireNonNullElse(this.baseBlock, furnitureSet.baseBlock);
        return this.blockPropertiesModifier.apply(furnitureSet, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)baseBlock.get()).sound(furnitureSet.blockSet().soundType()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BlockType) {
            BlockType other = (BlockType)obj;
            return this.registryName.equals(other.registryName);
        }
        return false;
    }

    public int hashCode() {
        return this.registryName.hashCode();
    }

    public String toString() {
        return "BlockType{" + this.registryName + "}";
    }

    @OverridingMethodsMustInvokeSuper
    void register(IEventBus modBus, FurnitureSet furnitureSet) {
        String blockRegistryName = furnitureSet.registrationName(this.registryName);
        furnitureSet.registree.register(Registries.BLOCK, blockRegistryName, registryName -> this.blockFactory.create(furnitureSet, this.blockProperties(furnitureSet).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)registryName))));
        furnitureSet.registree.listenFor(Registries.BLOCK, blockRegistryName, block -> this.onRegister.accept(furnitureSet, block));
        modBus.addListener(FMLCommonSetupEvent.class, event -> event.enqueueWork(() -> this.onRegisterEnqueued.accept(furnitureSet, furnitureSet.getOrThrow(this))));
        if (this.blockEntityType != null) {
            modBus.addListener(BlockEntityTypeAddBlocksEvent.class, event -> this.markAsValidBlockEntityBlock(furnitureSet, this.blockEntityType.get()));
        }
    }

    @OverridingMethodsMustInvokeSuper
    void registerDataGen(PackGenerator<?> generator, FurnitureSet furnitureSet) {
        this.providerListeners.keySet().forEach(providerType -> this.registerProvider(generator, (ProviderType)providerType, furnitureSet));
        generator.providing(ProviderTypes.BLOCK_TAGS, (context, provider) -> this.blockTags.forEach(tag -> {
            Object block = furnitureSet.getOrThrow(this);
            ((IntrusiveTagBuilder)provider.tag(tag)).withElement(block);
            if (block.defaultBlockState().canBeReplaced()) {
                ((IntrusiveTagBuilder)provider.tag(BlockTags.REPLACEABLE)).withElement(block);
            }
        }));
    }

    private <TProvider> void registerProvider(PackGenerator<?> generator, ProviderType<TProvider> providerType, FurnitureSet furnitureSet) {
        generator.providing(providerType, (context, provider) -> this.providerListeners.get(providerType).accept((ProviderListenerContext)context, provider, furnitureSet, furnitureSet.getOrThrow(this)));
    }

    private void markAsValidBlockEntityBlock(FurnitureSet furnitureSet, BlockEntityType<?> blockEntityType) {
        HashSet validBlocks = Sets.newHashSet((Iterable)blockEntityType.getValidBlocks());
        validBlocks.add(furnitureSet.getOrThrow(this));
        ((BlockEntityTypeAccessor)blockEntityType).neoforge$setValidBlocks((Set)validBlocks);
    }

    public static <TBlock extends Block, TItem extends Item> WithItem<TBlock, TItem> withItem(String registryName, BlockFactory<TBlock> blockFactory, ItemFactory<TBlock, TItem> itemFactory, Consumer<BlockTypeBuilder.WithItem<TBlock, TItem>> consumer) {
        BlockTypeBuilder.WithItem<TBlock, TItem> builder = new BlockTypeBuilder.WithItem<TBlock, TItem>(registryName, blockFactory, itemFactory);
        consumer.accept(builder);
        return builder.build();
    }

    public static <TBlock extends Block, TItem extends Item> WithItem<TBlock, TItem> withItem(String registryName, BlockFactory<TBlock> blockFactory, ItemFactory<TBlock, TItem> itemFactory) {
        return BlockType.withItem(registryName, blockFactory, itemFactory, Consumers.nop());
    }

    public static <TBlock extends Block> WithItem<TBlock, BlockItem> withItem(String registryName, BlockFactory<TBlock> blockFactory, Consumer<BlockTypeBuilder.WithItem<TBlock, BlockItem>> consumer) {
        return BlockType.withItem(registryName, blockFactory, (furnitureSet, block, properties) -> new BlockItem(block, properties), consumer);
    }

    public static <TBlock extends Block> WithItem<TBlock, BlockItem> withItem(String registryName, BlockFactory<TBlock> blockFactory) {
        return BlockType.withItem(registryName, blockFactory, (furnitureSet, block, properties) -> new BlockItem(block, properties), Consumers.nop());
    }

    public static <TBlock extends Block> NoItem<TBlock> noItem(String registryName, BlockFactory<TBlock> blockFactory, Consumer<BlockTypeBuilder.NoItem<TBlock>> consumer) {
        BlockTypeBuilder.NoItem<TBlock> builder = new BlockTypeBuilder.NoItem<TBlock>(registryName, blockFactory);
        consumer.accept(builder);
        return builder.build();
    }

    public static <TBlock extends Block> NoItem<TBlock> noItem(String registryName, BlockFactory<TBlock> blockFactory) {
        return BlockType.noItem(registryName, blockFactory, Consumers.nop());
    }

    private static <TBlock extends Block, TItem extends Item> BiFunction<String, BlockFactory<TBlock>, BlockTypeBuilder.WithItem<TBlock, TItem>> withItemFactory(ItemFactory<TBlock, TItem> itemFactory) {
        return (registryName, blockFactory) -> new BlockTypeBuilder.WithItem((String)registryName, blockFactory, itemFactory);
    }

    static {
        BlockTypes.register();
    }

    public static final class WithItem<TBlock extends Block, TItem extends Item>
    extends BlockType<TBlock> {
        final BiFunction<FurnitureSet, Item.Properties, Item.Properties> itemPropertiesModifier;
        final ItemFactory<TBlock, TItem> itemFactory;
        final Set<TagKey<Item>> itemTags;

        WithItem(BlockTypeBuilder.WithItem<TBlock, TItem> builder) {
            super(builder);
            this.itemPropertiesModifier = builder.itemPropertiesModifier;
            this.itemFactory = builder.itemFactory;
            this.itemTags = Set.copyOf(builder.itemTags);
        }

        public Item.Properties itemProperties(FurnitureSet furnitureSet) {
            return this.itemPropertiesModifier.apply(furnitureSet, new Item.Properties());
        }

        public WithItem<TBlock, TItem> copy(Consumer<BlockTypeCopier.WithItem<TBlock, TItem>> consumer) {
            BlockTypeCopier.WithItem copier = new BlockTypeCopier.WithItem(this);
            consumer.accept(copier);
            return copier.compile();
        }

        public WithItem<TBlock, TItem> copyWithSuffix(String suffix) {
            return this.copy(copier -> copier.registryName(registryName -> registryName + suffix));
        }

        public NoItem<TBlock> copyNoItem(Consumer<BlockTypeCopier.NoItem<TBlock>> consumer) {
            BlockTypeCopier.NoItem copier = new BlockTypeCopier.NoItem(this);
            consumer.accept(copier);
            return copier.compile();
        }

        public WithItem<TBlock, TItem> extend(BlockFactory<TBlock> blockFactory, ItemFactory<TBlock, TItem> itemFactory) {
            return this.copy(copier -> ((BlockTypeCopier.WithItem)copier.blockFactory(blockFactory)).itemFactory(itemFactory));
        }

        public WithItem<TBlock, TItem> extend(BlockFactory<TBlock> blockFactory) {
            return this.copy(copier -> copier.blockFactory(blockFactory));
        }

        public WithItem<TBlock, TItem> extend(ItemFactory<TBlock, TItem> itemFactory) {
            return this.copy(copier -> copier.itemFactory(itemFactory));
        }

        @Override
        void register(IEventBus modBus, FurnitureSet furnitureSet) {
            super.register(modBus, furnitureSet);
            furnitureSet.registree.register(Registries.ITEM, furnitureSet.registrationName(this.registryName), registryName -> this.itemFactory.create(furnitureSet, furnitureSet.getOrThrow(this), this.itemProperties(furnitureSet).useBlockDescriptionPrefix().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)registryName))));
        }

        @Override
        void registerDataGen(PackGenerator<?> generator, FurnitureSet furnitureSet) {
            super.registerDataGen(generator, furnitureSet);
            generator.providing(ProviderTypes.ITEM_TAGS, (context, provider) -> this.itemTags.forEach(tag -> ((IntrusiveTagBuilder)provider.tag(tag)).withElement((Object)furnitureSet.getOrThrow(this).asItem())));
        }
    }

    public static final class NoItem<TBlock extends Block>
    extends BlockType<TBlock> {
        NoItem(BlockTypeBuilder.NoItem<TBlock> builder) {
            super(builder);
        }

        public NoItem<TBlock> copy(Consumer<BlockTypeCopier.NoItem<TBlock>> consumer) {
            BlockTypeCopier.NoItem copier = new BlockTypeCopier.NoItem(this);
            consumer.accept(copier);
            return copier.compile();
        }

        public NoItem<TBlock> copyWithSuffix(String suffix) {
            return this.copy(copier -> copier.registryName(registryName -> registryName + suffix));
        }

        public NoItem<TBlock> extend(BlockFactory<TBlock> blockFactory) {
            return this.copy(copier -> copier.blockFactory(blockFactory));
        }
    }
}

