/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.set;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dev.apexstudios.apexcore.lib.data.ProviderType;
import dev.apexstudios.apexcore.lib.data.ProviderTypes;
import dev.apexstudios.apexcore.lib.data.provider.RecipeProvider;
import dev.apexstudios.apexcore.lib.data.provider.loot.BlockLootSubProvider;
import dev.apexstudios.fantasyfurniture.set.BlockType;
import dev.apexstudios.fantasyfurniture.set.FurnitureSet;
import dev.apexstudios.fantasyfurniture.set.function.BlockFactory;
import dev.apexstudios.fantasyfurniture.set.function.BlockLootTableListener;
import dev.apexstudios.fantasyfurniture.set.function.ItemFactory;
import dev.apexstudios.fantasyfurniture.set.function.ModelProviderListener;
import dev.apexstudios.fantasyfurniture.set.function.ProviderListener;
import dev.apexstudios.fantasyfurniture.set.function.RecipeListener;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public abstract sealed class BlockTypeBuilder<TBlock extends Block, TType extends BlockType<TBlock>, TSelf extends BlockTypeBuilder<TBlock, TType, TSelf>> {
    final String registryName;
    final BlockFactory<TBlock> blockFactory;
    BiFunction<FurnitureSet, BlockBehaviour.Properties, BlockBehaviour.Properties> blockPropertiesModifier = (furnitureSet, properties) -> properties;
    @Nullable
    Supplier<? extends BlockEntityType<?>> blockEntityType = null;
    Map<ProviderType<?>, ProviderListener<?, TBlock>> providerListeners = Maps.newLinkedHashMap();
    BiConsumer<FurnitureSet, TBlock> onRegister = (furnitureSet, block) -> {};
    BiConsumer<FurnitureSet, TBlock> onRegisterEnqueued = (furnitureSet, block) -> {};
    @Nullable
    Supplier<? extends BlockBehaviour> baseBlock = null;
    boolean usesMineableTag = true;
    final Set<TagKey<Block>> blockTags = Sets.newHashSet();

    private BlockTypeBuilder(String registryName, BlockFactory<TBlock> blockFactory) {
        this.registryName = registryName;
        this.blockFactory = blockFactory;
    }

    public TSelf blockProperties(BiFunction<FurnitureSet, BlockBehaviour.Properties, BlockBehaviour.Properties> blockPropertiesModifier) {
        this.blockPropertiesModifier = BlockTypeBuilder.andThen(this.blockPropertiesModifier, blockPropertiesModifier);
        return (TSelf)this;
    }

    public TSelf blockProperties(UnaryOperator<BlockBehaviour.Properties> blockPropertiesModifier) {
        return this.blockProperties((FurnitureSet furnitureSet, BlockBehaviour.Properties properties) -> (BlockBehaviour.Properties)blockPropertiesModifier.apply((BlockBehaviour.Properties)properties));
    }

    public TSelf baseBlock(Supplier<? extends BlockBehaviour> baseBlock) {
        this.baseBlock = baseBlock;
        return (TSelf)this;
    }

    public TSelf blockEntity(Supplier<? extends BlockEntityType<?>> blockEntityType) {
        this.blockEntityType = blockEntityType;
        return (TSelf)this;
    }

    public TSelf onRegister(BiConsumer<FurnitureSet, TBlock> listener, boolean enqueued) {
        if (enqueued) {
            this.onRegisterEnqueued = this.onRegisterEnqueued.andThen(listener);
        } else {
            this.onRegister = this.onRegister.andThen(listener);
        }
        return (TSelf)this;
    }

    public TSelf onRegister(BiConsumer<FurnitureSet, TBlock> listener) {
        return this.onRegister(listener, false);
    }

    public TSelf onRegister(Consumer<TBlock> listener, boolean enqueued) {
        return this.onRegister((FurnitureSet furnitureSet, TBlock block) -> listener.accept(block), enqueued);
    }

    public TSelf onRegister(Consumer<TBlock> listener) {
        return this.onRegister((FurnitureSet furnitureSet, TBlock block) -> listener.accept(block));
    }

    public <TProvider> TSelf providing(ProviderType<TProvider> providerType, ProviderListener<TProvider, TBlock> listener) {
        this.providerListeners.put(providerType, listener);
        return (TSelf)this;
    }

    public TSelf translation(String translation) {
        return this.providing(ProviderTypes.LANGUAGE, (context, provider, furnitureSet, block) -> {
            String furnitureSetName = StringUtils.capitalize((String)furnitureSet.name());
            String descriptionId = this instanceof WithItem ? block.asItem().getDescriptionId() : block.getDescriptionId();
            provider.add(descriptionId, furnitureSetName + " " + translation);
        });
    }

    public TSelf lootTable(BlockLootTableListener<TBlock> listener) {
        return this.providing(ProviderTypes.LOOT_TABLE, (context, provider, furnitureSet, block) -> provider.block(blocks -> listener.accept((BlockLootSubProvider)blocks, furnitureSet, block)));
    }

    public TSelf model(Supplier<ModelProviderListener<TBlock>> listener) {
        return this.providing(ProviderTypes.MODELS, (context, provider, furnitureSet, block) -> ((ModelProviderListener)listener.get()).accept(context, provider.blockModels(), furnitureSet, block));
    }

    @SafeVarargs
    public final TSelf blockTags(TagKey<Block> ... tags) {
        Collections.addAll(this.blockTags, tags);
        return (TSelf)this;
    }

    public TSelf usesMineableTag(boolean usesMineableTag) {
        this.usesMineableTag = usesMineableTag;
        return (TSelf)this;
    }

    public TSelf usesMineableTag() {
        return this.usesMineableTag(true);
    }

    public TSelf noMineableTag() {
        return this.usesMineableTag(false);
    }

    abstract TType build();

    private static <TLeft, TRight> BiFunction<TLeft, TRight, TRight> andThen(BiFunction<TLeft, TRight, TRight> before, BiFunction<TLeft, TRight, TRight> after) {
        return (furnitureSet, properties) -> after.apply(furnitureSet, before.apply(furnitureSet, properties));
    }

    public static final class WithItem<TBlock extends Block, TItem extends Item>
    extends BlockTypeBuilder<TBlock, BlockType.WithItem<TBlock, TItem>, WithItem<TBlock, TItem>> {
        final ItemFactory<TBlock, TItem> itemFactory;
        BiFunction<FurnitureSet, Item.Properties, Item.Properties> itemPropertiesModifier = (furnitureSet, properties) -> properties;
        final Set<TagKey<Item>> itemTags = Sets.newHashSet();

        WithItem(String registryName, BlockFactory<TBlock> blockFactory, ItemFactory<TBlock, TItem> itemFactory) {
            super(registryName, blockFactory);
            this.itemFactory = itemFactory;
        }

        public WithItem<TBlock, TItem> itemProperties(BiFunction<FurnitureSet, Item.Properties, Item.Properties> itemPropertiesModifier) {
            this.itemPropertiesModifier = BlockTypeBuilder.andThen(itemPropertiesModifier, itemPropertiesModifier);
            return this;
        }

        public WithItem<TBlock, TItem> itemProperties(UnaryOperator<Item.Properties> itemPropertiesModifier) {
            return this.itemProperties((FurnitureSet furnitureSet, Item.Properties properties) -> (Item.Properties)itemPropertiesModifier.apply((Item.Properties)properties));
        }

        @SafeVarargs
        public final WithItem<TBlock, TItem> itemTags(TagKey<Item> ... tags) {
            Collections.addAll(this.itemTags, tags);
            return this;
        }

        public WithItem<TBlock, TItem> recipe(RecipeListener<TItem> listener) {
            return (WithItem)this.providing(ProviderTypes.RECIPES, (context, provider, furnitureSet, block) -> listener.accept((RecipeProvider)provider, furnitureSet, (Object)block.asItem()));
        }

        @Override
        BlockType.WithItem<TBlock, TItem> build() {
            return new BlockType.WithItem(this);
        }
    }

    public static final class NoItem<TBlock extends Block>
    extends BlockTypeBuilder<TBlock, BlockType.NoItem<TBlock>, NoItem<TBlock>> {
        NoItem(String registryName, BlockFactory<TBlock> blockFactory) {
            super(registryName, blockFactory);
        }

        @Override
        BlockType.NoItem<TBlock> build() {
            return new BlockType.NoItem(this);
        }
    }
}

