/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.set;

import dev.apexstudios.apexcore.lib.component.block.BlockComponentTypes;
import dev.apexstudios.apexcore.lib.component.block.DoorBlockComponentHolder;
import dev.apexstudios.apexcore.lib.component.block.types.BedBlockComponent;
import dev.apexstudios.apexcore.lib.component.block.types.FacingBlockComponent;
import dev.apexstudios.apexcore.lib.component.block.types.MultiBlockComponent;
import dev.apexstudios.apexcore.lib.data.provider.RecipeProvider;
import dev.apexstudios.apexcore.lib.data.provider.model.ModelUtil;
import dev.apexstudios.apexcore.lib.placement.PlacementRenderEvent;
import dev.apexstudios.apexcore.lib.util.ApexTags;
import dev.apexstudios.apexcore.lib.util.ApexUtil;
import dev.apexstudios.fantasyfurniture.FantasyFurniture;
import dev.apexstudios.fantasyfurniture.FurnitureBlockEntities;
import dev.apexstudios.fantasyfurniture.block.BedDoubleBlock;
import dev.apexstudios.fantasyfurniture.block.BedSingleBlock;
import dev.apexstudios.fantasyfurniture.block.BenchBlock;
import dev.apexstudios.fantasyfurniture.block.BookshelfBlock;
import dev.apexstudios.fantasyfurniture.block.ChairBlock;
import dev.apexstudios.fantasyfurniture.block.ChandelierBlock;
import dev.apexstudios.fantasyfurniture.block.ChestBlock;
import dev.apexstudios.fantasyfurniture.block.CounterBlock;
import dev.apexstudios.fantasyfurniture.block.CushionBlock;
import dev.apexstudios.fantasyfurniture.block.DeskBlock;
import dev.apexstudios.fantasyfurniture.block.DrawerBlock;
import dev.apexstudios.fantasyfurniture.block.DresserBlock;
import dev.apexstudios.fantasyfurniture.block.FloorLightBlock;
import dev.apexstudios.fantasyfurniture.block.LockBoxBlock;
import dev.apexstudios.fantasyfurniture.block.OvenBlock;
import dev.apexstudios.fantasyfurniture.block.PaintingSmallBlock;
import dev.apexstudios.fantasyfurniture.block.PaintingWideBlock;
import dev.apexstudios.fantasyfurniture.block.ShelfBlock;
import dev.apexstudios.fantasyfurniture.block.SofaBlock;
import dev.apexstudios.fantasyfurniture.block.TableBlock;
import dev.apexstudios.fantasyfurniture.block.WallLightBlock;
import dev.apexstudios.fantasyfurniture.block.WardrobeBlock;
import dev.apexstudios.fantasyfurniture.block.base.FurnitureDoorBlockComponentHolder;
import dev.apexstudios.fantasyfurniture.block.base.SeatBlock;
import dev.apexstudios.fantasyfurniture.block.property.CounterConnection;
import dev.apexstudios.fantasyfurniture.block.property.ShelfConnection;
import dev.apexstudios.fantasyfurniture.block.property.SofaConnection;
import dev.apexstudios.fantasyfurniture.set.BlockType;
import dev.apexstudios.fantasyfurniture.set.BlockTypeBuilder;
import dev.apexstudios.fantasyfurniture.set.FurnitureSet;
import dev.apexstudios.fantasyfurniture.set.function.BlockFactory;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationRecipeBuilder;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationSetup;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.blockstates.Variant;
import net.minecraft.client.data.models.blockstates.VariantProperties;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import org.jetbrains.annotations.ApiStatus;

public interface BlockTypes {
    public static final BlockType.WithItem<Block, BlockItem> PLANKS = BlockType.withItem("planks", BlockFactory.wrapping(Block::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.OAK_PLANKS)).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> models.createTrivialCube(block))).translation("Planks")).blockTags(BlockTags.PLANKS)).itemTags(FantasyFurniture.FURNITURE_PLANKS).recipe((provider, furnitureSet, item) -> SingleItemRecipeBuilder.stonecutting((Ingredient)DifferenceIngredient.of((Ingredient)provider.tag(ItemTags.PLANKS), (Ingredient)provider.tag(FantasyFurniture.FURNITURE_PLANKS)), (RecipeCategory)RecipeCategory.MISC, (ItemLike)item).unlockedBy("has_planks", provider.has((ItemLike)item)).save(provider.output(), RecipeProvider.recipeKeyWithPrefix((ItemLike)item, (String)"conversion/"))));
    public static final BlockType.WithItem<Block, BlockItem> BRICKS = BlockType.withItem("bricks", BlockFactory.wrapping(Block::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.STONE)).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> models.createTrivialCube(block))).translation("Bricks")).blockTags(Tags.Blocks.STONES)).itemTags(FantasyFurniture.FURNITURE_BRICKS).recipe((provider, furnitureSet, item) -> SingleItemRecipeBuilder.stonecutting((Ingredient)DifferenceIngredient.of((Ingredient)provider.tag(ItemTags.STONE_CRAFTING_MATERIALS), (Ingredient)provider.tag(FantasyFurniture.FURNITURE_BRICKS)), (RecipeCategory)RecipeCategory.MISC, (ItemLike)item).unlockedBy("has_bricks", provider.has((ItemLike)item)).save(provider.output(), RecipeProvider.recipeKeyWithPrefix((ItemLike)item, (String)"conversion/"))));
    public static final BlockType.WithItem<Block, BlockItem> WOOL = BlockType.withItem("wool", BlockFactory.wrapping(Block::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.WHITE_WOOL)).blockProperties(properties -> properties.sound(SoundType.WOOL))).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> models.createTrivialCube(block))).translation("Wool")).noMineableTag()).blockTags(BlockTags.WOOL)).itemTags(FantasyFurniture.FURNITURE_WOOL).recipe((provider, furnitureSet, item) -> SingleItemRecipeBuilder.stonecutting((Ingredient)DifferenceIngredient.of((Ingredient)provider.tag(ItemTags.WOOL), (Ingredient)provider.tag(FantasyFurniture.FURNITURE_WOOL)), (RecipeCategory)RecipeCategory.MISC, (ItemLike)item).unlockedBy("has_wool", provider.has((ItemLike)item)).save(provider.output(), RecipeProvider.recipeKeyWithPrefix((ItemLike)item, (String)"conversion/"))));
    public static final BlockType.WithItem<CarpetBlock, BlockItem> CARPET = BlockType.withItem("carpet", BlockFactory.wrapping(CarpetBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.WHITE_CARPET)).blockProperties(properties -> properties.sound(SoundType.WOOL))).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> BlockTypes.carpetModel(block, furnitureSet, models))).translation("Carpet")).noMineableTag()).blockTags(BlockTags.WOOL_CARPETS)).itemTags(ItemTags.WOOL_CARPETS).recipe((provider, furnitureSet, item) -> provider.carpet((ItemLike)item, furnitureSet.getOrThrow(WOOL))));
    public static final BlockType.WithItem<DresserBlock, BlockItem> DRESSER = BlockType.withItem("dresser", BlockFactory.wrapping(DresserBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.CHEST)).blockProperties(properties -> properties.pushReaction(PushReaction.BLOCK))).blockEntity((Supplier<? extends BlockEntityType<?>>)FurnitureBlockEntities.DRESSER)).lootTable((blocks, furnitureSet, block) -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)))).model(() -> (context, models, furnitureSet, block) -> {
        BlockTypes.dresserModel(block, models);
        ModelUtil.registerBlockItemModel((Block)block, (BlockModelGenerators)models);
    })).translation("Dresser")).blockTags(ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST, Tags.Blocks.RELOCATION_NOT_SUPPORTED)).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<SeatBlock, BlockItem> STOOL = BlockType.withItem("stool", BlockFactory.wrapping(SeatBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> ModelUtil.horizontalFacingBlock((Block)block, (BlockModelGenerators)models))).translation("Stool")).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<CushionBlock, BlockItem> CUSHION = BlockType.withItem("cushion", BlockFactory.wrapping(CushionBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> ModelUtil.horizontalFacingBlock((Block)block, (BlockModelGenerators)models))).translation("Cushion")).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<LockBoxBlock, BlockItem> LOCKBOX = BlockType.withItem("lockbox", BlockFactory.wrapping(LockBoxBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.CHEST)).blockEntity((Supplier<? extends BlockEntityType<?>>)FurnitureBlockEntities.LOCKBOX)).lootTable((blocks, furnitureSet, block) -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)))).model(() -> (context, models, furnitureSet, block) -> ModelUtil.horizontalFacingBlock((Block)block, (BlockModelGenerators)models))).translation("Lockbox")).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<DrawerBlock, BlockItem> DRAWER = BlockType.withItem("drawer", BlockFactory.wrapping(DrawerBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.CHEST)).blockProperties(properties -> properties.pushReaction(PushReaction.BLOCK))).blockEntity((Supplier<? extends BlockEntityType<?>>)FurnitureBlockEntities.DRAWER)).lootTable((blocks, furnitureSet, block) -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)))).model(() -> (context, models, furnitureSet, block) -> ModelUtil.horizontalFacingBlock((Block)block, (BlockModelGenerators)models))).translation("Drawer")).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<ChairBlock, BlockItem> CHAIR = BlockType.withItem("chair", BlockFactory.wrapping(ChairBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.blockProperties(properties -> properties.pushReaction(PushReaction.BLOCK))).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> {
        BlockTypes.chairModel(block, models);
        ModelUtil.registerBlockItemModel((Block)block, (BlockModelGenerators)models);
    })).translation("Chair")).blockTags(ApexTags.Blocks.SEAT_ORIGIN_ONLY, ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST, Tags.Blocks.RELOCATION_NOT_SUPPORTED)).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<BookshelfBlock, BlockItem> BOOKSHELF = BlockType.withItem("bookshelf", BlockFactory.wrapping(BookshelfBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.CHEST)).blockProperties(properties -> properties.pushReaction(PushReaction.BLOCK))).blockEntity((Supplier<? extends BlockEntityType<?>>)FurnitureBlockEntities.BOOKSHELF)).lootTable((blocks, furnitureSet, block) -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)))).model(() -> (context, models, furnitureSet, block) -> {
        BlockTypes.bookshelfModel(block, models);
        ModelUtil.registerBlockItemModel((Block)block, (BlockModelGenerators)models);
    })).translation("Bookshelf")).blockTags(ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST, Tags.Blocks.RELOCATION_NOT_SUPPORTED, BlockTags.ENCHANTMENT_POWER_PROVIDER)).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<BedSingleBlock, BlockItem> BED_SINGLE = BlockType.withItem("bed_single", BlockFactory.wrapping(BedSingleBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.blockProperties(properties -> properties.pushReaction(PushReaction.BLOCK))).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> {
        BlockTypes.bedSingleModel(block, models);
        ModelUtil.registerBlockItemModel((Block)block, (BlockModelGenerators)models);
    })).translation("Bed Single")).blockTags(BlockTags.BEDS, ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST, Tags.Blocks.RELOCATION_NOT_SUPPORTED)).itemTags(ItemTags.BEDS).recipe(BlockTypes::furnitureStationRecipe).onRegister(block -> BedBlockComponent.registerPoi((Block)block), true));
    public static final BlockType.WithItem<BedDoubleBlock, BlockItem> BED_DOUBLE = BlockType.withItem("bed_double", BlockFactory.wrapping(BedDoubleBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.blockProperties(properties -> properties.pushReaction(PushReaction.BLOCK))).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> {
        BlockTypes.bedDoubleModel(block, models);
        ModelUtil.registerBlockItemModel((Block)block, (BlockModelGenerators)models);
    })).translation("Bed Double")).blockTags(BlockTags.BEDS, ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST, Tags.Blocks.RELOCATION_NOT_SUPPORTED)).itemTags(ItemTags.BEDS).recipe(BlockTypes::furnitureStationRecipe).onRegister(block -> BedBlockComponent.registerPoi((Block)block), true));
    public static final BlockType.WithItem<FurnitureDoorBlockComponentHolder, BlockItem> DOOR_SINGLE = BlockType.withItem("door_single", FurnitureDoorBlockComponentHolder::new, builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.OAK_DOOR)).blockProperties(properties -> properties.pushReaction(PushReaction.BLOCK))).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> {
        BlockTypes.doorModel(block, models);
        ModelUtil.registerBlockItemModel((Block)block, (BlockModelGenerators)models);
    })).translation("Door Single")).blockTags(BlockTags.WOODEN_DOORS, ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST, Tags.Blocks.RELOCATION_NOT_SUPPORTED)).itemTags(ItemTags.WOODEN_DOORS).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<FurnitureDoorBlockComponentHolder, BlockItem> DOOR_DOUBLE = BlockType.withItem("door_double", FurnitureDoorBlockComponentHolder::new, builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.OAK_DOOR)).blockProperties(properties -> properties.pushReaction(PushReaction.BLOCK))).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> {
        BlockTypes.doorModel(block, models);
        ModelUtil.registerBlockItemModel((Block)block, (BlockModelGenerators)models);
    })).translation("Door Double")).blockTags(BlockTags.WOODEN_DOORS, ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST, Tags.Blocks.RELOCATION_NOT_SUPPORTED)).itemTags(ItemTags.WOODEN_DOORS).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<DeskBlock, BlockItem> DESK_LEFT = BlockType.withItem("desk_left", BlockFactory.wrapping(properties -> new DeskBlock((BlockBehaviour.Properties)properties, true)), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.CHEST)).blockProperties(properties -> properties.pushReaction(PushReaction.BLOCK))).blockEntity((Supplier<? extends BlockEntityType<?>>)FurnitureBlockEntities.DESK)).lootTable((blocks, furnitureSet, block) -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)))).model(() -> (context, models, furnitureSet, block) -> {
        BlockTypes.deskModel(block, models);
        ModelUtil.registerBlockItemModel((Block)block, (BlockModelGenerators)models);
    })).translation("Desk Left")).blockTags(ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST, Tags.Blocks.RELOCATION_NOT_SUPPORTED)).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<DeskBlock, BlockItem> DESK_RIGHT = BlockType.withItem("desk_right", BlockFactory.wrapping(properties -> new DeskBlock((BlockBehaviour.Properties)properties, false)), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.CHEST)).blockProperties(properties -> properties.pushReaction(PushReaction.BLOCK))).blockEntity((Supplier<? extends BlockEntityType<?>>)FurnitureBlockEntities.DESK)).lootTable((blocks, furnitureSet, block) -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)))).model(() -> (context, models, furnitureSet, block) -> {
        BlockTypes.deskModel(block, models);
        ModelUtil.registerBlockItemModel((Block)block, (BlockModelGenerators)models);
    })).translation("Desk Right")).blockTags(ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST, Tags.Blocks.RELOCATION_NOT_SUPPORTED)).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<PaintingWideBlock, BlockItem> PAINTING_WIDE = BlockType.withItem("painting_wide", BlockFactory.wrapping(PaintingWideBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.blockProperties(properties -> properties.pushReaction(PushReaction.BLOCK))).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> {
        BlockTypes.paintingWideModel(block, models);
        ModelUtil.registerBlockItemModel((Block)block, (BlockModelGenerators)models);
    })).translation("Painting Wide")).blockTags(ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST, Tags.Blocks.RELOCATION_NOT_SUPPORTED)).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<PaintingSmallBlock, BlockItem> PAINTING_SMALL = BlockType.withItem("painting_small", BlockFactory.wrapping(PaintingSmallBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> ModelUtil.horizontalFacingBlock((Block)block, (BlockModelGenerators)models))).translation("Painting Small")).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<OvenBlock, BlockItem> OVEN = BlockType.withItem("oven", BlockFactory.wrapping(OvenBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.SMOKER)).blockProperties(BlockBehaviour.Properties::noOcclusion)).blockEntity((Supplier<? extends BlockEntityType<?>>)FurnitureBlockEntities.OVEN)).lootTable((blocks, furnitureSet, block) -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)))).model(() -> (context, models, furnitureSet, block) -> ModelUtil.horizontalFacingBlock((Block)block, (BlockModelGenerators)models))).translation("Oven")).noMineableTag()).blockTags(BlockTags.MINEABLE_WITH_PICKAXE, Tags.Blocks.PLAYER_WORKSTATIONS_FURNACES)).itemTags(Tags.Items.PLAYER_WORKSTATIONS_FURNACES).recipe(BlockTypes::furnitureStationRecipe).onRegister(block -> ApexUtil.registerPoiBlockStates((ResourceKey)PoiTypes.BUTCHER, (Block)block), true));
    public static final BlockType.WithItem<ChestBlock, BlockItem> CHEST = BlockType.withItem("chest", BlockFactory.wrapping(ChestBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.CHEST)).blockProperties(properties -> properties.pushReaction(PushReaction.BLOCK))).blockEntity((Supplier<? extends BlockEntityType<?>>)FurnitureBlockEntities.CHEST)).lootTable((blocks, furnitureSet, block) -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)))).model(() -> (context, models, furnitureSet, block) -> {
        BlockTypes.chestModel(block, models);
        ModelUtil.registerBlockItemModel((Block)block, (BlockModelGenerators)models);
    })).translation("Chest")).blockTags(ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST, Tags.Blocks.RELOCATION_NOT_SUPPORTED)).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<FloorLightBlock, BlockItem> FLOOR_LIGHT = BlockType.withItem("floor_light", FloorLightBlock::new, builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.blockProperties(properties -> properties.pushReaction(PushReaction.BLOCK).lightLevel(blockState -> 14))).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> {
        BlockTypes.floorLightModel(block, models);
        ModelUtil.registerBlockItemModel((Block)block, (BlockModelGenerators)models);
    })).translation("Floor Light")).blockTags(ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST, Tags.Blocks.RELOCATION_NOT_SUPPORTED)).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<ChandelierBlock, BlockItem> CHANDELIER = BlockType.withItem("chandelier", ChandelierBlock::new, builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.blockProperties(properties -> properties.lightLevel(blockState -> 14))).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> ModelUtil.horizontalFacingBlock((Block)block, (BlockModelGenerators)models))).translation("Chandelier")).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<ShelfBlock, BlockItem> SHELF = BlockType.withItem("shelf", BlockFactory.wrapping(ShelfBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> {
        BlockTypes.shelfModel(block, models);
        models.registerSimpleItemModel(block, ModelLocationUtils.getModelLocation((Block)block, (String)"_single"));
    })).translation("Shelf")).blockTags(ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST)).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<SofaBlock, BlockItem> SOFA = BlockType.withItem("sofa", BlockFactory.wrapping(SofaBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> {
        BlockTypes.sofaModel(block, models);
        models.registerSimpleItemModel(block, ModelLocationUtils.getModelLocation((Block)block, (String)"_single"));
    })).translation("Sofa")).blockTags(ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST)).recipe(BlockTypes::furnitureStationRecipe).onRegister(block -> NeoForge.EVENT_BUS.addListener(PlacementRenderEvent.DefaultBlockState.class, event -> {
        BlockState blockState = event.defaultBlockState();
        if (blockState.is((Block)block)) {
            FacingBlockComponent facingComponent = (FacingBlockComponent)block.getComponentOrThrow(BlockComponentTypes.FACING);
            event.setDefaultBlockState(SofaConnection.setConnection((BlockGetter)event.level(), event.pos(), blockState, arg_0 -> ((FacingBlockComponent)facingComponent).get(arg_0), (arg_0, arg_1) -> ((FacingBlockComponent)facingComponent).set(arg_0, arg_1)));
        }
    })));
    public static final BlockType.WithItem<CounterBlock, BlockItem> COUNTER = BlockType.withItem("counter", BlockFactory.wrapping(CounterBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.blockEntity((Supplier<? extends BlockEntityType<?>>)FurnitureBlockEntities.COUNTER)).lootTable((blocks, furnitureSet, block) -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)))).model(() -> (context, models, furnitureSet, block) -> {
        BlockTypes.counterModel(block, models);
        models.registerSimpleItemModel(block, ModelLocationUtils.getModelLocation((Block)block, (String)"_single"));
    })).translation("Counter")).blockTags(ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST)).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<WallLightBlock, BlockItem> WALL_LIGHT = BlockType.withItem("wall_light", WallLightBlock::new, builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.blockProperties(properties -> properties.pushReaction(PushReaction.DESTROY).lightLevel(blockState -> 14).noCollission().instabreak())).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> ModelUtil.horizontalFacingBlock((Block)block, (BlockModelGenerators)models))).translation("Wall Light")).blockTags(ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST)).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<BenchBlock, BlockItem> BENCH = BlockType.withItem("bench", BlockFactory.wrapping(BenchBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.blockProperties(properties -> properties.pushReaction(PushReaction.BLOCK))).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> {
        BlockTypes.benchModel(block, models);
        ModelUtil.registerBlockItemModel((Block)block, (BlockModelGenerators)models);
    })).translation("Bench")).blockTags(ApexTags.Blocks.SEAT_ORIGIN_ONLY, ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST, Tags.Blocks.RELOCATION_NOT_SUPPORTED)).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<WardrobeBlock, BlockItem> WARDROBE = BlockType.withItem("wardrobe", BlockFactory.wrapping(WardrobeBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.CHEST)).blockProperties(properties -> properties.pushReaction(PushReaction.BLOCK))).blockEntity((Supplier<? extends BlockEntityType<?>>)FurnitureBlockEntities.WARDROBE)).lootTable((blocks, furnitureSet, block) -> blocks.accept(block, blocks.createNameableBlockEntityTable(block)))).model(() -> (context, models, furnitureSet, block) -> {
        BlockTypes.wardrobeModel(block, models);
        ModelUtil.registerBlockItemModel((Block)block, (BlockModelGenerators)models);
    })).translation("Wardrobe")).blockTags(ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST, Tags.Blocks.RELOCATION_NOT_SUPPORTED)).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<TableBlock, BlockItem> TABLE = BlockType.withItem("table", BlockFactory.wrapping(TableBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> BlockTypes.tableModel(block, models))).translation("Table")).blockTags(ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST)).recipe(BlockTypes::furnitureStationRecipe));
    public static final BlockType.WithItem<StairBlock, BlockItem> STAIRS = BlockType.withItem("stairs", (furnitureSet, properties) -> new StairBlock(furnitureSet.getCoreBlock().defaultBlockState(), properties), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.OAK_STAIRS)).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> {
        TextureMapping textures = TextureMapping.cube((Block)furnitureSet.getCoreBlock());
        ResourceLocation straightModel = ModelTemplates.STAIRS_STRAIGHT.create(block, textures, models.modelOutput);
        models.blockStateOutput.accept(BlockModelGenerators.createStairs((Block)block, (ResourceLocation)ModelTemplates.STAIRS_INNER.create(block, textures, models.modelOutput), (ResourceLocation)straightModel, (ResourceLocation)ModelTemplates.STAIRS_OUTER.create(block, textures, models.modelOutput)));
        models.registerSimpleItemModel(block, straightModel);
    })).translation("Stairs")).blockTags(BlockTags.WOODEN_STAIRS)).itemTags(ItemTags.STAIRS).recipe((provider, furnitureSet, item) -> provider.stairBuilder((ItemLike)item, Ingredient.of((ItemLike)furnitureSet.getCoreBlock())).unlockedBy("has_core_block", provider.has((ItemLike)furnitureSet.getCoreBlock())).save(provider.output())));
    public static final BlockType.WithItem<SlabBlock, BlockItem> SLAB = BlockType.withItem("slab", BlockFactory.wrapping(SlabBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.OAK_SLAB)).lootTable((blocks, furnitureSet, block) -> blocks.accept(block, blocks.createSlabItemTable(block)))).model(() -> (context, models, furnitureSet, block) -> {
        TextureMapping textures = TextureMapping.cube((Block)furnitureSet.getCoreBlock());
        ResourceLocation bottomModel = ModelTemplates.SLAB_BOTTOM.create(block, textures, models.modelOutput);
        models.blockStateOutput.accept(BlockModelGenerators.createSlab((Block)block, (ResourceLocation)bottomModel, (ResourceLocation)ModelTemplates.SLAB_TOP.create(block, textures, models.modelOutput), (ResourceLocation)ModelLocationUtils.getModelLocation((Block)furnitureSet.getCoreBlock())));
        models.registerSimpleItemModel(block, bottomModel);
    })).translation("Slab")).blockTags(BlockTags.WOODEN_SLABS)).itemTags(ItemTags.WOODEN_SLABS).recipe((provider, furnitureSet, item) -> provider.slabBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, Ingredient.of((ItemLike)furnitureSet.getCoreBlock())).unlockedBy("has_core_block", provider.has((ItemLike)furnitureSet.getCoreBlock())).save(provider.output())));
    public static final BlockType.WithItem<FenceBlock, BlockItem> FENCE = BlockType.withItem("fence", BlockFactory.wrapping(FenceBlock::new), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.OAK_FENCE)).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> {
        TextureMapping textures = TextureMapping.cube((Block)furnitureSet.getCoreBlock());
        models.blockStateOutput.accept(BlockModelGenerators.createFence((Block)block, (ResourceLocation)ModelTemplates.FENCE_POST.create(block, textures, models.modelOutput), (ResourceLocation)ModelTemplates.FENCE_SIDE.create(block, textures, models.modelOutput)));
        models.registerSimpleItemModel(block, ModelTemplates.FENCE_INVENTORY.create(block, textures, models.modelOutput));
    })).translation("Fence")).blockTags(BlockTags.WOODEN_FENCES)).itemTags(ItemTags.WOODEN_FENCES).recipe((provider, furnitureSet, item) -> provider.fenceBuilder((ItemLike)item, Ingredient.of((ItemLike)furnitureSet.getCoreBlock())).unlockedBy("has_core_block", provider.has((ItemLike)furnitureSet.getCoreBlock())).save(provider.output())));
    public static final BlockType.WithItem<FenceGateBlock, BlockItem> FENCE_GATE = BlockType.withItem("fence_gate", (furnitureSet, properties) -> new FenceGateBlock(furnitureSet.woodType(), properties), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.OAK_FENCE_GATE)).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> {
        TextureMapping textures = TextureMapping.cube((Block)furnitureSet.getCoreBlock());
        models.blockStateOutput.accept(BlockModelGenerators.createFenceGate((Block)block, (ResourceLocation)ModelTemplates.FENCE_GATE_OPEN.create(block, textures, models.modelOutput), (ResourceLocation)ModelTemplates.FENCE_GATE_CLOSED.create(block, textures, models.modelOutput), (ResourceLocation)ModelTemplates.FENCE_GATE_WALL_OPEN.create(block, textures, models.modelOutput), (ResourceLocation)ModelTemplates.FENCE_GATE_WALL_CLOSED.create(block, textures, models.modelOutput), (boolean)true));
    })).translation("Fence Gate")).blockTags(BlockTags.FENCE_GATES)).itemTags(ItemTags.FENCE_GATES).recipe((provider, furnitureSet, item) -> provider.fenceGateBuilder((ItemLike)item, Ingredient.of((ItemLike)furnitureSet.getCoreBlock())).unlockedBy("has_core_block", provider.has((ItemLike)furnitureSet.getCoreBlock())).save(provider.output())));
    public static final BlockType.WithItem<TrapDoorBlock, BlockItem> TRAP_DOOR = BlockType.withItem("trapdoor", (furnitureSet, properties) -> new TrapDoorBlock(furnitureSet.blockSet(), properties), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.OAK_TRAPDOOR)).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> models.createOrientableTrapdoor(block))).translation("Trapdoor")).blockTags(BlockTags.WOODEN_TRAPDOORS)).itemTags(ItemTags.WOODEN_TRAPDOORS).recipe((provider, furnitureSet, item) -> provider.trapdoorBuilder((ItemLike)item, Ingredient.of((ItemLike)furnitureSet.getCoreBlock())).unlockedBy("has_core_block", provider.has((ItemLike)furnitureSet.getCoreBlock())).save(provider.output())));
    public static final BlockType.WithItem<PressurePlateBlock, BlockItem> PRESSURE_PLATE = BlockType.withItem("pressure_plate", (furnitureSet, properties) -> new PressurePlateBlock(furnitureSet.blockSet(), properties), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.OAK_PRESSURE_PLATE)).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> {
        TextureMapping textures = TextureMapping.cube((Block)furnitureSet.getCoreBlock());
        models.blockStateOutput.accept(BlockModelGenerators.createPressurePlate((Block)block, (ResourceLocation)ModelTemplates.PRESSURE_PLATE_UP.create(block, textures, models.modelOutput), (ResourceLocation)ModelTemplates.PRESSURE_PLATE_DOWN.create(block, textures, models.modelOutput)));
    })).translation("Pressure Plate")).blockTags(BlockTags.WOODEN_PRESSURE_PLATES)).itemTags(ItemTags.WOODEN_PRESSURE_PLATES));
    public static final BlockType.WithItem<ButtonBlock, BlockItem> BUTTON = BlockType.withItem("button", (furnitureSet, properties) -> new ButtonBlock(furnitureSet.blockSet(), 30, properties), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.OAK_BUTTON)).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> {
        TextureMapping textures = TextureMapping.cube((Block)furnitureSet.getCoreBlock());
        models.blockStateOutput.accept(BlockModelGenerators.createButton((Block)block, (ResourceLocation)ModelTemplates.BUTTON.create(block, textures, models.modelOutput), (ResourceLocation)ModelTemplates.BUTTON_PRESSED.create(block, textures, models.modelOutput)));
        models.registerSimpleItemModel(block, ModelTemplates.BUTTON_INVENTORY.create(block, textures, models.modelOutput));
    })).translation("Button")).blockTags(BlockTags.WOODEN_BUTTONS)).itemTags(ItemTags.WOODEN_BUTTONS).recipe((provider, furnitureSet, item) -> provider.buttonBuilder((ItemLike)item, Ingredient.of((ItemLike)furnitureSet.getCoreBlock())).unlockedBy("has_core_block", provider.has((ItemLike)furnitureSet.getCoreBlock())).save(provider.output())));
    public static final BlockType.WithItem<CeilingHangingSignBlock, HangingSignItem> HANGING_SIGN = BlockType.withItem("hanging_sign", (furnitureSet, properties) -> new CeilingHangingSignBlock(furnitureSet.woodType(), properties), (furnitureSet, block, properties) -> new HangingSignItem(block, (Block)BlockTypes.wallHangingSign(furnitureSet), properties), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.OAK_HANGING_SIGN)).itemProperties(properties -> properties.stacksTo(16)).blockEntity(() -> BlockEntityType.HANGING_SIGN)).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> models.createHangingSign(furnitureSet.getCoreBlock(), block, (Block)BlockTypes.wallHangingSign(furnitureSet)))).translation("Hanging Sign")).blockTags(BlockTags.CEILING_HANGING_SIGNS)).itemTags(ItemTags.HANGING_SIGNS).recipe((provider, furnitureSet, item) -> provider.hangingSign((ItemLike)item, (ItemLike)furnitureSet.getCoreBlock())));
    public static final BlockType.NoItem<WallHangingSignBlock> WALL_HANGING_SIGN = BlockType.noItem("wall_hanging_sign", (furnitureSet, properties) -> new WallHangingSignBlock(furnitureSet.woodType(), properties), builder -> ((BlockTypeBuilder.NoItem)((BlockTypeBuilder.NoItem)((BlockTypeBuilder.NoItem)builder.baseBlock(() -> Blocks.OAK_WALL_HANGING_SIGN)).blockProperties((furnitureSet, properties) -> properties.overrideLootTable(((CeilingHangingSignBlock)furnitureSet.getOrThrow(HANGING_SIGN)).getLootTable()))).blockEntity(() -> BlockEntityType.HANGING_SIGN)).blockTags(BlockTags.WALL_HANGING_SIGNS));
    public static final BlockType.WithItem<StandingSignBlock, SignItem> SIGN = BlockType.withItem("sign", (furnitureSet, properties) -> new StandingSignBlock(furnitureSet.woodType(), properties), (furnitureSet, block, properties) -> new SignItem(block, (Block)BlockTypes.wallSign(furnitureSet), properties), builder -> ((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)((BlockTypeBuilder.WithItem)builder.baseBlock(() -> Blocks.OAK_SIGN)).itemProperties(properties -> properties.stacksTo(16)).blockEntity(() -> BlockEntityType.SIGN)).lootTable((blocks, furnitureSet, block) -> blocks.dropSelf(block))).model(() -> (context, models, furnitureSet, block) -> {
        ResourceLocation model = ModelTemplates.PARTICLE_ONLY.create(block, TextureMapping.particle((Block)furnitureSet.getCoreBlock()), models.modelOutput);
        models.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (ResourceLocation)model));
        models.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)BlockTypes.wallSign(furnitureSet), (ResourceLocation)model));
        models.registerSimpleFlatItemModel(block.asItem());
    })).translation("Sign")).blockTags(BlockTags.STANDING_SIGNS)).itemTags(ItemTags.SIGNS).recipe((provider, furnitureSet, item) -> provider.signBuilder((ItemLike)item, Ingredient.of((ItemLike)furnitureSet.getCoreBlock())).unlockedBy("has_core_block", provider.has((ItemLike)furnitureSet.getCoreBlock())).save(provider.output())));
    public static final BlockType.NoItem<WallSignBlock> WALL_SIGN = BlockType.noItem("wall_sign", (furnitureSet, properties) -> new WallSignBlock(furnitureSet.woodType(), properties), builder -> ((BlockTypeBuilder.NoItem)((BlockTypeBuilder.NoItem)((BlockTypeBuilder.NoItem)builder.baseBlock(() -> Blocks.OAK_WALL_SIGN)).blockProperties((furnitureSet, properties) -> properties.overrideLootTable(((StandingSignBlock)furnitureSet.getOrThrow(SIGN)).getLootTable()))).blockEntity(() -> BlockEntityType.SIGN)).blockTags(BlockTags.WALL_SIGNS));

    public static void carpetModel(CarpetBlock block, FurnitureSet furnitureSet, BlockModelGenerators models) {
        models.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (ResourceLocation)TexturedModel.CARPET.get(furnitureSet.getOrThrow(WOOL)).create((Block)block, models.modelOutput)));
    }

    public static void dresserModel(DresserBlock block, BlockModelGenerators models) {
        ModelUtil.multiBlockModelSuffix((Block)block, (BlockModelGenerators)models, index -> index == 0 ? "_left" : "_right");
    }

    public static void chairModel(ChairBlock block, BlockModelGenerators models) {
        ModelUtil.multiBlockModelSuffix((Block)block, (BlockModelGenerators)models, index -> index == 0 ? "_bottom" : "_top");
    }

    public static void bookshelfModel(BookshelfBlock block, BlockModelGenerators models) {
        ModelUtil.multiBlockModelSuffix((Block)block, (BlockModelGenerators)models, index -> switch (index) {
            case 1 -> "_bottom_right";
            case 2 -> "_top_right";
            case 3 -> "_top_left";
            default -> "_bottom_left";
        });
    }

    public static void bedSingleModel(BedSingleBlock block, BlockModelGenerators models) {
        ModelUtil.multiBlockModelSuffix((Block)block, (BlockModelGenerators)models, index -> index == 0 ? "_bottom" : "_top");
    }

    public static void bedDoubleModel(BedDoubleBlock block, BlockModelGenerators models) {
        ModelUtil.multiBlockModelSuffix((Block)block, (BlockModelGenerators)models, index -> switch (index) {
            case 1 -> "_top_left";
            case 2 -> "_top_right";
            case 3 -> "_bottom_right";
            default -> "_bottom_left";
        });
    }

    public static void doorModel(FurnitureDoorBlockComponentHolder block, BlockModelGenerators blockModels) {
        MultiBlockComponent multiBlock = (MultiBlockComponent)block.getComponentOrThrow(BlockComponentTypes.MULTI_BLOCK);
        EnumProperty facingProperty = ((FacingBlockComponent)block.getComponentOrThrow(BlockComponentTypes.FACING)).getProperty();
        blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.properties((Property)facingProperty, (Property)multiBlock.property(), (Property)DoorBlockComponentHolder.HINGE, (Property)DoorBlockComponentHolder.OPEN).generate((facing, index, hinge, open) -> {
            String indexName = index == 0 ? "bottom" : "top";
            String openName = open != false ? "open" : "closed";
            ResourceLocation modelPath = ModelLocationUtils.getModelLocation((Block)block, (String)("_" + hinge.getSerializedName() + "_" + indexName + "_" + openName));
            if (open.booleanValue()) {
                facing = hinge == DoorHingeSide.LEFT ? facing.getClockWise() : facing.getCounterClockWise();
            }
            VariantProperties.Rotation rot = switch (facing) {
                case Direction.NORTH -> VariantProperties.Rotation.R270;
                case Direction.SOUTH -> VariantProperties.Rotation.R90;
                case Direction.WEST -> VariantProperties.Rotation.R180;
                default -> VariantProperties.Rotation.R0;
            };
            return Variant.variant().with(VariantProperties.MODEL, (Object)modelPath).with(VariantProperties.Y_ROT, (Object)rot);
        })));
    }

    public static void deskModel(DeskBlock block, BlockModelGenerators models) {
        ModelUtil.multiBlockModelSuffix((Block)block, (BlockModelGenerators)models, index -> index == 0 ? "_left" : "_right");
    }

    public static void paintingWideModel(PaintingWideBlock block, BlockModelGenerators models) {
        ModelUtil.multiBlockModelSuffix((Block)block, (BlockModelGenerators)models, index -> index == 0 ? "_left" : "_right");
    }

    public static void chestModel(ChestBlock block, BlockModelGenerators models) {
        ModelUtil.multiBlockModelSuffix((Block)block, (BlockModelGenerators)models, index -> index == 0 ? "_left" : "_right");
    }

    public static void floorLightModel(FloorLightBlock block, BlockModelGenerators models) {
        ModelUtil.multiBlockModelSuffix((Block)block, (BlockModelGenerators)models, index -> index == 0 ? "_bottom" : "_top");
    }

    public static void shelfModel(ShelfBlock block, BlockModelGenerators models) {
        ModelUtil.facingPropertyModelSuffix((Block)block, (BlockModelGenerators)models, ShelfConnection.PROPERTY, ShelfConnection::getModelSuffix, (Comparable)((Object)ShelfConnection.NONE));
    }

    public static void sofaModel(SofaBlock block, BlockModelGenerators models) {
        ModelUtil.facingPropertyModelSuffix((Block)block, (BlockModelGenerators)models, SofaConnection.PROPERTY, SofaConnection::getModelSuffix, (Comparable)((Object)SofaConnection.NONE));
    }

    public static void counterModel(CounterBlock block, BlockModelGenerators models) {
        ModelUtil.facingPropertyModelSuffix((Block)block, (BlockModelGenerators)models, CounterConnection.PROPERTY, CounterConnection::getModelSuffix, (Comparable)((Object)CounterConnection.NONE));
    }

    public static void benchModel(BenchBlock block, BlockModelGenerators models) {
        ModelUtil.multiBlockModelSuffix((Block)block, (BlockModelGenerators)models, index -> index == 0 ? "_left" : "_right");
    }

    public static void wardrobeModel(WardrobeBlock block, BlockModelGenerators models) {
        ModelUtil.multiBlockModelSuffix((Block)block, (BlockModelGenerators)models, index -> switch (index) {
            case 1 -> "_bottom_right";
            case 2 -> "_middle_right";
            case 3 -> "_middle_left";
            case 4 -> "_top_right";
            case 5 -> "_top_left";
            default -> "_bottom_left";
        });
    }

    public static void tableModel(TableBlock block, BlockModelGenerators blockModels) {
        EnumProperty facingProperty = ((FacingBlockComponent)block.getComponentOrThrow(BlockComponentTypes.FACING)).getProperty();
        blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.properties((Property)facingProperty, (Property)TableBlock.NORTH, (Property)TableBlock.EAST, (Property)TableBlock.SOUTH, (Property)TableBlock.WEST).generate((facing, north, east, south, west) -> {
            EnumSet<Direction> connections = EnumSet.noneOf(Direction.class);
            Direction facingForConnection = TableBlock.getFacingForConnection(facing);
            if (north.booleanValue()) {
                connections.add(Direction.NORTH);
            }
            if (east.booleanValue()) {
                connections.add(Direction.EAST);
            }
            if (south.booleanValue()) {
                connections.add(Direction.SOUTH);
            }
            if (west.booleanValue()) {
                connections.add(Direction.WEST);
            }
            Rotation rotation = ModelUtil.facingToRotation((Direction)facingForConnection);
            String suffix = connections.stream().map(arg_0 -> ((Rotation)rotation).rotate(arg_0)).sorted(Comparator.comparingInt(connection -> switch (connection) {
                case Direction.NORTH -> 0;
                case Direction.EAST -> 1;
                case Direction.SOUTH -> 2;
                case Direction.WEST -> 3;
                default -> -1;
            })).map(connection -> switch (connection) {
                case Direction.NORTH -> Character.valueOf('n');
                case Direction.EAST -> Character.valueOf('e');
                case Direction.SOUTH -> Character.valueOf('s');
                case Direction.WEST -> Character.valueOf('w');
                default -> null;
            }).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(""));
            return Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block, (String)(suffix.isBlank() ? "" : "_" + suffix))).with(VariantProperties.Y_ROT, (Object)ModelUtil.facingToModelRotation((Direction)facing));
        })));
    }

    public static <TItem extends Item> void furnitureStationRecipe(RecipeProvider provider, FurnitureSet furnitureSet, TItem item) {
        ItemLike wool = furnitureSet.getWool();
        FurnitureStationRecipeBuilder.builder(RecipeCategory.MISC, Ingredient.of((ItemLike)furnitureSet.getCoreBlock()), wool == null ? null : Ingredient.of((ItemLike)wool), provider.tag(FurnitureStationSetup.BINDING_AGENT), item).unlockedBy("has_core_block", provider.has((ItemLike)furnitureSet.getCoreBlock())).save(provider.output(), RecipeProvider.recipeKeyWithPrefix(item, (String)"furniture_station/"));
    }

    private static WallHangingSignBlock wallHangingSign(FurnitureSet furnitureSet) {
        return furnitureSet.getOrThrow(WALL_HANGING_SIGN);
    }

    private static WallSignBlock wallSign(FurnitureSet furnitureSet) {
        return furnitureSet.getOrThrow(WALL_SIGN);
    }

    @ApiStatus.Internal
    public static void register() {
    }
}

