/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.set;

import com.google.common.collect.Sets;
import dev.apexstudios.apexcore.lib.data.ProviderTypes;
import dev.apexstudios.apexcore.lib.data.ResourceGenerator;
import dev.apexstudios.apexcore.lib.data.pack.ModPackGenerator;
import dev.apexstudios.apexcore.lib.data.pack.PackGenerator;
import dev.apexstudios.apexcore.lib.data.provider.tag.IntrusiveTagBuilder;
import dev.apexstudios.apexcore.lib.registree.Registree;
import dev.apexstudios.fantasyfurniture.FantasyFurniture;
import dev.apexstudios.fantasyfurniture.set.BlockType;
import dev.apexstudios.fantasyfurniture.set.BlockTypes;
import dev.apexstudios.fantasyfurniture.set.FurnitureSetBuilder;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.function.Consumers;
import org.jetbrains.annotations.Nullable;

public final class FurnitureSet {
    final Registree registree;
    private final String name;
    private final Set<BlockType<?>> blockTypes;
    private final WoodType woodType;
    private final ResourceKey<CreativeModeTab> creativeModeTab;
    private final boolean usesPrefix;
    final Supplier<? extends BlockBehaviour> baseBlock;
    private final TagKey<Block> mineableTag;
    private final BlockType<?> coreBlockType;
    private final TagKey<Block> blockTag;
    private final TagKey<Item> itemTag;
    @Nullable
    private final ItemLike woolItem;
    private final Supplier<? extends ParticleOptions> flameParticle;

    private FurnitureSet(FurnitureSetBuilder builder) {
        this.registree = builder.registree;
        this.name = builder.name;
        this.blockTypes = FurnitureSet.blockTypes(builder);
        this.woodType = builder.woodType.build(this.name + "_wood_type", this.name + "_block_set");
        this.usesPrefix = builder.usesPrefix;
        this.baseBlock = builder.baseBlock;
        this.mineableTag = builder.mineableTag;
        this.coreBlockType = builder.coreBlockType;
        this.woolItem = builder.woolItem;
        this.flameParticle = builder.flameParticle;
        this.blockTag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)FantasyFurniture.identifier(this.name));
        this.itemTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)FantasyFurniture.identifier(this.name));
        this.creativeModeTab = this.registree.registerCreativeModeTab(this.name, () -> new ItemStack(this.getOrThrow(BlockTypes.BED_SINGLE)), (parameters, output) -> this.blockTypes.forEach(blockType -> {
            Object block = this.getOrThrow((BlockType)blockType);
            if (block.isEnabled(parameters.enabledFeatures())) {
                output.accept(block);
            }
        }));
    }

    String registrationName(String registrationName) {
        return this.usesPrefix ? this.name + "_" + registrationName : registrationName;
    }

    public void register(IEventBus modBus) {
        for (BlockType<?> blockType : this.blockTypes) {
            blockType.register(modBus, this);
        }
        modBus.addListener(FMLClientSetupEvent.class, event -> event.enqueueWork(() -> {
            if (this.isRegistered(BlockTypes.HANGING_SIGN) || this.isRegistered(BlockTypes.WALL_HANGING_SIGN)) {
                Sheets.HANGING_SIGN_MATERIALS.put(this.woodType, Sheets.createHangingSignMaterial((ResourceLocation)this.registree.registryName(this.name)));
            }
            if (this.isRegistered(BlockTypes.SIGN) || this.isRegistered(BlockTypes.WALL_SIGN)) {
                Sheets.SIGN_MATERIALS.put(this.woodType, Sheets.createSignMaterial((ResourceLocation)this.registree.registryName(this.name)));
            }
            this.ifRegistered(BlockTypes.TRAP_DOOR, block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.cutout()));
        }));
    }

    public void registerDataGen(ResourceGenerator generator) {
        ModPackGenerator pack = generator.pack();
        for (BlockType<?> blockType : this.blockTypes) {
            blockType.registerDataGen((PackGenerator<?>)pack, this);
        }
        pack.providing(ProviderTypes.LANGUAGE, (context, provider) -> {
            String englishName = StringUtils.capitalize((String)this.name);
            provider.addCreativeModeTab(this.creativeModeTab, englishName);
            provider.add(this.blockTag, englishName + " (Blocks)");
            provider.add(this.itemTag, englishName + " (Items)");
        });
        pack.providing(ProviderTypes.BLOCK_TAGS, (context, provider) -> {
            for (BlockType<?> blockType : this.blockTypes) {
                ((IntrusiveTagBuilder)provider.tag(this.blockTag)).withElement(this.getOrThrow(blockType));
                if (!blockType.usesMineableTag) continue;
                ((IntrusiveTagBuilder)provider.tag(this.mineableTag)).withElement(this.getOrThrow(blockType));
            }
        });
        pack.providing(ProviderTypes.ITEM_TAGS, (context, provider) -> {
            for (BlockType<?> blockType : this.blockTypes) {
                Item item = this.getOrThrow(blockType).asItem();
                if (item == Items.AIR) continue;
                ((IntrusiveTagBuilder)provider.tag(this.itemTag)).withElement((Object)item);
            }
        });
    }

    public String ownerNamespace() {
        return this.registree.namespace();
    }

    public String name() {
        return this.name;
    }

    public Set<BlockType<?>> blockTypes() {
        return this.blockTypes;
    }

    public BlockSetType blockSet() {
        return this.woodType.setType();
    }

    public WoodType woodType() {
        return this.woodType;
    }

    public ResourceKey<CreativeModeTab> creativeModeTab() {
        return this.creativeModeTab;
    }

    public boolean isRegistered(BlockType<?> blockType) {
        return this.registree.containsKey(Registries.BLOCK, this.registrationName(blockType.registryName));
    }

    public <TBlock extends Block> Optional<TBlock> get(BlockType<TBlock> blockType) {
        return this.registree.getOptional(Registries.BLOCK, this.registrationName(blockType.registryName)).map(value -> value);
    }

    public <TBlock extends Block> TBlock getOrThrow(BlockType<TBlock> blockType) {
        return (TBlock)((Block)this.get(blockType).orElseThrow(() -> new NullPointerException()));
    }

    public <TBlock extends Block> void ifRegistered(BlockType<TBlock> blockType, Consumer<TBlock> consumer) {
        this.get(blockType).ifPresent(consumer);
    }

    public BlockType<?> coreBlockType() {
        return this.coreBlockType;
    }

    public Block getCoreBlock() {
        return this.getOrThrow(this.coreBlockType);
    }

    @Nullable
    public ItemLike getWool() {
        if (this.woolItem != null) {
            return this.woolItem;
        }
        return this.get(BlockTypes.WOOL).orElse(null);
    }

    public ParticleOptions flameParticle() {
        return this.flameParticle.get();
    }

    public boolean is(ItemStack stack) {
        return stack.is(this.itemTag);
    }

    public boolean is(BlockState blockState) {
        return blockState.is(this.blockTag);
    }

    public boolean is(Block block) {
        return block.builtInRegistryHolder().is(this.blockTag);
    }

    public boolean is(Item item) {
        return item.builtInRegistryHolder().is(this.itemTag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FurnitureSet) {
            FurnitureSet other = (FurnitureSet)obj;
            return this.ownerNamespace().equals(other.ownerNamespace()) && this.name.equals(other.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.ownerNamespace(), this.name);
    }

    public String toString() {
        return "FurnitureSet{" + this.ownerNamespace() + ":" + this.name + "}";
    }

    public static FurnitureSet create(Registree registree, String name, Consumer<FurnitureSetBuilder> consumer) {
        FurnitureSetBuilder builder = new FurnitureSetBuilder(registree, name);
        consumer.accept(builder);
        return new FurnitureSet(builder);
    }

    public static FurnitureSet createWoodLike(Registree registree, String name, Consumer<FurnitureSetBuilder> consumer) {
        return FurnitureSet.create(registree, name, builder -> {
            builder.baseBlock(() -> Blocks.OAK_PLANKS).mineable((TagKey<Block>)BlockTags.MINEABLE_WITH_AXE).baseBlockType(BlockTypes.PLANKS).woodType(woodType -> woodType.copy(WoodType.OAK)).with(FurnitureSetBuilder.WOODEN_BLOCK_TYPES);
            consumer.accept((FurnitureSetBuilder)builder);
        });
    }

    public static FurnitureSet createWoodLike(Registree registree, String name) {
        return FurnitureSet.createWoodLike(registree, name, Consumers.nop());
    }

    public static FurnitureSet createStoneLike(Registree registree, String name, Consumer<FurnitureSetBuilder> consumer) {
        return FurnitureSet.createWoodLike(registree, name, builder -> {
            builder.baseBlock(() -> Blocks.STONE).mineable((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE).baseBlockType(BlockTypes.BRICKS).blockSet(blockSet -> blockSet.copy(BlockSetType.STONE)).remove(BlockTypes.PLANKS);
            consumer.accept((FurnitureSetBuilder)builder);
        });
    }

    public static FurnitureSet createStoneLike(Registree registree, String name) {
        return FurnitureSet.createStoneLike(registree, name, Consumers.nop());
    }

    private static Set<BlockType<?>> blockTypes(FurnitureSetBuilder builder) {
        LinkedHashSet blockTypes = Sets.newLinkedHashSet(builder.blockTypes.values());
        blockTypes.addFirst(builder.coreBlockType);
        return Collections.unmodifiableSet(blockTypes);
    }
}

