/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.station;

import dev.apexstudios.fantasyfurniture.station.FurnitureStationRecipeInput;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationSetup;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public final class FurnitureStationRecipe
implements Recipe<FurnitureStationRecipeInput> {
    private final String group;
    private final Ingredient planks;
    private final Optional<Ingredient> wool;
    private final Ingredient bindingAgent;
    private final ItemStack result;

    FurnitureStationRecipe(String group, Ingredient planks, Optional<Ingredient> wool, Ingredient bindingAgent, ItemStack result) {
        this.group = group;
        this.planks = planks;
        this.wool = wool;
        this.bindingAgent = bindingAgent;
        this.result = result;
    }

    public Ingredient planks() {
        return this.planks;
    }

    public Optional<Ingredient> wool() {
        return this.wool;
    }

    public Ingredient bindingAgent() {
        return this.bindingAgent;
    }

    public ItemStack result() {
        return this.result;
    }

    private boolean matches(FurnitureStationRecipeInput input) {
        if (this.wool.isPresent() && !this.wool.get().test(input.wool())) {
            return false;
        }
        return this.planks.test(input.planks()) && this.bindingAgent.test(input.bindingAgent());
    }

    public boolean matches(FurnitureStationRecipeInput input, Level level) {
        return this.matches(input);
    }

    public ItemStack assemble(FurnitureStationRecipeInput input, HolderLookup.Provider registries) {
        return this.matches(input) ? this.result.copy() : ItemStack.EMPTY;
    }

    public RecipeSerializer<FurnitureStationRecipe> getSerializer() {
        return (RecipeSerializer)FurnitureStationSetup.RECIPE_SERIALIZER.value();
    }

    public RecipeType<FurnitureStationRecipe> getType() {
        return (RecipeType)FurnitureStationSetup.RECIPE_TYPE.value();
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.create((List)this.wool.map(wool -> List.of(this.planks, wool, this.bindingAgent)).orElseGet(() -> List.of(this.planks, this.bindingAgent)));
    }

    public RecipeBookCategory recipeBookCategory() {
        return (RecipeBookCategory)FurnitureStationSetup.RECIPE_BOOK_CATEGORY.value();
    }

    public String group() {
        return this.group;
    }
}

