/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies;

import com.mojang.brigadier.CommandDispatcher;
import de.dafuqs.starryskies.advancements.ProximityAdvancementCheckEvent;
import de.dafuqs.starryskies.advancements.StarryAdvancementCriteria;
import de.dafuqs.starryskies.commands.ClosestSphereCommand;
import de.dafuqs.starryskies.commands.ConfiguredSphereArgumentType;
import de.dafuqs.starryskies.commands.GenerateSphereCommand;
import de.dafuqs.starryskies.configs.StarrySkyConfig;
import de.dafuqs.starryskies.data_loaders.UniqueBlockGroupDataLoader;
import de.dafuqs.starryskies.data_loaders.WeightedBlockGroupDataLoader;
import de.dafuqs.starryskies.registries.StarryDimensionKeys;
import de.dafuqs.starryskies.registries.StarryRegistries;
import de.dafuqs.starryskies.registries.StarryRegistryKeys;
import de.dafuqs.starryskies.state_providers.StarryStateProviders;
import de.dafuqs.starryskies.worldgen.ConfiguredSphere;
import de.dafuqs.starryskies.worldgen.GenerationGroup;
import de.dafuqs.starryskies.worldgen.SphereConfig;
import de.dafuqs.starryskies.worldgen.SphereDecorators;
import de.dafuqs.starryskies.worldgen.Spheres;
import de.dafuqs.starryskies.worldgen.StarryFeatures;
import de.dafuqs.starryskies.worldgen.dimension.StarrySkyChunkGenerator;
import de.dafuqs.starryskies.worldgen.dimension.SystemGenerator;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2319;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarrySkies
implements ModInitializer {
    public static final String MOD_ID = "starry_skies";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"starry_skies");
    public static StarrySkyConfig CONFIG;

    public static class_2960 id(String name) {
        return class_2960.method_60655((String)MOD_ID, (String)name);
    }

    public static String idPlain(String name) {
        return StarrySkies.id(name).toString();
    }

    public static boolean isStarryWorld(class_3218 world) {
        class_2794 chunkGenerator = world.method_14178().method_12129();
        return chunkGenerator instanceof StarrySkyChunkGenerator;
    }

    public void onInitialize() {
        LOGGER.info("Starting up...");
        AutoConfig.register(StarrySkyConfig.class, JanksonConfigSerializer::new);
        CONFIG = (StarrySkyConfig)AutoConfig.getConfigHolder(StarrySkyConfig.class).getConfig();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)UniqueBlockGroupDataLoader.INSTANCE);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)WeightedBlockGroupDataLoader.INSTANCE);
        class_2378.method_10230((class_2378)class_7923.field_41157, (class_2960)StarrySkies.id(MOD_ID), StarrySkyChunkGenerator.CODEC);
        StarryRegistries.register();
        StarryStateProviders.register();
        Spheres.initialize();
        StarryFeatures.initialize();
        SphereDecorators.initialize();
        StarryAdvancementCriteria.register();
        class_2316.method_10017((class_2378)class_7923.field_41192, (String)"starry_skies_configured_sphere", ConfiguredSphereArgumentType.class, (class_2314)class_2319.method_41998(ConfiguredSphereArgumentType::configuredSphere));
        CommandRegistrationCallback.EVENT.register((commandDispatcher, commandRegistryAccess, registrationEnvironment) -> {
            ClosestSphereCommand.register((CommandDispatcher<class_2168>)commandDispatcher, commandRegistryAccess);
            GenerateSphereCommand.register((CommandDispatcher<class_2168>)commandDispatcher, commandRegistryAccess);
        });
        ServerTickEvents.END_SERVER_TICK.register((Object)new ProximityAdvancementCheckEvent());
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            class_2378 generationGroupRegistry = server.method_30611().method_30530(StarryRegistryKeys.GENERATION_GROUP);
            class_2378 systemGeneratorRegistry = server.method_30611().method_30530(StarryRegistryKeys.SYSTEM_GENERATOR);
            class_2378 configuredSphereRegistry = server.method_30611().method_30530(StarryRegistryKeys.CONFIGURED_SPHERE);
            for (GenerationGroup generationGroup : generationGroupRegistry) {
                class_2960 generationGroupId = ((class_5321)generationGroupRegistry.method_29113((Object)generationGroup).get()).method_29177();
                class_2960 systemGeneratorId = generationGroup.systemGeneratorId();
                SystemGenerator systemGenerator = (SystemGenerator)systemGeneratorRegistry.method_63535(systemGeneratorId);
                if (systemGenerator == null) {
                    LOGGER.error("System generator with id {} referenced in starry skies generation group {} was not found", (Object)generationGroup.systemGeneratorId(), (Object)generationGroupId);
                    continue;
                }
                Object2ObjectArrayMap weightedSpheres = new Object2ObjectArrayMap();
                for (ConfiguredSphere sphere : configuredSphereRegistry) {
                    Optional<SphereConfig.Generation> sphereGenerationGroup = sphere.getGenerationGroup();
                    if (!sphereGenerationGroup.isPresent() || !sphereGenerationGroup.get().group().equals((Object)generationGroupId)) continue;
                    weightedSpheres.put(sphere, Float.valueOf(sphereGenerationGroup.get().weight()));
                }
                if (weightedSpheres.isEmpty()) continue;
                systemGenerator.addGenerationGroup((Map<ConfiguredSphere<?, ?>, Float>)weightedSpheres, generationGroup.weight());
            }
        });
        EntitySleepEvents.STOP_SLEEPING.register((entity, sleepingPos) -> {
            class_3222 serverPlayerEntity;
            class_3218 world;
            if (entity instanceof class_3222 && StarrySkies.isStarryWorld(world = (serverPlayerEntity = (class_3222)entity).method_51469()) && serverPlayerEntity.method_7276()) {
                long nextDay = world.method_8532() + 24000L;
                long mod = nextDay - nextDay % 24000L;
                world.method_8503().method_30002().method_29199(mod);
                if (world.method_64395().method_8355(class_1928.field_19406) && world.method_8419()) {
                    world.method_8503().method_30002().method_14195();
                }
            }
        });
        if (StarrySkies.CONFIG.registerStarryPortal) {
            StarrySkies.setupPortals();
        }
        LOGGER.info("Finished loading.");
    }

    public static void setupPortals() {
        LOGGER.info("Setting up Portal to Starry Skies...");
        class_2960 portalFrameBlockIdentifier = class_2960.method_12829((String)StarrySkies.CONFIG.starrySkyPortalFrameBlock.toLowerCase());
        class_2248 portalFrameBlock = (class_2248)class_7923.field_41175.method_63535(portalFrameBlockIdentifier);
        PortalLink portalLink = new PortalLink(portalFrameBlockIdentifier, StarryDimensionKeys.STARRY_SKIES_DIMENSION_ID, StarrySkies.CONFIG.starrySkyPortalColor);
        CustomPortalApiRegistry.addPortal((class_2248)portalFrameBlock, (PortalLink)portalLink);
    }
}

