/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.client.sky;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.dafuqs.starryskies.StarrySkies;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9848;
import net.minecraft.class_9909;
import net.minecraft.class_9916;
import net.minecraft.class_9960;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@Environment(value=EnvType.CLIENT)
public class StarrySkyBox
implements DimensionRenderingRegistry.SkyRenderer {
    private GpuBuffer skyVertexBuffer;
    private RenderSystem.class_5590 indexBuffer;
    public final class_2960 UP;
    public final class_2960 DOWN;
    public final class_2960 WEST;
    public final class_2960 EAST;
    public final class_2960 NORTH;
    public final class_2960 SOUTH;

    public StarrySkyBox(String up, String down, String west, String east, String north, String south) {
        this.UP = StarrySkies.id(up);
        this.DOWN = StarrySkies.id(down);
        this.WEST = StarrySkies.id(west);
        this.EAST = StarrySkies.id(east);
        this.NORTH = StarrySkies.id(north);
        this.SOUTH = StarrySkies.id(south);
    }

    public void render(WorldRenderContext context) {
        class_5636 cameraSubmersionType = context.camera().method_19334();
        if (cameraSubmersionType == class_5636.field_27887 || cameraSubmersionType == class_5636.field_27885 || this.hasBlindnessOrDarkness(context.camera())) {
            return;
        }
        if (this.skyVertexBuffer == null) {
            this.skyVertexBuffer = this.uploadStarrySky();
            this.indexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        }
        class_761 capture = context.worldRenderer();
        class_9909 frameGraphBuilder = capture.starrySkies$frameGraphBuilder();
        class_9960 framebufferSet = capture.starrySkies$framebufferSet();
        GpuBufferSlice fog = capture.starrySkies$fog();
        class_9916 framePass = frameGraphBuilder.method_61911("sky");
        framebufferSet.field_53091 = framePass.method_61933(framebufferSet.field_53091);
        framePass.method_61929(() -> {
            RenderSystem.setShaderFog((GpuBufferSlice)fog);
            this.renderStarrySky(context);
        });
    }

    private boolean hasBlindnessOrDarkness(class_4184 camera) {
        class_1309 livingEntity;
        class_1297 focusedEntity = camera.method_19331();
        return focusedEntity instanceof class_1309 && ((livingEntity = (class_1309)focusedEntity).method_6059(class_1294.field_5919) || livingEntity.method_6059(class_1294.field_38092));
    }

    private void renderStarrySky(WorldRenderContext context) {
        class_1044[] skyTextures;
        class_310 client = class_310.method_1551();
        class_1060 textureManager = client.method_1531();
        for (class_1044 skyTexture : skyTextures = new class_1044[]{textureManager.method_4619(this.NORTH), textureManager.method_4619(this.SOUTH), textureManager.method_4619(this.EAST), textureManager.method_4619(this.WEST), textureManager.method_4619(this.UP), textureManager.method_4619(this.DOWN)}) {
            skyTexture.method_4527(false, false);
        }
        class_4184 camera = context.camera();
        class_638 world = context.world();
        float tickProgress = context.tickCounter().method_60637(false);
        int color = world.method_23777(camera.method_19326(), tickProgress);
        Vector4f colorVec = new Vector4f(class_9848.method_65101((int)color), class_9848.method_65102((int)color), class_9848.method_65103((int)color), class_9848.method_65100((int)color));
        GpuBufferSlice colorTransform = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)colorVec, (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
        GpuBuffer idxBuf = this.indexBuffer.method_68274(36);
        class_276 framebuffer = client.method_1522();
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Starry Skies skybox", framebuffer.method_71639(), OptionalInt.empty(), framebuffer.field_1478 ? framebuffer.method_71640() : null, OptionalDouble.empty());){
            renderPass.setPipeline(class_10799.field_56875);
            RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
            renderPass.setUniform("DynamicTransforms", colorTransform);
            renderPass.setIndexBuffer(idxBuf, this.indexBuffer.method_31924());
            renderPass.setVertexBuffer(0, this.skyVertexBuffer);
            for (int i = 0; i < 6; ++i) {
                renderPass.bindSampler("Sampler0", skyTextures[i].method_71659());
                renderPass.drawIndexed(0, 6 * i, 6, 1);
            }
        }
    }

    private GpuBuffer uploadStarrySky() {
        try (class_9799 bufferAllocator = class_9799.method_72201((int)(24 * class_290.field_1575.getVertexSize()));){
            GpuBuffer gpuBuffer;
            block12: {
                class_287 bufferBuilder = new class_287(bufferAllocator, VertexFormat.class_5596.field_27382, class_290.field_1575);
                int color = -1;
                bufferBuilder.method_22912(-100.0f, -100.0f, -100.0f).method_22913(0.0f, 1.0f).method_39415(-1);
                bufferBuilder.method_22912(100.0f, -100.0f, -100.0f).method_22913(1.0f, 1.0f).method_39415(-1);
                bufferBuilder.method_22912(100.0f, 100.0f, -100.0f).method_22913(1.0f, 0.0f).method_39415(-1);
                bufferBuilder.method_22912(-100.0f, 100.0f, -100.0f).method_22913(0.0f, 0.0f).method_39415(-1);
                bufferBuilder.method_22912(100.0f, -100.0f, 100.0f).method_22913(0.0f, 1.0f).method_39415(-1);
                bufferBuilder.method_22912(-100.0f, -100.0f, 100.0f).method_22913(1.0f, 1.0f).method_39415(-1);
                bufferBuilder.method_22912(-100.0f, 100.0f, 100.0f).method_22913(1.0f, 0.0f).method_39415(-1);
                bufferBuilder.method_22912(100.0f, 100.0f, 100.0f).method_22913(0.0f, 0.0f).method_39415(-1);
                bufferBuilder.method_22912(100.0f, -100.0f, -100.0f).method_22913(0.0f, 1.0f).method_39415(-1);
                bufferBuilder.method_22912(100.0f, -100.0f, 100.0f).method_22913(1.0f, 1.0f).method_39415(-1);
                bufferBuilder.method_22912(100.0f, 100.0f, 100.0f).method_22913(1.0f, 0.0f).method_39415(-1);
                bufferBuilder.method_22912(100.0f, 100.0f, -100.0f).method_22913(0.0f, 0.0f).method_39415(-1);
                bufferBuilder.method_22912(-100.0f, -100.0f, 100.0f).method_22913(0.0f, 1.0f).method_39415(-1);
                bufferBuilder.method_22912(-100.0f, -100.0f, -100.0f).method_22913(1.0f, 1.0f).method_39415(-1);
                bufferBuilder.method_22912(-100.0f, 100.0f, -100.0f).method_22913(1.0f, 0.0f).method_39415(-1);
                bufferBuilder.method_22912(-100.0f, 100.0f, 100.0f).method_22913(0.0f, 0.0f).method_39415(-1);
                bufferBuilder.method_22912(-100.0f, 100.0f, -100.0f).method_22913(0.0f, 1.0f).method_39415(-1);
                bufferBuilder.method_22912(100.0f, 100.0f, -100.0f).method_22913(1.0f, 1.0f).method_39415(-1);
                bufferBuilder.method_22912(100.0f, 100.0f, 100.0f).method_22913(1.0f, 0.0f).method_39415(-1);
                bufferBuilder.method_22912(-100.0f, 100.0f, 100.0f).method_22913(0.0f, 0.0f).method_39415(-1);
                bufferBuilder.method_22912(-100.0f, -100.0f, 100.0f).method_22913(0.0f, 1.0f).method_39415(-1);
                bufferBuilder.method_22912(100.0f, -100.0f, 100.0f).method_22913(1.0f, 1.0f).method_39415(-1);
                bufferBuilder.method_22912(100.0f, -100.0f, -100.0f).method_22913(1.0f, 0.0f).method_39415(-1);
                bufferBuilder.method_22912(-100.0f, -100.0f, -100.0f).method_22913(0.0f, 0.0f).method_39415(-1);
                class_9801 builtBuffer = bufferBuilder.method_60800();
                try {
                    gpuBuffer = RenderSystem.getDevice().createBuffer(() -> "StarrySkies sky vertex buffer", 32, builtBuffer.method_60818());
                    if (builtBuffer == null) break block12;
                }
                catch (Throwable throwable) {
                    if (builtBuffer != null) {
                        try {
                            builtBuffer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builtBuffer.close();
            }
            return gpuBuffer;
        }
    }
}

