/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.data_loaders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.starryskies.StarrySkies;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5819;
import net.minecraft.class_7654;
import net.minecraft.class_7923;

public class UniqueBlockGroupDataLoader
extends class_4309<Entry>
implements IdentifiableResourceReloadListener {
    public static final String LOCATION = "starry_skies/unique_block_group";
    public static final class_2960 ID = StarrySkies.id("starry_skies/unique_block_group");
    public static final UniqueBlockGroupDataLoader INSTANCE = new UniqueBlockGroupDataLoader();
    protected static final Map<String, class_2248> GROUPS = new Object2ObjectArrayMap();

    private UniqueBlockGroupDataLoader() {
        super(Entry.CODEC, class_7654.method_45114((String)LOCATION));
    }

    protected void apply(Map<class_2960, Entry> prepared, class_3300 manager, class_3695 profiler) {
        for (Map.Entry<class_2960, Entry> entry : prepared.entrySet()) {
            String groupName = entry.getValue().group;
            if (GROUPS.containsKey(groupName)) {
                return;
            }
            Iterator<class_2960> iterator = entry.getValue().blockIDs.iterator();
            if (!iterator.hasNext()) continue;
            class_2960 blockId = iterator.next();
            Optional optionalBlock = class_7923.field_41175.method_17966(blockId);
            optionalBlock.ifPresent(block -> GROUPS.put(groupName, (class_2248)block));
            return;
        }
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public class_2248 get(String id) {
        return GROUPS.get(id);
    }

    public class_2680 getEntry(String group, class_5819 random) {
        class_2248 block = INSTANCE.get(group);
        if (block == null) {
            StarrySkies.LOGGER.warn("Trying to query a nonexistent UniqueBlockGroup: {}", (Object)group);
            StarrySkies.LOGGER.error(Arrays.toString(Thread.currentThread().getStackTrace()));
            return class_2246.field_10124.method_9564();
        }
        return block.method_9564();
    }

    public record Entry(String group, List<class_2960> blockIDs) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("group").forGetter(Entry::group), (App)class_2960.field_25139.listOf().fieldOf("blocks").forGetter(Entry::blockIDs)).apply((Applicative)instance, Entry::new));
    }
}

