/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen.decorators;

import com.mojang.serialization.Codec;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.SphereDecorator;
import de.dafuqs.starryskies.worldgen.SphereFeatureContext;
import de.dafuqs.starryskies.worldgen.decorators.DripleafDecoratorConfig;
import java.util.Iterator;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class DripleafDecorator
extends SphereDecorator<DripleafDecoratorConfig> {
    private static final class_2680 DRIPLEAF_BLOCK_STATE = class_2246.field_28682.method_9564();
    private static final class_2680 DRIPLEAF_STEM_BLOCK_STATE = class_2246.field_28683.method_9564();
    private static final class_2680 WATER_BLOCK_STATE = class_2246.field_10382.method_9564();
    private static final class_2680 CLAY_BLOCK_STATE = class_2246.field_10460.method_9564();

    public DripleafDecorator(Codec<DripleafDecoratorConfig> codec) {
        super(codec);
    }

    @Override
    public boolean generate(SphereFeatureContext<DripleafDecoratorConfig> context) {
        class_5281 world = context.getWorld();
        PlacedSphere<?> sphere = context.getSphere();
        class_1923 origin = context.getChunkPos();
        class_5819 random = context.getRandom();
        DripleafDecoratorConfig config = context.getConfig();
        for (class_2338 bp : this.getRandomCaveBottomBlocks(world, origin, sphere, random, config.tries())) {
            boolean canGenerate = true;
            Iterator direction = class_2350.class_2353.field_11062.iterator();
            while (direction.hasNext() && canGenerate) {
                class_2338 currentCheckBlockPos = bp.method_10093((class_2350)direction.next());
                if (world.method_8320(currentCheckBlockPos).method_26212((class_1922)world, currentCheckBlockPos) && world.method_8320(currentCheckBlockPos.method_10084()).method_26215()) continue;
                canGenerate = false;
            }
            if (!canGenerate) continue;
            world.method_8652(bp, CLAY_BLOCK_STATE, 3);
            class_2350 randomDirection = class_2350.class_2353.field_11062.method_10183(random);
            int dripLeafHeight = random.method_43048(3) + 1;
            for (int i = 0; i <= dripLeafHeight; ++i) {
                class_2680 dripleafState = (class_2680)DRIPLEAF_BLOCK_STATE.method_11657((class_2769)class_2383.field_11177, (Comparable)randomDirection);
                if (!dripleafState.method_26184((class_4538)world, bp.method_10086(i))) continue;
                if (i == dripLeafHeight) {
                    world.method_8652(bp.method_10086(i), (class_2680)DRIPLEAF_BLOCK_STATE.method_11657((class_2769)class_2383.field_11177, (Comparable)randomDirection), 3);
                    continue;
                }
                world.method_8652(bp.method_10086(i), (class_2680)DRIPLEAF_STEM_BLOCK_STATE.method_11657((class_2769)class_2383.field_11177, (Comparable)randomDirection), 3);
            }
            for (class_2350 currentDirection : class_2350.class_2353.field_11062) {
                class_2338 offsetPos = bp.method_10093(currentDirection);
                if (!world.method_8320(offsetPos.method_10084()).method_26215()) continue;
                world.method_8652(offsetPos, WATER_BLOCK_STATE, 3);
            }
        }
        return true;
    }
}

