/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen.decorators;

import com.mojang.serialization.Codec;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.SphereDecorator;
import de.dafuqs.starryskies.worldgen.SphereFeatureContext;
import de.dafuqs.starryskies.worldgen.decorators.LootChestDecoratorConfig;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class LootChestDecorator
extends SphereDecorator<LootChestDecoratorConfig> {
    public LootChestDecorator(Codec<LootChestDecoratorConfig> codec) {
        super(codec);
    }

    @Override
    public boolean generate(SphereFeatureContext<LootChestDecoratorConfig> context) {
        class_2338 chestPos;
        class_5281 world = context.getWorld();
        PlacedSphere<?> sphere = context.getSphere();
        class_1923 origin = context.getChunkPos();
        class_5819 random = context.getRandom();
        LootChestDecoratorConfig config = context.getConfig();
        if (!sphere.isCenterInChunk(origin)) {
            return false;
        }
        LootChestDecoratorConfig.Position position = config.position();
        switch (position) {
            default: {
                throw new MatchException(null, null);
            }
            case TOP_CENTER: {
                class_2338 class_23382 = sphere.getPosition().method_10086(sphere.getRadius() + 1);
                break;
            }
            case CENTER: {
                class_2338 class_23382 = sphere.getPosition();
                break;
            }
            case CAVE_FLOOR: {
                class_2338 class_23382 = chestPos = this.getCaveBottomBlock(world, sphere.getPosition().method_10084(), sphere);
            }
        }
        if (chestPos != null) {
            this.placeLootChest(world, chestPos, config.lootTable(), random);
            return true;
        }
        return false;
    }
}

