/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen.spheres;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.state_providers.SphereStateProvider;
import de.dafuqs.starryskies.worldgen.ConfiguredSphere;
import de.dafuqs.starryskies.worldgen.ConfiguredSphereDecorator;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.Sphere;
import de.dafuqs.starryskies.worldgen.SphereConfig;
import de.dafuqs.starryskies.worldgen.SphereEntitySpawnDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_2230;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2472;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_3545;
import net.minecraft.class_4651;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5863;
import net.minecraft.class_6017;
import net.minecraft.class_6880;

public class CoralsSphere
extends Sphere<Config> {
    public static final ArrayList<class_2680> LIST_FULL_CORAL_BLOCKS = new ArrayList<class_2680>(){
        {
            this.add(class_2246.field_10629.method_9564());
            this.add(class_2246.field_10309.method_9564());
            this.add(class_2246.field_10000.method_9564());
            this.add(class_2246.field_10516.method_9564());
            this.add(class_2246.field_10464.method_9564());
        }
    };
    public static final ArrayList<class_2680> LIST_WATERLOGGABLE_CORAL_BLOCKS = new ArrayList<class_2680>(){
        {
            this.add((class_2680)class_2246.field_10339.method_9564().method_11657((class_2769)class_2230.field_9940, (Comparable)Boolean.valueOf(true)));
            this.add((class_2680)class_2246.field_10125.method_9564().method_11657((class_2769)class_2230.field_9940, (Comparable)Boolean.valueOf(true)));
            this.add((class_2680)class_2246.field_10134.method_9564().method_11657((class_2769)class_2230.field_9940, (Comparable)Boolean.valueOf(true)));
            this.add((class_2680)class_2246.field_10618.method_9564().method_11657((class_2769)class_2230.field_9940, (Comparable)Boolean.valueOf(true)));
            this.add((class_2680)class_2246.field_10169.method_9564().method_11657((class_2769)class_2230.field_9940, (Comparable)Boolean.valueOf(true)));
            this.add((class_2680)class_2246.field_10079.method_9564().method_11657((class_2769)class_2230.field_9940, (Comparable)Boolean.valueOf(true)));
            this.add((class_2680)class_2246.field_10053.method_9564().method_11657((class_2769)class_2230.field_9940, (Comparable)Boolean.valueOf(true)));
            this.add((class_2680)class_2246.field_10427.method_9564().method_11657((class_2769)class_2230.field_9940, (Comparable)Boolean.valueOf(true)));
            this.add((class_2680)class_2246.field_10551.method_9564().method_11657((class_2769)class_2230.field_9940, (Comparable)Boolean.valueOf(true)));
            this.add((class_2680)class_2246.field_10005.method_9564().method_11657((class_2769)class_2230.field_9940, (Comparable)Boolean.valueOf(true)));
            this.add((class_2680)((class_2680)class_2246.field_10476.method_9564().method_11657((class_2769)class_2472.field_11475, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2472.field_11472, (Comparable)Integer.valueOf(1)));
            this.add((class_2680)((class_2680)class_2246.field_10476.method_9564().method_11657((class_2769)class_2472.field_11475, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2472.field_11472, (Comparable)Integer.valueOf(2)));
            this.add((class_2680)((class_2680)class_2246.field_10476.method_9564().method_11657((class_2769)class_2472.field_11475, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2472.field_11472, (Comparable)Integer.valueOf(3)));
            this.add((class_2680)((class_2680)class_2246.field_10476.method_9564().method_11657((class_2769)class_2472.field_11475, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2472.field_11472, (Comparable)Integer.valueOf(4)));
        }
    };
    protected static class_2680 WATER = class_2246.field_10382.method_9564();

    public CoralsSphere(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public PlacedSphere<?> generate(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, Config config, class_2919 random, class_5455 registryManager, class_2338 pos, float radius) {
        return new Placed(configuredSphere, radius, configuredSphere.getDecorators(random), configuredSphere.getSpawns(random), random, config.shellBlock.getForSphere((class_5819)random, pos), config.shellThickness.method_35008((class_5819)random));
    }

    public static class Placed
    extends PlacedSphere<Config> {
        private final class_4651 shellBlock;
        private final float shellRadius;

        public Placed(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, float radius, List<class_6880<ConfiguredSphereDecorator<?, ?>>> decorators, List<class_3545<class_1299<?>, Integer>> spawns, class_2919 random, class_4651 shellBlock, float shellRadius) {
            super(configuredSphere, radius, decorators, spawns, random);
            this.shellBlock = shellBlock;
            this.shellRadius = shellRadius;
        }

        @Override
        public void generate(class_2791 chunk, class_5455 registryManager) {
            int chunkX = chunk.method_12004().field_9181;
            int chunkZ = chunk.method_12004().field_9180;
            this.random.method_43052((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
            class_2338 spherePos = this.getPosition();
            int x = spherePos.method_10263();
            int y = spherePos.method_10264();
            int z = spherePos.method_10260();
            int ceiledRadius = (int)Math.ceil(this.radius);
            int maxX = Math.min(chunkX * 16 + 15, x + ceiledRadius);
            int maxZ = Math.min(chunkZ * 16 + 15, z + ceiledRadius);
            class_2338.class_2339 currBlockPos = new class_2338.class_2339();
            for (int x2 = Math.max(chunkX * 16, x - ceiledRadius); x2 <= maxX; ++x2) {
                for (int y2 = y - ceiledRadius; y2 <= y + ceiledRadius; ++y2) {
                    for (int z2 = Math.max(chunkZ * 16, z - ceiledRadius); z2 <= maxZ; ++z2) {
                        long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                        if ((float)d > this.radius) continue;
                        currBlockPos.method_10103(x2, y2, z2);
                        if ((float)d <= this.radius - this.shellRadius - 1.0f) {
                            int rand = this.random.method_43048(7);
                            if (rand < 2) {
                                class_2680 coral = this.getRandomCoralBlock(this.random);
                                if (rand == 0 && chunk.method_8320(currBlockPos.method_10074()).method_26204() == class_2246.field_10382) {
                                    chunk.method_66480(currBlockPos.method_10074(), coral);
                                    chunk.method_66480((class_2338)currBlockPos, this.getRandomWaterLoggableBlock(this.random));
                                    continue;
                                }
                                chunk.method_66480((class_2338)currBlockPos, coral);
                                continue;
                            }
                            chunk.method_66480((class_2338)currBlockPos, WATER);
                            continue;
                        }
                        if ((float)d <= this.radius - this.shellRadius) {
                            chunk.method_66480((class_2338)currBlockPos, WATER);
                            continue;
                        }
                        chunk.method_66480((class_2338)currBlockPos, this.shellBlock.method_23455((class_5819)this.random, (class_2338)currBlockPos));
                    }
                }
            }
        }

        public class_2680 getRandomCoralBlock(class_2919 random) {
            return LIST_FULL_CORAL_BLOCKS.get(random.method_43048(LIST_FULL_CORAL_BLOCKS.size()));
        }

        public class_2680 getRandomWaterLoggableBlock(class_2919 random) {
            return LIST_WATERLOGGABLE_CORAL_BLOCKS.get(random.method_43048(LIST_WATERLOGGABLE_CORAL_BLOCKS.size()));
        }

        @Override
        public String getDescription(class_5455 registryManager) {
            return "+++ CoralSphere +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nTemplateID: " + String.valueOf(this.getID(registryManager)) + "\nRadius: " + this.radius + "\nShell: " + this.shellBlock.toString() + " (Radius: " + this.shellRadius + ")";
        }
    }

    public static class Config
    extends SphereConfig {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SphereConfig.CONFIG_CODEC.forGetter(config -> config), (App)SphereStateProvider.CODEC.fieldOf("shell_block").forGetter(config -> config.shellBlock), (App)class_6017.field_33451.fieldOf("shell_thickness").forGetter(config -> config.shellThickness), (App)class_5699.field_53754.fieldOf("hole_in_bottom_chance").forGetter(config -> Float.valueOf(config.holeInBottomChance))).apply((Applicative)instance, (sphereConfig, shellBlock, shellThickness, holeInBottomChance) -> new Config(sphereConfig.size, sphereConfig.decorators, sphereConfig.spawns, sphereConfig.generation, (SphereStateProvider)shellBlock, (class_6017)shellThickness, holeInBottomChance.floatValue())));
        protected final SphereStateProvider shellBlock;
        protected final class_6017 shellThickness;
        protected final float holeInBottomChance;

        public Config(class_5863 size, Map<class_6880<ConfiguredSphereDecorator<?, ?>>, Float> decorators, List<SphereEntitySpawnDefinition> spawns, Optional<SphereConfig.Generation> generation, SphereStateProvider shellBlock, class_6017 shellThickness, float holeInBottomChance) {
            super(size, decorators, spawns, generation);
            this.shellBlock = shellBlock;
            this.shellThickness = shellThickness;
            this.holeInBottomChance = holeInBottomChance;
        }
    }
}

