/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen.spheres;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.state_providers.SphereStateProvider;
import de.dafuqs.starryskies.worldgen.ConfiguredSphere;
import de.dafuqs.starryskies.worldgen.ConfiguredSphereDecorator;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.Sphere;
import de.dafuqs.starryskies.worldgen.SphereConfig;
import de.dafuqs.starryskies.worldgen.SphereEntitySpawnDefinition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_3545;
import net.minecraft.class_4651;
import net.minecraft.class_5455;
import net.minecraft.class_5543;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5863;
import net.minecraft.class_6880;

public class GeodeSphere
extends Sphere<Config> {
    public GeodeSphere(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public PlacedSphere<?> generate(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, Config config, class_2919 random, class_5455 registryManager, class_2338 pos, float radius) {
        return new Placed(configuredSphere, radius, configuredSphere.getDecorators(random), configuredSphere.getSpawns(random), random, config.innerBlockState.getForSphere((class_5819)random, pos), config.innerSpecklesBlockState.getForSphere((class_5819)random, pos), config.speckleChance, config.innerSpecklesAttachedBlockState.getForSphere((class_5819)random, pos), config.middleBlockState.getForSphere((class_5819)random, pos), config.outerBlockState.getForSphere((class_5819)random, pos));
    }

    public static class Placed
    extends PlacedSphere<Config> {
        private final class_4651 innerBlockState;
        private final class_4651 innerSpecklesBlockState;
        private final float speckleChance;
        private final class_4651 innerSpecklesAttachedBlockState;
        private final class_4651 middleBlockState;
        private final class_4651 outerBlockState;

        public Placed(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, float radius, List<class_6880<ConfiguredSphereDecorator<?, ?>>> decorators, List<class_3545<class_1299<?>, Integer>> spawns, class_2919 random, class_4651 innerBlockState, class_4651 innerSpecklesBlockState, float speckleChance, class_4651 innerSpecklesAttachedBlockState, class_4651 middleBlockState, class_4651 outerBlockState) {
            super(configuredSphere, radius, decorators, spawns, random);
            this.innerBlockState = innerBlockState;
            this.innerSpecklesBlockState = innerSpecklesBlockState;
            this.speckleChance = speckleChance;
            this.innerSpecklesAttachedBlockState = innerSpecklesAttachedBlockState;
            this.middleBlockState = middleBlockState;
            this.outerBlockState = outerBlockState;
        }

        @Override
        public void generate(class_2791 chunk, class_5455 registryManager) {
            int chunkX = chunk.method_12004().field_9181;
            int chunkZ = chunk.method_12004().field_9180;
            this.random.method_43052((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
            class_2338 spherePos = this.getPosition();
            int x = spherePos.method_10263();
            int y = spherePos.method_10264();
            int z = spherePos.method_10260();
            int ceiledRadius = (int)Math.ceil(this.radius);
            int maxX = Math.min(chunkX * 16 + 15, x + ceiledRadius);
            int maxZ = Math.min(chunkZ * 16 + 15, z + ceiledRadius);
            class_2338.class_2339 currBlockPos = new class_2338.class_2339();
            for (int x2 = Math.max(chunkX * 16, x - ceiledRadius); x2 <= maxX; ++x2) {
                for (int y2 = y - ceiledRadius; y2 <= y + ceiledRadius; ++y2) {
                    for (int z2 = Math.max(chunkZ * 16, z - ceiledRadius); z2 <= maxZ; ++z2) {
                        long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                        if ((float)d > this.radius) continue;
                        currBlockPos.method_10103(x2, y2, z2);
                        if ((float)d < this.radius - 4.0f) continue;
                        if ((float)d < this.radius - 3.0f) {
                            if (this.random.method_43057() < this.speckleChance) {
                                chunk.method_66480((class_2338)currBlockPos, this.innerSpecklesBlockState.method_23455((class_5819)this.random, (class_2338)currBlockPos));
                                for (class_2350 direction : class_2350.values()) {
                                    class_2338 posInDirection = currBlockPos.method_10093(direction);
                                    class_2680 crystalState = this.innerSpecklesAttachedBlockState.method_23455((class_5819)this.random, posInDirection);
                                    if (!Support.isBlockPosInChunkPos(chunk.method_12004(), posInDirection) || !class_5543.method_31626((class_2680)chunk.method_8320(posInDirection))) continue;
                                    if (crystalState.method_28498((class_2769)class_2741.field_12525)) {
                                        crystalState = (class_2680)crystalState.method_11657((class_2769)class_2741.field_12525, (Comparable)direction);
                                    }
                                    chunk.method_66480(posInDirection, crystalState);
                                }
                                continue;
                            }
                            chunk.method_66480((class_2338)currBlockPos, this.innerBlockState.method_23455((class_5819)this.random, (class_2338)currBlockPos));
                            continue;
                        }
                        if ((float)d < this.radius - 2.0f) {
                            chunk.method_66480((class_2338)currBlockPos, this.middleBlockState.method_23455((class_5819)this.random, (class_2338)currBlockPos));
                            continue;
                        }
                        if (!((float)d < this.radius - 1.0f)) continue;
                        chunk.method_66480((class_2338)currBlockPos, this.outerBlockState.method_23455((class_5819)this.random, (class_2338)currBlockPos));
                    }
                }
            }
        }

        @Override
        public String getDescription(class_5455 registryManager) {
            return "+++ GeodeSphere +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nTemplateID: " + String.valueOf(this.getID(registryManager)) + "\nRadius: " + this.radius + "\nInnerBlock: " + String.valueOf(this.innerBlockState) + "\nInnerSpecklesBlock: " + String.valueOf(this.innerSpecklesBlockState) + "\nSpeckleChance: " + this.speckleChance + "\nMiddleBlock: " + String.valueOf(this.middleBlockState) + "\nOuterBlock: " + String.valueOf(this.outerBlockState);
        }
    }

    public static class Config
    extends SphereConfig {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SphereConfig.CONFIG_CODEC.forGetter(config -> config), (App)SphereStateProvider.CODEC.fieldOf("inner_block").forGetter(config -> config.innerBlockState), (App)SphereStateProvider.CODEC.fieldOf("inner_speckles_block").forGetter(config -> config.innerSpecklesBlockState), (App)class_5699.field_34387.fieldOf("inner_speckles_block_chance").forGetter(config -> Float.valueOf(config.speckleChance)), (App)SphereStateProvider.CODEC.fieldOf("inner_speckles_attached_block").forGetter(config -> config.innerSpecklesAttachedBlockState), (App)SphereStateProvider.CODEC.fieldOf("middle_block").forGetter(config -> config.middleBlockState), (App)SphereStateProvider.CODEC.fieldOf("outer_block").forGetter(config -> config.outerBlockState)).apply((Applicative)instance, (sphereConfig, innerBlockState, innerSpecklesBlockState, speckleChance, innerSpecklesAttachedBlockState, middleBlockState, outerBlockState) -> new Config(sphereConfig.size, sphereConfig.decorators, sphereConfig.spawns, sphereConfig.generation, (SphereStateProvider)innerBlockState, (SphereStateProvider)innerSpecklesBlockState, speckleChance.floatValue(), (SphereStateProvider)innerSpecklesAttachedBlockState, (SphereStateProvider)middleBlockState, (SphereStateProvider)outerBlockState)));
        private final SphereStateProvider innerBlockState;
        private final SphereStateProvider innerSpecklesBlockState;
        private final float speckleChance;
        private final SphereStateProvider innerSpecklesAttachedBlockState;
        private final SphereStateProvider middleBlockState;
        private final SphereStateProvider outerBlockState;

        public Config(class_5863 size, Map<class_6880<ConfiguredSphereDecorator<?, ?>>, Float> decorators, List<SphereEntitySpawnDefinition> spawns, Optional<SphereConfig.Generation> generation, SphereStateProvider innerBlockState, SphereStateProvider innerSpecklesBlockState, float speckleChance, SphereStateProvider innerSpecklesAttachedBlockState, SphereStateProvider middleBlockState, SphereStateProvider outerBlockState) {
            super(size, decorators, spawns, generation);
            this.innerBlockState = innerBlockState;
            this.innerSpecklesBlockState = innerSpecklesBlockState;
            this.speckleChance = speckleChance;
            this.innerSpecklesAttachedBlockState = innerSpecklesAttachedBlockState;
            this.middleBlockState = middleBlockState;
            this.outerBlockState = outerBlockState;
        }
    }
}

