/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import dev.hexnowloading.dungeonnowloading.block.MendingAuraBlock;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MendingAuraCrossCollisionBlock
extends MendingAuraBlock {
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().filter(entry -> ((Direction)entry.getKey()).m_122434_().m_122479_()).collect(Util.m_137448_());
    protected final VoxelShape[] collisionShapeByIndex;
    protected final VoxelShape[] shapeByIndex;
    private final Object2IntMap<BlockState> stateToIndex = new Object2IntOpenHashMap();

    public MendingAuraCrossCollisionBlock(float f, float g, float h, float i, float j, BlockBehaviour.Properties properties) {
        super(properties);
        this.collisionShapeByIndex = this.makeShapes(f, g, j, 0.0f, j);
        this.shapeByIndex = this.makeShapes(f, g, h, 0.0f, i);
        for (BlockState blockState : this.f_49792_.m_61056_()) {
            this.getAABBIndex(blockState);
        }
    }

    protected VoxelShape[] makeShapes(float f, float g, float h, float i, float j) {
        float k = 8.0f - f;
        float l = 8.0f + f;
        float m = 8.0f - g;
        float n = 8.0f + g;
        VoxelShape voxelShape = Block.m_49796_((double)k, (double)0.0, (double)k, (double)l, (double)h, (double)l);
        VoxelShape voxelShape2 = Block.m_49796_((double)m, (double)i, (double)0.0, (double)n, (double)j, (double)n);
        VoxelShape voxelShape3 = Block.m_49796_((double)m, (double)i, (double)m, (double)n, (double)j, (double)16.0);
        VoxelShape voxelShape4 = Block.m_49796_((double)0.0, (double)i, (double)m, (double)n, (double)j, (double)n);
        VoxelShape voxelShape5 = Block.m_49796_((double)m, (double)i, (double)m, (double)16.0, (double)j, (double)n);
        VoxelShape voxelShape6 = Shapes.m_83110_((VoxelShape)voxelShape2, (VoxelShape)voxelShape5);
        VoxelShape voxelShape7 = Shapes.m_83110_((VoxelShape)voxelShape3, (VoxelShape)voxelShape4);
        VoxelShape[] voxelShapes = new VoxelShape[]{Shapes.m_83040_(), voxelShape3, voxelShape4, voxelShape7, voxelShape2, Shapes.m_83110_((VoxelShape)voxelShape3, (VoxelShape)voxelShape2), Shapes.m_83110_((VoxelShape)voxelShape4, (VoxelShape)voxelShape2), Shapes.m_83110_((VoxelShape)voxelShape7, (VoxelShape)voxelShape2), voxelShape5, Shapes.m_83110_((VoxelShape)voxelShape3, (VoxelShape)voxelShape5), Shapes.m_83110_((VoxelShape)voxelShape4, (VoxelShape)voxelShape5), Shapes.m_83110_((VoxelShape)voxelShape7, (VoxelShape)voxelShape5), voxelShape6, Shapes.m_83110_((VoxelShape)voxelShape3, (VoxelShape)voxelShape6), Shapes.m_83110_((VoxelShape)voxelShape4, (VoxelShape)voxelShape6), Shapes.m_83110_((VoxelShape)voxelShape7, (VoxelShape)voxelShape6)};
        for (int o = 0; o < 16; ++o) {
            voxelShapes[o] = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)voxelShapes[o]);
        }
        return voxelShapes;
    }

    @Override
    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) == false;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.shapeByIndex[this.getAABBIndex(blockState)];
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.collisionShapeByIndex[this.getAABBIndex(blockState)];
    }

    private static int indexFor(Direction direction) {
        return 1 << direction.m_122416_();
    }

    protected int getAABBIndex(BlockState blockState2) {
        return this.stateToIndex.computeIntIfAbsent((Object)blockState2, blockState -> {
            int i = 0;
            if (((Boolean)blockState.m_61143_((Property)NORTH)).booleanValue()) {
                i |= MendingAuraCrossCollisionBlock.indexFor(Direction.NORTH);
            }
            if (((Boolean)blockState.m_61143_((Property)EAST)).booleanValue()) {
                i |= MendingAuraCrossCollisionBlock.indexFor(Direction.EAST);
            }
            if (((Boolean)blockState.m_61143_((Property)SOUTH)).booleanValue()) {
                i |= MendingAuraCrossCollisionBlock.indexFor(Direction.SOUTH);
            }
            if (((Boolean)blockState.m_61143_((Property)WEST)).booleanValue()) {
                i |= MendingAuraCrossCollisionBlock.indexFor(Direction.WEST);
            }
            return i;
        });
    }

    @Override
    public FluidState m_5888_(BlockState blockState) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(blockState);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)NORTH, (Comparable)((Boolean)blockState.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)blockState.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)blockState.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)blockState.m_61143_((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)NORTH, (Comparable)((Boolean)blockState.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)blockState.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)blockState.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)blockState.m_61143_((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)NORTH, (Comparable)((Boolean)blockState.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)blockState.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)blockState.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)blockState.m_61143_((Property)SOUTH)));
            }
        }
        return blockState;
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)blockState.m_61124_((Property)NORTH, (Comparable)((Boolean)blockState.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)blockState.m_61143_((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)blockState.m_61124_((Property)EAST, (Comparable)((Boolean)blockState.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)blockState.m_61143_((Property)EAST)));
            }
        }
        return super.m_6943_(blockState, mirror);
    }
}

