/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import com.google.common.collect.ImmutableList;
import dev.hexnowloading.dungeonnowloading.entity.ai.StoppableGoal;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.BorusArrowEntity;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class FairkeeperBorosPursueAndShootArrowGoal
extends StoppableGoal {
    private final FairkeeperBorosEntity boros;
    private final FairkeeperBorosEntity.FairkeeperBorosState state;
    private final ShootingPattern pattern;
    private final double speed;
    private LivingEntity target;
    private Vec3 targetPosition;
    private final double shootingRange;
    private int stoppingTick;
    private int maxShootingCooldown;
    private int shootingCooldown;
    private int targetIndex;
    private int totalDuration;
    private static final int EXPIRY_DURATION = 300;
    private static final int STOP_DURATION = 42;
    private static final int BEAM_TICK = 40;
    private static final int SHOOT_ARROW_TICK = 25;
    private static final int CLOSE_MOUTH_TICK = 18;
    private static final int DEFAULT_SHOOTING_COOLDOWN = 60;
    private static final float ADDED_SPEED = 0.2f;
    public static final ShootingPattern PATTERN_SINGLE = new ShootingPattern((ImmutableList<ImmutableList<Float>>)ImmutableList.of((Object)ImmutableList.of((Object)Float.valueOf(0.0f)), (Object)ImmutableList.of((Object)Float.valueOf(0.0f)), (Object)ImmutableList.of((Object)Float.valueOf(0.0f))));
    public static final ShootingPattern PATTERN_DOUBLE = new ShootingPattern((ImmutableList<ImmutableList<Float>>)ImmutableList.of((Object)ImmutableList.of((Object)Float.valueOf(10.0f), (Object)Float.valueOf(-10.0f)), (Object)ImmutableList.of((Object)Float.valueOf(10.0f), (Object)Float.valueOf(-10.0f)), (Object)ImmutableList.of((Object)Float.valueOf(10.0f), (Object)Float.valueOf(-10.0f))));
    public static final ShootingPattern PATTERN_TRIPLE = new ShootingPattern((ImmutableList<ImmutableList<Float>>)ImmutableList.of((Object)ImmutableList.of((Object)Float.valueOf(15.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(-15.0f)), (Object)ImmutableList.of((Object)Float.valueOf(15.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(-15.0f)), (Object)ImmutableList.of((Object)Float.valueOf(15.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(-15.0f))));
    public static final ShootingPattern PATTERN_DESPERATE = new ShootingPattern((ImmutableList<ImmutableList<Float>>)ImmutableList.of((Object)ImmutableList.of((Object)Float.valueOf(25.0f), (Object)Float.valueOf(15.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(-15.0f), (Object)Float.valueOf(-25.0f)), (Object)ImmutableList.of((Object)Float.valueOf(30.0f), (Object)Float.valueOf(10.0f), (Object)Float.valueOf(-10.0f), (Object)Float.valueOf(-30.0f)), (Object)ImmutableList.of((Object)Float.valueOf(25.0f), (Object)Float.valueOf(15.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(-15.0f), (Object)Float.valueOf(-25.0f)), (Object)ImmutableList.of((Object)Float.valueOf(30.0f), (Object)Float.valueOf(10.0f), (Object)Float.valueOf(-10.0f), (Object)Float.valueOf(-30.0f)), (Object)ImmutableList.of((Object)Float.valueOf(30.0f), (Object)Float.valueOf(20.0f), (Object)Float.valueOf(10.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(-10.0f), (Object)Float.valueOf(-50.0f))));

    public FairkeeperBorosPursueAndShootArrowGoal(FairkeeperBorosEntity.FairkeeperBorosState state, FairkeeperBorosEntity boros, double speed, double shootingRange, int shootingCooldown, ShootingPattern pattern) {
        this.state = state;
        this.boros = boros;
        this.speed = speed;
        this.shootingRange = shootingRange;
        this.maxShootingCooldown = shootingCooldown;
        this.pattern = pattern;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        this.target = this.boros.m_5448_();
        return this.target != null && this.target.m_6084_() && this.boros.isState(this.state);
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.targetPosition = this.target.m_20318_(1.0f);
        this.targetIndex = 0;
        this.shootingCooldown = this.maxShootingCooldown;
        this.totalDuration = FairkeeperBorosPursueAndShootArrowGoal.m_186073_((int)300);
    }

    public void m_8041_() {
        this.boros.stopAttacking(20);
    }

    public void m_8037_() {
        if (this.stoppingTick > 0) {
            --this.stoppingTick;
            if (this.stoppingTick == FairkeeperBorosPursueAndShootArrowGoal.m_186073_((int)40)) {
                ((ImmutableList)this.pattern.arrowPattern.get(this.targetIndex)).stream().forEach(angle -> this.spawnRedstoneTrail(this.boros, angle.floatValue(), 0.0, 0.0));
                this.boros.playBeamSound(this.boros.m_20185_(), this.boros.m_20186_(), this.boros.m_20189_(), 3.0f);
                this.boros.playMouthOpenSound(this.boros.m_20185_(), this.boros.m_20186_(), this.boros.m_20189_());
                this.boros.playMouthOpenForShootingArrow();
                this.boros.transitionTo(FairkeeperBorosEntity.FairkeeperBorosAnimationState.MOUTH_OPEN_WITHOUT_OPENED);
            }
            if (this.stoppingTick == FairkeeperBorosPursueAndShootArrowGoal.m_186073_((int)25)) {
                ((ImmutableList)this.pattern.arrowPattern.get(this.targetIndex)).stream().forEach(angle -> this.shootArrow(this.boros, angle.floatValue(), 0.0, 0.0));
                this.boros.playArrowSound(this.boros.m_20185_(), this.boros.m_20186_(), this.boros.m_20189_(), 3.0f);
            }
            if (this.stoppingTick == FairkeeperBorosPursueAndShootArrowGoal.m_186073_((int)18)) {
                this.boros.playMouthClose();
            }
            if (this.stoppingTick <= 0) {
                ++this.targetIndex;
                if (this.targetIndex >= this.pattern.arrowPattern.size()) {
                    this.stopGoal();
                    return;
                }
                this.shootingCooldown = this.maxShootingCooldown;
            } else {
                return;
            }
        }
        if (this.totalDuration > 0) {
            --this.totalDuration;
        } else {
            this.stopGoal();
            return;
        }
        double updatedSpeed = this.speed;
        double distanceSqr = this.boros.m_20280_((Entity)this.target);
        this.targetPosition = this.target.m_20318_(1.0f);
        if (this.shootingCooldown <= 0) {
            this.stoppingTick = FairkeeperBorosPursueAndShootArrowGoal.m_186073_((int)42);
            return;
        }
        --this.shootingCooldown;
        if (distanceSqr < this.shootingRange * this.shootingRange) {
            updatedSpeed = this.speed + (double)0.2f;
        }
        this.boros.m_21566_().m_6849_(this.targetPosition.f_82479_, this.targetPosition.f_82480_, this.targetPosition.f_82481_, updatedSpeed);
    }

    private void shootArrow(FairkeeperBorosEntity partEntity, float angleOffset, double rxOffset, double rzOffset) {
        double viewDistance = 2.0;
        float borosFacingYaw = partEntity.m_146908_();
        double finalAngle = Math.toRadians(borosFacingYaw - angleOffset);
        double cosFinal = Math.cos(finalAngle);
        double sinFinal = Math.sin(finalAngle);
        Vec3 shootDirection = new Vec3(-sinFinal, 0.0, cosFinal).m_82541_();
        double rotatedRxOffset = rxOffset * cosFinal - rzOffset * sinFinal;
        double rotatedRzOffset = rxOffset * sinFinal + rzOffset * cosFinal;
        Vec3 startPos = new Vec3(partEntity.m_20185_() + rotatedRxOffset, partEntity.m_20186_() + partEntity.m_20191_().m_82376_() * (double)0.3f, partEntity.m_20189_() + rotatedRzOffset);
        Vec3 arrowPos = startPos.m_82549_(shootDirection.m_82490_(viewDistance));
        BorusArrowEntity arrow = new BorusArrowEntity((LivingEntity)this.boros, this.boros.m_9236_());
        arrow.m_146884_(arrowPos);
        arrow.m_37251_((Entity)partEntity, partEntity.m_146909_(), borosFacingYaw - angleOffset, 0.0f, 2.0f, 1.0f);
        this.boros.m_9236_().m_7967_((Entity)arrow);
    }

    private void spawnRedstoneTrail(FairkeeperBorosEntity partEntity, float angleOffset, double rxOffset, double rzOffset) {
        double viewDistance = 2.0;
        float borosFacingYaw = partEntity.m_146908_();
        double finalAngle = Math.toRadians(borosFacingYaw - angleOffset);
        double cosFinal = Math.cos(finalAngle);
        double sinFinal = Math.sin(finalAngle);
        Vec3 beamDirection = new Vec3(-sinFinal, 0.0, cosFinal).m_82541_();
        double rotatedRxOffset = rxOffset * cosFinal - rzOffset * sinFinal;
        double rotatedRzOffset = rxOffset * sinFinal + rzOffset * cosFinal;
        Vec3 startPos = new Vec3(partEntity.m_20185_() + rotatedRxOffset, partEntity.m_20186_() + partEntity.m_20191_().m_82376_() * (double)0.3f, partEntity.m_20189_() + rotatedRzOffset).m_82549_(beamDirection.m_82490_(viewDistance));
        for (int i = 0; i <= 30; ++i) {
            Vec3 particlePos = startPos.m_82549_(beamDirection.m_82490_((double)i));
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.ARROW_HAZARD_INDICATOR.get(), 0.5f);
            ((ServerLevel)partEntity.m_9236_()).m_8767_((ParticleOptions)particleData, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public record ShootingPattern(ImmutableList<ImmutableList<Float>> arrowPattern) {
    }
}

