/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.boss;

import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperOurosBodyDropScuttleGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperOurosBodyDropVertexPillarGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperOurosBodyShootVertexOrbGoal;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperOurosEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexDomainProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexOrbProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.AnimationChainer;
import dev.hexnowloading.dungeonnowloading.entity.util.Boss;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.entity.util.SlumberingEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLMobEffects;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class FairkeeperOurosPartEntity
extends Monster
implements Boss,
Enemy,
SlumberingEntity,
FairkeeperSerpentEntity {
    private static final EntityDataAccessor<FairkeeperOurosPartState> STATE = SynchedEntityData.m_135353_(FairkeeperOurosPartEntity.class, EntityStates.FAIRKEEPER_OUROS_PART_STATE);
    private static final EntityDataAccessor<FairkeeperOurosPartAnimationState> ANIMATION_STATE = SynchedEntityData.m_135353_(FairkeeperOurosPartEntity.class, EntityStates.FAIRKEEPER_OUROS_PART_ANIMATION_STATE);
    private static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.m_135353_(FairkeeperOurosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> HEAD_UUID = SynchedEntityData.m_135353_(FairkeeperOurosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.m_135353_(FairkeeperOurosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> CANNON_YAW = SynchedEntityData.m_135353_(FairkeeperOurosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> CANNON_PITCH = SynchedEntityData.m_135353_(FairkeeperOurosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> BODY_INDEX = SynchedEntityData.m_135353_(FairkeeperOurosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DROPPER = SynchedEntityData.m_135353_(FairkeeperOurosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TAIL = SynchedEntityData.m_135353_(FairkeeperOurosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HEAD_MOVING = SynchedEntityData.m_135353_(FairkeeperOurosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MODEL_VISIBLE = SynchedEntityData.m_135353_(FairkeeperOurosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ROTATABLE = SynchedEntityData.m_135353_(FairkeeperOurosPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState cannonIdleAnimationState = new AnimationState();
    public final AnimationState scuttleOpenAnimationState = new AnimationState();
    public final AnimationState cannonOpenAnimationState = new AnimationState();
    public final AnimationState scuttleCloseAnimationState = new AnimationState();
    public final AnimationState cannonCloseAnimationState = new AnimationState();
    private float previousTilt = 0.0f;
    private BlockPos dropPosition;
    private Entity shootingTarget;
    private boolean cancelShooting;
    private float inaccuracy;
    public float prevCannonYaw = 0.0f;
    public float cannonYaw = 0.0f;
    public float prevCannonPitch = 0.0f;
    public float cannonPitch = 0.0f;
    private final AnimationChainer<FairkeeperOurosPartAnimationState> animationChainer = new AnimationChainer();

    public FairkeeperOurosPartEntity(EntityType<? extends Monster> entityType, LivingEntity parent, LivingEntity head, int bodyIndex) {
        super(entityType, parent.m_9236_());
        this.setParent((Entity)parent);
        this.setHead((Entity)head);
        this.setBodyIndex(bodyIndex);
        this.setArmor(this.isArmoredSegment());
        this.setModelVisible(false);
        this.m_21530_();
    }

    public FairkeeperOurosPartEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 8.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FairkeeperOurosBodyDropVertexPillarGoal(this, FairkeeperOurosPartState.DROP_PILLAR));
        this.f_21345_.m_25352_(1, (Goal)new FairkeeperOurosBodyDropScuttleGoal(this, FairkeeperOurosPartState.DROP_SCUTTLE));
        this.f_21345_.m_25352_(1, (Goal)new FairkeeperOurosBodyShootVertexOrbGoal(this, FairkeeperOurosPartState.SHOOT_ORB));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PARENT_UUID, Optional.empty());
        this.f_19804_.m_135372_(CHILD_UUID, Optional.empty());
        this.f_19804_.m_135372_(HEAD_UUID, Optional.empty());
        this.f_19804_.m_135372_(BODY_INDEX, (Object)0);
        this.f_19804_.m_135372_(TAIL, (Object)false);
        this.f_19804_.m_135372_(DROPPER, (Object)false);
        this.f_19804_.m_135372_(HEAD_MOVING, (Object)false);
        this.f_19804_.m_135372_(MODEL_VISIBLE, (Object)true);
        this.f_19804_.m_135372_(ROTATABLE, (Object)true);
        this.f_19804_.m_135372_(CANNON_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CANNON_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(STATE, (Object)FairkeeperOurosPartState.IDLE);
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)FairkeeperOurosPartAnimationState.NONE);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.getParentId() != null) {
            compoundTag.m_128362_("ParentUUID", this.getParentId());
        }
        if (this.getChildId() != null) {
            compoundTag.m_128362_("ChildUUID", this.getChildId());
        }
        if (this.getHeadId() != null) {
            compoundTag.m_128362_("HeadUUID", this.getHeadId());
        }
        compoundTag.m_128379_("TailPart", this.isTail());
        compoundTag.m_128405_("BodyIndex", this.getBodyIndex());
        compoundTag.m_128379_("Armor", this.hasArmor());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128403_("ParentUUID")) {
            this.setParentId(compoundTag.m_128342_("ParentUUID"));
        }
        if (compoundTag.m_128403_("ChildUUID")) {
            this.setChildId(compoundTag.m_128342_("ChildUUID"));
        }
        if (compoundTag.m_128403_("HeadUUID")) {
            this.setHeadId(compoundTag.m_128342_("HeadUUID"));
        }
        this.setTail(compoundTag.m_128471_("TailPart"));
        this.setBodyIndex(compoundTag.m_128451_("BodyIndex"));
        this.setArmor(compoundTag.m_128471_("Armor"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_8119_() {
        Entity parent = this.getParent();
        if (parent != null && !this.m_9236_().f_46443_) {
            this.m_20242_(true);
            Entity entity = this.getHead();
            if (entity instanceof FairkeeperOurosEntity) {
                FairkeeperOurosEntity headEntity = (FairkeeperOurosEntity)entity;
                int historyIndex = (this.getBodyIndex() + 1) * FairkeeperOurosEntity.SEGMENT_DELAY_STEP;
                Queue<Vec3> queue = headEntity.getPositionHistory();
                synchronized (queue) {
                    if (headEntity.getPositionHistory().size() > historyIndex) {
                        this.setModelVisible(true);
                        Vec3 targetPos = headEntity.getSegmentTargetPosition(this.getBodyIndex() + 1);
                        this.m_6034_(this.lerp(this.m_20185_(), targetPos.f_82479_, 0.5), this.lerp(this.m_20186_(), targetPos.f_82480_, 0.5), this.lerp(this.m_20189_(), targetPos.f_82481_, 0.5));
                        Vec3 nextPos = headEntity.getPositionHistory().stream().skip(historyIndex - 1).findFirst().orElse(targetPos);
                        if (!this.isRotatable()) {
                            Vec3 awakenEndPos = headEntity.getAwakenEndPos();
                            if (awakenEndPos == null) {
                                this.setRotatable(true);
                            } else {
                                double dy = awakenEndPos.f_82480_ - (this.m_20186_() + (double)this.m_20206_());
                                if (dy * dy < 25.0) {
                                    this.setRotatable(true);
                                }
                            }
                        }
                        if (this.isRotatable() && this.isHeadEntityMoving()) {
                            this.alignRotation(this.m_20182_(), targetPos);
                        }
                    }
                }
                this.setHeadEntityMoving(headEntity.m_20184_().m_82556_() > 0.01);
            }
        } else if (!this.m_9236_().f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (this.m_9236_().f_46443_ && this.isState(FairkeeperOurosPartState.SHOOT_ORB)) {
            this.prevCannonYaw = this.cannonYaw;
            this.prevCannonPitch = this.cannonPitch;
            this.cannonYaw = ((Float)this.f_19804_.m_135370_(CANNON_YAW)).floatValue();
            this.cannonPitch = ((Float)this.f_19804_.m_135370_(CANNON_PITCH)).floatValue();
        }
        super.m_8119_();
    }

    private void animationControl() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.f_19804_.m_135370_(ANIMATION_STATE) == FairkeeperOurosPartAnimationState.NONE) {
            this.transitionTo(FairkeeperOurosPartAnimationState.IDLE);
        }
        this.animationChainer.tick(this::transitionTo);
    }

    private double lerp(double start, double end, double factor) {
        return start + (end - start) * factor;
    }

    private void alignRotation(Vec3 currentPos, Vec3 targetPos) {
        double deltaX = targetPos.f_82479_ - currentPos.f_82479_;
        double deltaZ = targetPos.f_82481_ - currentPos.f_82481_;
        float yaw = (float)(Math.atan2(deltaZ, deltaX) * 57.29577951308232) - 90.0f;
        this.m_146922_(yaw);
    }

    protected void m_8024_() {
        this.animationControl();
        if (this.isHeadEntityMoving()) {
            this.performContactDamage();
        }
        if (!this.isState(FairkeeperOurosPartState.SHOOT_ORB) && this.isCancelShooting()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
            this.playCannonCancelAnimation(null);
            this.setCancelShooting(false);
        }
        super.m_8024_();
    }

    private void vertexTransmissionEffectImmunity() {
        this.m_21195_(DNLMobEffects.VERTEX_TRANSMISSION.get());
    }

    private void performContactDamage() {
        this.m_9236_().m_6249_((Entity)this, this.m_20191_(), this::canPerformContactDamageTo).forEach(entity -> {
            entity.m_7334_((Entity)this);
            LivingEntity head = (LivingEntity)this.getHead();
            if (head != null) {
                entity.m_6469_(entity.m_9236_().m_269111_().m_269333_(head), (float)(head.m_21133_(Attributes.f_22281_) * 0.5));
            }
        });
    }

    private boolean canPerformContactDamageTo(Entity entity) {
        if (entity instanceof FairkeeperOurosEntity) {
            FairkeeperOurosEntity head = (FairkeeperOurosEntity)entity;
            return !this.getHeadId().equals(head.m_20148_());
        }
        if (entity instanceof FairkeeperOurosPartEntity) {
            FairkeeperOurosPartEntity part = (FairkeeperOurosPartEntity)entity;
            return !this.getHeadId().equals(part.getHeadId());
        }
        return !(entity instanceof VertexOrbProjectileEntity) && !(entity instanceof VertexDomainProjectileEntity);
    }

    public boolean m_6469_(DamageSource damageSource, float damageAmount) {
        LivingEntity livingEntity;
        Entity entity;
        if (damageSource.m_7639_() instanceof FairkeeperSerpentEntity) {
            Entity entity2 = damageSource.m_7640_();
            if (entity2 instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)entity2;
                arrow.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return false;
        }
        if (!this.hasArmor() || damageSource.m_19390_()) {
            FairkeeperOurosEntity head;
            float damage = damageAmount;
            if (this.isTail()) {
                damage = damageAmount * 2.0f;
            }
            if (damage >= 5.0f && (this.getAnimationState().equals((Object)FairkeeperOurosPartAnimationState.CANNON_IDLE) || this.getAnimationState().equals((Object)FairkeeperOurosPartAnimationState.CANNON_OPEN) || this.getAnimationState().equals((Object)FairkeeperOurosPartAnimationState.CANNON_CLOSE))) {
                this.setCancelShooting(true);
            }
            if ((head = (FairkeeperOurosEntity)this.getHead()) != null) {
                head.m_6469_(damageSource, damage);
            }
            return super.m_6469_(damageSource, 0.0f);
        }
        if (damageSource.m_276093_(DamageTypes.f_268565_) || (entity = damageSource.m_7640_()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_213824_()) {
            this.setArmor(false);
        }
        return false;
    }

    protected void m_6153_() {
        ++this.f_20919_;
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        MobEffect effect = mobEffectInstance.m_19544_();
        if (effect == MobEffects.f_19614_ || effect == DNLMobEffects.VERTEX_TRANSMISSION.get()) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public void aimCannonAtPlayer(Entity targetPlayer) {
        Vec3 cannonPos = this.m_20182_().m_82520_(0.0, (double)this.m_20206_() * 0.5, 0.0);
        Vec3 playerPos = targetPlayer.m_20182_().m_82520_(0.0, (double)targetPlayer.m_20206_() * 0.5, 0.0);
        Vec3 dir = playerPos.m_82546_(cannonPos);
        float targetYaw = (float)Math.toDegrees(Math.atan2(dir.f_82481_, dir.f_82479_)) - 90.0f;
        float horizontalDistance = (float)Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_);
        float targetPitch = (float)Math.toDegrees(Math.atan2(dir.f_82480_, horizontalDistance));
        float currentYaw = ((Float)this.f_19804_.m_135370_(CANNON_YAW)).floatValue();
        float currentPitch = ((Float)this.f_19804_.m_135370_(CANNON_PITCH)).floatValue();
        float smoothedPitch = Mth.m_14179_((float)0.2f, (float)currentPitch, (float)targetPitch);
        float deltaYaw = Mth.m_14177_((float)(targetYaw - currentYaw));
        float smoothedYaw = currentYaw + deltaYaw * 0.2f;
        this.f_19804_.m_135381_(CANNON_YAW, (Object)Float.valueOf(smoothedYaw));
        this.f_19804_.m_135381_(CANNON_PITCH, (Object)Float.valueOf(smoothedPitch));
    }

    private void resetAnimations() {
        this.idleAnimationState.m_216973_();
        this.scuttleOpenAnimationState.m_216973_();
        this.scuttleCloseAnimationState.m_216973_();
        this.cannonOpenAnimationState.m_216973_();
        this.cannonCloseAnimationState.m_216973_();
        this.cannonIdleAnimationState.m_216973_();
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIMATION_STATE.equals(entityDataAccessor)) {
            FairkeeperOurosPartAnimationState animationState = (FairkeeperOurosPartAnimationState)((Object)this.f_19804_.m_135370_(ANIMATION_STATE));
            this.resetAnimations();
            switch (animationState) {
                case IDLE: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case SCUTTLE_OPEN: {
                    this.scuttleOpenAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case SCUTTLE_CLOSE: {
                    this.scuttleCloseAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case CANNON_OPEN: {
                    this.cannonOpenAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case CANNON_CLOSE: {
                    this.cannonCloseAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case CANNON_IDLE: {
                    this.cannonIdleAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public FairkeeperOurosPartEntity transitionTo(FairkeeperOurosPartAnimationState state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state);
        return this;
    }

    public void playVertexPillarDoorOpenAnimation(Runnable runnable) {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosPartAnimationState.SCUTTLE_OPEN, 3.0f, () -> this.playVertexPillarDoorOpenSound(this.m_20185_(), this.m_20186_(), this.m_20189_()), runnable));
    }

    public void playScuttleDoorOpenAnimation(Runnable runnable) {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosPartAnimationState.SCUTTLE_OPEN, 3.0f, () -> this.playScuttleDoorOpenSound(this.m_20185_(), this.m_20186_(), this.m_20189_()), runnable));
    }

    public void playScuttleDoorCloseAnimation(Runnable runnable) {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosPartAnimationState.SCUTTLE_CLOSE, 1.625f, () -> this.playDoorCloseSound(this.m_20185_(), this.m_20186_(), this.m_20189_()), runnable));
    }

    public boolean playDoorCloseAnimation() {
        if (!this.animationChainer.isEmpty()) {
            return false;
        }
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosPartAnimationState.SCUTTLE_CLOSE, 1.625f, () -> this.playDoorCloseSound(this.m_20185_(), this.m_20186_(), this.m_20189_()), null));
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosPartAnimationState.IDLE, 0.0f));
        return true;
    }

    public void playCannonSetupAnimation(Runnable runnable) {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosPartAnimationState.CANNON_OPEN, 2.0f, () -> this.playCannonDoorOpenSound(this.m_20185_(), this.m_20186_(), this.m_20189_()), runnable));
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosPartAnimationState.CANNON_IDLE, 0.0f));
    }

    public void playCannonPackAnimation(Runnable runnable) {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosPartAnimationState.CANNON_CLOSE, 2.0f, () -> this.playDoorCloseSound(this.m_20185_(), this.m_20186_(), this.m_20189_()), runnable));
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosPartAnimationState.IDLE, 0.0f));
    }

    public void playCannonCancelAnimation(Runnable runnable) {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosPartAnimationState.SCUTTLE_CLOSE, 1.625f, () -> this.playCannonBreakSound(this.m_20185_(), this.m_20186_(), this.m_20189_()), runnable));
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosPartAnimationState.IDLE, 0.0f));
    }

    public void playCannonDoorOpenSound(double x, double y, double z) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_OUROS_CANNON_DOOR_OPEN.get(), this.m_5720_(), 4.0f, 1.0f);
    }

    public void playCannonBreakSound(double x, double y, double z) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_OUROS_CANNON_BREAK.get(), this.m_5720_(), 4.0f, 1.0f);
    }

    public void playDoorCloseSound(double x, double y, double z) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_OUROS_DOOR_CLOSE.get(), this.m_5720_(), 4.0f, 1.0f);
    }

    public void playVertexPillarDoorOpenSound(double x, double y, double z) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_OUROS_PILLAR_DOOR_OPEN.get(), this.m_5720_(), 4.0f, 1.0f);
    }

    public void playScuttleDoorOpenSound(double x, double y, double z) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_OUROS_SCUTTLE_DOOR_OPEN.get(), this.m_5720_(), 4.0f, 1.0f);
    }

    public void playVertexOrbShootSound(double x, double y, double z) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_OUROS_CANNON_SHOOT.get(), this.m_5720_(), 4.0f, 1.0f);
    }

    public void shootVertexOrb(Entity target, float inaccuracy) {
        this.setShootingTarget(target);
        this.setInaccuracy(inaccuracy);
        this.setState(FairkeeperOurosPartState.SHOOT_ORB);
    }

    public float getInaccuracy() {
        return this.inaccuracy;
    }

    public void setInaccuracy(float inaccuracy) {
        this.inaccuracy = inaccuracy;
    }

    public Entity getShootingTarget() {
        return this.shootingTarget;
    }

    public void setShootingTarget(Entity target) {
        this.shootingTarget = target;
    }

    public void dropVertexPillar(BlockPos dropPosition) {
        this.setState(FairkeeperOurosPartState.DROP_PILLAR);
        this.setDropPosition(dropPosition);
    }

    public void dropScuttle() {
        this.setState(FairkeeperOurosPartState.DROP_SCUTTLE);
    }

    public BlockPos getDropPosition() {
        return this.dropPosition;
    }

    public void setDropPosition(BlockPos dropPosition) {
        this.dropPosition = dropPosition;
    }

    public boolean m_5830_() {
        return false;
    }

    public void m_7334_(Entity entity) {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    protected boolean m_20073_() {
        return false;
    }

    protected void m_7840_(double $$0, boolean $$1, BlockState $$2, BlockPos $$3) {
    }

    protected int m_5639_(float $$0, float $$1) {
        return 0;
    }

    public boolean m_142535_(float v, float v1, DamageSource damageSource) {
        return false;
    }

    @Override
    public void resetBoss() {
    }

    @Override
    public boolean resetCondition() {
        return false;
    }

    @Override
    public BlockPos resetRegionCenter() {
        return null;
    }

    @Override
    public boolean isSlumbering() {
        return false;
    }

    @Override
    public boolean isStationary() {
        return false;
    }

    public Entity getHead() {
        UUID id = this.getHeadId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    public void setHead(Entity entity) {
        this.setHeadId(entity.m_20148_());
    }

    public UUID getHeadId() {
        return ((Optional)this.f_19804_.m_135370_(HEAD_UUID)).orElse(null);
    }

    public void setHeadId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(HEAD_UUID, Optional.ofNullable(uniqueId));
    }

    public int getBodyIndex() {
        return (Integer)this.f_19804_.m_135370_(BODY_INDEX);
    }

    public void setBodyIndex(int index) {
        this.f_19804_.m_135381_(BODY_INDEX, (Object)index);
    }

    @Nullable
    public UUID getParentId() {
        return ((Optional)this.f_19804_.m_135370_(PARENT_UUID)).orElse(null);
    }

    public void setParentId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(PARENT_UUID, Optional.ofNullable(uniqueId));
    }

    public void setParent(Entity entity) {
        this.setParentId(entity.m_20148_());
    }

    public Entity getParent() {
        UUID id = this.getParentId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public void setChild(Entity entity) {
        this.setChildId(entity.m_20148_());
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    public float getPreviousTilt() {
        return this.previousTilt;
    }

    public void setPreviousTilt(float tilt) {
        this.previousTilt = tilt;
    }

    public boolean isHeadEntityMoving() {
        return (Boolean)this.f_19804_.m_135370_(HEAD_MOVING);
    }

    public void setHeadEntityMoving(boolean moving) {
        this.f_19804_.m_135381_(HEAD_MOVING, (Object)moving);
    }

    public boolean isModelVisible() {
        return (Boolean)this.f_19804_.m_135370_(MODEL_VISIBLE);
    }

    public void setModelVisible(boolean moving) {
        this.f_19804_.m_135381_(MODEL_VISIBLE, (Object)moving);
    }

    public boolean isArmoredSegment() {
        return false;
    }

    public boolean hasArmor() {
        return (Boolean)this.f_19804_.m_135370_(DROPPER);
    }

    public void setArmor(boolean armor) {
        this.f_19804_.m_135381_(DROPPER, (Object)armor);
    }

    public boolean isTail() {
        return (Boolean)this.f_19804_.m_135370_(TAIL);
    }

    public void setTail(boolean tail) {
        this.f_19804_.m_135381_(TAIL, (Object)tail);
    }

    public void setRotatable(boolean enableRotation) {
        this.f_19804_.m_135381_(ROTATABLE, (Object)enableRotation);
    }

    public boolean isRotatable() {
        return (Boolean)this.f_19804_.m_135370_(ROTATABLE);
    }

    public float getCannonTargetYaw() {
        return ((Float)this.f_19804_.m_135370_(CANNON_YAW)).floatValue();
    }

    public float getCannonTargetPitch() {
        return ((Float)this.f_19804_.m_135370_(CANNON_PITCH)).floatValue();
    }

    public boolean isCancelShooting() {
        return this.cancelShooting;
    }

    public void setCancelShooting(boolean b) {
        this.cancelShooting = b;
    }

    public boolean isState(FairkeeperOurosPartState state) {
        return this.f_19804_.m_135370_(STATE) == state;
    }

    public void setState(FairkeeperOurosPartState state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public AnimationChainer<FairkeeperOurosPartAnimationState> getAnimationChainer() {
        return this.animationChainer;
    }

    public FairkeeperOurosPartAnimationState getAnimationState() {
        return (FairkeeperOurosPartAnimationState)((Object)this.f_19804_.m_135370_(ANIMATION_STATE));
    }

    public static enum FairkeeperOurosPartState {
        IDLE,
        DROP_SCUTTLE,
        DROP_PILLAR,
        SHOOT_ORB;

    }

    public static enum FairkeeperOurosPartAnimationState {
        NONE,
        IDLE,
        CANNON_IDLE,
        CANNON_OPEN,
        CANNON_CLOSE,
        SCUTTLE_OPEN,
        SCUTTLE_CLOSE;

    }
}

