/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.client.model;

import dev.hexnowloading.dungeonnowloading.entity.client.animation.ScuttleAnimation;
import dev.hexnowloading.dungeonnowloading.entity.monster.ScuttleEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class ScuttleModel<T extends ScuttleEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("dungeonnowloading", "scuttle"), "main");
    private final ModelPart torchgolem;
    private final ModelPart body;
    private final ModelPart flame_thrower_n_upper;
    private final ModelPart flame_thrower;
    private final ModelPart cannon;
    private final ModelPart upper;
    private final ModelPart lower;
    private final ModelPart lowerjaw;
    private final ModelPart Legs;
    private final ModelPart right_back_leg;
    private final ModelPart right_front_leg;
    private final ModelPart left_back_leg;
    private final ModelPart left_front_leg;
    private final ModelPart root;

    public ScuttleModel(ModelPart root) {
        this.root = root;
        this.torchgolem = root.m_171324_("torchgolem");
        this.body = this.torchgolem.m_171324_("body");
        this.flame_thrower_n_upper = this.body.m_171324_("flame_thrower_n_upper");
        this.flame_thrower = this.flame_thrower_n_upper.m_171324_("flame_thrower");
        this.cannon = this.flame_thrower.m_171324_("cannon");
        this.upper = this.flame_thrower_n_upper.m_171324_("upper");
        this.lower = this.body.m_171324_("lower");
        this.lowerjaw = this.lower.m_171324_("lowerjaw");
        this.Legs = this.torchgolem.m_171324_("Legs");
        this.right_back_leg = this.Legs.m_171324_("right_back_leg");
        this.right_front_leg = this.Legs.m_171324_("right_front_leg");
        this.left_back_leg = this.Legs.m_171324_("left_back_leg");
        this.left_front_leg = this.Legs.m_171324_("left_front_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition torchgolem = partdefinition.m_171599_("torchgolem", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = torchgolem.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition flame_thrower_n_upper = body.m_171599_("flame_thrower_n_upper", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition flame_thrower = flame_thrower_n_upper.m_171599_("flame_thrower", CubeListBuilder.m_171558_().m_171514_(64, 9).m_171488_(-2.0f, -10.0f, -2.0f, 4.0f, 22.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(80, 7).m_171488_(-3.0f, -10.0f, -3.0f, 6.0f, 22.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-21.0f, (float)0.0f));
        PartDefinition cannon = flame_thrower.m_171599_("cannon", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(-2.0f, -2.0f, -7.0f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = cannon.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(-2.0f, -2.0f, -2.5f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition cube_r2 = cannon.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(-2.0f, -2.0f, -2.5f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r3 = cannon.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(-2.0f, -2.0f, -2.5f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)4.5f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition upper = flame_thrower_n_upper.m_171599_("upper", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-8.0f, -5.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-8.0f, -16.0f, -8.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(0, 74).m_171488_(-6.0f, -18.0f, -6.0f, 12.0f, 3.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(0, 107).m_171488_(-8.0f, -20.0f, -8.0f, 16.0f, 5.0f, 16.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)0.0f));
        PartDefinition lower = body.m_171599_("lower", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition lowerjaw = lower.m_171599_("lowerjaw", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-8.0f, -13.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(-0.001f)).m_171514_(0, 32).m_171488_(-8.0f, -18.0f, -8.0f, 16.0f, 10.0f, 16.0f, new CubeDeformation(-0.001f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition Legs = torchgolem.m_171599_("Legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition right_back_leg = Legs.m_171599_("right_back_leg", CubeListBuilder.m_171558_().m_171514_(0, 58).m_171488_(-6.0f, 0.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)0.0f, (float)6.0f));
        PartDefinition right_front_leg = Legs.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 58).m_171488_(-6.0f, 0.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)0.0f, (float)-6.0f));
        PartDefinition left_back_leg = Legs.m_171599_("left_back_leg", CubeListBuilder.m_171558_().m_171514_(0, 58).m_171488_(-2.0f, 0.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)0.0f, (float)6.0f));
        PartDefinition left_front_leg = Legs.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 58).m_171488_(-2.0f, 0.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)0.0f, (float)-6.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(ScuttleEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.isStationary()) {
            this.m_267799_(ScuttleAnimation.SCUTTLE_WALKING_CLOSED, limbSwing, limbSwingAmount, 4.0f, 4.5f);
        }
        if (entity.isState(ScuttleEntity.ScuttleState.SLUMBERING) || entity.isState(ScuttleEntity.ScuttleState.AWAKENING) && !entity.wakingUpAnimationState.m_216984_() && !entity.idleClosedAnimationState.m_216984_()) {
            this.left_front_leg.f_104202_ += 2.0f;
            this.left_front_leg.f_104200_ -= 1.0f;
            this.right_front_leg.f_104202_ += 2.0f;
            this.right_front_leg.f_104200_ += 1.0f;
            this.left_back_leg.f_104202_ -= 2.0f;
            this.left_back_leg.f_104200_ -= 1.0f;
            this.right_back_leg.f_104202_ -= 2.0f;
            this.right_back_leg.f_104200_ += 1.0f;
        }
        this.animateFlameThrowerRotation(entity, ageInTicks, 12, 0.3f, 0.4f, 0.3f);
        this.m_233381_(entity.wakingUpAnimationState, ScuttleAnimation.SCUTTLE_WAKING_UP, ageInTicks);
        this.m_233381_(entity.mouthOpenAnimationState, ScuttleAnimation.SCUTTLE_MOUTH_OPEN, ageInTicks);
        this.m_233381_(entity.mouthCloseAnimationState, ScuttleAnimation.SCUTTLE_MOUTH_CLOSE, ageInTicks);
        this.m_233381_(entity.idleClosedAnimationState, ScuttleAnimation.SCUTTLE_IDLE_CLOSED, ageInTicks);
        this.m_233381_(entity.idleOpenedAnimationState, ScuttleAnimation.SCUTTLE_IDLE_OPENED, ageInTicks);
        this.m_233381_(entity.blockFormAnimationState, ScuttleAnimation.SCUTTLE_BLOCK_FORM, ageInTicks);
    }

    private void animateFlameThrowerRotation(ScuttleEntity entity, float ageInTicks, int numberOfRotation, float timeEaseIn, float timeConstant, float timeEaseOut) {
        if (entity.isState(ScuttleEntity.ScuttleState.OPENING) && !entity.isRotateStarted()) {
            entity.setOldAgeInTicks(ageInTicks);
            entity.setRotateStarted(true);
        }
        if (entity.isState(ScuttleEntity.ScuttleState.OPENING) || entity.isState(ScuttleEntity.ScuttleState.OPENED)) {
            float timeInSeconds = (ageInTicks - entity.getOldAgeInTicks()) / 20.0f;
            float ROTATION_RAD = (float)Math.PI / 180 * (float)numberOfRotation * 180.0f;
            float FULL_ROTATION_SECOND = 10.0f;
            float time = timeInSeconds / FULL_ROTATION_SECOND;
            this.easeInPhase(ROTATION_RAD, time, timeEaseIn);
            this.constantPhase(ROTATION_RAD, time, timeEaseIn, timeConstant);
            this.easeOutPhase(ROTATION_RAD, time, timeEaseIn, timeConstant, timeEaseOut);
        }
        if (!entity.isAttackingState() && entity.isRotateStarted()) {
            entity.setRotateStarted(false);
        }
    }

    private void easeInPhase(float rotationRad, float time, float timeIn) {
        if (time < timeIn) {
            this.flame_thrower.f_104204_ = this.easeInRotation(rotationRad, time, timeIn);
        }
    }

    private void constantPhase(float rotationRad, float time, float timeIn, float timeConstant) {
        if ((time == timeIn || time > timeIn) && time < timeIn + timeConstant) {
            this.flame_thrower.f_104204_ = this.constantRotation(rotationRad, time, timeIn, timeConstant);
        }
    }

    private void easeOutPhase(float rotationRad, float time, float timeIn, float timeConstant, float timeOut) {
        if ((time == timeIn + timeConstant || time > timeIn + timeConstant) && (time < 1.0f || time == 1.0f)) {
            this.flame_thrower.f_104204_ = this.easeOutRotation(rotationRad, time, timeOut);
        }
    }

    private float easeInRotation(float rotationRad, float time, float timeIn) {
        float a = time / timeIn;
        return rotationRad * (float)Math.pow(a, 2.0);
    }

    private float constantRotation(float rotationRad, float time, float timeIn, float timeConstant) {
        float a = (2.0f * time - timeIn) / timeConstant;
        return rotationRad * a;
    }

    private float easeOutRotation(float rotationRad, float time, float timeOut) {
        float a = (1.0f - time) / timeOut;
        return rotationRad - rotationRad * (float)Math.pow(a, 2.0);
    }

    private float easeInSteepness(int steepness, float time, float rotationRad) {
        return (float)Math.pow(2.0, steepness - 1) * rotationRad * (float)Math.pow(time, steepness);
    }

    private float easeOutSteepness(int steepness, float time, float rotationRad) {
        float a = -2.0f * time + 2.0f;
        return rotationRad * (1.0f - (float)Math.pow(a, steepness) / 2.0f);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

