/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.monster;

import dev.hexnowloading.dungeonnowloading.entity.ai.SpawnerCarrierAttackGoal;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class SpawnerCarrierEntity
extends Monster {
    public final AnimationState attackAnimationState = new AnimationState();
    private static final EntityDataAccessor<String> SUMMON_MOB_TYPE = SynchedEntityData.m_135353_(SpawnerCarrierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private int summonTick = 200;
    private final float SPAWN_RANGE = 5.0f;
    private final String[] SUMMON_MOB_TYPE_LIST = new String[]{"Zombie", "Skeleton", "Spider", "Creeper", "Cave Spider"};

    public SpawnerCarrierEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
        this.f_21364_ = 20;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22282_, 1.25).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SpawnerCarrierAttackGoal(this, 1.0f, true));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{SpawnerCarrierEntity.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SUMMON_MOB_TYPE, (Object)"");
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128359_("SummonMobType", (String)this.f_19804_.m_135370_(SUMMON_MOB_TYPE));
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(SUMMON_MOB_TYPE, (Object)compoundTag.m_128461_("SummonMobType"));
    }

    protected void m_8024_() {
        if (this.m_5448_() instanceof Player) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + 1.75, this.m_20189_(), 1, 0.25, 0.15, 0.25, 0.0);
            if (this.summonTick > 0) {
                --this.summonTick;
            } else {
                if (this.getSummonMobType().equals("")) {
                    this.setSummonMobType(Arrays.stream(this.SUMMON_MOB_TYPE_LIST).toList().get(this.f_19796_.m_188503_(this.SUMMON_MOB_TYPE_LIST.length)));
                }
                int spawnCount = this.m_217043_().m_216339_(1, 4);
                BlockPos centerPos = this.m_20097_();
                for (int i = 0; i < spawnCount; ++i) {
                    RandomSource randomSource = this.m_9236_().m_213780_();
                    EntityType spawningEntity = this.summonSpawnerMob();
                    double d = centerPos.m_123341_();
                    double d2 = randomSource.m_188500_() - randomSource.m_188500_();
                    Objects.requireNonNull(this);
                    double x = d + d2 * 5.0 + 0.5;
                    double y = centerPos.m_123342_() + randomSource.m_188503_(3) - 1;
                    double d3 = centerPos.m_123343_();
                    double d4 = randomSource.m_188500_() - randomSource.m_188500_();
                    Objects.requireNonNull(this);
                    double z = d3 + d4 * 5.0 + 0.5;
                    if (spawningEntity == null || !this.m_9236_().m_45772_(spawningEntity.m_20585_(x, y, z))) continue;
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, x + 0.5, y + 0.5, z + 0.5, 20, 0.3, 0.3, 0.3, 0.0);
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, x + 0.5, y + 0.5, z + 0.5, 10, 0.3, 0.3, 0.3, 0.0);
                    Entity livingEntity = spawningEntity.m_20615_(this.m_9236_());
                    if (livingEntity == null) continue;
                    BlockPos summonPos = new BlockPos((int)x, (int)y, (int)z);
                    livingEntity.m_7678_(x, y, z, 0.0f, 0.0f);
                    ((Monster)livingEntity).m_6518_((ServerLevelAccessor)((ServerLevel)this.m_9236_()), this.m_9236_().m_6436_(summonPos), MobSpawnType.MOB_SUMMONED, null, null);
                    this.m_9236_().m_7967_(livingEntity);
                }
                this.summonTick = 100 + this.m_217043_().m_216339_(0, 5) * 20;
            }
        }
        super.m_8024_();
    }

    private EntityType summonSpawnerMob() {
        switch (this.getSummonMobType()) {
            case "Zombie": {
                EntityType zombie = EntityType.f_20501_;
                return zombie;
            }
            case "Skeleton": {
                EntityType skeleton = EntityType.f_20524_;
                return skeleton;
            }
            case "Spider": {
                EntityType spider = EntityType.f_20479_;
                return spider;
            }
            case "Cave Spider": {
                EntityType caveSpider = EntityType.f_20554_;
                return caveSpider;
            }
            case "Creeper": {
                EntityType creeper = EntityType.f_20558_;
                return creeper;
            }
        }
        return null;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 0.95f;
    }

    public boolean m_7327_(Entity entity) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        return super.m_7327_(entity);
    }

    public void m_7822_(byte b) {
        if (b == 4) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(b);
        }
    }

    protected void m_267689_(float v) {
        float w = this.m_20089_() == Pose.STANDING ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(w, 1.0f);
    }

    protected SoundEvent m_7975_(DamageSource $$0) {
        return SoundEvents.f_12008_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(SoundEvents.f_12010_, 1.0f, 2.0f);
    }

    public String getSummonMobType() {
        return (String)this.f_19804_.m_135370_(SUMMON_MOB_TYPE);
    }

    public void setSummonMobType(String string) {
        this.f_19804_.m_135381_(SUMMON_MOB_TYPE, (Object)string);
    }
}

