/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.item;

import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ScrapItem
extends Item {
    private static final String ORIGINAL_TAG = "Original";

    public ScrapItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack ofOriginal(ItemStack original) {
        ItemStack scrap = new ItemStack((ItemLike)DNLItems.ITEM_SCRAPS.get());
        CompoundTag tag = scrap.m_41784_();
        CompoundTag originalTag = new CompoundTag();
        original.m_41739_(originalTag);
        tag.m_128365_(ORIGINAL_TAG, (Tag)originalTag);
        return scrap;
    }

    public static boolean hasOriginal(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128425_(ORIGINAL_TAG, 10);
    }

    public static ItemStack getOriginal(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(ORIGINAL_TAG, 10)) {
            return ItemStack.m_41712_((CompoundTag)tag.m_128469_(ORIGINAL_TAG));
        }
        return ItemStack.f_41583_;
    }

    public Component m_7626_(ItemStack stack) {
        if (ScrapItem.hasOriginal(stack)) {
            ItemStack original = ScrapItem.getOriginal(stack);
            return Component.m_237119_().m_7220_(original.m_41786_()).m_7220_((Component)Component.m_237113_((String)" Scrap"));
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (!ScrapItem.hasOriginal(stack)) {
            return;
        }
        ItemStack original = ScrapItem.getOriginal(stack);
        if (original.m_41619_()) {
            return;
        }
        Component nativeMat = ScrapItem.findNativeRepairMaterialName(original);
        tooltip.add((Component)Component.m_237115_((String)"item.dungeonnowloading.item_scraps.tooltip.reconstruct.detail1").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)"item.dungeonnowloading.item_scraps.tooltip.reconstruct.detail2", (Object[])new Object[]{nativeMat.m_6881_().m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.GRAY));
    }

    private static Component findNativeRepairMaterialName(ItemStack original) {
        try {
            for (Item item : BuiltInRegistries.f_257033_) {
                ItemStack candidate = new ItemStack((ItemLike)item);
                if (candidate.m_41619_() || !original.m_41720_().m_6832_(original, candidate)) continue;
                return candidate.m_41786_();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Component.m_237113_((String)"???");
    }
}

