/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.mixin.structures;

import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.GeodeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GeodeFeature.class})
public class NoGeodesInStructuresMixin {
    @Inject(method={"place(Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void dungeonnowloading_noGeodesInStructures(FeaturePlaceContext<GeodeConfiguration> context, CallbackInfoReturnable<Boolean> cir) {
        WorldGenLevel worldGenLevel = context.m_159774_();
        if (!(worldGenLevel instanceof WorldGenRegion)) {
            return;
        }
        WorldGenRegion worldGenRegion = (WorldGenRegion)worldGenLevel;
        Registry structureRegistry = worldGenRegion.m_9598_().m_175515_(Registries.f_256944_);
        List<StructureStart> starts = NoGeodesInStructuresMixin.getValidStructureStarts(worldGenRegion, context.m_159777_(), structure -> structureRegistry.m_203636_((ResourceKey)structureRegistry.m_7854_(structure).get()).map(holder -> holder.m_203656_(DNLTags.NO_GEODES_TAG)).orElse(false));
        if (!starts.isEmpty()) {
            cir.setReturnValue((Object)false);
        }
    }

    private static List<StructureStart> getValidStructureStarts(WorldGenRegion level, BlockPos pos, Predicate<Structure> structureMatch) {
        StructureManager structureManager = level.m_6018_().m_215010_();
        SectionPos sectionPos = SectionPos.m_123199_((BlockPos)pos);
        ChunkAccess chunk = level.m_46819_(sectionPos.m_123170_(), sectionPos.m_123222_(), ChunkStatus.f_62316_);
        if (!chunk.m_284331_().m_62427_(ChunkStatus.f_62316_)) {
            return List.of();
        }
        Map references = chunk.m_62769_();
        ArrayList<StructureStart> list = new ArrayList<StructureStart>();
        for (Map.Entry entry : references.entrySet()) {
            Structure structure = (Structure)entry.getKey();
            LongSet refs = (LongSet)entry.getValue();
            if (!structureMatch.test(structure)) continue;
            NoGeodesInStructuresMixin.fillStartsForStructure((LevelReader)level, structureManager, structure, refs, pos, list::add);
        }
        return list;
    }

    private static void fillStartsForStructure(LevelReader level, StructureManager structureManager, Structure structure, LongSet references, BlockPos pos, Consumer<StructureStart> consumer) {
        LongIterator longIterator = references.iterator();
        while (longIterator.hasNext()) {
            StructureStart start;
            long ref = (Long)longIterator.next();
            SectionPos sectionPos = SectionPos.m_123196_((ChunkPos)new ChunkPos(ref), (int)level.m_151560_());
            if (!level.m_7232_(sectionPos.m_123170_(), sectionPos.m_123222_()) || (start = structureManager.m_220512_(sectionPos, structure, (StructureAccess)level.m_46819_(sectionPos.m_123170_(), sectionPos.m_123222_(), ChunkStatus.f_62315_))) == null || !start.m_73603_() || !start.m_73601_().m_71051_((Vec3i)pos)) continue;
            consumer.accept(start);
        }
    }
}

