/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hexnowloading.dungeonnowloading.block.entity.PlayerStatueBlockEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLProcessors;
import dev.hexnowloading.dungeonnowloading.supporter.PatronRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StatueProcessor
extends StructureProcessor {
    public static final Codec<StatueProcessor> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("campaign").forGetter(p -> p.campaign), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(p -> Float.valueOf(p.chance)), (App)BuiltInRegistries.f_256975_.m_194605_().optionalFieldOf("fallback_block", (Object)Blocks.f_50016_).forGetter(p -> p.fallbackBlock)).apply((Applicative)i, StatueProcessor::new));
    private final String campaign;
    private final float chance;
    private final Block fallbackBlock;

    public StatueProcessor(String campaign) {
        this(campaign, 1.0f, Blocks.f_50016_);
    }

    public StatueProcessor(String campaign, float chance, Block fallbackBlock) {
        this.campaign = campaign;
        this.chance = Math.max(0.0f, Math.min(1.0f, chance));
        this.fallbackBlock = fallbackBlock == null ? Blocks.f_50016_ : fallbackBlock;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader level, BlockPos pieceOrigin, BlockPos pieceWorldPos, StructureTemplate.StructureBlockInfo original, StructureTemplate.StructureBlockInfo current, StructurePlaceSettings settings) {
        CompoundTag beTag;
        if (!current.f_74676_().m_60713_(DNLBlocks.PLAYER_STATUE.get())) {
            return current;
        }
        RandomSource rand = settings.m_230326_(current.f_74675_());
        if (rand.m_188501_() >= this.chance) {
            return new StructureTemplate.StructureBlockInfo(current.f_74675_(), this.fallbackBlock.m_49966_(), null);
        }
        BlockState state = current.f_74676_();
        CompoundTag compoundTag = beTag = current.f_74677_() == null ? new CompoundTag() : current.f_74677_().m_6426_();
        if (!beTag.m_128425_("PoseVariant", 3)) {
            beTag.m_128405_("PoseVariant", rand.m_188503_(4));
        }
        beTag.m_128473_("Owner");
        beTag.m_128473_("SkullOwner");
        PatronRegistry.Patron patron = PatronRegistry.pickPatron(this.campaign, rand);
        if (patron != null && patron.uuid != null) {
            CompoundTag owner = new CompoundTag();
            owner.m_128362_("Id", patron.uuid);
            if (patron.name != null && !patron.name.isBlank()) {
                owner.m_128359_("Name", patron.name);
            }
            beTag.m_128365_("Owner", (Tag)owner);
            PlayerStatueBlockEntity.NotchTier tier = PatronRegistry.tierFor(patron);
            beTag.m_128359_("NotchTier", tier.name());
        } else {
            beTag.m_128359_("NotchTier", PlayerStatueBlockEntity.NotchTier.NONE.name());
        }
        return new StructureTemplate.StructureBlockInfo(current.f_74675_(), state, beTag);
    }

    protected StructureProcessorType<?> m_6953_() {
        return DNLProcessors.STATUE_PROCESSOR.get();
    }
}

