/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import dev.hexnowloading.dungeonnowloading.block.BallistaGolemStatuePartBlock;
import dev.hexnowloading.dungeonnowloading.block.entity.BallistaGolemStatueBlockEntity;
import dev.hexnowloading.dungeonnowloading.block.property.BallistaGolemStatueStates;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class BallistaGolemStatueBlock
extends class_2237
implements class_2343 {
    public static final class_2753 FACING = class_2383.field_11177;
    public static final Map<BallistaGolemStatueStates, class_2338> statePositions = Map.ofEntries(Map.entry(BallistaGolemStatueStates.TOP_N, new class_2338(0, 2, -1)), Map.entry(BallistaGolemStatueStates.TOP_NE, new class_2338(1, 2, -1)), Map.entry(BallistaGolemStatueStates.TOP_E, new class_2338(1, 2, 0)), Map.entry(BallistaGolemStatueStates.TOP_SE, new class_2338(1, 2, 1)), Map.entry(BallistaGolemStatueStates.TOP_S, new class_2338(0, 2, 1)), Map.entry(BallistaGolemStatueStates.TOP_SW, new class_2338(-1, 2, 1)), Map.entry(BallistaGolemStatueStates.TOP_W, new class_2338(-1, 2, 0)), Map.entry(BallistaGolemStatueStates.TOP_NW, new class_2338(-1, 2, -1)), Map.entry(BallistaGolemStatueStates.TOP_C, new class_2338(0, 2, 0)), Map.entry(BallistaGolemStatueStates.MIDDLE_N, new class_2338(0, 1, -1)), Map.entry(BallistaGolemStatueStates.MIDDLE_NE, new class_2338(1, 1, -1)), Map.entry(BallistaGolemStatueStates.MIDDLE_E, new class_2338(1, 1, 0)), Map.entry(BallistaGolemStatueStates.MIDDLE_SE, new class_2338(1, 1, 1)), Map.entry(BallistaGolemStatueStates.MIDDLE_S, new class_2338(0, 1, 1)), Map.entry(BallistaGolemStatueStates.MIDDLE_SW, new class_2338(-1, 1, 1)), Map.entry(BallistaGolemStatueStates.MIDDLE_W, new class_2338(-1, 1, 0)), Map.entry(BallistaGolemStatueStates.MIDDLE_NW, new class_2338(-1, 1, -1)), Map.entry(BallistaGolemStatueStates.MIDDLE_C, new class_2338(0, 1, 0)), Map.entry(BallistaGolemStatueStates.BOTTOM_N, new class_2338(0, 0, -1)), Map.entry(BallistaGolemStatueStates.BOTTOM_NE, new class_2338(1, 0, -1)), Map.entry(BallistaGolemStatueStates.BOTTOM_E, new class_2338(1, 0, 0)), Map.entry(BallistaGolemStatueStates.BOTTOM_SE, new class_2338(1, 0, 1)), Map.entry(BallistaGolemStatueStates.BOTTOM_S, new class_2338(0, 0, 1)), Map.entry(BallistaGolemStatueStates.BOTTOM_SW, new class_2338(-1, 0, 1)), Map.entry(BallistaGolemStatueStates.BOTTOM_W, new class_2338(-1, 0, 0)), Map.entry(BallistaGolemStatueStates.BOTTOM_NW, new class_2338(-1, 0, -1)));
    public boolean playerDestroyed = false;

    public BallistaGolemStatueBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateBuilder) {
        stateBuilder.method_11667(new class_2769[]{FACING});
    }

    public class_2680 method_9598(class_2680 blockState, class_2470 rotation) {
        return (class_2680)blockState.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)blockState.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 blockState, class_2415 mirror) {
        return blockState.method_26186(mirror.method_10345((class_2350)blockState.method_11654((class_2769)FACING)));
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2350 playerFacing;
        class_2338 corePos;
        class_1937 world = context.method_8045();
        if (this.isAreaClear(world, corePos = context.method_8037(), playerFacing = context.method_8042().method_10153())) {
            return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)playerFacing);
        }
        return null;
    }

    private boolean isAreaClear(class_1937 world, class_2338 corePos, class_2350 facing) {
        for (class_2338 relativePos : statePositions.values()) {
            class_2338 partPos = corePos.method_10081((class_2382)this.getRotatedPos(relativePos, facing));
            class_2680 stateAtPos = world.method_8320(partPos);
            if (stateAtPos.method_26215() || stateAtPos.method_45474()) continue;
            return false;
        }
        return true;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        if (!world.field_9236 && placer instanceof class_1657) {
            class_2350 playerFacing = placer.method_5735().method_10153();
            boolean triggeredByRedstone = false;
            for (Map.Entry<BallistaGolemStatueStates, class_2338> entry : statePositions.entrySet()) {
                BallistaGolemStatueStates golemState = entry.getKey();
                class_2338 relativePos = entry.getValue();
                class_2338 rotatedPos = this.getRotatedPos(relativePos, playerFacing);
                class_2338 partPos = pos.method_10081((class_2382)rotatedPos);
                class_2680 partBlockState = (class_2680)((class_2680)DNLBlocks.BALLISTA_GOLEM_STATUE_PART.get().method_9564().method_11657((class_2769)BallistaGolemStatuePartBlock.FACING, (Comparable)playerFacing)).method_11657(BallistaGolemStatuePartBlock.STATES, (Comparable)((Object)golemState));
                world.method_8652(partPos, partBlockState, 3);
                if (!world.method_49803(partPos)) continue;
                triggeredByRedstone = true;
            }
            if (triggeredByRedstone) {
                BallistaGolemStatueBlock.destroyAllBlocks(world, pos);
            } else if (world.method_49803(pos)) {
                BallistaGolemStatueBlock.destroyAllBlocks(world, pos);
                BallistaGolemStatueBlock.destroyBlocksAbove(world, pos);
            }
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (!world.field_9236 && state.method_26204() != newState.method_26204()) {
            BallistaGolemStatueBlockEntity blockEntity;
            BallistaGolemStatueBlock.destroyAllBlocks(world, pos);
            BallistaGolemStatueBlock.destroyBlocksAbove(world, pos);
            if (this.playerDestroyed && state.method_26204() instanceof BallistaGolemStatueBlock && (blockEntity = (BallistaGolemStatueBlockEntity)world.method_8321(pos)) != null) {
                blockEntity.summonBallistaGolemEntity(world, pos, (class_2350)state.method_11654((class_2769)FACING));
            }
        }
        super.method_9536(state, world, pos, newState, isMoving);
    }

    public static void destroyAllBlocks(class_1937 world, class_2338 pos) {
        for (Map.Entry<BallistaGolemStatueStates, class_2338> entry : statePositions.entrySet()) {
            class_2338 relativePos = entry.getValue();
            class_2338 partPos = pos.method_10081((class_2382)relativePos);
            world.method_22352(partPos, false);
        }
    }

    public static void destroyBlocksAbove(class_1937 level, class_2338 blockPos) {
        class_2338 targetPlane = blockPos;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2338 breakPos = targetPlane.method_10069(x, 3, z);
                level.method_22352(breakPos, true);
            }
        }
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.field_9236) {
            boolean bl = this.playerDestroyed = !player.method_31549().field_7477;
            if (this.playerDestroyed) {
                class_1799 heldItem = player.method_6047();
                this.playerDestroyed = class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)heldItem) < 1;
            }
        }
        super.method_9576(world, pos, state, player);
    }

    public void method_9612(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, class_2338 blockPos1, boolean b) {
        if (level.field_9236) {
            return;
        }
        if (!level.method_49803(blockPos)) {
            return;
        }
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)FACING);
        BallistaGolemStatueBlockEntity blockEntity = (BallistaGolemStatueBlockEntity)level.method_8321(blockPos);
        if (blockEntity != null) {
            blockEntity.summonBallistaGolemEntity(level, blockPos, facing);
        }
        BallistaGolemStatueBlock.destroyAllBlocks(level, blockPos);
        BallistaGolemStatueBlock.destroyBlocksAbove(level, blockPos);
    }

    private class_2338 getRotatedPos(class_2338 pos, class_2350 facing) {
        switch (facing) {
            case field_11043: {
                return pos;
            }
            case field_11035: {
                return new class_2338(-pos.method_10263(), pos.method_10264(), -pos.method_10260());
            }
            case field_11039: {
                return new class_2338(pos.method_10260(), pos.method_10264(), -pos.method_10263());
            }
            case field_11034: {
                return new class_2338(-pos.method_10260(), pos.method_10264(), pos.method_10263());
            }
        }
        return pos;
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new BallistaGolemStatueBlockEntity(blockPos, blockState);
    }

    public class_2464 method_9604(class_2680 $blockState0) {
        return class_2464.field_11458;
    }

    public void setPlayerDestroyed(boolean b) {
        this.playerDestroyed = b;
    }

    public static class_2350 getDirection(class_2680 blockState) {
        return (class_2350)blockState.method_11654((class_2769)FACING);
    }
}

