/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import com.mojang.authlib.GameProfile;
import dev.hexnowloading.dungeonnowloading.block.entity.PlayerStatueBlockEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlockEntityTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5558;

public class PlayerStatueBlock
extends class_2237
implements class_2343,
class_3737 {
    public static final class_2758 ROTATION = class_2741.field_12532;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final int MAX_POSES = 4;
    public static final boolean ENABLE_SIGN_EDIT = false;

    public PlayerStatueBlock(class_4970.class_2251 props) {
        super(props);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(0))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluid = ctx.method_8045().method_8316(ctx.method_8037());
        int rot = class_3532.method_15375((float)(ctx.method_8044() * 16.0f / 360.0f + 0.5f)) & 0xF;
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(rot))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.method_15772() == class_3612.field_15910));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(rot.method_10502(((Integer)state.method_11654((class_2769)ROTATION)).intValue(), 16)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(mirror.method_10344(((Integer)state.method_11654((class_2769)ROTATION)).intValue(), 16)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> b) {
        b.method_11667(new class_2769[]{ROTATION, WATERLOGGED});
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 dir, class_2680 neighbor, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return super.method_9559(state, dir, neighbor, level, pos, neighborPos);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
        return SHAPE;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return DNLBlockEntityTypes.PLAYER_STATUE.get().method_11032(pos, state);
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(level, pos, state, placer, stack);
        if (level.field_9236) {
            return;
        }
        class_2586 be = level.method_8321(pos);
        if (!(be instanceof PlayerStatueBlockEntity)) {
            return;
        }
        PlayerStatueBlockEntity statue = (PlayerStatueBlockEntity)be;
        GameProfile gp = null;
        class_2487 tag = stack.method_7969();
        if (tag != null) {
            if (tag.method_10573("Owner", 10)) {
                gp = class_2512.method_10683((class_2487)tag.method_10562("Owner"));
            } else if (tag.method_10573("SkullOwner", 10)) {
                gp = class_2512.method_10683((class_2487)tag.method_10562("SkullOwner"));
            } else if (tag.method_10573("SkullOwner", 8)) {
                gp = new GameProfile(null, tag.method_10558("SkullOwner"));
            }
        }
        if (gp == null) {
            gp = new GameProfile(null, "MHF_Alex");
        }
        statue.setOwner(gp);
        if (tag != null) {
            class_1799 off;
            PlayerStatueBlockEntity.NotchTier tier;
            if (tag.method_10573("DNL_Notch", 8)) {
                PlayerStatueBlockEntity.NotchTier tier2 = PlayerStatueBlockEntity.NotchTier.fromString(tag.method_10558("DNL_Notch"));
                if (tier2 != PlayerStatueBlockEntity.NotchTier.NONE) {
                    statue.setNotchTier(tier2);
                }
            } else if (tag.method_10573("Offering", 10) && (tier = PlayerStatueBlockEntity.tierFromItem(off = class_1799.method_7915((class_2487)tag.method_10562("Offering")))) != PlayerStatueBlockEntity.NotchTier.NONE) {
                statue.setNotchTier(tier);
            }
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 held = player.method_5998(hand);
        class_2586 be = level.method_8321(pos);
        if (!(be instanceof PlayerStatueBlockEntity)) {
            return class_1269.field_5811;
        }
        PlayerStatueBlockEntity statue = (PlayerStatueBlockEntity)be;
        if (!level.field_9236) {
            if (statue.isWaxed()) {
                level.method_8396(null, pos, class_3417.field_43167, class_3419.field_15245, 1.0f, 1.0f);
                return class_1269.field_5811;
            }
            if (statue.isOccupied()) {
                class_1799 out = statue.takeMaterial();
                if (!out.method_7960()) {
                    boolean added = player.method_7270(out);
                    if (!added) {
                        player.method_7328(out, false);
                    }
                    level.method_8396(null, pos, class_3417.field_15197, class_3419.field_15248, 0.5f, 1.0f);
                    String ownerName = "Someone";
                    GameProfile gp = statue.getOwner();
                    if (gp != null && gp.getName() != null && !gp.getName().isEmpty()) {
                        ownerName = gp.getName();
                    } else {
                        String resolved = statue.ensureServerSideOwnerName();
                        if (resolved != null && !resolved.isEmpty()) {
                            ownerName = resolved;
                        } else if (gp != null) {
                            ownerName = PlayerStatueBlockEntity.shortUuid(gp.getId());
                        }
                    }
                    class_5250 msg = class_2561.method_43469((String)"block.dungeonnowloading.player_statue.message", (Object[])new Object[]{class_2561.method_43470((String)ownerName).method_27692(class_124.field_1065)});
                    player.method_7353((class_2561)msg, true);
                }
                return class_1269.field_21466;
            }
            PlayerStatueBlockEntity.NotchTier tier = PlayerStatueBlockEntity.tierFromItem(held);
            if (tier != PlayerStatueBlockEntity.NotchTier.NONE) {
                class_1799 one = held.method_7972();
                one.method_7939(1);
                if (statue.placeMaterial(one)) {
                    if (!player.method_31549().field_7477) {
                        held.method_7934(1);
                    }
                    level.method_8396(null, pos, class_3417.field_26980, class_3419.field_15245, 0.6f, 1.2f);
                    return class_1269.field_21466;
                }
            }
        } else if (statue.isOccupied() || PlayerStatueBlockEntity.tierFromItem(held) != PlayerStatueBlockEntity.NotchTier.NONE) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static boolean otherPlayerIsEditing(class_1657 player, PlayerStatueBlockEntity be) {
        UUID lock = be.getAllowedEditor();
        return lock != null && !lock.equals(player.method_5667());
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return !level.field_9236 ? PlayerStatueBlock.method_31618(type, DNLBlockEntityTypes.PLAYER_STATUE.get(), PlayerStatueBlockEntity::serverTick) : null;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_1799 stack = super.method_9574(world, pos, state);
        class_2586 be = world.method_8321(pos);
        if (be instanceof PlayerStatueBlockEntity) {
            PlayerStatueBlockEntity statue = (PlayerStatueBlockEntity)be;
            GameProfile gp = statue.getOwner();
            if (gp != null && gp.getName() != null && !gp.getName().isEmpty()) {
                stack.method_7948().method_10582("SkullOwner", gp.getName());
            } else if (gp != null) {
                stack.method_7948().method_10566("SkullOwner", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)gp));
            }
            stack.method_7948().method_10569("DNL_Pose", statue.getPoseVariant());
            stack.method_7948().method_10582("DNL_Notch", statue.getNotchTier().name());
        }
        return stack;
    }
}

