/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import dev.hexnowloading.dungeonnowloading.block.property.RedstoneLaneMode;
import dev.hexnowloading.dungeonnowloading.entity.monster.ScuttleEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class RedstoneLaneBlock
extends class_2318 {
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2754<RedstoneLaneMode> REDSTONE_LANE_MODE = DNLProperties.REDSTONE_LANE_MODE;
    public static final class_2758 REDSTONE_LANE_POWER = DNLProperties.REDSTONE_LANE_POWER;

    public RedstoneLaneBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.UNPOWERED))).method_11657((class_2769)REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public class_2680 method_9605(class_1750 blockPlaceContext) {
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)blockPlaceContext.method_8042().method_10153())).method_11657(REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.UNPOWERED))).method_11657((class_2769)REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(0));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateBuilder) {
        stateBuilder.method_11667(new class_2769[]{FACING});
        stateBuilder.method_11667(new class_2769[]{REDSTONE_LANE_MODE});
        stateBuilder.method_11667(new class_2769[]{REDSTONE_LANE_POWER});
    }

    public class_2680 method_9598(class_2680 blockState, class_2470 rotation) {
        return (class_2680)blockState.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)blockState.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 blockState, class_2415 mirror) {
        return blockState.method_26186(mirror.method_10345((class_2350)blockState.method_11654((class_2769)FACING)));
    }

    public void method_9591(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1297 entity) {
        if (level.method_8320(blockPos).method_11654(DNLProperties.REDSTONE_LANE_MODE) == RedstoneLaneMode.OVERPOWERED && entity instanceof class_1309 && !class_1890.method_8216((class_1309)((class_1309)entity)) && !(entity instanceof ScuttleEntity)) {
            entity.method_5643(level.method_48963().method_48820(), 6.0f);
            if (!entity.method_5753()) {
                entity.method_5639(5);
            }
        }
        super.method_9591(level, blockPos, blockState, entity);
    }

    public void method_9615(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 oldBlockState, boolean b) {
        this.updatePowerStrength(blockState, level, blockPos);
        super.method_9615(blockState, level, blockPos, oldBlockState, b);
    }

    public int method_9524(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_2350 direction) {
        if (blockState.method_11654(DNLProperties.REDSTONE_LANE_MODE) == RedstoneLaneMode.UNPOWERED) {
            return 0;
        }
        if (direction == class_2350.field_11033) {
            return 150;
        }
        List<class_2350> directions = this.getConnectionDirection(blockState);
        for (class_2350 laneDirection : directions) {
            if (blockGetter.method_8320(blockPos.method_10093(laneDirection)).method_26204() instanceof RedstoneLaneBlock || direction != laneDirection.method_10153()) continue;
            return 150;
        }
        return 0;
    }

    public int method_9603(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_2350 direction) {
        return blockState.method_26195(blockGetter, blockPos, direction);
    }

    public boolean method_9506(class_2680 blockState) {
        return true;
    }

    public void method_9612(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, class_2338 neighbourBlock, boolean b) {
        if (blockState.method_11654(REDSTONE_LANE_MODE) == RedstoneLaneMode.UNPOWERED) {
            if (level.method_8320(neighbourBlock).method_27852(class_2246.field_10002)) {
                this.neighbourChangedRedstoneBlock(blockState, level, blockPos, block, neighbourBlock);
            } else if (level.method_8320(neighbourBlock).method_27852(DNLBlocks.REDSTONE_IDOL.get())) {
                this.neighbourChangedRedstoneIdolBlock(blockState, level, blockPos, block, neighbourBlock);
            } else if (level.method_8320(neighbourBlock).method_27852(DNLBlocks.OVERCHARGED_REDSTONE_BLOCK.get())) {
                this.neighbourChangedOverpoweredBlock(blockState, level, blockPos, block, neighbourBlock);
            } else if ((level.method_8320(neighbourBlock).method_27852(DNLBlocks.REDSTONE_LANE_I.get()) || level.method_8320(neighbourBlock).method_27852(DNLBlocks.REDSTONE_LANE_L.get()) || level.method_8320(neighbourBlock).method_27852(DNLBlocks.REDSTONE_LANE_T.get())) && (level.method_8320(neighbourBlock).method_11654(REDSTONE_LANE_MODE) == RedstoneLaneMode.POWERED || level.method_8320(neighbourBlock).method_11654(REDSTONE_LANE_MODE) == RedstoneLaneMode.OVERPOWERED)) {
                this.neighbourChangedLane(blockState, level, blockPos, block, neighbourBlock);
            }
        } else {
            this.updatePowerStrength(blockState, level, blockPos);
        }
    }

    private void updatePowerStrength(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        int power;
        boolean hasOverchargedRedstoneBlock;
        List<class_2338> neighborLaneBlockPosList = this.getConnectionBlockPos(blockPos, blockState);
        int originalPower = (Integer)blockState.method_11654((class_2769)DNLProperties.REDSTONE_LANE_POWER);
        boolean overpowered = false;
        boolean hasRedstoneBlock = !neighborLaneBlockPosList.stream().filter(b -> level.method_8320(b).method_27852(class_2246.field_10002)).toList().isEmpty();
        boolean bl = hasOverchargedRedstoneBlock = !neighborLaneBlockPosList.stream().filter(b -> level.method_8320(b).method_27852(DNLBlocks.OVERCHARGED_REDSTONE_BLOCK.get())).toList().isEmpty();
        if (hasRedstoneBlock || level.method_8320(blockPos.method_10084()).method_27852(class_2246.field_10002) || level.method_8320(blockPos.method_10084()).method_27852(DNLBlocks.REDSTONE_IDOL.get())) {
            if (hasOverchargedRedstoneBlock || level.method_8320(blockPos.method_10084()).method_27852(DNLBlocks.OVERCHARGED_REDSTONE_BLOCK.get())) {
                level.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
                level.method_8537(null, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, 3.0f, true, class_1937.class_7867.field_40889);
                return;
            }
            power = 150;
        } else if (hasOverchargedRedstoneBlock || level.method_8320(blockPos.method_10084()).method_27852(DNLBlocks.OVERCHARGED_REDSTONE_BLOCK.get())) {
            if (hasRedstoneBlock || level.method_8320(blockPos.method_10084()).method_27852(class_2246.field_10002) || level.method_8320(blockPos.method_10084()).method_27852(DNLBlocks.REDSTONE_IDOL.get())) {
                level.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
                level.method_8537(null, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, 3.0f, true, class_1937.class_7867.field_40889);
                return;
            }
            power = 150;
            overpowered = true;
        } else {
            List<class_2338> redstoneLanePosList = neighborLaneBlockPosList.stream().filter(b -> level.method_8320(b).method_26204() instanceof RedstoneLaneBlock).filter(b -> this.isLaneConnected(level, blockState, blockPos, (class_2338)b)).toList();
            int highestPower = redstoneLanePosList.stream().mapToInt(b -> (Integer)level.method_8320(b).method_11654((class_2769)DNLProperties.REDSTONE_LANE_POWER)).max().orElse(0);
            overpowered = !redstoneLanePosList.stream().filter(b -> level.method_8320(b).method_11654(DNLProperties.REDSTONE_LANE_MODE) == RedstoneLaneMode.OVERPOWERED).toList().isEmpty();
            power = Math.max(highestPower - 1, 0);
        }
        if (originalPower == power) {
            return;
        }
        if (power == 0) {
            level.method_8652(blockPos, (class_2680)((class_2680)blockState.method_11657(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.UNPOWERED))).method_11657((class_2769)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(0)), 2);
        } else if (overpowered) {
            if (blockState.method_11654(DNLProperties.REDSTONE_LANE_MODE) == RedstoneLaneMode.POWERED) {
                level.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
                level.method_8537(null, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, 3.0f, true, class_1937.class_7867.field_40889);
            } else {
                level.method_8652(blockPos, (class_2680)((class_2680)blockState.method_11657(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.OVERPOWERED))).method_11657((class_2769)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(power)), 2);
            }
        } else if (blockState.method_11654(DNLProperties.REDSTONE_LANE_MODE) == RedstoneLaneMode.OVERPOWERED) {
            level.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
            level.method_8537(null, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, 3.0f, true, class_1937.class_7867.field_40889);
        } else {
            level.method_8652(blockPos, (class_2680)((class_2680)blockState.method_11657(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.POWERED))).method_11657((class_2769)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(power)), 2);
        }
        level.method_8492(blockPos.method_10084(), (class_2248)this, blockPos);
        this.updateConnectedNegihbors(neighborLaneBlockPosList, level, blockPos);
    }

    private void neighbourChangedRedstoneBlock(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, class_2338 neighbourBlock) {
        class_2338 pos;
        List<class_2338> neighborBlockPosList = this.getConnectionBlockPos(blockPos, blockState);
        neighborBlockPosList.add(blockPos.method_10084());
        boolean isRedstoneBlock = false;
        Iterator<class_2338> iterator = neighborBlockPosList.iterator();
        while (iterator.hasNext() && !(isRedstoneBlock = (pos = iterator.next()).equals((Object)neighbourBlock))) {
        }
        if (!isRedstoneBlock) {
            return;
        }
        level.method_8652(blockPos, (class_2680)((class_2680)blockState.method_11657(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.POWERED))).method_11657((class_2769)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(150)), 2);
        this.poweredParticle(level, blockState, blockPos);
        level.method_8492(blockPos.method_10084(), (class_2248)this, blockPos);
        this.updateConnectedNeighborsWithExcluded(level, blockState, blockPos, neighbourBlock);
    }

    private void neighbourChangedRedstoneIdolBlock(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, class_2338 neighbourBlock) {
        class_2338 pos;
        List<class_2338> neighborBlockPosList = this.getConnectionBlockPos(blockPos, blockState);
        neighborBlockPosList.add(blockPos.method_10084());
        boolean isRedstoneBlock = false;
        Iterator<class_2338> iterator = neighborBlockPosList.iterator();
        while (iterator.hasNext() && !(isRedstoneBlock = (pos = iterator.next()).equals((Object)neighbourBlock))) {
        }
        if (!isRedstoneBlock) {
            return;
        }
        level.method_8652(blockPos, (class_2680)((class_2680)blockState.method_11657(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.POWERED))).method_11657((class_2769)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(150)), 2);
        this.poweredParticle(level, blockState, blockPos);
        level.method_8492(blockPos.method_10084(), (class_2248)this, blockPos);
        this.updateConnectedNeighborsWithExcluded(level, blockState, blockPos, neighbourBlock);
    }

    private void neighbourChangedOverpoweredBlock(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, class_2338 neighbourBlock) {
        class_2338 pos;
        List<class_2338> neighborBlockPosList = this.getConnectionBlockPos(blockPos, blockState);
        neighborBlockPosList.add(blockPos.method_10084());
        boolean isOverpoweredBlock = false;
        Iterator<class_2338> iterator = neighborBlockPosList.iterator();
        while (iterator.hasNext() && !(isOverpoweredBlock = (pos = iterator.next()).equals((Object)neighbourBlock))) {
        }
        if (!isOverpoweredBlock) {
            return;
        }
        level.method_8652(blockPos, (class_2680)((class_2680)blockState.method_11657(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.OVERPOWERED))).method_11657((class_2769)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(150)), 2);
        this.poweredParticle(level, blockState, blockPos);
        level.method_8492(blockPos.method_10084(), (class_2248)this, blockPos);
        this.updateConnectedNeighborsWithExcluded(level, blockState, blockPos, neighbourBlock);
    }

    private void neighbourChangedLane(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, class_2338 neighbourBlock) {
        boolean overpowered;
        if (!this.isLaneConnected(level, blockState, blockPos, neighbourBlock)) {
            return;
        }
        int power = (Integer)level.method_8320(neighbourBlock).method_11654((class_2769)DNLProperties.REDSTONE_LANE_POWER) - 1;
        boolean bl = overpowered = level.method_8320(neighbourBlock).method_11654(DNLProperties.REDSTONE_LANE_MODE) == RedstoneLaneMode.OVERPOWERED;
        if (power == 0) {
            level.method_8652(blockPos, (class_2680)((class_2680)blockState.method_11657(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.UNPOWERED))).method_11657((class_2769)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(0)), 2);
        } else {
            if (overpowered) {
                level.method_8652(blockPos, (class_2680)((class_2680)blockState.method_11657(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.OVERPOWERED))).method_11657((class_2769)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(power)), 2);
            } else {
                level.method_8652(blockPos, (class_2680)((class_2680)blockState.method_11657(DNLProperties.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.POWERED))).method_11657((class_2769)DNLProperties.REDSTONE_LANE_POWER, (Comparable)Integer.valueOf(power)), 2);
            }
            this.poweredParticle(level, blockState, blockPos);
        }
        level.method_8492(blockPos.method_10084(), (class_2248)this, blockPos);
        this.updateConnectedNeighborsWithExcluded(level, blockState, blockPos, neighbourBlock);
    }

    private void updateConnectedNegihbors(List<class_2338> blockPosList, class_1937 level, class_2338 blockPos) {
        for (class_2338 pos : blockPosList) {
            level.method_8492(pos, (class_2248)this, blockPos);
        }
    }

    private void updateConnectedNeighborsWithExcluded(class_1937 level, class_2680 blockState, class_2338 blockPos, class_2338 excludedBlockPos) {
        List<class_2338> updateTargets = this.getConnectionBlockPos(blockPos, blockState);
        for (class_2338 pos : updateTargets) {
            if (pos.equals((Object)excludedBlockPos)) continue;
            level.method_8492(pos, (class_2248)this, blockPos);
        }
    }

    private boolean isLaneConnected(class_1937 level, class_2680 blockState, class_2338 originalBlockPos, class_2338 neighborBlockPos) {
        class_2338 pos;
        class_2338 pos2;
        List<class_2338> originalBlockPosList = this.getConnectionBlockPos(originalBlockPos, blockState);
        boolean isRedstoneBlock = false;
        Iterator<class_2338> iterator = originalBlockPosList.iterator();
        while (iterator.hasNext() && !(isRedstoneBlock = (pos2 = iterator.next()).equals((Object)neighborBlockPos))) {
        }
        if (!isRedstoneBlock) {
            return false;
        }
        class_2680 neighborBlockState = level.method_8320(neighborBlockPos);
        List<class_2338> neighborBlockPosList = this.getConnectionBlockPos(neighborBlockPos, neighborBlockState);
        Iterator<class_2338> iterator2 = neighborBlockPosList.iterator();
        while (iterator2.hasNext() && !(isRedstoneBlock = (pos = iterator2.next()).equals((Object)originalBlockPos))) {
        }
        return isRedstoneBlock;
    }

    private List<class_2338> getConnectionBlockPos(class_2338 blockPos, class_2680 blockState) {
        ArrayList<class_2338> neighborBlockPosList = new ArrayList<class_2338>();
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)FACING);
        if (blockState.method_27852(DNLBlocks.REDSTONE_LANE_I.get())) {
            neighborBlockPosList.add(blockPos.method_10093(direction));
            neighborBlockPosList.add(blockPos.method_10093(direction.method_10153()));
        }
        if (blockState.method_27852(DNLBlocks.REDSTONE_LANE_L.get())) {
            neighborBlockPosList.add(blockPos.method_10093(direction.method_10160()));
            neighborBlockPosList.add(blockPos.method_10093(direction));
        }
        if (blockState.method_27852(DNLBlocks.REDSTONE_LANE_T.get())) {
            neighborBlockPosList.add(blockPos.method_10093(direction.method_10160()));
            neighborBlockPosList.add(blockPos.method_10093(direction.method_10170()));
            neighborBlockPosList.add(blockPos.method_10093(direction));
        }
        return neighborBlockPosList;
    }

    private List<class_2350> getConnectionDirection(class_2680 blockState) {
        ArrayList<class_2350> directions = new ArrayList<class_2350>();
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)FACING);
        if (blockState.method_27852(DNLBlocks.REDSTONE_LANE_I.get())) {
            directions.add(direction);
            directions.add(direction.method_10153());
        }
        if (blockState.method_27852(DNLBlocks.REDSTONE_LANE_L.get())) {
            directions.add(direction.method_10160());
            directions.add(direction);
        }
        if (blockState.method_27852(DNLBlocks.REDSTONE_LANE_T.get())) {
            directions.add(direction.method_10160());
            directions.add(direction.method_10170());
            directions.add(direction);
        }
        return directions;
    }

    public void method_9496(class_2680 blockState, class_1937 level, class_2338 blockPos, class_5819 randomSource) {
        switch ((RedstoneLaneMode)((Object)blockState.method_11654(DNLProperties.REDSTONE_LANE_MODE))) {
            default: {
                break;
            }
            case POWERED: {
                if (!(randomSource.method_43057() < 0.1f)) break;
                float r = randomSource.method_43057() - randomSource.method_43057();
                double x = (double)blockPos.method_10263() + (double)randomSource.method_43057();
                double y = (double)blockPos.method_10264() + 1.1 + 0.1 * (double)r;
                double z = (double)blockPos.method_10260() + (double)randomSource.method_43057();
                level.method_8406((class_2394)class_2390.field_11188, x, y, z, 0.0, 0.0, 0.0);
                break;
            }
            case OVERPOWERED: {
                double z;
                double y;
                double x;
                float r;
                if (randomSource.method_43057() < 0.1f) {
                    r = randomSource.method_43057() - randomSource.method_43057();
                    x = (double)blockPos.method_10263() + (double)randomSource.method_43057();
                    y = (double)blockPos.method_10264() + 1.1 + 0.1 * (double)r;
                    z = (double)blockPos.method_10260() + (double)randomSource.method_43057();
                    level.method_8406((class_2394)class_2390.field_11188, x, y, z, 0.0, 0.0, 0.0);
                }
                if (!(randomSource.method_43057() < 0.03f)) break;
                r = randomSource.method_43057() - randomSource.method_43057();
                x = (double)blockPos.method_10263() + (double)randomSource.method_43057();
                y = (double)blockPos.method_10264() + 1.1 + 0.1 * (double)r;
                z = (double)blockPos.method_10260() + (double)randomSource.method_43057();
                level.method_8406((class_2394)class_2398.field_11240, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    private void poweredParticle(class_1937 level, class_2680 blockState, class_2338 blockPos) {
        double x = (double)blockPos.method_10263() + 0.5;
        double y = (double)blockPos.method_10264() + 1.1;
        double z = (double)blockPos.method_10260() + 0.5;
        ((class_3218)level).method_14199((class_2394)class_2390.field_11188, x, y, z, 5, 0.25, 0.1, 0.25, 0.0);
    }
}

