/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block.client;

import com.google.common.hash.Hashing;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1068;
import net.minecraft.class_1071;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_4844;

public final class StatueSkinCache {
    private static final boolean LOG = true;
    private static final class_2960 DEFAULT_STONE = new class_2960("dungeonnowloading", "textures/block/player_statue_stone.png");
    private static final float DEFAULT_OVERLAY_ALPHA = 0.35f;
    private static final Map<String, StatueSkin> READY = new ConcurrentHashMap<String, StatueSkin>();
    private static final Set<String> INFLIGHT = ConcurrentHashMap.newKeySet();
    private static final ExecutorService EXEC = Executors.newFixedThreadPool(2, r -> {
        Thread t = new Thread(r, "DNL-StatueSkin");
        t.setDaemon(true);
        return t;
    });

    private StatueSkinCache() {
    }

    public static void clear() {
        READY.clear();
        INFLIGHT.clear();
    }

    private static String cacheKey(GameProfile p) {
        if (p.getName() != null && !p.getName().isEmpty()) {
            return "name:" + p.getName().toLowerCase(Locale.ROOT);
        }
        return "uuid:" + (p.getId() != null ? p.getId().toString() : "unknown");
    }

    public static StatueSkin get(GameProfile profile) {
        return StatueSkinCache.get(profile, 0.35f, DEFAULT_STONE);
    }

    public static StatueSkin get(GameProfile profile, float overlayAlpha, class_2960 stoneTex) {
        StatueSkin ready;
        if (profile == null) {
            return StatueSkinCache.buildPlaceholder(overlayAlpha, stoneTex, "null-profile");
        }
        String k1 = StatueSkinCache.primaryKey(profile);
        String k2 = k1 != null && k1.startsWith("name:") ? StatueSkinCache.uuidKey(profile) : StatueSkinCache.nameKey(profile);
        StatueSkin statueSkin = ready = k1 != null ? READY.get(k1) : null;
        if (ready == null && k2 != null) {
            ready = READY.get(k2);
        }
        if (ready != null) {
            return ready;
        }
        if (k1 != null && INFLIGHT.add(k1)) {
            StatueSkinCache.startAsyncBuild(profile, k1, overlayAlpha, stoneTex);
        }
        return StatueSkinCache.buildPlaceholder(overlayAlpha, stoneTex, k1 != null ? k1 : "unknown");
    }

    private static void startAsyncBuild(GameProfile profile, String key, float overlayAlpha, class_2960 stoneTex) {
        EXEC.submit(() -> {
            try {
                SkinImg s;
                SkinImg skinImg = s = profile != null ? StatueSkinCache.resolveSkinImageAndModel(profile) : null;
                if (s == null || s.img == null) {
                    UUID derived = profile != null ? class_4844.method_43343((GameProfile)profile) : new UUID(0L, 0L);
                    class_2960 def = class_1068.method_4648((UUID)derived);
                    boolean slim = "slim".equals(class_1068.method_4647((UUID)derived));
                    class_1011 img = StatueSkinCache.readResource(def);
                    if (img == null) {
                        return;
                    }
                    s = new SkinImg(img, slim);
                }
                StatueSkinCache.grayscale(s.img);
                class_1011 stone = StatueSkinCache.readResource(stoneTex);
                if (stone != null) {
                    StatueSkinCache.blendOverlay(s.img, stone, overlayAlpha);
                    stone.close();
                }
                class_1011 finalImg = s.img;
                String seed = key + "|" + String.format(Locale.ROOT, "%.2f", Float.valueOf(overlayAlpha)) + "|" + stoneTex;
                String digest = Hashing.sha1().hashString((CharSequence)seed, StandardCharsets.UTF_8).toString();
                class_2960 loc = new class_2960("dungeonnowloading", "statue/" + digest);
                boolean isSlim = s.slim;
                class_310.method_1551().execute(() -> {
                    class_310.method_1551().method_1531().method_4616(loc, (class_1044)new class_1043(finalImg));
                    StatueSkin ss = new StatueSkin(loc, isSlim);
                    READY.put(key, ss);
                    String nk = StatueSkinCache.nameKey(profile);
                    String uk = StatueSkinCache.uuidKey(profile);
                    if (nk != null) {
                        READY.put(nk, ss);
                    }
                    if (uk != null) {
                        READY.put(uk, ss);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                INFLIGHT.remove(key);
            }
        });
    }

    private static SkinImg resolveSkinImageAndModel(GameProfile profile) {
        String uuidNoDash;
        try {
            class_1071 sm = class_310.method_1551().method_1582();
            Map map = sm.method_4654(profile);
            MinecraftProfileTexture skin = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
            if (skin != null) {
                String model = skin.getMetadata("model");
                boolean slim = "slim".equals(model);
                class_1011 img = StatueSkinCache.downloadPng(skin.getUrl());
                if (img != null) {
                    return new SkinImg(img, slim);
                }
            }
        }
        catch (Exception sm) {
            // empty catch block
        }
        String string = profile.getId() != null ? profile.getId().toString().replace("-", "") : (uuidNoDash = profile.getName() != null ? StatueSkinCache.lookupUuidByName(profile.getName()) : null);
        if (uuidNoDash == null) {
            return null;
        }
        try {
            JsonObject prof = StatueSkinCache.httpJson("https://sessionserver.mojang.com/session/minecraft/profile/" + uuidNoDash);
            if (prof != null && prof.has("properties")) {
                JsonArray props = prof.getAsJsonArray("properties");
                for (int i = 0; i < props.size(); ++i) {
                    class_1011 img;
                    JsonObject md;
                    JsonObject p = props.get(i).getAsJsonObject();
                    if (!"textures".equals(p.get("name").getAsString())) continue;
                    String val = p.get("value").getAsString();
                    String decoded = new String(Base64.getDecoder().decode(val), StandardCharsets.UTF_8);
                    JsonObject textures = JsonParser.parseString((String)decoded).getAsJsonObject().getAsJsonObject("textures");
                    if (textures == null || !textures.has("SKIN")) continue;
                    JsonObject skin = textures.getAsJsonObject("SKIN");
                    String url = skin.get("url").getAsString();
                    boolean slim = false;
                    if (skin.has("metadata") && (md = skin.getAsJsonObject("metadata")).has("model")) {
                        slim = "slim".equals(md.get("model").getAsString());
                    }
                    if ((img = StatueSkinCache.downloadPng(url)) == null) continue;
                    return new SkinImg(img, slim);
                }
            }
        }
        catch (Exception prof) {
            // empty catch block
        }
        boolean slim = "slim".equals(class_1068.method_4647((UUID)UUID.fromString(uuidNoDash.replaceFirst("(........)(....)(....)(....)(............)", "$1-$2-$3-$4-$5"))));
        class_1011 img = StatueSkinCache.downloadPng("https://crafatar.com/skins/" + uuidNoDash);
        return img != null ? new SkinImg(img, slim) : null;
    }

    private static class_1011 resolveSkinImage(GameProfile profile) {
        String url = StatueSkinCache.trySkinManager(profile);
        if (url != null) {
            System.out.println("[DNL][Statue] SkinManager URL: " + url);
            class_1011 img = StatueSkinCache.downloadPng(url);
            if (img != null) {
                return img;
            }
        }
        String uuidNoDash = null;
        if (profile.getId() != null) {
            uuidNoDash = profile.getId().toString().replace("-", "");
        } else if (profile.getName() != null && !profile.getName().isEmpty()) {
            uuidNoDash = StatueSkinCache.lookupUuidByName(profile.getName());
            System.out.println("[DNL][Statue] Mojang name\u2192uuid: " + profile.getName() + " -> " + uuidNoDash);
        }
        if (uuidNoDash == null) {
            return null;
        }
        String mojangUrl = StatueSkinCache.lookupSkinUrlViaSessionServer(uuidNoDash);
        if (mojangUrl != null) {
            System.out.println("[DNL][Statue] SessionServer SKIN URL: " + mojangUrl);
            class_1011 img = StatueSkinCache.downloadPng(mojangUrl);
            if (img != null) {
                return img;
            }
        }
        String crafatarUrl = "https://crafatar.com/skins/" + uuidNoDash;
        System.out.println("[DNL][Statue] Crafatar fallback: " + crafatarUrl);
        return StatueSkinCache.downloadPng(crafatarUrl);
    }

    private static String trySkinManager(GameProfile profile) {
        try {
            class_1071 sm = class_310.method_1551().method_1582();
            Map map = sm.method_4654(profile);
            MinecraftProfileTexture skin = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
            return skin != null ? skin.getUrl() : null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static String lookupUuidByName(String name) {
        try {
            JsonObject o = StatueSkinCache.httpJson("https://api.mojang.com/users/profiles/minecraft/" + name);
            if (o == null || !o.has("id")) {
                return null;
            }
            return o.get("id").getAsString();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static String lookupSkinUrlViaSessionServer(String uuidNoDash) {
        try {
            JsonObject prof = StatueSkinCache.httpJson("https://sessionserver.mojang.com/session/minecraft/profile/" + uuidNoDash);
            if (prof == null || !prof.has("properties")) {
                return null;
            }
            JsonArray props = prof.getAsJsonArray("properties");
            for (int i = 0; i < props.size(); ++i) {
                JsonObject skin;
                JsonObject p = props.get(i).getAsJsonObject();
                if (!"textures".equals(p.get("name").getAsString())) continue;
                String val = p.get("value").getAsString();
                String decoded = new String(Base64.getDecoder().decode(val), StandardCharsets.UTF_8);
                JsonObject textures = JsonParser.parseString((String)decoded).getAsJsonObject().getAsJsonObject("textures");
                if (textures == null || !textures.has("SKIN") || !(skin = textures.getAsJsonObject("SKIN")).has("url")) continue;
                return skin.get("url").getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static JsonObject httpJson(String urlStr) {
        try {
            HttpURLConnection c = (HttpURLConnection)new URL(urlStr).openConnection();
            c.setConnectTimeout(5000);
            c.setReadTimeout(5000);
            c.setRequestProperty("User-Agent", "DNL-Statue/1.0");
            try (InputStream in = c.getInputStream();){
                JsonObject jsonObject;
                try (InputStreamReader r = new InputStreamReader(in, StandardCharsets.UTF_8);){
                    jsonObject = JsonParser.parseReader((Reader)r).getAsJsonObject();
                }
                return jsonObject;
            }
        }
        catch (Exception e) {
            System.out.println("[DNL][Statue] httpJson fail " + urlStr + " : " + e.getMessage());
            return null;
        }
    }

    private static class_1011 downloadPng(String urlStr) {
        class_1011 class_10112;
        block8: {
            HttpURLConnection c = (HttpURLConnection)new URL(urlStr).openConnection();
            c.setConnectTimeout(6000);
            c.setReadTimeout(6000);
            c.setRequestProperty("User-Agent", "DNL-Statue/1.0");
            InputStream in = c.getInputStream();
            try {
                class_10112 = class_1011.method_4309((InputStream)in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    System.out.println("[DNL][Statue] download fail " + urlStr + " : " + e.getMessage());
                    return null;
                }
            }
            in.close();
        }
        return class_10112;
    }

    private static class_1011 readResource(class_2960 rl) {
        class_1011 class_10112;
        block9: {
            Optional res = class_310.method_1551().method_1478().method_14486(rl);
            if (res.isEmpty()) {
                return null;
            }
            InputStream in = ((class_3298)res.get()).method_14482();
            try {
                class_10112 = class_1011.method_4309((InputStream)in);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    System.out.println("[DNL][Statue] resource fail " + rl + " : " + e.getMessage());
                    return null;
                }
            }
            in.close();
        }
        return class_10112;
    }

    private static void grayscale(class_1011 img) {
        int w = img.method_4307();
        int h = img.method_4323();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int abgr = img.method_4315(x, y);
                int a = abgr >>> 24 & 0xFF;
                int b = abgr >>> 16 & 0xFF;
                int g = abgr >>> 8 & 0xFF;
                int r = abgr & 0xFF;
                int gray = (int)(0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b) & 0xFF;
                img.method_4305(x, y, a << 24 | gray << 16 | gray << 8 | gray);
            }
        }
    }

    private static void blendOverlay(class_1011 base, class_1011 overlay, float alpha) {
        int w = base.method_4307();
        int h = base.method_4323();
        int ow = overlay.method_4307();
        int oh = overlay.method_4323();
        alpha = Math.max(0.0f, Math.min(1.0f, alpha));
        for (int y = 0; y < h; ++y) {
            int oy = y % oh;
            for (int x = 0; x < w; ++x) {
                int ox = x % ow;
                int bc = base.method_4315(x, y);
                int a = bc >>> 24 & 0xFF;
                if (a == 0) continue;
                int bb = bc >>> 16 & 0xFF;
                int bg = bc >>> 8 & 0xFF;
                int br = bc & 0xFF;
                int oc = overlay.method_4315(ox, oy);
                int ob = oc >>> 16 & 0xFF;
                int og = oc >>> 8 & 0xFF;
                int or = oc & 0xFF;
                int oa = oc >>> 24 & 0xFF;
                float oaf = (float)oa / 255.0f * alpha;
                int r = (int)((float)br * (1.0f - oaf) + (float)or * oaf);
                int g = (int)((float)bg * (1.0f - oaf) + (float)og * oaf);
                int b = (int)((float)bb * (1.0f - oaf) + (float)ob * oaf);
                base.method_4305(x, y, a << 24 | b << 16 | g << 8 | r);
            }
        }
    }

    private static StatueSkin buildPlaceholder(float overlayAlpha, class_2960 stoneTex, String keySeed) {
        try {
            UUID derived = new UUID(0L, 0L);
            class_2960 def = class_1068.method_4648((UUID)derived);
            boolean slim = "slim".equals(class_1068.method_4647((UUID)derived));
            class_1011 img = StatueSkinCache.readResource(def);
            if (img != null) {
                StatueSkinCache.grayscale(img);
                class_1011 stone = StatueSkinCache.readResource(stoneTex);
                if (stone != null) {
                    StatueSkinCache.blendOverlay(img, stone, overlayAlpha);
                    stone.close();
                }
                class_1043 dyn = new class_1043(img);
                String seed = keySeed + "|ph|" + String.format(Locale.ROOT, "%.2f", Float.valueOf(overlayAlpha)) + "|" + stoneTex;
                String digest = Hashing.sha1().hashString((CharSequence)seed, StandardCharsets.UTF_8).toString();
                class_2960 loc = new class_2960("dungeonnowloading", "statue/" + digest);
                class_310.method_1551().method_1531().method_4616(loc, (class_1044)dyn);
                return new StatueSkin(loc, slim);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new StatueSkin(stoneTex, false);
    }

    private static String nameKey(GameProfile p) {
        if (p == null) {
            return null;
        }
        return p.getName() != null && !p.getName().isEmpty() ? "name:" + p.getName().toLowerCase(Locale.ROOT) : null;
    }

    private static String uuidKey(GameProfile p) {
        if (p == null) {
            return null;
        }
        return p.getId() != null ? "uuid:" + p.getId() : null;
    }

    private static String primaryKey(GameProfile p) {
        if (p == null) {
            return "null";
        }
        String nk = StatueSkinCache.nameKey(p);
        String uk = StatueSkinCache.uuidKey(p);
        return nk != null ? nk : (uk != null ? uk : "unknown");
    }

    public record StatueSkin(class_2960 texture, boolean slim) {
    }

    private static final class SkinImg {
        final class_1011 img;
        final boolean slim;

        SkinImg(class_1011 img, boolean slim) {
            this.img = img;
            this.slim = slim;
        }
    }
}

