/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block.client.renderer;

import dev.hexnowloading.dungeonnowloading.block.client.StatueSkinCache;
import dev.hexnowloading.dungeonnowloading.block.client.model.PlayerStatueModel;
import dev.hexnowloading.dungeonnowloading.block.client.model.PlayerStatuePedestalModel;
import dev.hexnowloading.dungeonnowloading.block.entity.PlayerStatueBlockEntity;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class PlayerStatueRenderer
implements class_827<PlayerStatueBlockEntity> {
    private final PlayerStatueModel statue;
    private final PlayerStatuePedestalModel pedestal;
    private final class_327 font;
    private static final class_2960 PEDESTAL_TEX = new class_2960("dungeonnowloading", "textures/block/player_statue_pedestal.png");
    private static final class_2960 PEDESTAL_TEX_COPPER_NOTCH = new class_2960("dungeonnowloading", "textures/block/player_statue_pedestal_copper_notch.png");
    private static final class_2960 PEDESTAL_TEX_IRON_NOTCH = new class_2960("dungeonnowloading", "textures/block/player_statue_pedestal_iron_notch.png");
    private static final class_2960 PEDESTAL_TEX_GOLD_NOTCH = new class_2960("dungeonnowloading", "textures/block/player_statue_pedestal_gold_notch.png");
    private static final class_2960 PEDESTAL_TEX_DIAMOND_NOTCH = new class_2960("dungeonnowloading", "textures/block/player_statue_pedestal_diamond_notch.png");
    private static final class_2960 STONE_OVERLAY_TEX = new class_2960("dungeonnowloading", "textures/block/player_statue_stone.png");
    private static final float TEXT_MARGIN_BLOCKS = 0.0625f;
    private static final float FACE_WIDTH_BLOCKS = 0.875f;
    private static final float TEXT_SCALE = 0.010416667f;
    private static final float TEXT_Y = 0.25f;
    private static final float TEXT_Z = 0.5005f;
    public static final int PEDESTAL_TEXT_MAX_PX = 100;

    public PlayerStatueRenderer(class_5614.class_5615 ctx) {
        this.statue = new PlayerStatueModel(ctx.method_32140(PlayerStatueModel.LAYER_LOCATION));
        this.pedestal = new PlayerStatuePedestalModel(ctx.method_32140(PlayerStatuePedestalModel.LAYER_LOCATION));
        this.font = ctx.method_32143();
    }

    public void render(PlayerStatueBlockEntity be, float pt, class_4587 pose, class_4597 buf, int light, int overlay) {
        float pedestalYaw;
        pose.method_22903();
        pose.method_22904(0.5, 0.0, 0.5);
        class_2680 state = be.method_11010();
        int rot16 = state.method_28498((class_2769)class_2741.field_12532) ? (Integer)state.method_11654((class_2769)class_2741.field_12532) : 0;
        float statueYaw = 180.0f - (float)rot16 * 22.5f;
        if (state.method_28498((class_2769)class_2383.field_11177)) {
            class_2350 f = (class_2350)state.method_11654((class_2769)class_2383.field_11177);
            pedestalYaw = 180.0f - f.method_10144();
        } else {
            int cardinal = (rot16 + 2) / 4 * 4;
            pedestalYaw = 180.0f - (float)cardinal * 22.5f;
        }
        pose.method_22903();
        pose.method_22907(class_7833.field_40716.rotationDegrees(pedestalYaw));
        pose.method_46416(0.0f, 1.5005f, 0.0f);
        pose.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        pose.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        class_4588 pedVx = buf.getBuffer(class_1921.method_23578((class_2960)PEDESTAL_TEX));
        this.pedestal.renderPedestal(pose, pedVx, light, overlay);
        class_2960 notchTex = this.notchOverlayTex(be);
        if (notchTex != null) {
            pose.method_22903();
            pose.method_22905(1.001f, 1.001f, 1.001f);
            class_4588 overlayVx = buf.getBuffer(class_1921.method_23578((class_2960)notchTex));
            this.pedestal.renderPedestal(pose, overlayVx, light, overlay);
            pose.method_22909();
        }
        pose.method_22909();
        pose.method_22903();
        pose.method_22907(class_7833.field_40716.rotationDegrees(statueYaw));
        pose.method_46416(0.0f, 1.75f, 0.0f);
        pose.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        pose.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        StatueSkinCache.StatueSkin skin = StatueSkinCache.get(be.getOwner(), 0.6f, STONE_OVERLAY_TEX);
        this.statue.useSlimArms(skin.slim());
        class_4588 statVx = buf.getBuffer(class_1921.method_25448((class_2960)skin.texture()));
        this.statue.method_2828(pose, statVx, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        pose.method_22909();
        this.renderPedestalText(be, pose, buf, light, pedestalYaw);
        pose.method_22909();
    }

    private void renderPedestalText(PlayerStatueBlockEntity be, class_4587 pose, class_4597 buf, int worldLight, float pedestalYaw) {
        boolean outlineVisible;
        int packedLight;
        int argbText;
        class_2561 lineComp = be.getLine(0);
        if (lineComp == null) {
            return;
        }
        List seqs = this.font.method_1728((class_5348)lineComp, 4096);
        if (seqs.isEmpty()) {
            return;
        }
        class_5481 seq = (class_5481)seqs.get(0);
        boolean glowing = be.isGlowingText();
        int baseRGB = be.getTextColor() != null ? be.getTextColor().method_16357() : 0;
        int darkColor = PlayerStatueRenderer.getDarkColorLikeSigns(baseRGB, glowing);
        if (glowing) {
            argbText = 0xFF000000 | baseRGB;
            packedLight = 0xF000F0;
            outlineVisible = PlayerStatueRenderer.isOutlineVisibleLikeSigns(be.method_11016(), baseRGB);
        } else {
            argbText = 0xFF000000 | darkColor;
            packedLight = worldLight;
            outlineVisible = false;
        }
        pose.method_22903();
        pose.method_22907(class_7833.field_40716.rotationDegrees(pedestalYaw));
        pose.method_46416(0.0f, 0.25f, -0.5005f);
        pose.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        pose.method_22905(0.010416667f, -0.010416667f, 0.010416667f);
        int w = this.font.method_30880((class_5481)seqs.get(0));
        float fit = w > 100 ? 100.0f / (float)w : 1.0f;
        pose.method_22905(fit, fit, fit);
        float x = (float)(-this.font.method_30880((class_5481)seqs.get(0))) / 2.0f;
        Objects.requireNonNull(this.font);
        float y = (float)(-9) / 2.0f;
        if (outlineVisible) {
            this.font.method_37296((class_5481)seqs.get(0), x, y, argbText, darkColor, pose.method_23760().method_23761(), buf, packedLight);
        } else {
            this.font.method_22942((class_5481)seqs.get(0), x, y, argbText, false, pose.method_23760().method_23761(), buf, class_327.class_6415.field_33995, 0, packedLight);
        }
        pose.method_22909();
    }

    private static boolean isOutlineVisibleLikeSigns(class_2338 pos, int rgb) {
        if (rgb == class_1767.field_7963.method_16357()) {
            return true;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player != null && mc.field_1690.method_31044().method_31034() && player.method_31550()) {
            return true;
        }
        class_1297 cam = mc.method_1560();
        return cam != null && cam.method_5707(class_243.method_24953((class_2382)pos)) < 256.0;
    }

    private static int getDarkColorLikeSigns(int rgb, boolean glowing) {
        if (rgb == class_1767.field_7963.method_16357() && glowing) {
            return -988212;
        }
        int r = (int)((double)class_5253.class_5254.method_27765((int)rgb) * 0.4);
        int g = (int)((double)class_5253.class_5254.method_27766((int)rgb) * 0.4);
        int b = (int)((double)class_5253.class_5254.method_27767((int)rgb) * 0.4);
        return class_5253.class_5254.method_27764((int)0, (int)r, (int)g, (int)b);
    }

    public static int pedestalMaxTextPixels(class_327 font) {
        return 100;
    }

    private class_2960 notchOverlayTex(PlayerStatueBlockEntity be) {
        return switch (be.getNotchTier()) {
            default -> throw new IncompatibleClassChangeError();
            case PlayerStatueBlockEntity.NotchTier.COPPER -> PEDESTAL_TEX_COPPER_NOTCH;
            case PlayerStatueBlockEntity.NotchTier.IRON -> PEDESTAL_TEX_IRON_NOTCH;
            case PlayerStatueBlockEntity.NotchTier.GOLD -> PEDESTAL_TEX_GOLD_NOTCH;
            case PlayerStatueBlockEntity.NotchTier.DIAMOND -> PEDESTAL_TEX_DIAMOND_NOTCH;
            case PlayerStatueBlockEntity.NotchTier.NONE -> null;
        };
    }
}

