/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import dev.hexnowloading.dungeonnowloading.block.FairkeeperSpawnerBlock;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityScale;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlockEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLProperties;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import org.slf4j.Logger;

public class FairkeeperSpawnerBlockEntity
extends class_2586 {
    private static final int SPAWN_RANGE = 4;
    private static final int SPAWN_POS_TRIES = 10;
    private static final Logger LOGGER = LogUtils.getLogger();
    private class_6005<class_1952> spawnPotentials = class_6005.method_38062();
    private class_1952 nextSpawnData;
    private class_1297 displayEntity;
    private int remainingStoredMobs = 0;
    private int spawnDelay = 0;
    private int startUpTick = 40;
    private int destroyTick = -1;
    private int requiredPlayerRange = 16;
    private double spin;
    private double oSpin;
    private boolean disabled = false;

    public FairkeeperSpawnerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(DNLBlockEntityTypes.FAIRKEEPER_SPAWNER.get(), blockPos, blockState);
    }

    protected void method_11007(class_2487 compoundTag) {
        compoundTag.method_10569("RemainingStoredMobs", this.remainingStoredMobs);
        compoundTag.method_10569("StartUpTick", this.startUpTick);
        compoundTag.method_10569("SpawnDelay", this.spawnDelay);
        compoundTag.method_10556("Disabled", this.disabled);
        if (this.nextSpawnData != null) {
            compoundTag.method_10566("SpawnData", (class_2520)class_1952.field_34460.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.nextSpawnData).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
        }
        compoundTag.method_10566("SpawnPotentials", (class_2520)class_1952.field_34461.encodeStart((DynamicOps)class_2509.field_11560, this.spawnPotentials).result().orElseThrow());
        super.method_11007(compoundTag);
    }

    public void method_11014(class_2487 compoundTag) {
        boolean b1;
        this.remainingStoredMobs = compoundTag.method_10550("RemainingStoredMobs");
        this.startUpTick = compoundTag.method_10550("StartUpTick");
        this.spawnDelay = compoundTag.method_10550("SpawnDelay");
        this.disabled = compoundTag.method_10577("Disabled");
        boolean b0 = compoundTag.method_10573("SpawnData", 10);
        if (b0) {
            class_1952 spawnData = class_1952.field_34460.parse((DynamicOps)class_2509.field_11560, (Object)compoundTag.method_10562("SpawnData")).resultOrPartial($$0x -> LOGGER.warn("Invalid SpawnData: {}", $$0x)).orElseGet(class_1952::new);
            this.setNextSpawnData(this.field_11863, this.method_11016(), spawnData);
        }
        if (b1 = compoundTag.method_10573("SpawnPotentials", 9)) {
            class_2499 $$6 = compoundTag.method_10554("SpawnPotentials", 10);
            this.spawnPotentials = class_1952.field_34461.parse((DynamicOps)class_2509.field_11560, (Object)$$6).resultOrPartial($$0x -> LOGGER.warn("Invalid SpawnPotentials list: {}", $$0x)).orElseGet(class_6005::method_38062);
        } else {
            this.spawnPotentials = class_6005.method_38061((Object)(this.nextSpawnData != null ? this.nextSpawnData : new class_1952()));
        }
        this.displayEntity = null;
        super.method_11014(compoundTag);
    }

    protected void setNextSpawnData(class_1937 level, class_2338 blockPos, class_1952 spawnData) {
        this.nextSpawnData = spawnData;
        if (level != null) {
            class_2680 blockState = level.method_8320(blockPos);
            level.method_8413(blockPos, blockState, blockState, 4);
        }
    }

    public class_1297 getOrCreateDisplayEntity(class_1937 level, class_5819 randomSource, class_2338 blockPos) {
        if (this.displayEntity == null) {
            class_2487 $$3 = this.getOrCreateNextSpawnData(level, randomSource, blockPos).method_38093();
            if (!$$3.method_10573("id", 8)) {
                return null;
            }
            this.displayEntity = class_1299.method_17842((class_2487)$$3, (class_1937)level, Function.identity());
            if ($$3.method_10546() != 1 || this.displayEntity instanceof class_1308) {
                // empty if block
            }
        }
        return this.displayEntity;
    }

    private class_1952 getOrCreateNextSpawnData(@Nullable class_1937 level, class_5819 randomSource, class_2338 blockPos) {
        if (this.nextSpawnData != null) {
            return this.nextSpawnData;
        }
        this.setNextSpawnData(level, blockPos, this.spawnPotentials.method_34992(randomSource).map(class_6008.class_6010::method_34983).orElseGet(class_1952::new));
        return this.nextSpawnData;
    }

    private boolean isNearPlayer(class_1937 level, class_2338 blockPos) {
        return level.method_18458((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, (double)this.requiredPlayerRange);
    }

    public void setDisabled(boolean b) {
        this.disabled = b;
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, FairkeeperSpawnerBlockEntity blockEntity) {
        if (state.method_11654((class_2769)DNLProperties.FAIRKEEPER_ALERT) == Boolean.TRUE) {
            class_5819 randomSource = level.method_8409();
            double d = (double)pos.method_10263() + randomSource.method_43058();
            double e = (double)pos.method_10264() + randomSource.method_43058();
            double f = (double)pos.method_10260() + randomSource.method_43058();
            level.method_8406((class_2394)class_2398.field_11251, d, e, f, 0.0, 0.0, 0.0);
            level.method_8406((class_2394)class_2398.field_11240, d, e, f, 0.0, 0.0, 0.0);
        }
        if (!blockEntity.isNearPlayer(level, pos)) {
            blockEntity.oSpin = blockEntity.spin;
        } else if (blockEntity.displayEntity != null) {
            blockEntity.oSpin = blockEntity.spin;
            blockEntity.spin = (blockEntity.spin + (double)(1000.0f / ((float)blockEntity.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, FairkeeperSpawnerBlockEntity blockEntity) {
        if (blockEntity.disabled) {
            if (blockEntity.destroyTick < 0) {
                blockEntity.destroyTick = 20 + level.field_9229.method_43048(40);
            }
            --blockEntity.destroyTick;
            if (blockEntity.destroyTick == 0) {
                level.method_22352(pos, false);
                double d = (double)pos.method_10263() + 0.5;
                double e = (double)pos.method_10264() + 0.5;
                double f = (double)pos.method_10260() + 0.5;
                ((class_3218)level).method_14199((class_2394)class_2390.field_11188, d, e, f, 10, 0.0, 0.5, 0.5, 0.5);
            }
        }
        if (((Boolean)state.method_11654((class_2769)DNLProperties.FAIRKEEPER_ALERT)).booleanValue()) {
            if (blockEntity.startUpTick > 0) {
                if (blockEntity.startUpTick == 40) {
                    level.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_14588, class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.2f + 0.8f);
                }
                --blockEntity.startUpTick;
            } else if (blockEntity.remainingStoredMobs > 0) {
                if (blockEntity.spawnDelay > 0) {
                    --blockEntity.spawnDelay;
                } else {
                    blockEntity.spawnDelay = 20;
                    --blockEntity.remainingStoredMobs;
                    blockEntity.randomMobSummon((class_3218)level);
                    level.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_14858, class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.2f + 0.8f);
                }
            } else {
                level.method_22352(pos, false);
            }
        }
    }

    public void alert(int playerCount, class_2338 blockPos, FairkeeperSpawnerBlockEntity blockEntity) {
        if (blockEntity.method_11010().method_11654((class_2769)DNLProperties.FAIRKEEPER_ALERT) == Boolean.FALSE) {
            FairkeeperSpawnerBlock.setFairkeeperAlert(blockEntity.field_11863, blockPos, Boolean.TRUE);
            blockEntity.remainingStoredMobs = Math.min(playerCount + 1, 4);
        }
    }

    public void destroyed() {
        class_238 aabb = new class_238((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260(), (double)(this.method_11016().method_10263() + 1), (double)(this.method_11016().method_10264() + 1), (double)this.method_11016().method_10260()).method_1014(32.0);
        List nearbyPlayers = this.field_11863.method_18467(class_1657.class, aabb);
        int playerCount = Math.min(nearbyPlayers.size() + 1, 4);
        for (int i = 0; i < playerCount; ++i) {
            this.randomMobSummon((class_3218)this.field_11863);
        }
    }

    public void randomMobSummon(class_3218 level) {
        class_5819 randomSource = level.method_8409();
        class_1952 spawnData = this.getOrCreateNextSpawnData((class_1937)level, randomSource, this.method_11016());
        class_2487 compoundTag = spawnData.method_38093();
        Optional entityType = class_1299.method_17684((class_2487)compoundTag);
        if (entityType.isEmpty()) {
            return;
        }
        if (!((class_1299)entityType.get()).method_5891().method_6136() && level.method_8407() == class_1267.field_5801) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            class_1308 mob1;
            double x = (double)this.method_11016().method_10263() + (level.field_9229.method_43058() - level.field_9229.method_43058()) * 4.0 + 0.5;
            double y = this.method_11016().method_10264() + level.field_9229.method_43048(3) - 1;
            double z = (double)this.method_11016().method_10260() + (level.field_9229.method_43058() - level.field_9229.method_43058()) * 4.0 + 0.5;
            class_2338 blockPos = class_2338.method_49637((double)x, (double)y, (double)z);
            class_1297 mob = class_1299.method_17842((class_2487)compoundTag, (class_1937)level, a -> {
                a.method_5808(x, y, z, a.method_36454(), a.method_36455());
                return a;
            });
            if (mob == null) break;
            mob.method_5808(x, y, z, level.field_9229.method_43057() * 360.0f, 0.0f);
            if (!(mob instanceof class_1308) || !level.method_8587((class_1297)(mob1 = (class_1308)mob), ((class_1299)entityType.get()).method_17683(mob1.method_23317(), mob1.method_23318(), mob1.method_23321())) || !mob1.method_5957((class_4538)level)) continue;
            EntityScale.scaleMobAttributes((class_1309)mob1);
            mob1.method_5971();
            if (spawnData.method_38093().method_10546() == 1 && spawnData.method_38093().method_10573("id", 8)) {
                ((class_1308)mob).method_5943((class_5425)level, level.method_8404(mob.method_24515()), class_3730.field_16469, (class_1315)null, (class_2487)null);
            }
            if (!level.method_30736((class_1297)mob1)) break;
            level.method_20290(2004, this.method_11016(), 0);
            level.method_33596((class_1297)mob1, class_5712.field_28738, blockPos);
            mob1.method_5990();
            this.spawnPotentials.method_34992(randomSource).ifPresent(b -> this.setNextSpawnData((class_1937)level, blockPos, (class_1952)b.method_34983()));
            break;
        }
    }

    public double getSpin() {
        return this.spin;
    }

    public double getoSpin() {
        return this.oSpin;
    }
}

