/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block.entity;

import dev.hexnowloading.dungeonnowloading.item.ScrapItem;
import dev.hexnowloading.dungeonnowloading.menu.MendingTableMenu;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlockEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MendingTableBlockEntity
extends class_2586
implements class_3908,
class_1263 {
    private static final int INVENTORY_SIZE = 4;
    private class_2371<class_1799> items = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    private int cachedRepairPercent = 0;
    int cachedBasePercent = 0;
    int cachedBonusPercent = 0;
    private int cachedPotentialBasePercent = 0;
    private int cachedPotentialBonusPercent = 0;
    private static final int PICKAXE_SLOT = 0;
    private static final int MAT_SLOT_1 = 1;
    private static final int MAT_SLOT_2 = 2;
    private static final int OUTPUT_SLOT = 3;
    private static final int DURITE_PERCENT = 20;
    private static final int MENDSTONE_PERCENT = 50;
    private static final int TOOL_MATERIAL_PERCENT = 40;
    private static final int BONUS_PERCENT = 10;

    public MendingTableBlockEntity(class_2338 pos, class_2680 state) {
        super(DNLBlockEntityTypes.MENDING_TABLE.get(), pos, state);
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.dungeonnowloading.mending_table");
    }

    @Nullable
    public class_1703 createMenu(int id, @NotNull class_1661 inventory, @NotNull class_1657 player) {
        return new MendingTableMenu(id, inventory, this);
    }

    protected void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5426((class_2487)tag, this.items);
    }

    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        this.items = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, this.items);
    }

    public int method_5439() {
        return 4;
    }

    public boolean method_5442() {
        for (class_1799 stack : this.items) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public class_1799 method_5438(int index) {
        return (class_1799)this.items.get(index);
    }

    @NotNull
    public class_1799 method_5434(int index, int count) {
        class_1799 result = class_1262.method_5430(this.items, (int)index, (int)count);
        if (!result.method_7960()) {
            this.recalc();
        }
        return result;
    }

    @NotNull
    public class_1799 method_5441(int index) {
        class_1799 stack = (class_1799)this.items.get(index);
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        this.items.set(index, (Object)class_1799.field_8037);
        this.recalc();
        return stack;
    }

    public void method_5447(int index, @NotNull class_1799 stack) {
        this.items.set(index, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.recalc();
    }

    public boolean method_5443(@NotNull class_1657 player) {
        if (this.field_11863 == null) {
            return false;
        }
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.items.clear();
        this.recalc();
    }

    public int getPotentialBasePercent() {
        return this.cachedPotentialBasePercent;
    }

    public int getPotentialBonusPercent() {
        return this.cachedPotentialBonusPercent;
    }

    private boolean isTool(class_1799 stack) {
        return stack.method_7963();
    }

    private boolean isToolRepairIngredient(class_1799 tool, class_1799 ingredientStack) {
        if (tool.method_7960() || ingredientStack.method_7960()) {
            return false;
        }
        if (!tool.method_7963()) {
            return false;
        }
        return tool.method_7909().method_7878(tool, ingredientStack);
    }

    private int percentPerItem(class_1799 tool, class_1799 stack) {
        if (stack.method_31574(DNLItems.MENDSTONE.get())) {
            return 50;
        }
        if (stack.method_31574(DNLItems.DURITE.get())) {
            return 20;
        }
        if (!tool.method_7960() && this.isToolRepairIngredient(tool, stack)) {
            return 40;
        }
        return 0;
    }

    private void recalc() {
        int p2;
        class_1799 inputTool;
        class_1799 input = (class_1799)this.items.get(0);
        class_1799 mat1 = (class_1799)this.items.get(1);
        class_1799 mat2 = (class_1799)this.items.get(2);
        this.items.set(3, (Object)class_1799.field_8037);
        this.cachedRepairPercent = 0;
        this.cachedBasePercent = 0;
        this.cachedBonusPercent = 0;
        this.cachedPotentialBasePercent = 0;
        this.cachedPotentialBonusPercent = 0;
        boolean isScrap = input.method_31574(DNLItems.ITEM_SCRAPS.get());
        class_1799 class_17992 = inputTool = isScrap ? ScrapItem.getOriginal(input) : input;
        if (inputTool.method_7960() || !this.isTool(inputTool)) {
            this.method_5431();
            return;
        }
        if (inputTool.method_31574(DNLItems.MENDSTONE_PICKAXE.get())) {
            this.method_5431();
            return;
        }
        int damage = inputTool.method_7919();
        if (damage <= 0) {
            this.method_5431();
            return;
        }
        int max = inputTool.method_7936();
        int neededPercent = (damage * 100 + max - 1) / max;
        int p1 = this.percentPerItem(inputTool, mat1);
        int potentialBase = p1 + (p2 = this.percentPerItem(inputTool, mat2));
        if (potentialBase <= 0) {
            this.method_5431();
            return;
        }
        boolean hasToolMat = !mat1.method_7960() && this.isToolRepairIngredient(inputTool, mat1) || !mat2.method_7960() && this.isToolRepairIngredient(inputTool, mat2);
        boolean hasDuriteOrMendstone = !mat1.method_7960() && (mat1.method_31574(DNLItems.DURITE.get()) || mat1.method_31574(DNLItems.MENDSTONE.get())) || !mat2.method_7960() && (mat2.method_31574(DNLItems.DURITE.get()) || mat2.method_31574(DNLItems.MENDSTONE.get()));
        int potentialBonus = hasToolMat && hasDuriteOrMendstone ? 10 : 0;
        this.cachedPotentialBasePercent = Math.min(potentialBase, 100);
        this.cachedPotentialBonusPercent = potentialBonus;
        int appliedBase = Math.min(potentialBase, neededPercent);
        int appliedBonus = Math.min(potentialBonus, Math.max(0, neededPercent - appliedBase));
        int appliedTotal = appliedBase + appliedBonus;
        int repairAmount = (appliedTotal * max + 99) / 100;
        int newDamage = Math.max(0, damage - repairAmount);
        class_1799 result = inputTool.method_7972();
        result.method_7974(newDamage);
        this.items.set(3, (Object)result);
        this.cachedBasePercent = appliedBase;
        this.cachedBonusPercent = appliedBonus;
        this.cachedRepairPercent = Math.min(appliedTotal, 100);
        this.method_5431();
    }

    public void applyRepair() {
        class_1799 inputTool;
        class_1799 input = (class_1799)this.items.get(0);
        if (input.method_7960() || this.cachedRepairPercent <= 0) {
            return;
        }
        boolean isScrap = input.method_31574(DNLItems.ITEM_SCRAPS.get());
        class_1799 class_17992 = inputTool = isScrap ? ScrapItem.getOriginal(input) : input;
        if (inputTool.method_7960()) {
            return;
        }
        class_1799 mat1 = (class_1799)this.items.get(1);
        class_1799 mat2 = (class_1799)this.items.get(2);
        int p1 = this.percentPerItem(inputTool, mat1);
        int p2 = this.percentPerItem(inputTool, mat2);
        boolean s1ToolMat = !mat1.method_7960() && this.isToolRepairIngredient(inputTool, mat1);
        boolean s1DuriteOrMendstone = !mat1.method_7960() && (mat1.method_31574(DNLItems.DURITE.get()) || mat1.method_31574(DNLItems.MENDSTONE.get()));
        boolean s2ToolMat = !mat2.method_7960() && this.isToolRepairIngredient(inputTool, mat2);
        boolean s2DuriteOrMendstone = !mat2.method_7960() && (mat2.method_31574(DNLItems.DURITE.get()) || mat2.method_31574(DNLItems.MENDSTONE.get()));
        int remaining = this.cachedBasePercent;
        boolean c1 = false;
        boolean c2 = false;
        if (remaining > 0 && p1 > 0) {
            c1 = true;
            remaining = Math.max(0, remaining - p1);
        }
        if (remaining > 0 && p2 > 0) {
            c2 = true;
        }
        if (this.cachedBonusPercent > 0) {
            boolean haveDurite;
            boolean haveToolMat;
            boolean bl = haveToolMat = c1 && s1ToolMat || c2 && s2ToolMat;
            if (!haveToolMat) {
                if (!c1 && p1 > 0 && s1ToolMat) {
                    c1 = true;
                } else if (!c2 && p2 > 0 && s2ToolMat) {
                    c2 = true;
                }
            }
            boolean bl2 = haveDurite = c1 && s1DuriteOrMendstone || c2 && s2DuriteOrMendstone;
            if (!haveDurite) {
                if (!c1 && p1 > 0 && s1DuriteOrMendstone) {
                    c1 = true;
                } else if (!c2 && p2 > 0 && s2DuriteOrMendstone) {
                    c2 = true;
                }
            }
        }
        if (c1) {
            mat1.method_7934(1);
        }
        if (c2) {
            mat2.method_7934(1);
        }
        this.items.set(0, (Object)class_1799.field_8037);
        this.items.set(3, (Object)class_1799.field_8037);
        this.recalc();
    }
}

