/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block.entity;

import com.mojang.authlib.GameProfile;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlockEntityTypes;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_5250;

public class PlayerStatueBlockEntity
extends class_2586 {
    public static final int LINES = 4;
    public static final int MAX_TEXT_LINE_WIDTH = 90;
    public static final int TEXT_LINE_HEIGHT = 10;
    @Nullable
    private GameProfile owner;
    private int poseVariant = 0;
    private final class_2561[] text = new class_2561[]{class_2561.method_43473(), class_2561.method_43473(), class_2561.method_43473(), class_2561.method_43473()};
    private class_1767 textColor = class_1767.field_7963;
    private boolean glowingText = false;
    @Nullable
    private UUID allowedEditor;
    private boolean waxed = false;
    private class_1799 offering = class_1799.field_8037;
    private NotchTier notchTier = NotchTier.NONE;

    public PlayerStatueBlockEntity(class_2338 pos, class_2680 state) {
        super(DNLBlockEntityTypes.PLAYER_STATUE.get(), pos, state);
    }

    public boolean hasOffering() {
        return !this.offering.method_7960();
    }

    public class_1799 getOfferingCopy() {
        return this.offering.method_7972();
    }

    @Nullable
    public GameProfile getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable GameProfile gp) {
        this.owner = gp;
        this.method_5431();
        this.sync();
    }

    public int getPoseVariant() {
        return this.poseVariant;
    }

    public void setPoseVariant(int v) {
        this.poseVariant = v;
        this.method_5431();
        this.sync();
    }

    public class_2561 getLine(int i) {
        return this.text[i];
    }

    public class_2561[] getLines() {
        return this.text;
    }

    public class_1767 getTextColor() {
        return this.textColor;
    }

    public boolean isGlowingText() {
        return this.glowingText;
    }

    public int getMaxTextLineWidth() {
        return 90;
    }

    public int getTextLineHeight() {
        return 10;
    }

    public void setLine(int i, class_2561 c) {
        this.text[i] = (class_2561)Objects.requireNonNullElse(c, class_2561.method_43473());
        this.method_5431();
        this.sync();
    }

    public void setAllText(List<class_2561> lines, class_1767 color, boolean glow) {
        for (int i = 0; i < 4; ++i) {
            class_5250 c = i < lines.size() && lines.get(i) != null ? lines.get(i) : class_2561.method_43473();
            this.text[i] = c;
        }
        this.textColor = color != null ? color : class_1767.field_7963;
        this.glowingText = glow;
        this.method_5431();
        this.sync();
    }

    public boolean isWaxed() {
        return this.waxed;
    }

    public boolean setWaxed(boolean wax) {
        if (this.waxed != wax) {
            this.waxed = wax;
            this.method_5431();
            this.sync();
            return true;
        }
        return false;
    }

    public void setAllowedEditor(@Nullable UUID id) {
        this.allowedEditor = id;
        this.method_5431();
    }

    @Nullable
    public UUID getAllowedEditor() {
        return this.allowedEditor;
    }

    public boolean playerIsTooFarAwayToEdit(UUID playerId) {
        if (this.field_11863 == null) {
            return true;
        }
        class_1657 p = this.field_11863.method_18470(playerId);
        return p == null || p.method_5649((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260()) > 64.0;
    }

    public static void serverTick(class_1937 lvl, class_2338 pos, class_2680 state, PlayerStatueBlockEntity be) {
        if (!(lvl instanceof class_3218)) {
            return;
        }
        UUID lock = be.allowedEditor;
        if (lock != null && be.playerIsTooFarAwayToEdit(lock)) {
            be.setAllowedEditor(null);
        }
    }

    public void applyTextUpdateFromClient(class_3222 sender, List<class_2561> newLines, class_1767 color, boolean glow) {
        if (!(this.field_11863 instanceof class_3218)) {
            return;
        }
        if (this.isWaxed()) {
            sender.method_7353((class_2561)class_2561.method_43470((String)"Statue is waxed"), false);
            return;
        }
        if (!sender.method_5667().equals(this.allowedEditor)) {
            sender.method_7353((class_2561)class_2561.method_43470((String)"No edit lock / wrong editor"), false);
            return;
        }
        if (this.playerIsTooFarAwayToEdit(sender.method_5667())) {
            sender.method_7353((class_2561)class_2561.method_43470((String)"Too far to edit"), false);
            return;
        }
        this.setAllText(newLines, color, glow);
        this.setAllowedEditor(null);
        this.method_5431();
        this.sync();
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.owner != null) {
            class_2487 o = new class_2487();
            class_2512.method_10684((class_2487)o, (GameProfile)this.owner);
            tag.method_10566("Owner", (class_2520)o);
        }
        tag.method_10569("PoseVariant", this.poseVariant);
        for (int i = 0; i < 4; ++i) {
            tag.method_10582("Text" + (i + 1), class_2561.class_2562.method_10867((class_2561)this.text[i]));
        }
        tag.method_10582("TextColor", this.textColor.method_7792());
        tag.method_10556("TextGlowing", this.glowingText);
        if (this.allowedEditor != null) {
            tag.method_25927("AllowedEditor", this.allowedEditor);
        }
        tag.method_10556("Waxed", this.waxed);
        tag.method_10582("NotchTier", this.notchTier.name());
    }

    public void method_11014(class_2487 tag) {
        class_1799 legacy;
        NotchTier legacyTier;
        super.method_11014(tag);
        this.owner = tag.method_10573("Owner", 10) ? class_2512.method_10683((class_2487)tag.method_10562("Owner")) : null;
        this.poseVariant = tag.method_10550("PoseVariant");
        for (int i = 0; i < 4; ++i) {
            String key = "Text" + (i + 1);
            this.text[i] = tag.method_10573(key, 8) ? class_2561.class_2562.method_10877((String)tag.method_10558(key)) : class_2561.method_43473();
        }
        if (tag.method_10573("TextColor", 8)) {
            try {
                this.textColor = class_1767.method_7793((String)tag.method_10558("TextColor"), (class_1767)class_1767.field_7963);
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        this.glowingText = tag.method_10577("TextGlowing");
        this.allowedEditor = tag.method_10573("AllowedEditor", 11) || tag.method_10573("AllowedEditor", 12) ? tag.method_25926("AllowedEditor") : null;
        this.waxed = tag.method_10577("Waxed");
        this.notchTier = NotchTier.fromString(tag.method_10558("NotchTier"));
        if (this.notchTier == NotchTier.NONE && tag.method_10573("Offering", 10) && (legacyTier = PlayerStatueBlockEntity.tierFromItem(legacy = class_1799.method_7915((class_2487)tag.method_10562("Offering")))) != NotchTier.NONE) {
            this.notchTier = legacyTier;
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void sync() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
    }

    public static NotchTier tierFromItem(class_1799 s) {
        if (s.method_31574(class_1802.field_27022)) {
            return NotchTier.COPPER;
        }
        if (s.method_31574(class_1802.field_8620)) {
            return NotchTier.IRON;
        }
        if (s.method_31574(class_1802.field_8695)) {
            return NotchTier.GOLD;
        }
        if (s.method_31574(class_1802.field_8477)) {
            return NotchTier.DIAMOND;
        }
        return NotchTier.NONE;
    }

    public static class_1799 defaultItemForTier(NotchTier t) {
        return switch (t) {
            case NotchTier.COPPER -> new class_1799((class_1935)class_1802.field_27022);
            case NotchTier.IRON -> new class_1799((class_1935)class_1802.field_8620);
            case NotchTier.GOLD -> new class_1799((class_1935)class_1802.field_8695);
            case NotchTier.DIAMOND -> new class_1799((class_1935)class_1802.field_8477);
            default -> class_1799.field_8037;
        };
    }

    @Nullable
    public String ensureServerSideOwnerName() {
        Optional opt;
        if (this.owner == null) {
            return null;
        }
        if (this.owner.getName() != null && !this.owner.getName().isEmpty()) {
            return this.owner.getName();
        }
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 sl = (class_3218)class_19372;
        UUID id = this.owner.getId();
        if (id == null) {
            return null;
        }
        class_3312 cache = sl.method_8503().method_3793();
        if (cache != null && (opt = cache.method_14512(id)).isPresent()) {
            this.owner = (GameProfile)opt.get();
            this.method_5431();
            return this.owner.getName();
        }
        return null;
    }

    public static String shortUuid(@Nullable UUID id) {
        return id == null ? "Someone" : id.toString().substring(0, 8);
    }

    public boolean isOccupied() {
        return this.notchTier != NotchTier.NONE;
    }

    public boolean placeMaterial(class_1799 oneItem) {
        NotchTier t = PlayerStatueBlockEntity.tierFromItem(oneItem);
        if (t == NotchTier.NONE) {
            return false;
        }
        this.setNotchTier(t);
        return true;
    }

    public class_1799 takeMaterial() {
        if (!this.isOccupied()) {
            return class_1799.field_8037;
        }
        class_1799 out = PlayerStatueBlockEntity.defaultItemForTier(this.notchTier);
        this.setNotchTier(NotchTier.NONE);
        return out;
    }

    public NotchTier getNotchTier() {
        return this.notchTier;
    }

    public void setNotchTier(NotchTier tier) {
        if (tier == null) {
            tier = NotchTier.NONE;
        }
        if (tier != this.notchTier) {
            this.notchTier = tier;
            this.method_5431();
            this.sync();
        }
    }

    public static enum NotchTier {
        NONE,
        COPPER,
        IRON,
        GOLD,
        DIAMOND;


        public static NotchTier fromString(String s) {
            if (s == null) {
                return NONE;
            }
            try {
                return NotchTier.valueOf(s.toUpperCase());
            }
            catch (Exception e) {
                return NONE;
            }
        }
    }
}

