/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import dev.hexnowloading.dungeonnowloading.entity.util.WeightedTargetProvider;
import dev.hexnowloading.dungeonnowloading.util.WeightedRandomBag;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1405;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_270;

public class BossTargetSelectorGoal
extends class_1405 {
    private final class_1308 mob;
    private final WeightedTargetProvider targetProvider;
    private class_1309 selectedTarget = null;

    public BossTargetSelectorGoal(class_1308 mob) {
        super(mob, false);
        WeightedTargetProvider t;
        class_1308 class_13082 = this.mob = mob;
        this.targetProvider = class_13082 instanceof WeightedTargetProvider ? (t = (WeightedTargetProvider)class_13082) : null;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
    }

    public boolean method_6264() {
        if (this.mob.method_5968() == null) {
            this.findTarget();
            return this.selectedTarget != null;
        }
        return false;
    }

    public boolean method_6266() {
        boolean withinZ;
        class_1309 livingEntity = this.mob.method_5968();
        if (livingEntity == null) {
            livingEntity = this.field_6664;
        }
        if (livingEntity == null) {
            return false;
        }
        if (!this.mob.method_18395(livingEntity)) {
            return false;
        }
        class_270 teamMob = this.mob.method_5781();
        class_270 teamOther = livingEntity.method_5781();
        if (teamMob != null && teamOther == teamMob) {
            return false;
        }
        int arenaSize = this.targetProvider.getArenaSize();
        class_2338 arenaCenter = this.targetProvider.getArenaCenter();
        boolean withinX = Math.abs(livingEntity.method_23317() - (double)arenaCenter.method_10263() + 0.5) < (double)((float)arenaSize + 0.5f);
        boolean withinY = Math.abs(livingEntity.method_23318() - (double)arenaCenter.method_10264() + 0.5) < (double)((float)arenaSize + 0.5f);
        boolean bl = withinZ = Math.abs(livingEntity.method_23321() - (double)arenaCenter.method_10260() + 0.5) < (double)((float)arenaSize + 0.5f);
        if (!(withinX && withinY && withinZ)) {
            return false;
        }
        this.mob.method_5980(livingEntity);
        return true;
    }

    public void method_6269() {
        if (this.selectedTarget != null) {
            this.mob.method_5980(this.selectedTarget);
            this.field_6664 = this.selectedTarget;
            this.selectedTarget = null;
        }
        super.method_6269();
    }

    public static void changeTarget(WeightedTargetProvider targetProvider) {
        class_1308 mob = (class_1308)targetProvider;
        if (mob.method_5968() == null) {
            return;
        }
        mob.method_5980(BossTargetSelectorGoal.weightTargets(targetProvider, mob));
    }

    private void findTarget() {
        this.selectedTarget = BossTargetSelectorGoal.weightTargets(this.targetProvider, this.mob);
    }

    /*
     * WARNING - void declaration
     */
    private static class_1309 weightTargets(WeightedTargetProvider targetProvider, class_1308 mob) {
        void var8_12;
        class_2338 arenaCenter = targetProvider.getArenaCenter();
        int range = targetProvider.getArenaSize();
        class_238 aabb = new class_238(arenaCenter).method_1014((double)range);
        HashSet<UUID> seen = new HashSet<UUID>();
        ArrayList<Object> candidates = new ArrayList<Object>();
        for (class_1657 class_16572 : mob.method_37908().method_18467(class_1657.class, aabb)) {
            if (!class_16572.method_5805() || !mob.method_18395((class_1309)class_16572)) continue;
            candidates.add(class_16572);
            seen.add(class_16572.method_5667());
        }
        for (Map.Entry entry : targetProvider.getAttackers().entrySet()) {
            class_1309 attacker = (class_1309)entry.getValue();
            if (attacker == null || !attacker.method_5805() || !mob.method_18395(attacker) || !seen.add((UUID)entry.getKey())) continue;
            candidates.add(attacker);
        }
        targetProvider.getThreatScoreMap().clear();
        WeightedRandomBag<class_1309> weightedPool = new WeightedRandomBag<class_1309>();
        candidates.sort(Comparator.comparingDouble(arg_0 -> ((class_1308)mob).method_5858(arg_0)));
        boolean bl = false;
        while (var8_12 < candidates.size()) {
            class_1309 entity = (class_1309)candidates.get((int)var8_12);
            double distanceMultiplier = switch (var8_12) {
                case 0 -> 2.0;
                case 1 -> 1.5;
                default -> 1.0;
            };
            double damage = targetProvider.getDamageMap().getOrDefault(entity.method_5667(), 0.0);
            int damageScore = (int)Math.floor(damage / (double)(mob.method_6063() * 0.1f));
            int finalScore = (int)Math.floor((double)damageScore * distanceMultiplier + 1.0);
            targetProvider.getThreatScoreMap().put(entity.method_5667(), Double.valueOf(finalScore));
            weightedPool.addEntry(entity, finalScore);
            ++var8_12;
        }
        class_1309 class_13092 = (class_1309)weightedPool.getRandom();
        if (class_13092 != null) {
            // empty if block
        }
        return class_13092;
    }
}

