/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import com.google.common.collect.ImmutableList;
import dev.hexnowloading.dungeonnowloading.entity.ai.StoppableGoal;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosPartEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentCallerEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.BorusArrowEntity;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.apache.commons.lang3.tuple.Triple;

public class FairkeeperBorosShootArrowGoal
extends StoppableGoal {
    private final FairkeeperBorosEntity boros;
    private FairkeeperBorosEntity.FairkeeperBorosState state;
    ShootingPattern pattern;
    private FairkeeperBorosPartEntity currentPart;
    private int arenaSize;
    private class_2338 arenaCenter;
    private int targetIndex = 0;
    private final double speed;
    private List<FairkeeperBorosPartEntity> partList = new ArrayList<FairkeeperBorosPartEntity>();
    private int stoppingTick;
    private int playSoundForPart;
    private boolean forceStop;
    private static final float FULL_ARENA_SIZE = 49.0f;
    private static final int STOP_DURATION = 32;
    private static final int SHOOT_ARROW_TICK = 15;
    private static final int BEAM_TICK = 30;
    private static List<Integer> ODD_PARTS = List.of(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(7), Integer.valueOf(9), Integer.valueOf(11));
    private static List<Integer> EVEN_PARTS = List.of(Integer.valueOf(0), Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(8), Integer.valueOf(10), Integer.valueOf(12));
    private static List<Integer> ALL_PARTS = List.of(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
    public static ShootingPattern PATTERN_LINE = new ShootingPattern(true, 0.79591835f, (ImmutableList<Triple<ShootingType, List<Integer>, class_243>>)ImmutableList.of((Object)Triple.of((Object)((Object)ShootingType.NONE), List.of(), (Object)new class_243(0.0, 0.0, 1.0)), (Object)Triple.of((Object)((Object)ShootingType.BOTH), ODD_PARTS, (Object)new class_243(0.0, 0.0, -1.0)), (Object)Triple.of((Object)((Object)ShootingType.BOTH), EVEN_PARTS, (Object)new class_243(0.0, 0.0, -1.0)), (Object)Triple.of((Object)((Object)ShootingType.BOTH), ODD_PARTS, (Object)new class_243(0.0, 0.0, -1.0))));
    public static ShootingPattern PATTERN_LINE_FAST = new ShootingPattern(true, 0.79591835f, (ImmutableList<Triple<ShootingType, List<Integer>, class_243>>)ImmutableList.of((Object)Triple.of((Object)((Object)ShootingType.NONE), List.of(), (Object)new class_243(0.0, 0.0, 1.0)), (Object)Triple.of((Object)((Object)ShootingType.TRIPLE_BOTH), ODD_PARTS, (Object)new class_243(0.0, 0.0, -1.0)), (Object)Triple.of((Object)((Object)ShootingType.TRIPLE_BOTH), EVEN_PARTS, (Object)new class_243(0.0, 0.0, -1.0)), (Object)Triple.of((Object)((Object)ShootingType.TRIPLE_BOTH), ODD_PARTS, (Object)new class_243(0.0, 0.0, -1.0))));
    public static ShootingPattern PATTERN_SLITHER = new ShootingPattern(true, 0.79591835f, (ImmutableList<Triple<ShootingType, List<Integer>, class_243>>)ImmutableList.of((Object)Triple.of((Object)((Object)ShootingType.NONE), List.of(), (Object)new class_243(1.0, 0.0, 1.0)), (Object)Triple.of((Object)((Object)ShootingType.RIGHT), ALL_PARTS, (Object)new class_243(-1.0, 0.0, 1.0))));

    public FairkeeperBorosShootArrowGoal(FairkeeperBorosEntity.FairkeeperBorosState state, FairkeeperBorosEntity boros, double speed, ShootingPattern pattern) {
        this.boros = boros;
        this.state = state;
        this.pattern = pattern;
        this.speed = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        return this.boros.method_5968() != null && this.boros.method_5968().method_5805() && this.boros.isState(this.state);
    }

    @Override
    public void method_6269() {
        super.method_6269();
        FairkeeperSerpentCallerEntity caller = this.boros.getCaller();
        if (caller != null) {
            this.arenaSize = caller.getArenaSize();
            class_2338 callerPos = caller.method_24515();
            this.arenaCenter = new class_2338(callerPos.method_10263(), (int)this.boros.method_23318(), callerPos.method_10260());
        }
        this.currentPart = (FairkeeperBorosPartEntity)this.boros.getChild();
        if (this.currentPart == null) {
            this.stopGoal();
            return;
        }
        this.partList.add(this.currentPart);
        for (int i = 0; i < 12; ++i) {
            this.currentPart = (FairkeeperBorosPartEntity)this.currentPart.getChild();
            if (this.currentPart == null) {
                this.stopGoal();
                return;
            }
            this.partList.add(this.currentPart);
        }
        this.targetIndex = 0;
        this.stoppingTick = 0;
        if (this.pattern.shiftStartingPoint) {
            this.rotatePatternToClosest();
        }
    }

    public void method_6270() {
        this.boros.stopAttacking(20);
    }

    public void method_6268() {
        if (this.stoppingTick > 0) {
            --this.stoppingTick;
            if (this.stoppingTick == FairkeeperBorosShootArrowGoal.method_38848((int)30)) {
                this.playSoundForPart = 0;
                ((List)((Triple)this.pattern.positionList().get(this.targetIndex)).getMiddle()).stream().forEach(partIndex -> {
                    ShootingType shootingType = (ShootingType)((Object)((Object)((Triple)this.pattern.positionList().get(this.targetIndex)).getLeft()));
                    FairkeeperBorosPartEntity part = this.partList.get((int)partIndex);
                    if (shootingType == ShootingType.BOTH || shootingType == ShootingType.LEFT) {
                        this.spawnRedstoneTrail(part, 90.0f, 0.0, 0.0);
                    }
                    if (shootingType == ShootingType.BOTH || shootingType == ShootingType.RIGHT) {
                        this.spawnRedstoneTrail(part, -90.0f, 0.0, 0.0);
                    }
                    if (shootingType == ShootingType.TRIPLE_BOTH || shootingType == ShootingType.TRIPLE_LEFT) {
                        this.spawnRedstoneTrail(part, 90.0f, -1.5, 0.0);
                        this.spawnRedstoneTrail(part, 90.0f, 0.0, 0.0);
                        this.spawnRedstoneTrail(part, 90.0f, 1.5, 0.0);
                    }
                    if (shootingType == ShootingType.TRIPLE_BOTH || shootingType == ShootingType.TRIPLE_RIGHT) {
                        this.spawnRedstoneTrail(part, -90.0f, -1.5, 0.0);
                        this.spawnRedstoneTrail(part, -90.0f, 0.0, 0.0);
                        this.spawnRedstoneTrail(part, -90.0f, 1.5, 0.0);
                    }
                    if (this.playSoundForPart % 3 == 0) {
                        this.boros.playBeamSound(part.method_23317(), part.method_23318(), part.method_23321(), 3.0f);
                    }
                    ++this.playSoundForPart;
                });
            }
            if (this.stoppingTick == FairkeeperBorosShootArrowGoal.method_38848((int)15)) {
                this.playSoundForPart = 0;
                ((List)((Triple)this.pattern.positionList().get(this.targetIndex)).getMiddle()).stream().forEach(partIndex -> {
                    ShootingType shootingType = (ShootingType)((Object)((Object)((Triple)this.pattern.positionList().get(this.targetIndex)).getLeft()));
                    FairkeeperBorosPartEntity part = this.partList.get((int)partIndex);
                    if (shootingType == ShootingType.BOTH || shootingType == ShootingType.LEFT) {
                        this.shootArrow(part, 90.0f, 0.0, 0.0);
                    }
                    if (shootingType == ShootingType.BOTH || shootingType == ShootingType.RIGHT) {
                        this.shootArrow(part, -90.0f, 0.0, 0.0);
                    }
                    if (shootingType == ShootingType.TRIPLE_BOTH || shootingType == ShootingType.TRIPLE_LEFT) {
                        this.shootArrow(part, 90.0f, -1.5, 0.0);
                        this.shootArrow(part, 90.0f, 0.0, 0.0);
                        this.shootArrow(part, 90.0f, 1.5, 0.0);
                    }
                    if (shootingType == ShootingType.TRIPLE_BOTH || shootingType == ShootingType.TRIPLE_RIGHT) {
                        this.shootArrow(part, -90.0f, -1.5, 0.0);
                        this.shootArrow(part, -90.0f, 0.0, 0.0);
                        this.shootArrow(part, -90.0f, 1.5, 0.0);
                    }
                    if (this.playSoundForPart % 3 == 0) {
                        this.boros.playArrowSound(part.method_23317(), part.method_23318(), part.method_23321(), 3.0f);
                    }
                    ++this.playSoundForPart;
                });
            }
            if (this.stoppingTick <= 0) {
                ++this.targetIndex;
                if (this.targetIndex >= this.pattern.positionList().size()) {
                    this.stopGoal();
                    return;
                }
                double difference = ((class_243)((Triple)this.pattern.positionList().get(this.targetIndex)).getRight()).method_1027() - ((class_243)((Triple)this.pattern.positionList.get(this.targetIndex - 1)).getRight()).method_1027();
                if (difference * difference < 1.0E-7) {
                    this.stoppingTick = FairkeeperBorosShootArrowGoal.method_38848((int)32);
                    return;
                }
            } else {
                return;
            }
        }
        float ratio = this.pattern.ratio();
        class_243 relativeTarget = (class_243)((Triple)this.pattern.positionList().get(this.targetIndex)).getRight();
        double targetX = (double)((float)this.arenaCenter.method_10263() + 0.5f) + relativeTarget.field_1352 * (double)this.arenaSize * (double)ratio;
        double targetZ = (double)((float)this.arenaCenter.method_10260() + 0.5f) + relativeTarget.field_1350 * (double)this.arenaSize * (double)ratio;
        class_2338 targetBlockPos = class_2338.method_49637((double)targetX, (double)this.boros.method_23318(), (double)targetZ);
        double distanceSq = this.boros.method_19538().method_1028((double)targetBlockPos.method_10263(), (double)targetBlockPos.method_10264(), (double)targetBlockPos.method_10260());
        if (distanceSq < 1.5) {
            if (((List)((Triple)this.pattern.positionList.get(this.targetIndex)).getMiddle()).isEmpty()) {
                ++this.targetIndex;
            } else {
                this.stoppingTick = FairkeeperBorosShootArrowGoal.method_38848((int)32);
                return;
            }
        }
        this.boros.method_5962().method_6239((double)targetBlockPos.method_10263(), (double)targetBlockPos.method_10264(), (double)targetBlockPos.method_10260(), this.speed);
    }

    private void shootArrow(FairkeeperBorosPartEntity partEntity, float angleOffset, double rxOffset, double rzOffset) {
        double viewDistance = 2.0;
        float borosFacingYaw = partEntity.method_36454();
        double finalAngle = Math.toRadians(borosFacingYaw - angleOffset);
        double cosFinal = Math.cos(finalAngle);
        double sinFinal = Math.sin(finalAngle);
        class_243 shootDirection = new class_243(-sinFinal, 0.0, cosFinal).method_1029();
        double rotatedRxOffset = rxOffset * cosFinal - rzOffset * sinFinal;
        double rotatedRzOffset = rxOffset * sinFinal + rzOffset * cosFinal;
        class_243 startPos = new class_243(partEntity.method_23317() + rotatedRxOffset, partEntity.method_23318() + partEntity.method_5829().method_17940() * (double)0.3f, partEntity.method_23321() + rotatedRzOffset);
        class_243 arrowPos = startPos.method_1019(shootDirection.method_1021(viewDistance));
        BorusArrowEntity arrow = new BorusArrowEntity((class_1309)this.boros, this.boros.method_37908());
        arrow.method_33574(arrowPos);
        arrow.method_24919((class_1297)partEntity, partEntity.method_36455(), borosFacingYaw - angleOffset, 0.0f, 2.0f, 1.0f);
        this.boros.method_37908().method_8649((class_1297)arrow);
    }

    private void spawnRedstoneTrail(FairkeeperBorosPartEntity partEntity, float angleOffset, double rxOffset, double rzOffset) {
        double viewDistance = 2.0;
        float borosFacingYaw = partEntity.method_36454();
        double finalAngle = Math.toRadians(borosFacingYaw - angleOffset);
        double cosFinal = Math.cos(finalAngle);
        double sinFinal = Math.sin(finalAngle);
        class_243 beamDirection = new class_243(-sinFinal, 0.0, cosFinal).method_1029();
        double rotatedRxOffset = rxOffset * cosFinal - rzOffset * sinFinal;
        double rotatedRzOffset = rxOffset * sinFinal + rzOffset * cosFinal;
        class_243 startPos = new class_243(partEntity.method_23317() + rotatedRxOffset, partEntity.method_23318() + partEntity.method_5829().method_17940() * (double)0.3f, partEntity.method_23321() + rotatedRzOffset).method_1019(beamDirection.method_1021(viewDistance));
        for (int i = 0; i <= 30; ++i) {
            class_243 particlePos = startPos.method_1019(beamDirection.method_1021((double)i));
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.ARROW_HAZARD_INDICATOR.get(), 0.5f);
            ((class_3218)partEntity.method_37908()).method_14199((class_2394)particleData, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void rotatePatternToClosest() {
        ImmutableList<Triple<ShootingType, List<Integer>, class_243>> originalList = this.pattern.positionList();
        class_243 firstVector = (class_243)((Triple)originalList.get(0)).getRight();
        double minDistance = Double.MAX_VALUE;
        int bestRotation = 0;
        class_243 borosPos = this.boros.method_19538();
        for (int angle : List.of(Integer.valueOf(0), Integer.valueOf(90), Integer.valueOf(180), Integer.valueOf(270))) {
            class_243 rotatedVector = this.rotateVector(firstVector, angle);
            class_243 absolutePos = new class_243((double)this.arenaCenter.method_10263() + rotatedVector.field_1352 * (double)this.arenaSize * (double)this.pattern.ratio(), this.boros.method_23318(), (double)this.arenaCenter.method_10260() + rotatedVector.field_1350 * (double)this.arenaSize * (double)this.pattern.ratio());
            double distance = borosPos.method_1025(absolutePos);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            bestRotation = angle;
        }
        ArrayList<Triple> rotatedList = new ArrayList<Triple>();
        for (Triple entry : originalList) {
            class_243 rotatedVec = this.rotateVector((class_243)entry.getRight(), bestRotation);
            rotatedList.add(Triple.of((Object)((Object)((ShootingType)((Object)entry.getLeft()))), (Object)((List)entry.getMiddle()), (Object)rotatedVec));
        }
        this.pattern = new ShootingPattern(this.pattern.shiftStartingPoint(), this.pattern.ratio(), (ImmutableList<Triple<ShootingType, List<Integer>, class_243>>)ImmutableList.copyOf(rotatedList));
    }

    private class_243 rotateVector(class_243 vector, int degrees) {
        double radians = Math.toRadians(degrees);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double newX = vector.field_1352 * cos - vector.field_1350 * sin;
        double newZ = vector.field_1352 * sin + vector.field_1350 * cos;
        return new class_243(newX, vector.field_1351, newZ);
    }

    private record ShootingPattern(boolean shiftStartingPoint, float ratio, ImmutableList<Triple<ShootingType, List<Integer>, class_243>> positionList) {
    }

    private static enum ShootingType {
        NONE,
        LEFT,
        RIGHT,
        BOTH,
        TRIPLE_LEFT,
        TRIPLE_RIGHT,
        TRIPLE_BOTH;

    }
}

