/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.boss;

import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexDomainProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexOrbProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.Boss;
import dev.hexnowloading.dungeonnowloading.entity.util.SlumberingEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLMobEffects;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1665;
import net.minecraft.class_1810;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8111;

public class FairkeeperBorosPartEntity
extends class_1588
implements Boss,
class_1569,
SlumberingEntity,
FairkeeperSerpentEntity {
    private static final class_2940<Optional<UUID>> PARENT_UUID = class_2945.method_12791(FairkeeperBorosPartEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Optional<UUID>> CHILD_UUID = class_2945.method_12791(FairkeeperBorosPartEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Optional<UUID>> HEAD_UUID = class_2945.method_12791(FairkeeperBorosPartEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Integer> BODY_INDEX = class_2945.method_12791(FairkeeperBorosPartEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> ARMOR = class_2945.method_12791(FairkeeperBorosPartEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> TAIL = class_2945.method_12791(FairkeeperBorosPartEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HEAD_MOVING = class_2945.method_12791(FairkeeperBorosPartEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> MODEL_VISIBLE = class_2945.method_12791(FairkeeperBorosPartEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> ROTATABLE = class_2945.method_12791(FairkeeperBorosPartEntity.class, (class_2941)class_2943.field_13323);
    private float previousTilt = 0.0f;
    private boolean enableRotation = true;

    public FairkeeperBorosPartEntity(class_1299<? extends class_1588> entityType, class_1309 parent, class_1309 head, int bodyIndex) {
        super(entityType, parent.method_37908());
        this.setParent((class_1297)parent);
        this.setHead((class_1297)head);
        this.setBodyIndex(bodyIndex);
        this.setArmor(this.isArmoredSegment());
        this.setModelVisible(false);
        this.method_5971();
    }

    public FairkeeperBorosPartEntity(class_1299<? extends class_1588> entityType, class_1937 level) {
        super(entityType, level);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 50.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23721, 8.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(PARENT_UUID, Optional.empty());
        this.field_6011.method_12784(HEAD_UUID, Optional.empty());
        this.field_6011.method_12784(CHILD_UUID, Optional.empty());
        this.field_6011.method_12784(BODY_INDEX, (Object)0);
        this.field_6011.method_12784(TAIL, (Object)false);
        this.field_6011.method_12784(ARMOR, (Object)false);
        this.field_6011.method_12784(HEAD_MOVING, (Object)false);
        this.field_6011.method_12784(MODEL_VISIBLE, (Object)true);
        this.field_6011.method_12784(ROTATABLE, (Object)true);
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        if (this.getParentId() != null) {
            compoundTag.method_25927("ParentUUID", this.getParentId());
        }
        if (this.getChildId() != null) {
            compoundTag.method_25927("ChildUUID", this.getChildId());
        }
        if (this.getHeadId() != null) {
            compoundTag.method_25927("HeadUUID", this.getHeadId());
        }
        compoundTag.method_10556("TailPart", this.isTail());
        compoundTag.method_10569("BodyIndex", this.getBodyIndex());
        compoundTag.method_10556("Armor", this.hasArmor());
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        if (compoundTag.method_25928("ParentUUID")) {
            this.setParentId(compoundTag.method_25926("ParentUUID"));
        }
        if (compoundTag.method_25928("ChildUUID")) {
            this.setChildId(compoundTag.method_25926("ChildUUID"));
        }
        if (compoundTag.method_25928("HeadUUID")) {
            this.setHeadId(compoundTag.method_25926("HeadUUID"));
        }
        this.setTail(compoundTag.method_10577("TailPart"));
        this.setBodyIndex(compoundTag.method_10550("BodyIndex"));
        this.setArmor(compoundTag.method_10577("Armor"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_5773() {
        class_1297 parent = this.getParent();
        if (parent != null && !this.method_37908().field_9236) {
            this.method_5875(true);
            class_1297 class_12972 = this.getHead();
            if (class_12972 instanceof FairkeeperBorosEntity) {
                FairkeeperBorosEntity headEntity = (FairkeeperBorosEntity)class_12972;
                int historyIndex = (this.getBodyIndex() + 1) * FairkeeperBorosEntity.SEGMENT_DELAY_STEP;
                Queue<class_243> queue = headEntity.getPositionHistory();
                synchronized (queue) {
                    if (headEntity.getPositionHistory().size() > historyIndex) {
                        this.setModelVisible(true);
                        class_243 targetPos = headEntity.getSegmentTargetPosition(this.getBodyIndex() + 1);
                        this.method_5814(this.lerp(this.method_23317(), targetPos.field_1352, 0.5), this.lerp(this.method_23318(), targetPos.field_1351, 0.5), this.lerp(this.method_23321(), targetPos.field_1350, 0.5));
                        if (!this.isRotatable()) {
                            class_243 awakenEndPos = headEntity.getAwakenEndPos();
                            if (awakenEndPos == null) {
                                this.setRotatable(true);
                            } else {
                                double dy = awakenEndPos.field_1351 - this.method_23318();
                                if (dy * dy < 25.0) {
                                    this.setRotatable(true);
                                }
                            }
                        }
                        if (this.isRotatable() && this.isHeadEntityMoving()) {
                            this.alignRotation(this.method_19538(), targetPos);
                        }
                    }
                }
                this.setHeadEntityMoving(headEntity.method_18798().method_1027() > 0.01);
            }
        } else if (!this.method_37908().field_9236) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
        super.method_5773();
    }

    private double lerp(double start, double end, double factor) {
        return start + (end - start) * factor;
    }

    private void alignRotation(class_243 currentPos, class_243 targetPos) {
        double deltaX = targetPos.field_1352 - currentPos.field_1352;
        double deltaZ = targetPos.field_1350 - currentPos.field_1350;
        float yaw = (float)(Math.atan2(deltaZ, deltaX) * 57.29577951308232) - 90.0f;
        this.method_36456(yaw);
    }

    protected void method_5958() {
        if (this.isTail()) {
            // empty if block
        }
        if (this.isHeadEntityMoving()) {
            this.performContactDamage();
        }
        super.method_5958();
    }

    private void vertexTransmissionEffectImmunity() {
        this.method_6016(DNLMobEffects.VERTEX_TRANSMISSION.get());
    }

    private void setPathOnFire() {
        class_2338 blockPos = new class_2338(class_3532.method_15357((double)this.method_23317()), class_3532.method_15357((double)(this.method_23318() - 1.0)), class_3532.method_15357((double)this.method_23321()));
        if (this.method_37908().method_8320(blockPos.method_10084()).method_27852(class_2246.field_10124)) {
            this.method_37908().method_8652(blockPos.method_10084(), class_2246.field_10036.method_9564(), 3);
        }
    }

    private void performContactDamage() {
        this.method_37908().method_8333((class_1297)this, this.method_5829(), this::canPerformContactDamageTo).forEach(entity -> {
            entity.method_5697((class_1297)this);
            class_1309 head = (class_1309)this.getHead();
            if (head != null) {
                entity.method_5643(entity.method_37908().method_48963().method_48812(head), (float)(head.method_26825(class_5134.field_23721) * 0.5));
            }
        });
    }

    private boolean canPerformContactDamageTo(class_1297 entity) {
        if (entity instanceof FairkeeperBorosEntity) {
            FairkeeperBorosEntity head = (FairkeeperBorosEntity)entity;
            return !this.getHeadId().equals(head.method_5667());
        }
        if (entity instanceof FairkeeperBorosPartEntity) {
            FairkeeperBorosPartEntity part = (FairkeeperBorosPartEntity)entity;
            return !this.getHeadId().equals(part.getHeadId());
        }
        return !(entity instanceof VertexOrbProjectileEntity) && !(entity instanceof VertexDomainProjectileEntity);
    }

    public boolean method_5643(class_1282 damageSource, float damageAmount) {
        class_1309 livingEntity;
        class_1297 head2;
        if (damageSource.method_5529() instanceof FairkeeperSerpentEntity) {
            class_1297 class_12972 = damageSource.method_5526();
            if (class_12972 instanceof class_1665) {
                class_1665 arrow = (class_1665)class_12972;
                arrow.method_5650(class_1297.class_5529.field_26999);
            }
            return false;
        }
        if (!this.hasArmor() || damageSource.method_5530() || damageSource.method_48789(DNLTags.FAIRKEEPER_BOROS_BYPASS_ARMOR)) {
            FairkeeperBorosEntity head2;
            float damage = damageAmount;
            if (this.isTail()) {
                damage = damageAmount * 2.0f;
            }
            if ((head2 = (FairkeeperBorosEntity)this.getHead()) != null) {
                head2.setDamageFromOtherSegment(true);
                head2.method_5643(damageSource, damage);
            }
            return super.method_5643(damageSource, 0.0f);
        }
        if (damageSource.method_48789(DNLTags.FAIRKEEPER_BOROS_ARMOR_HURTABLE) || (head2 = damageSource.method_5526()) instanceof class_1309 && (livingEntity = (class_1309)head2).method_6047().method_7909() instanceof class_1810) {
            float nonKillableDamage;
            boolean doesKill = this.method_6032() - damageAmount <= 0.0f;
            float f = nonKillableDamage = doesKill ? 0.0f : damageAmount;
            if (doesKill) {
                this.setArmor(false);
                class_1937 class_19372 = this.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    serverLevel.method_14199((class_2394)class_2398.field_11236, this.method_23317(), this.method_23318(), this.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15152, class_3419.field_15251, 1.0f, 1.0f);
                return super.method_5643(damageSource, 0.0f);
            }
            this.method_37908().method_8396(null, this.method_24515(), DNLSounds.FAIRKEEPER_BOROS_ARMOR_BREAK.get(), class_3419.field_15251, 1.0f, 1.0f);
            return super.method_5643(damageSource, nonKillableDamage);
        }
        if (damageSource.method_49708(class_8111.field_42335) || damageSource.method_49708(class_8111.field_42337)) {
            return false;
        }
        this.method_37908().method_8396(null, this.method_24515(), DNLSounds.FAIRKEEPER_BOROS_ARMOR_HIT.get(), class_3419.field_15251, 1.0f, 1.0f);
        return false;
    }

    protected void method_6108() {
        ++this.field_6213;
    }

    public boolean method_6049(class_1293 mobEffectInstance) {
        class_1291 effect = mobEffectInstance.method_5579();
        if (effect == class_1294.field_5899 || effect == DNLMobEffects.VERTEX_TRANSMISSION.get()) {
            return false;
        }
        return super.method_6049(mobEffectInstance);
    }

    public boolean method_5757() {
        return false;
    }

    public void method_5697(class_1297 entity) {
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    protected boolean method_5876() {
        return false;
    }

    protected void method_5623(double $$0, boolean $$1, class_2680 $$2, class_2338 $$3) {
    }

    protected int method_23329(float $$0, float $$1) {
        return 0;
    }

    public boolean method_5747(float v, float v1, class_1282 damageSource) {
        return false;
    }

    @Override
    public void resetBoss() {
    }

    @Override
    public boolean resetCondition() {
        return false;
    }

    @Override
    public class_2338 resetRegionCenter() {
        return null;
    }

    @Override
    public boolean isSlumbering() {
        return false;
    }

    @Override
    public boolean isStationary() {
        return false;
    }

    public class_1297 getHead() {
        UUID id = this.getHeadId();
        if (id != null && !this.method_37908().field_9236) {
            return ((class_3218)this.method_37908()).method_14190(id);
        }
        return null;
    }

    public void setHead(class_1297 entity) {
        this.setHeadId(entity.method_5667());
    }

    public UUID getHeadId() {
        return ((Optional)this.field_6011.method_12789(HEAD_UUID)).orElse(null);
    }

    public void setHeadId(@Nullable UUID uniqueId) {
        this.field_6011.method_12778(HEAD_UUID, Optional.ofNullable(uniqueId));
    }

    public int getBodyIndex() {
        return (Integer)this.field_6011.method_12789(BODY_INDEX);
    }

    public void setBodyIndex(int index) {
        this.field_6011.method_12778(BODY_INDEX, (Object)index);
    }

    @Nullable
    public UUID getParentId() {
        return ((Optional)this.field_6011.method_12789(PARENT_UUID)).orElse(null);
    }

    public void setParentId(@Nullable UUID uniqueId) {
        this.field_6011.method_12778(PARENT_UUID, Optional.ofNullable(uniqueId));
    }

    public void setParent(class_1297 entity) {
        this.setParentId(entity.method_5667());
    }

    public class_1297 getParent() {
        UUID id = this.getParentId();
        if (id != null && !this.method_37908().field_9236) {
            return ((class_3218)this.method_37908()).method_14190(id);
        }
        return null;
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.field_6011.method_12789(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.field_6011.method_12778(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public void setChild(class_1297 entity) {
        this.setChildId(entity.method_5667());
    }

    public class_1297 getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.method_37908().field_9236) {
            return ((class_3218)this.method_37908()).method_14190(id);
        }
        return null;
    }

    public float getPreviousTilt() {
        return this.previousTilt;
    }

    public void setPreviousTilt(float tilt) {
        this.previousTilt = tilt;
    }

    public boolean isHeadEntityMoving() {
        return (Boolean)this.field_6011.method_12789(HEAD_MOVING);
    }

    public void setHeadEntityMoving(boolean moving) {
        this.field_6011.method_12778(HEAD_MOVING, (Object)moving);
    }

    public boolean isModelVisible() {
        return (Boolean)this.field_6011.method_12789(MODEL_VISIBLE);
    }

    public void setModelVisible(boolean moving) {
        this.field_6011.method_12778(MODEL_VISIBLE, (Object)moving);
    }

    public boolean isArmoredSegment() {
        return true;
    }

    public boolean hasArmor() {
        return (Boolean)this.field_6011.method_12789(ARMOR);
    }

    public void setArmor(boolean armor) {
        this.field_6011.method_12778(ARMOR, (Object)armor);
    }

    public boolean isTail() {
        return (Boolean)this.field_6011.method_12789(TAIL);
    }

    public void setTail(boolean tail) {
        this.field_6011.method_12778(TAIL, (Object)tail);
    }

    public void setRotatable(boolean enableRotation) {
        this.field_6011.method_12778(ROTATABLE, (Object)enableRotation);
    }

    public boolean isRotatable() {
        return (Boolean)this.field_6011.method_12789(ROTATABLE);
    }
}

