/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.boss;

import com.google.common.collect.ImmutableList;
import dev.hexnowloading.dungeonnowloading.block.entity.PreserverBlockEntity;
import dev.hexnowloading.dungeonnowloading.block.entity.VertexPillarBlockEntity;
import dev.hexnowloading.dungeonnowloading.config.BossConfig;
import dev.hexnowloading.dungeonnowloading.entity.ai.BossTargetSelectorGoal;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperOurosEntity;
import dev.hexnowloading.dungeonnowloading.entity.misc.SpecialItemEntity;
import dev.hexnowloading.dungeonnowloading.entity.monster.ScuttleEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityScale;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.entity.util.ExhaustionTracker;
import dev.hexnowloading.dungeonnowloading.entity.util.SpawnMobUtil;
import dev.hexnowloading.dungeonnowloading.entity.util.WeightBaseMoveSet;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CFadeInTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CFadeOutBackgroundMusicSoundPacket;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStartTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStopTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.platform.Services;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.sound.TickingSoundTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_4076;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_7094;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class FairkeeperSerpentCallerEntity
extends class_1297 {
    private static final class_2940<FairkeeperSerpentCallerAnimationState> ANIMATION_STATE = class_2945.method_12791(FairkeeperSerpentCallerEntity.class, EntityStates.FAIRKEEPER_SERPENT_CALLER_ANIMATION_STATE);
    private static final class_2940<Boolean> ACTIVATED = class_2945.method_12791(FairkeeperSerpentCallerEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Optional<UUID>> BOROS_UUID = class_2945.method_12791(FairkeeperSerpentCallerEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Optional<UUID>> OUROS_UUID = class_2945.method_12791(FairkeeperSerpentCallerEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Integer> HORIZONTAL_OFFSET = class_2945.method_12791(FairkeeperSerpentCallerEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> VERTICAL_OFFSET = class_2945.method_12791(FairkeeperSerpentCallerEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> PHASE = class_2945.method_12791(FairkeeperSerpentCallerEntity.class, (class_2941)class_2943.field_13327);
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 activeAnimationState = new class_7094();
    private static final int SPAWN_OFFSET_X = 20;
    private static final int SPAWN_OFFSET_Y = 15;
    private final int BEHIND_BLOCK_SPAWN_OFFSET = 5;
    private final int ARENA_SIZE = 36;
    private final int MAX_SCUTTLE_COUNT = 6;
    private class_1282 lastDamageSource;
    private FairkeeperBorosEntity boros;
    private FairkeeperOurosEntity ouros;
    private boolean hasAddedDesperateMove;
    private boolean burrowing;
    private boolean borosWaitingForCommand;
    private boolean ourosWaitingForCommand;
    private int isBorosDefeated;
    private int isOurosDefeated;
    private UUID pendingBorosUUID;
    private UUID pendingOurosUUID;
    private int activationTick;
    private int musicTick;
    private Set<UUID> playerUUIDs;
    private Set<UUID> minionUUIDs;
    private WeightBaseMoveSet<Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>> introMoveSet = new WeightBaseMoveSet();
    private WeightBaseMoveSet<Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>> comboMoveSet = new WeightBaseMoveSet();
    private WeightBaseMoveSet<Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>> directMoveSet = new WeightBaseMoveSet();
    private WeightBaseMoveSet<FairkeeperOurosEntity.FairkeeperOurosState> ourosMoveSet = new WeightBaseMoveSet();
    private WeightBaseMoveSet<FairkeeperOurosEntity.FairkeeperOurosState> ourosPillarMoveSet = new WeightBaseMoveSet();
    private WeightBaseMoveSet<FairkeeperBorosEntity.FairkeeperBorosState> borosMoveSet = new WeightBaseMoveSet();
    private WeightBaseMoveSet<FairkeeperBorosEntity.FairkeeperBorosState> borosArrowMoveSet = new WeightBaseMoveSet();
    private WeightBaseMoveSet<FairkeeperBorosEntity.FairkeeperBorosState> borosPursueMoveSet = new WeightBaseMoveSet();
    private ExhaustionTracker ourosExhaustion = new ExhaustionTracker(10.0f);
    private ExhaustionTracker borosExhaustion = new ExhaustionTracker(10.0f);
    private static final Map<FairkeeperOurosEntity.FairkeeperOurosState, Float> OUROS_EXHAUSTION_MAP = Map.of(FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_SCUTTLE, Float.valueOf(2.0f), FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_MORE_SCUTTLES, Float.valueOf(2.0f), FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_SINGLE_VERTEX_ORB, Float.valueOf(1.0f), FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_TRIPLE_VERTEX_ORB, Float.valueOf(2.0f), FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_VERTEX_DOMAIN, Float.valueOf(5.0f), FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_LINE_CENTER, Float.valueOf(2.0f), FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_LINE_INNER, Float.valueOf(2.0f), FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_LINE_OUTER, Float.valueOf(2.0f), FairkeeperOurosEntity.FairkeeperOurosState.DESPERATE, Float.valueOf(8.0f));
    private static final Map<FairkeeperBorosEntity.FairkeeperBorosState, Float> BOROS_EXHAUSTION_MAP = Map.of(FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_LINE_FAST, Float.valueOf(2.0f), FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_SMALL_CIRCLE, Float.valueOf(2.0f), FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_LARGE_CIRCLE, Float.valueOf(2.0f), FairkeeperBorosEntity.FairkeeperBorosState.TACKLE, Float.valueOf(2.0f), FairkeeperBorosEntity.FairkeeperBorosState.TACKLE_FAST, Float.valueOf(2.0f), FairkeeperBorosEntity.FairkeeperBorosState.FLAME_TACKLE, Float.valueOf(4.0f), FairkeeperBorosEntity.FairkeeperBorosState.PURSUE_AND_SHOOT_TRIPLE_ARROW, Float.valueOf(2.0f), FairkeeperBorosEntity.FairkeeperBorosState.DESPERATE, Float.valueOf(8.0f));
    private static final ImmutableList<FairkeeperBorosEntity.FairkeeperBorosState> BOROS_WAITING_STATES = ImmutableList.of((Object)((Object)FairkeeperBorosEntity.FairkeeperBorosState.IDLE));
    private static final ImmutableList<FairkeeperOurosEntity.FairkeeperOurosState> OUROS_WAITING_STATES = ImmutableList.of((Object)((Object)FairkeeperOurosEntity.FairkeeperOurosState.IDLE));

    public FairkeeperSerpentCallerEntity(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
        this.playerUUIDs = new HashSet<UUID>();
        this.minionUUIDs = new HashSet<UUID>();
    }

    protected void method_5693() {
        this.field_6011.method_12784(ANIMATION_STATE, (Object)FairkeeperSerpentCallerAnimationState.NONE);
        this.field_6011.method_12784(ACTIVATED, (Object)false);
        this.field_6011.method_12784(BOROS_UUID, Optional.empty());
        this.field_6011.method_12784(OUROS_UUID, Optional.empty());
        this.field_6011.method_12784(HORIZONTAL_OFFSET, (Object)0);
        this.field_6011.method_12784(VERTICAL_OFFSET, (Object)0);
        this.field_6011.method_12784(PHASE, (Object)0);
    }

    protected void method_5652(class_2487 compoundTag) {
        compoundTag.method_10556("Activated", this.isActivated());
        if (this.getBorosId() != null) {
            compoundTag.method_25927("BorosUUID", this.getBorosId());
        }
        if (this.getOurosId() != null) {
            compoundTag.method_25927("OurosUUID", this.getOurosId());
        }
        compoundTag.method_10569("IsBorosDefeated", this.isBorosDefeated);
        compoundTag.method_10569("IsOurosDefeated", this.isOurosDefeated);
        compoundTag.method_10569("HorizontalOffset", this.getHorizontalOffset());
        compoundTag.method_10569("VerticalOffset", this.getVerticalOffset());
        compoundTag.method_10569("Phase", this.getPhase());
        class_2499 listTag = new class_2499();
        class_2487 uuidCompoundTag = new class_2487();
        Iterator<UUID> var = this.playerUUIDs.iterator();
        int i = 0;
        while (var.hasNext()) {
            listTag.add((Object)uuidCompoundTag);
            uuidCompoundTag.method_25927("PlayerUUID" + i, var.next());
            ++i;
        }
        compoundTag.method_10566("PlayerUUIDs", (class_2520)listTag);
    }

    protected void method_5749(class_2487 compoundTag) {
        this.field_6011.method_12778(ACTIVATED, (Object)compoundTag.method_10577("Activated"));
        if (compoundTag.method_25928("BorosUUID")) {
            this.setBorosId(compoundTag.method_25926("BorosUUID"));
            this.pendingBorosUUID = this.getBorosId();
        }
        if (compoundTag.method_25928("OurosUUID")) {
            this.setOurosId(compoundTag.method_25926("OurosUUID"));
            this.pendingOurosUUID = this.getOurosId();
        }
        this.isOurosDefeated = compoundTag.method_10550("IsOurosDefeated");
        this.isBorosDefeated = compoundTag.method_10550("IsBorosDefeated");
        this.field_6011.method_12778(HORIZONTAL_OFFSET, (Object)compoundTag.method_10550("HorizontalOffset"));
        this.field_6011.method_12778(VERTICAL_OFFSET, (Object)compoundTag.method_10550("VerticalOffset"));
        this.field_6011.method_12778(PHASE, (Object)compoundTag.method_10550("Phase"));
        if (compoundTag.method_10573("PlayerUUIDs", 9)) {
            class_2499 listTag = compoundTag.method_10554("PlayerUUIDs", 10);
            for (int a = 0; a < listTag.size(); ++a) {
                class_2487 compoundTag1 = listTag.method_10602(a);
                this.playerUUIDs.add(compoundTag1.method_25926("PlayerUUID" + a));
            }
        }
    }

    public void startBossFight() {
        this.activationTick = 60;
        this.isBorosDefeated = 0;
        this.isOurosDefeated = 0;
        this.ourosExhaustion.resetExhaustion();
        this.borosExhaustion.resetExhaustion();
        this.method_5783(DNLSounds.FAIRKEEPER_SERPENT_CALLER_ACTIVATED.get(), 3.0f, 1.0f);
        this.playBossMusic();
        this.method_5783(DNLSounds.FAIRKEEPERS_INTRO.get(), 3.0f, 1.0f);
        this.clearAllMoveSet();
        this.setActivated(true);
        this.setOffsets(20, 15);
        this.transitionTo(FairkeeperSerpentCallerAnimationState.ACTIVE);
        class_238 bossArena = new class_238(this.method_24515()).method_1014(36.0);
        List players = this.method_37908().method_18467(class_3222.class, bossArena);
        for (class_3222 p : players) {
            this.playerUUIDs.add(p.method_5667());
        }
    }

    public void method_5773() {
        class_1297 entity;
        super.method_5773();
        if (this.isBorosDefeated <= 0 && this.boros == null && this.pendingBorosUUID != null && (entity = ((class_3218)this.method_37908()).method_14190(this.pendingBorosUUID)) instanceof FairkeeperBorosEntity) {
            FairkeeperBorosEntity borosEntity;
            this.boros = borosEntity = (FairkeeperBorosEntity)entity;
            this.pendingBorosUUID = null;
        }
        if (this.isOurosDefeated <= 0 && this.ouros == null && this.pendingOurosUUID != null && (entity = ((class_3218)this.method_37908()).method_14190(this.pendingOurosUUID)) instanceof FairkeeperOurosEntity) {
            FairkeeperOurosEntity ourosEntity;
            this.ouros = ourosEntity = (FairkeeperOurosEntity)entity;
            this.pendingOurosUUID = null;
        }
        if (!this.method_37908().field_9236 && this.field_6011.method_12789(ANIMATION_STATE) == FairkeeperSerpentCallerAnimationState.NONE) {
            this.transitionTo(FairkeeperSerpentCallerAnimationState.IDLE);
        }
        if (this.isActivated() && !this.method_37908().field_9236) {
            ++this.musicTick;
            if (this.musicTick >= 3242) {
                this.musicTick = 0;
                this.playLoopMusic();
            }
            switch (this.getPhase()) {
                case 0: {
                    if (this.activationTick > 0) {
                        --this.activationTick;
                        break;
                    }
                    this.summonBosses();
                    this.setPhase(1);
                    this.burrowing = true;
                    this.spawnEmergingParticles();
                    break;
                }
                case 1: {
                    if (this.burrowing) {
                        this.spawnBurrowingParticles();
                    }
                    if (this.isBorosWaitingForCommand() && this.isOurosWaitingForCommand()) {
                        this.introMoveSet();
                        this.burrowing = false;
                    }
                    if (this.activationTick > 0) {
                        --this.activationTick;
                        break;
                    }
                    if (this.getHealthRatio() < 0.75f) {
                        this.setPhase(2);
                        this.clearAllMoveSet();
                        break;
                    }
                    if (this.isAllPlayersInBound()) {
                        this.activationTick = 10;
                        break;
                    }
                    this.resetBosses();
                    break;
                }
                case 2: {
                    if (this.isBorosWaitingForCommand()) {
                        this.commandBorosPhase2();
                    }
                    if (this.isOurosWaitingForCommand()) {
                        this.commandOurosPhase2();
                    }
                    if (this.activationTick > 0) {
                        --this.activationTick;
                        break;
                    }
                    if (this.isOurosDefeated > 2 || this.isBorosDefeated > 2) {
                        if (this.isBorosDefeated > 2) {
                            this.fadeInOurosMusic();
                        } else {
                            this.fadeInBorosMusic();
                        }
                        this.setPhase(3);
                        this.clearAllMoveSet();
                        break;
                    }
                    if (this.isAllPlayersInBound()) {
                        this.activationTick = 10;
                        break;
                    }
                    this.resetBosses();
                    break;
                }
                case 3: {
                    if (this.isBorosWaitingForCommand()) {
                        this.commandBorosPhase2();
                    }
                    if (this.isOurosWaitingForCommand()) {
                        this.commandOurosPhase2();
                    }
                    if (this.activationTick > 0) {
                        --this.activationTick;
                        break;
                    }
                    if (this.isBorosDefeated > 2 && this.isOurosDefeated > 2) {
                        this.defeatedBosses();
                        this.setPhase(4);
                        break;
                    }
                    if (this.isAllPlayersInBound()) {
                        this.activationTick = 10;
                        break;
                    }
                    this.resetBosses();
                    break;
                }
            }
        }
    }

    private float getHealthRatio() {
        if (this.boros == null || this.ouros == null) {
            return 0.0f;
        }
        return (float)((double)(this.ouros.method_6032() + this.boros.method_6032()) / (this.ouros.method_26825(class_5134.field_23716) + this.boros.method_26825(class_5134.field_23716)));
    }

    private void introMoveSet() {
        BossTargetSelectorGoal.changeTarget(this.boros);
        BossTargetSelectorGoal.changeTarget(this.ouros);
        if (this.boros.method_5968() == null && this.ouros.method_5968() == null) {
            return;
        }
        if (this.introMoveSet.isEmpty()) {
            this.introMoveSet.addMove((Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>)new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.IDLE, (Object)FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_SCUTTLE), 1, 2, 2);
            this.introMoveSet.addMove((Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>)new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.IDLE, (Object)FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_SINGLE_VERTEX_ORB), 1, 0, 0);
            this.introMoveSet.addMove((Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>)new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.IDLE, (Object)FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_RANDOM), 1, 2, 0);
            this.introMoveSet.addMove((Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>)new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_LINE, (Object)FairkeeperOurosEntity.FairkeeperOurosState.IDLE), 1, 2, 1);
            this.introMoveSet.addMove((Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>)new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.TACKLE, (Object)FairkeeperOurosEntity.FairkeeperOurosState.IDLE), 1, 2, 0);
            this.introMoveSet.addMove((Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>)new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.PURSUE_AND_SHOOT_SINGLE_ARROW, (Object)FairkeeperOurosEntity.FairkeeperOurosState.IDLE), 1, 1, 0);
        }
        if (this.directMoveSet.isEmpty()) {
            this.directMoveSet.addMove((Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>)new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.IDLE, (Object)FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_SINGLE_VERTEX_ORB), 1, 0, 0);
            this.directMoveSet.addMove((Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>)new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_ABOVE, (Object)FairkeeperOurosEntity.FairkeeperOurosState.IDLE), 1, 0, 0);
        }
        if (this.ourosPillarMoveSet.isEmpty()) {
            this.ourosPillarMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_LINE_OUTER, 1, 0, 0);
            this.ourosPillarMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_LINE_CENTER, 1, 0, 1);
        }
        this.ourosBorosAssignState();
    }

    private void commandBorosPhase2() {
        BossTargetSelectorGoal.changeTarget(this.boros);
        if (this.boros.method_5968() == null) {
            return;
        }
        if (this.borosMoveSet.isEmpty()) {
            this.borosMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_RANDOM, 1, 0, 1);
            this.borosMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.PURSUE_RANDOM, 2, 0, 0);
        }
        if (this.borosArrowMoveSet.isEmpty()) {
            this.borosArrowMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_LINE_FAST, 1, 1, 2);
            this.borosArrowMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_SMALL_CIRCLE, 1, 1, 0);
            this.borosArrowMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_LARGE_CIRCLE, 1, 1, 0);
        }
        if (this.borosPursueMoveSet.isEmpty()) {
            this.borosPursueMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.TACKLE, 3, 1, 1);
            this.borosPursueMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.FLAME_TACKLE, 2, 1, 0);
            this.borosPursueMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.PURSUE_AND_SHOOT_TRIPLE_ARROW, 3, 0, 1);
        }
        this.borosAssignState();
    }

    private void commandOurosPhase2() {
        BossTargetSelectorGoal.changeTarget(this.ouros);
        if (this.ouros.method_5968() == null) {
            return;
        }
        if (this.ourosMoveSet.isEmpty()) {
            this.ourosMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_SCUTTLE, 3, 2, 3);
            this.ourosMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_SINGLE_VERTEX_ORB, 1, 0, 3);
            this.ourosMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_TRIPLE_VERTEX_ORB, 3, 2, 2);
            this.ourosMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_VERTEX_DOMAIN, 6, 4, 1);
            this.ourosMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_RANDOM, 3, 0);
        }
        if (this.ourosPillarMoveSet.isEmpty()) {
            this.ourosPillarMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_LINE_CENTER, 1, 1, 0);
            this.ourosPillarMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_LINE_INNER, 1, 1, 1);
            this.ourosPillarMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_LINE_OUTER, 1, 1, 0);
        }
        this.ourosAssignState();
    }

    private void ourosBorosAssignState() {
        this.cleanMinionList();
        Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState> statePair = this.isAboveBoros() ? this.directMoveSet.selectMove() : this.introMoveSet.selectMove();
        if (((FairkeeperOurosEntity.FairkeeperOurosState)((Object)statePair.getB())).equals((Object)FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_RANDOM)) {
            statePair = new Pair<FairkeeperBorosEntity.FairkeeperBorosState, FairkeeperOurosEntity.FairkeeperOurosState>((Object)((FairkeeperBorosEntity.FairkeeperBorosState)((Object)statePair.getA())), (Object)this.ourosPillarMoveSet.selectMove());
        }
        if (((FairkeeperOurosEntity.FairkeeperOurosState)((Object)statePair.getB())).equals((Object)FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_SCUTTLE)) {
            class_3218 serverLevel = (class_3218)this.method_37908();
            long scuttleCount = this.minionUUIDs.stream().map(arg_0 -> ((class_3218)serverLevel).method_14190(arg_0)).filter(entity -> entity instanceof ScuttleEntity).count();
            if (scuttleCount > 6L) {
                statePair = this.introMoveSet.selectMoveWithoutCooldownReduction();
            }
        }
        if (this.boros.method_5968() == null) {
            statePair = new Pair((Object)FairkeeperBorosEntity.FairkeeperBorosState.IDLE, (Object)((FairkeeperOurosEntity.FairkeeperOurosState)((Object)statePair.getB())));
        } else if (this.ouros.method_5968() == null) {
            statePair = new Pair((Object)((FairkeeperBorosEntity.FairkeeperBorosState)((Object)statePair.getA())), (Object)FairkeeperOurosEntity.FairkeeperOurosState.IDLE);
        }
        class_1297 boros = this.getBoros();
        class_1297 ouros = this.getOuros();
        boolean isBorosWaiting = false;
        boolean isOurosWaiting = false;
        if (boros != null && ouros != null) {
            ((FairkeeperBorosEntity)boros).setState((FairkeeperBorosEntity.FairkeeperBorosState)((Object)statePair.getA()));
            ((FairkeeperOurosEntity)ouros).setState((FairkeeperOurosEntity.FairkeeperOurosState)((Object)statePair.getB()));
            if (BOROS_WAITING_STATES.contains(statePair.getA())) {
                isBorosWaiting = true;
            }
            if (OUROS_WAITING_STATES.contains(statePair.getB())) {
                isOurosWaiting = true;
            }
        }
        this.setBorosWaitingForCommand(isBorosWaiting);
        this.setOurosWaitingForCommand(isOurosWaiting);
    }

    private void borosAssignState() {
        class_1297 boros;
        if (this.boros == null) {
            return;
        }
        this.cleanMinionList();
        float exhaustionPercent = this.borosExhaustion.getExhaustionPercent();
        float random = this.field_5974.method_43057();
        FairkeeperBorosEntity.FairkeeperBorosState state = this.isAboveBoros() ? FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_ABOVE : (exhaustionPercent > 0.5f && exhaustionPercent > random ? FairkeeperBorosEntity.FairkeeperBorosState.EXHAUSTED : this.borosMoveSet.selectMove());
        if (state == null) {
            state = FairkeeperBorosEntity.FairkeeperBorosState.IDLE;
        }
        if (state.equals((Object)FairkeeperBorosEntity.FairkeeperBorosState.SHOOT_ARROW_RANDOM)) {
            state = this.borosArrowMoveSet.selectMove();
        }
        if (state.equals((Object)FairkeeperBorosEntity.FairkeeperBorosState.PURSUE_RANDOM)) {
            state = this.borosPursueMoveSet.selectMove();
        }
        if (this.getPhase() > 2 && !this.hasAddedDesperateMove) {
            state = FairkeeperBorosEntity.FairkeeperBorosState.DESPERATE;
            this.hasAddedDesperateMove = true;
            this.borosPursueMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.DESPERATE, 2, 3, 3);
            this.borosPursueMoveSet.addMove(FairkeeperBorosEntity.FairkeeperBorosState.TACKLE_FAST, 3, 1, 1);
            this.borosPursueMoveSet.removeMove(FairkeeperBorosEntity.FairkeeperBorosState.TACKLE);
        }
        if ((boros = this.getBoros()) instanceof FairkeeperBorosEntity) {
            FairkeeperBorosEntity borosEntity = (FairkeeperBorosEntity)boros;
            if (state == null) {
                borosEntity.setState(FairkeeperBorosEntity.FairkeeperBorosState.IDLE);
                borosEntity.setAttackTick(60);
                this.ourosMoveSet.reduceAllCooldown();
            } else if (state == FairkeeperBorosEntity.FairkeeperBorosState.EXHAUSTED) {
                borosEntity.setState(FairkeeperBorosEntity.FairkeeperBorosState.IDLE);
                borosEntity.setAttackTick((int)(this.borosExhaustion.getExhaustionPercent() * 200.0f));
                this.borosExhaustion.resetExhaustion();
            } else {
                ((FairkeeperBorosEntity)boros).setState(state);
                float exhaustionCost = BOROS_EXHAUSTION_MAP.getOrDefault((Object)state, Float.valueOf(0.0f)).floatValue();
                this.borosExhaustion.addExhaustion(exhaustionCost);
            }
        }
        this.setBorosWaitingForCommand(false);
    }

    private void ourosAssignState() {
        class_1297 ouros;
        if (this.ouros == null) {
            return;
        }
        this.cleanMinionList();
        float exhaustionPercent = this.ourosExhaustion.getExhaustionPercent();
        FairkeeperOurosEntity.FairkeeperOurosState state = this.isAboveBoros() ? FairkeeperOurosEntity.FairkeeperOurosState.SHOOT_SINGLE_VERTEX_ORB : (exhaustionPercent > 0.5f && exhaustionPercent > this.field_5974.method_43057() ? FairkeeperOurosEntity.FairkeeperOurosState.EXHAUSTED : this.ourosMoveSet.selectMove());
        if (state == null) {
            state = FairkeeperOurosEntity.FairkeeperOurosState.IDLE;
        }
        if (state.equals((Object)FairkeeperOurosEntity.FairkeeperOurosState.DROP_PILLAR_RANDOM)) {
            state = this.ourosPillarMoveSet.selectMove();
        }
        if (state.equals((Object)FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_SCUTTLE) || state.equals((Object)FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_MORE_SCUTTLES)) {
            class_3218 serverLevel = (class_3218)this.method_37908();
            long scuttleCount = this.minionUUIDs.stream().map(arg_0 -> ((class_3218)serverLevel).method_14190(arg_0)).filter(entity -> entity instanceof ScuttleEntity).count();
            if (scuttleCount > 6L) {
                state = this.ourosMoveSet.selectMoveWithoutCooldownReduction();
            }
        }
        if (this.getPhase() > 2 && !this.hasAddedDesperateMove) {
            state = FairkeeperOurosEntity.FairkeeperOurosState.DESPERATE;
            this.hasAddedDesperateMove = true;
            this.ourosMoveSet.increaseAllCooldown();
            int previousTotalWeight = this.ourosMoveSet.getTotalWeight();
            this.ourosMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.DESPERATE, previousTotalWeight * 2, 3, 3);
            this.ourosMoveSet.addMove(FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_MORE_SCUTTLES, 3, 3, 0);
            this.ourosMoveSet.removeMove(FairkeeperOurosEntity.FairkeeperOurosState.SUMMON_SCUTTLE);
        }
        if ((ouros = this.getOuros()) instanceof FairkeeperOurosEntity) {
            FairkeeperOurosEntity ourosEntity = (FairkeeperOurosEntity)ouros;
            if (state == null) {
                ourosEntity.setState(FairkeeperOurosEntity.FairkeeperOurosState.IDLE);
                ourosEntity.setAttackTick(60);
                this.ourosMoveSet.reduceAllCooldown();
            } else if (state == FairkeeperOurosEntity.FairkeeperOurosState.EXHAUSTED) {
                ourosEntity.setState(FairkeeperOurosEntity.FairkeeperOurosState.IDLE);
                ourosEntity.setAttackTick((int)(this.ourosExhaustion.getExhaustionPercent() * 200.0f));
                this.ourosExhaustion.resetExhaustion();
            } else {
                ((FairkeeperOurosEntity)ouros).setState(state);
                float exhaustionCost = OUROS_EXHAUSTION_MAP.getOrDefault((Object)state, Float.valueOf(0.0f)).floatValue();
                this.ourosExhaustion.addExhaustion(exhaustionCost);
            }
        }
        this.setOurosWaitingForCommand(false);
    }

    private void clearAllMoveSet() {
        this.introMoveSet.clear();
        this.comboMoveSet.clear();
        this.directMoveSet.clear();
        this.ourosMoveSet.clear();
        this.ourosPillarMoveSet.clear();
        this.borosMoveSet.clear();
        this.borosArrowMoveSet.clear();
        this.borosPursueMoveSet.clear();
        this.hasAddedDesperateMove = false;
    }

    private boolean isAboveBoros() {
        return this.boros != null && this.boros.method_5968() != null && this.boros.method_5968().method_23318() > this.boros.method_23318() + 3.0;
    }

    private void defeatedBosses() {
        this.method_37908().method_8437(null, this.method_23317(), this.method_23318(), this.method_23321(), 1.0f, class_1937.class_7867.field_40889);
        if (((Boolean)BossConfig.TOGGLE_MULTIPLAYER_LOOT.get()).booleanValue() && !this.playerUUIDs.isEmpty()) {
            for (UUID playerUUID : this.playerUUIDs) {
                this.spawnLootTableItems(this.lastDamageSource, true, true, playerUUID);
            }
        } else {
            this.spawnLootTableItems(this.lastDamageSource, true, false, null);
        }
        this.removeAllMinions();
        this.removePreservers();
        this.removePillars();
        this.method_5650(class_1297.class_5529.field_26998);
    }

    private void removePreservers() {
        class_1937 level = this.method_37908();
        class_2338 center = this.method_24515();
        int includeWallPreserver = 1;
        int arenaSize = this.getArenaSize() + includeWallPreserver;
        HashMap map = new HashMap();
        int minX = center.method_10263() - arenaSize;
        int minZ = center.method_10260() - arenaSize;
        int maxX = center.method_10263() + arenaSize;
        int maxZ = center.method_10260() + arenaSize;
        int chunkMinX = class_4076.method_18675((int)minX);
        int chunkMinZ = class_4076.method_18675((int)minZ);
        int chunkMaxX = class_4076.method_18675((int)maxX);
        int chunkMaxZ = class_4076.method_18675((int)maxZ);
        for (int x = chunkMinX; x <= chunkMaxX; ++x) {
            for (int z = chunkMinZ; z <= chunkMaxZ; ++z) {
                map.putAll(level.method_8497(x, z).method_12214());
            }
        }
        Map<class_2338, class_2586> preserver = map.entrySet().stream().filter(e -> e.getValue() instanceof PreserverBlockEntity).filter(e -> {
            class_2338 pos = (class_2338)e.getKey();
            return pos.method_10263() >= minX && pos.method_10263() <= maxX && pos.method_10260() >= minZ && pos.method_10260() <= maxZ && Math.abs(pos.method_10264() - center.method_10264()) <= arenaSize;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        preserver.keySet().forEach(pos -> level.method_8652(pos, class_2246.field_10552.method_9564(), 3));
    }

    private void spawnLootTableItems(class_1282 damageSource, boolean b, boolean multiplayer, @javax.annotation.Nullable UUID uuid) {
        class_1297 class_12972;
        if (damageSource == null) {
            return;
        }
        class_2960 baseResourceLocation = class_7923.field_41177.method_10221(DNLEntityTypes.FAIRKEEPER_SERPENT_CALLER.get()).method_45138("entities/");
        class_2960 lootTableResourceLocation = this.isBorosDefeated > this.isOurosDefeated ? baseResourceLocation.method_48331("/boros") : baseResourceLocation.method_48331("/ouros");
        class_52 lootTable = this.method_37908().method_8503().method_3857().getLootTable(lootTableResourceLocation);
        class_8567.class_8568 builder = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1231, (Object)damageSource).method_51877(class_181.field_1230, (Object)damageSource.method_5529()).method_51877(class_181.field_1227, (Object)damageSource.method_5526());
        if (b && (class_12972 = damageSource.method_5529()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            builder = builder.method_51874(class_181.field_1233, (Object)player).method_51871(player.method_7292());
        }
        class_8567 lootParams = builder.method_51875(class_173.field_1173);
        if (multiplayer) {
            lootTable.method_51882(lootParams, itemStack -> this.spawnSpecialItemEntity((class_1799)itemStack, 0.0f, uuid));
        } else {
            lootTable.method_51882(lootParams, arg_0 -> ((FairkeeperSerpentCallerEntity)this).method_5775(arg_0));
        }
    }

    private void spawnSpecialItemEntity(class_1799 itemStack, float i, UUID uuid) {
        if (!itemStack.method_7960() && !this.method_37908().field_9236 && uuid != null) {
            SpecialItemEntity specialItemEntity = new SpecialItemEntity(this.method_37908(), this.method_23317(), this.method_23318() + (double)i, this.method_23321(), itemStack);
            specialItemEntity.setPickerUUID(uuid);
            specialItemEntity.method_6988();
            this.method_37908().method_8649((class_1297)specialItemEntity);
        }
    }

    private void resetBosses() {
        FairkeeperBorosEntity boros = (FairkeeperBorosEntity)this.getBoros();
        FairkeeperOurosEntity ouros = (FairkeeperOurosEntity)this.getOuros();
        if (boros != null) {
            boros.resetBoss();
        }
        if (ouros != null) {
            ouros.resetBoss();
        }
        this.setActivated(false);
        this.field_6011.method_12778(ANIMATION_STATE, (Object)FairkeeperSerpentCallerAnimationState.IDLE);
        this.setPhase(0);
        this.activationTick = 0;
        this.musicTick = 0;
        this.playerUUIDs.clear();
        this.removeAllMinions();
        this.removePillars();
        this.stopAllBossMusic();
    }

    public void removePillars() {
        class_1937 level = this.method_37908();
        class_2338 center = this.method_24515();
        int arenaSize = this.getArenaSize();
        HashMap map = new HashMap();
        int minX = center.method_10263() - arenaSize;
        int minZ = center.method_10260() - arenaSize;
        int maxX = center.method_10263() + arenaSize;
        int maxZ = center.method_10260() + arenaSize;
        int chunkMinX = class_4076.method_18675((int)minX);
        int chunkMinZ = class_4076.method_18675((int)minZ);
        int chunkMaxX = class_4076.method_18675((int)maxX);
        int chunkMaxZ = class_4076.method_18675((int)maxZ);
        for (int x = chunkMinX; x <= chunkMaxX; ++x) {
            for (int z = chunkMinZ; z <= chunkMaxZ; ++z) {
                map.putAll(level.method_8497(x, z).method_12214());
            }
        }
        Map<class_2338, class_2586> filtered = map.entrySet().stream().filter(e -> e.getValue() instanceof VertexPillarBlockEntity).filter(e -> {
            class_2338 pos = (class_2338)e.getKey();
            return pos.method_10263() >= minX && pos.method_10263() <= maxX && pos.method_10260() >= minZ && pos.method_10260() <= maxZ && Math.abs(pos.method_10264() - center.method_10264()) <= arenaSize;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        filtered.keySet().forEach(pos -> level.method_8650(pos, false));
    }

    private void removeAllMinions() {
        class_3218 serverLevel = (class_3218)this.method_37908();
        for (UUID minionUUID : this.minionUUIDs) {
            class_1297 minion = serverLevel.method_14190(minionUUID);
            if (minion == null) continue;
            SpawnMobUtil.createPoofParticle(serverLevel, minion);
            minion.method_31472();
        }
        this.minionUUIDs.clear();
    }

    private boolean isAllPlayersInBound() {
        if (!((Boolean)BossConfig.TOGGLE_BOSS_RESET.get()).booleanValue()) {
            return false;
        }
        class_238 aabb = new class_238(this.method_24515()).method_1014(36.0);
        List list = this.method_37908().method_18467(class_1657.class, aabb);
        list.removeIf(player -> !player.method_5805());
        return !list.isEmpty();
    }

    private void spawnEmergingParticles() {
        class_2338 currentPosition = new class_2338(this.method_31477(), this.method_31478(), this.method_31479());
        class_2350 direction = class_2350.method_10150((double)this.method_36454());
        class_2350 clockWiseDirection = direction.method_10170();
        class_2350 counterClockWiseDirection = direction.method_10160();
        class_2338 clockWiseTargetPosition = currentPosition.method_10079(clockWiseDirection, this.getHorizontalOffset()).method_10087(this.getVerticalOffset());
        class_2338 counterClockWiseTargetPosition = currentPosition.method_10079(counterClockWiseDirection, this.getHorizontalOffset()).method_10086(this.getVerticalOffset());
        class_243 centeredClockWiseTargetPosition = clockWiseTargetPosition.method_46558();
        class_243 centeredCounterClockWiseTargetPosition = counterClockWiseTargetPosition.method_46558();
        ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11236, centeredCounterClockWiseTargetPosition.field_1352, centeredCounterClockWiseTargetPosition.field_1351, centeredCounterClockWiseTargetPosition.field_1350, 5, 3.0, 0.0, 3.0, 0.0);
        ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11236, centeredClockWiseTargetPosition.field_1352, centeredClockWiseTargetPosition.field_1351, centeredClockWiseTargetPosition.field_1350, 5, 3.0, 0.0, 3.0, 0.0);
    }

    private void spawnBurrowingParticles() {
        class_2338 currentPosition = new class_2338(this.method_31477(), this.method_31478(), this.method_31479());
        class_2350 direction = class_2350.method_10150((double)this.method_36454());
        class_2350 clockWiseDirection = direction.method_10170();
        class_2350 counterClockWiseDirection = direction.method_10160();
        class_2338 clockWiseTargetPosition = currentPosition.method_10079(clockWiseDirection, this.getHorizontalOffset()).method_10087(this.getVerticalOffset());
        class_2338 counterClockWiseTargetPosition = currentPosition.method_10079(counterClockWiseDirection, this.getHorizontalOffset()).method_10086(this.getVerticalOffset());
        class_243 centeredClockWiseTargetPosition = clockWiseTargetPosition.method_46558();
        class_243 centeredCounterClockWiseTargetPosition = counterClockWiseTargetPosition.method_46558();
        class_2680 stoneBricks = class_2246.field_10056.method_9564();
        ((class_3218)this.method_37908()).method_14199((class_2394)new class_2388(class_2398.field_11217, stoneBricks), centeredCounterClockWiseTargetPosition.field_1352, centeredCounterClockWiseTargetPosition.field_1351, centeredCounterClockWiseTargetPosition.field_1350, 10, 3.0, 3.0, 3.0, 0.05);
        ((class_3218)this.method_37908()).method_14199((class_2394)new class_2388(class_2398.field_11217, stoneBricks), centeredClockWiseTargetPosition.field_1352, centeredClockWiseTargetPosition.field_1351, centeredClockWiseTargetPosition.field_1350, 10, 3.0, 3.0, 3.0, 0.05);
    }

    private void summonBosses() {
        FairkeeperOurosEntity ouros;
        class_2338 currentPosition = new class_2338(this.method_31477(), this.method_31478(), this.method_31479());
        class_2350 direction = class_2350.method_10150((double)this.method_36454());
        class_2350 clockWiseDirection = direction.method_10170();
        class_2350 counterClockWiseDirection = direction.method_10160();
        class_2338 clockWiseTargetPosition = currentPosition.method_10079(clockWiseDirection, this.getHorizontalOffset()).method_10087(this.getVerticalOffset());
        class_2338 counterClockWiseTargetPosition = currentPosition.method_10079(counterClockWiseDirection, this.getHorizontalOffset()).method_10086(this.getVerticalOffset());
        class_243 centeredClockWiseTargetPosition = clockWiseTargetPosition.method_46558();
        class_243 centeredCounterClockWiseTargetPosition = counterClockWiseTargetPosition.method_46558();
        int playerCount = this.playerUUIDs.size();
        FairkeeperBorosEntity boros = new FairkeeperBorosEntity(this.method_37908(), this);
        if (boros != null) {
            boros.method_24203(centeredCounterClockWiseTargetPosition.field_1352, centeredCounterClockWiseTargetPosition.field_1351 - boros.method_5829().method_17940() / 2.0 + 5.0, centeredCounterClockWiseTargetPosition.field_1350);
            boros.setState(FairkeeperBorosEntity.FairkeeperBorosState.AWAKENING);
            boros.method_36456(clockWiseDirection.method_10144());
            boros.field_6283 = boros.method_36454();
            boros.field_6241 = boros.method_36454();
            boros.setCanDestroyBlocks(false);
            this.method_37908().method_8649((class_1297)boros);
            boros.transitionTo(FairkeeperBorosEntity.FairkeeperBorosAnimationState.IDLE);
            this.setBorosId(boros.method_5667());
            this.setBorosWaitingForCommand(false);
            EntityScale.scaleBossHealth((class_1309)boros, playerCount);
            EntityScale.scaleBossAttack((class_1309)boros, playerCount);
            EntityScale.scaleBossExhaustion((class_1309)boros, playerCount, this.borosExhaustion);
            this.boros = boros;
        }
        if ((ouros = new FairkeeperOurosEntity(this.method_37908(), this)) != null) {
            ouros.method_24203(centeredClockWiseTargetPosition.field_1352, centeredClockWiseTargetPosition.field_1351 - ouros.method_5829().method_17940() / 2.0 - 5.0, centeredClockWiseTargetPosition.field_1350);
            ouros.setState(FairkeeperOurosEntity.FairkeeperOurosState.AWAKENING);
            ouros.method_36456(counterClockWiseDirection.method_10144());
            ouros.field_6283 = ouros.method_36454();
            ouros.field_6241 = ouros.method_36454();
            ouros.setCanDestroyBlocks(false);
            this.method_37908().method_8649((class_1297)ouros);
            ouros.transitionTo(FairkeeperOurosEntity.FairkeeperOurosAnimationState.IDLE);
            this.setOurosId(ouros.method_5667());
            this.setOurosWaitingForCommand(false);
            EntityScale.scaleBossHealth((class_1309)ouros, playerCount);
            EntityScale.scaleBossAttack((class_1309)ouros, playerCount);
            EntityScale.scaleBossExhaustion((class_1309)ouros, playerCount, this.ourosExhaustion);
            this.ouros = ouros;
        }
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        if (ANIMATION_STATE.equals(entityDataAccessor)) {
            FairkeeperSerpentCallerAnimationState animationState = (FairkeeperSerpentCallerAnimationState)((Object)this.field_6011.method_12789(ANIMATION_STATE));
            switch (animationState) {
                case IDLE: {
                    this.idleAnimationState.method_41324(this.field_6012);
                    break;
                }
                case ACTIVE: {
                    this.activeAnimationState.method_41325();
                    this.activeAnimationState.method_41322(this.field_6012);
                }
            }
        }
        super.method_5674(entityDataAccessor);
    }

    public void transitionTo(FairkeeperSerpentCallerAnimationState state) {
        this.field_6011.method_12778(ANIMATION_STATE, (Object)state);
    }

    public boolean method_5863() {
        return !this.isActivated() && !this.method_31481();
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)DNLItems.FAIRKEEPER_SERPENT_CALLER.get());
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (this.getPhase() < 1) {
            player.method_7353((class_2561)class_2561.method_43471((String)"entity.dungeonnowloading.fairkeeper_serpent_caller.right_click"), true);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5688(player, hand);
    }

    public boolean method_5643(class_1282 damageSource, float v) {
        if (!this.method_37908().field_9236 && !this.method_31481() && damageSource.method_5530()) {
            this.method_5768();
            return true;
        }
        return super.method_5643(damageSource, v);
    }

    private void playBossMusic() {
        float radius = 36.0f;
        class_238 detectionBox = this.method_5829().method_1014((double)radius);
        List nearbyPlayers = this.method_37908().method_18467(class_3222.class, detectionBox);
        ArrayList<class_2960> soundsToStart = new ArrayList<class_2960>(List.of());
        soundsToStart.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_BASE.get().method_14833());
        soundsToStart.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_BOROS.get().method_14833());
        soundsToStart.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_OUROS.get().method_14833());
        for (class_3222 player : nearbyPlayers) {
            for (class_2960 sound : soundsToStart) {
                Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.method_5628(), sound, class_3419.field_15253, 0.0f, 1.0f, false, 36.0f, 36.0f), player);
            }
            Services.NETWORK.sendToPlayer(new S2CFadeInTickingSoundPacket(this.method_5628(), DNLSounds.MUSIC_CLASH_OF_DUALITY_BASE.get().method_14833(), TickingSoundTarget.NEWEST, 1.0f, 60), player);
            Services.NETWORK.sendToPlayer(new S2CFadeOutBackgroundMusicSoundPacket(60), player);
        }
    }

    private void playLoopMusic() {
        float radius = 36.0f;
        class_238 detectionBox = this.method_5829().method_1014((double)radius);
        List nearbyPlayers = this.method_37908().method_18467(class_3222.class, detectionBox);
        for (class_3222 player : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.method_5628(), DNLSounds.MUSIC_CLASH_OF_DUALITY_BASE.get().method_14833(), class_3419.field_15253, 1.0f, 1.0f, false, 36.0f, 36.0f), player);
            if (this.isBorosDefeated > 2) {
                Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.method_5628(), DNLSounds.MUSIC_CLASH_OF_DUALITY_OUROS.get().method_14833(), class_3419.field_15253, 1.0f, 1.0f, false, 36.0f, 36.0f), player);
                continue;
            }
            if (this.isOurosDefeated > 2) {
                Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.method_5628(), DNLSounds.MUSIC_CLASH_OF_DUALITY_BOROS.get().method_14833(), class_3419.field_15253, 1.0f, 1.0f, false, 36.0f, 36.0f), player);
                continue;
            }
            Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.method_5628(), DNLSounds.MUSIC_CLASH_OF_DUALITY_OUROS.get().method_14833(), class_3419.field_15253, 0.0f, 1.0f, false, 36.0f, 36.0f), player);
            Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.method_5628(), DNLSounds.MUSIC_CLASH_OF_DUALITY_BOROS.get().method_14833(), class_3419.field_15253, 0.0f, 1.0f, false, 36.0f, 36.0f), player);
        }
    }

    public void stopAllBossMusic() {
        float radius = 72.0f;
        class_238 detectionBox = this.method_5829().method_1014((double)radius);
        List nearbyPlayers = this.method_37908().method_18467(class_3222.class, detectionBox);
        ArrayList<class_2960> soundsToStop = new ArrayList<class_2960>(List.of());
        soundsToStop.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_BASE.get().method_14833());
        soundsToStop.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_BOROS.get().method_14833());
        soundsToStop.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_OUROS.get().method_14833());
        for (class_3222 otherPlayer : nearbyPlayers) {
            for (class_2960 sound : soundsToStop) {
                Services.NETWORK.sendToPlayer(new S2CStopTickingSoundPacket(this.method_5628(), sound, TickingSoundTarget.ALL, 60, true), otherPlayer);
            }
        }
    }

    public void stopBossMusic() {
        float radius = 72.0f;
        class_238 detectionBox = this.method_5829().method_1014((double)radius);
        List nearbyPlayers = this.method_37908().method_18467(class_3222.class, detectionBox);
        ArrayList<class_2960> soundsToStop = new ArrayList<class_2960>(List.of());
        soundsToStop.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_BASE.get().method_14833());
        soundsToStop.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_BOROS.get().method_14833());
        soundsToStop.add(DNLSounds.MUSIC_CLASH_OF_DUALITY_OUROS.get().method_14833());
        for (class_3222 otherPlayer : nearbyPlayers) {
            for (class_2960 sound : soundsToStop) {
                Services.NETWORK.sendToPlayer(new S2CStopTickingSoundPacket(this.method_5628(), sound, 60, true), otherPlayer);
            }
        }
    }

    private void fadeInBorosMusic() {
        float radius = 36.0f;
        class_238 detectionBox = this.method_5829().method_1014((double)radius);
        List nearbyPlayers = this.method_37908().method_18467(class_3222.class, detectionBox);
        for (class_3222 otherPlayer : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CFadeInTickingSoundPacket(this.method_5628(), DNLSounds.MUSIC_CLASH_OF_DUALITY_BOROS.get().method_14833(), TickingSoundTarget.NEWEST, 1.0f, 20), otherPlayer);
        }
    }

    private void fadeInOurosMusic() {
        float radius = 36.0f;
        class_238 detectionBox = this.method_5829().method_1014((double)radius);
        List nearbyPlayers = this.method_37908().method_18467(class_3222.class, detectionBox);
        for (class_3222 otherPlayer : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CFadeInTickingSoundPacket(this.method_5628(), DNLSounds.MUSIC_CLASH_OF_DUALITY_OUROS.get().method_14833(), TickingSoundTarget.NEWEST, 1.0f, 20), otherPlayer);
        }
    }

    public class_1297 getBoros() {
        UUID id = this.getBorosId();
        if (id != null && !this.method_37908().field_9236) {
            return ((class_3218)this.method_37908()).method_14190(id);
        }
        return null;
    }

    @javax.annotation.Nullable
    public UUID getBorosId() {
        return ((Optional)this.field_6011.method_12789(BOROS_UUID)).orElse(null);
    }

    public void setBorosId(@javax.annotation.Nullable UUID uniqueId) {
        this.field_6011.method_12778(BOROS_UUID, Optional.ofNullable(uniqueId));
    }

    public class_1297 getOuros() {
        UUID id = this.getOurosId();
        if (id != null && !this.method_37908().field_9236) {
            return ((class_3218)this.method_37908()).method_14190(id);
        }
        return null;
    }

    @javax.annotation.Nullable
    public UUID getOurosId() {
        return ((Optional)this.field_6011.method_12789(OUROS_UUID)).orElse(null);
    }

    public void setOurosId(@javax.annotation.Nullable UUID uniqueId) {
        this.field_6011.method_12778(OUROS_UUID, Optional.ofNullable(uniqueId));
    }

    public void setActivated(boolean activated) {
        this.field_6011.method_12778(ACTIVATED, (Object)activated);
    }

    public boolean isActivated() {
        return (Boolean)this.field_6011.method_12789(ACTIVATED);
    }

    public void setOffsets(int x, int y) {
        this.field_6011.method_12778(HORIZONTAL_OFFSET, (Object)x);
        this.field_6011.method_12778(VERTICAL_OFFSET, (Object)y);
    }

    public int getHorizontalOffset() {
        return (Integer)this.field_6011.method_12789(HORIZONTAL_OFFSET);
    }

    public int getVerticalOffset() {
        return (Integer)this.field_6011.method_12789(VERTICAL_OFFSET);
    }

    public int getPhase() {
        return (Integer)this.field_6011.method_12789(PHASE);
    }

    public void setPhase(int phase) {
        this.field_6011.method_12778(PHASE, (Object)phase);
    }

    public void setLastDamageSource(class_1282 damageSource) {
        this.lastDamageSource = damageSource;
    }

    public int getArenaSize() {
        return 36;
    }

    public boolean isBorosWaitingForCommand() {
        return this.borosWaitingForCommand && this.boros != null;
    }

    public void setBorosWaitingForCommand(boolean waitingForCommand) {
        this.borosWaitingForCommand = waitingForCommand;
    }

    public boolean isOurosWaitingForCommand() {
        return this.ourosWaitingForCommand && this.ouros != null;
    }

    public void setOurosWaitingForCommand(boolean waitingForCommand) {
        this.ourosWaitingForCommand = waitingForCommand;
    }

    public int getParticipatingPlayerCount() {
        return this.playerUUIDs.size();
    }

    public Set<UUID> getParticipatingPlayerUUIDs() {
        return this.playerUUIDs;
    }

    public void removeMinion(UUID uuid) {
        this.minionUUIDs.remove(uuid);
    }

    public void addMinion(UUID uuid) {
        this.minionUUIDs.add(uuid);
    }

    public Set<UUID> getMinionUUIDs() {
        return this.minionUUIDs;
    }

    public boolean isBorosDefeated() {
        return this.isBorosDefeated > 0;
    }

    public boolean isOurosDefeated() {
        return this.isOurosDefeated > 0;
    }

    public void dyingBoros() {
        this.isBorosDefeated = this.isOurosDefeated > 0 ? 2 : 1;
    }

    public void dyingOuros() {
        this.isOurosDefeated = this.isBorosDefeated > 0 ? 2 : 1;
    }

    public void defeatedBoros() {
        this.isBorosDefeated = this.isBorosDefeated == 2 ? 4 : 3;
    }

    public void defeatedOuros() {
        this.isOurosDefeated = this.isOurosDefeated == 2 ? 4 : 3;
    }

    public void cleanMinionList() {
        class_3218 serverLevel = (class_3218)this.method_37908();
        this.minionUUIDs = this.getMinionUUIDs().stream().map(arg_0 -> ((class_3218)serverLevel).method_14190(arg_0)).filter(Objects::nonNull).map(class_1297::method_5667).collect(Collectors.toSet());
    }

    public static enum FairkeeperSerpentCallerAnimationState {
        NONE,
        IDLE,
        ACTIVE;

    }
}

