/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.client.renderer;

import dev.hexnowloading.dungeonnowloading.entity.client.model.VertexDomainProjectileModel;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexDomainProjectileEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_897;

public class VertexDomainProjectileRenderer<T extends VertexDomainProjectileEntity>
extends class_897<VertexDomainProjectileEntity> {
    private static final class_2960 TEXTURE = new class_2960("dungeonnowloading", "textures/entity/vertex_domain_projectile.png");
    private static final class_2960 EMISSIVE = new class_2960("dungeonnowloading", "textures/entity/vertex_domain_projectile_emissive.png");
    private static final class_1921 RENDER_TYPE = class_1921.method_23580((class_2960)TEXTURE);
    private static final class_1921 EMISSIVE_RENDER_TYPE = class_1921.method_23580((class_2960)EMISSIVE);
    private VertexDomainProjectileModel model;

    public VertexDomainProjectileRenderer(class_5617.class_5618 context) {
        super(context);
        this.model = new VertexDomainProjectileModel(context.method_32167(VertexDomainProjectileModel.LAYER_LOCATION));
    }

    public boolean shouldRender(VertexDomainProjectileEntity entity, class_4604 frustum, double x, double y, double z) {
        return true;
    }

    public void render(VertexDomainProjectileEntity entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        poseStack.method_22903();
        poseStack.method_22905(-2.0f, -2.0f, 2.0f);
        poseStack.method_46416(0.0f, 0.0f, 0.0f);
        boolean bl = entity.getHurtTime() > 0;
        float alpha = 1.0f;
        int fadeStart = 20;
        if (entity.getLife() > 0 && entity.getLife() < fadeStart) {
            alpha = Math.max((float)entity.getLife() / (float)fadeStart, 0.0f);
        } else if (entity.getDyingTick() > 0) {
            alpha = Math.max((float)entity.getDyingTick() / (float)fadeStart, 0.0f);
        }
        class_4588 vertexConsumer = buffer.getBuffer(RENDER_TYPE);
        this.model.setupAnim(entity, 0.0f, 0.0f, (float)entity.field_6012 + partialTicks, entityYaw, 0.0f);
        this.model.renderToBufferWithEntity(entity, poseStack, vertexConsumer, 0xF000F0, class_4608.method_23624((float)0.0f, (boolean)bl), 1.0f, 1.0f, 1.0f, alpha);
        float emissiveAlpha = VertexDomainProjectileRenderer.getEmissiveAlpha(entity, partialTicks);
        if (emissiveAlpha > 0.01f) {
            class_4588 emissiveVertexConsumer = buffer.getBuffer(EMISSIVE_RENDER_TYPE);
            this.model.renderToBufferWithEntity(entity, poseStack, emissiveVertexConsumer, 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, emissiveAlpha);
        }
        poseStack.method_22909();
        super.method_3936((class_1297)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private static float getEmissiveAlpha(VertexDomainProjectileEntity entity, float partialTicks) {
        if (entity.getLife() <= 0) {
            return 0.2f;
        }
        float lifeProgress = (float)entity.getLife() / 1200.0f;
        float cycleTime = 40.0f;
        float time = ((float)(1200 - entity.getLife()) + partialTicks) % cycleTime;
        float pulse = 0.0f;
        if (time < 5.0f) {
            pulse = time / 5.0f;
        } else if (time < 20.0f) {
            float fadeTime = (time - 5.0f) / 15.0f;
            pulse = 1.0f - fadeTime * fadeTime;
        }
        pulse = 0.2f + 0.8f * pulse;
        return lifeProgress * pulse;
    }

    public class_2960 getTextureLocation(VertexDomainProjectileEntity vertexDomainProjectileEntity) {
        return TEXTURE;
    }
}

