/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.misc;

import dev.hexnowloading.dungeonnowloading.entity.ai.EntityBodyRotationControl;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.item.RepulsorItem;
import dev.hexnowloading.dungeonnowloading.item.ScrapItem;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLEnchantments;
import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1330;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1685;
import net.minecraft.class_1686;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3619;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class RepulsorEntity
extends class_1308 {
    public static final int SHIELD_MAX_HEALTH = 100;
    public static final float SHIELD_ALERT_THRESHOLD = 50.0f;
    private static final double BEAM_INITIAL_PARTICLE_SPACING = 0.5;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MIN = 0.1f;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MAX = 0.3f;
    private static final int SHIELD_HEAL_AMOUNT = 5;
    private static final class_2940<Boolean> DATA_CAN_RENDER = class_2945.method_12791(RepulsorEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_AGE = class_2945.method_12791(RepulsorEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> DATA_SHIELD_HEALTH = class_2945.method_12791(RepulsorEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<State> DATA_STATE = class_2945.method_12791(RepulsorEntity.class, EntityStates.COMMAND_PYLON_STATE);
    private static final class_2940<Skin> DATA_SKIN = class_2945.method_12791(RepulsorEntity.class, EntityStates.REPULSOR_SKIN);
    private static final class_2940<Boolean> DATA_SKIN_VALIDATION = class_2945.method_12791(RepulsorEntity.class, (class_2941)class_2943.field_13323);
    public class_7094 setupAnimState = new class_7094();
    public class_7094 idleAnimState = new class_7094();
    public class_7094 rechargeAnimState = new class_7094();
    private Set<class_1685> processedTridents = new HashSet<class_1685>();
    private int rechargeAnimDuration;
    private class_1799 sourceStack = class_1799.field_8037;

    public RepulsorEntity(class_1299<? extends class_1308> $$0, class_1937 $$1) {
        super($$0, $$1);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1314.method_26828().method_26868(class_5134.field_23716, 1.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_CAN_RENDER, (Object)false);
        this.field_6011.method_12784(DATA_AGE, (Object)0);
        this.field_6011.method_12784(DATA_SHIELD_HEALTH, (Object)100);
        this.field_6011.method_12784(DATA_STATE, (Object)State.SETUP);
        this.field_6011.method_12784(DATA_SKIN, (Object)Skin.DEFAULT);
        this.field_6011.method_12784(DATA_SKIN_VALIDATION, (Object)false);
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.field_6011.method_12778(DATA_CAN_RENDER, (Object)compoundTag.method_10577("canRender"));
        this.field_6011.method_12778(DATA_AGE, (Object)compoundTag.method_10550("age"));
        this.field_6011.method_12778(DATA_SHIELD_HEALTH, (Object)compoundTag.method_10550("shieldHealth"));
        if (compoundTag.method_10545("skin") && !this.getSkinValidation()) {
            this.field_6011.method_12778(DATA_SKIN, (Object)Skin.fromId(compoundTag.method_10558("skin")));
        }
        this.sourceStack = compoundTag.method_10573("SourceStack", 10) ? class_1799.method_7915((class_2487)compoundTag.method_10562("SourceStack")) : class_1799.field_8037;
        this.setSkinValidation(true);
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10556("canRender", this.canRender());
        compoundTag.method_10569("age", this.getAge());
        compoundTag.method_10569("shieldHealth", ((Integer)this.field_6011.method_12789(DATA_SHIELD_HEALTH)).intValue());
        compoundTag.method_10582("skin", this.getSkin().getId());
        if (!this.sourceStack.method_7960()) {
            class_2487 s = new class_2487();
            this.sourceStack.method_7953(s);
            compoundTag.method_10566("SourceStack", (class_2520)s);
        }
    }

    public void method_5697(class_1297 entity) {
    }

    public boolean method_5810() {
        return false;
    }

    protected boolean method_5876() {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    public class_3619 method_5657() {
        this.dropItem(null);
        this.method_31472();
        return class_3619.field_15974;
    }

    protected class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (itemStack.method_31574(class_1802.field_8725) && this.getAge() >= 35 && this.getShieldHealth() < 100 && this.rechargeAnimDuration <= 0) {
            if (this.getShieldHealth() >= 95) {
                this.method_5783(DNLSounds.REPULSOR_RECHARGE.get(), 0.5f, 0.5f);
            } else {
                this.method_5783(DNLSounds.REPULSOR_RECHARGE.get(), 0.5f, 1.0f);
            }
            this.rechargeAnimDuration = 10;
            if (!this.method_37908().field_9236) {
                itemStack.method_7934(1);
                this.setShieldHealth(this.getShieldHealth() + 5);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, interactionHand);
    }

    protected class_1330 method_5963() {
        return new EntityBodyRotationControl(this);
    }

    public boolean method_36320() {
        return super.method_36320();
    }

    public boolean method_5643(class_1282 damageSource, float f) {
        if (this.method_5679(damageSource)) {
            return false;
        }
        if (!this.method_31481() && !this.method_37908().field_9236) {
            this.method_31472();
            this.method_5785();
            this.dropItem(damageSource.method_5529());
        }
        return true;
    }

    public void method_5762(double d, double e, double f) {
        if (!this.method_37908().field_9236 && !this.method_31481() && d * d + e * e + f * f > 0.0) {
            this.method_31472();
            this.dropItem(null);
        }
    }

    public void dropItem(@Nullable class_1297 entity) {
        if (this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            this.method_43077(DNLSounds.REPULSOR_BREAK.get());
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                if (player.method_31549().field_7477) {
                    return;
                }
            }
            class_1799 itemStack = this.sourceStack.method_7960() ? new class_1799((class_1935)DNLItems.REPULSOR.get()) : this.sourceStack.method_7972();
            itemStack.method_7939(1);
            int damage = 100 - (Integer)this.field_6011.method_12789(DATA_SHIELD_HEALTH);
            itemStack.method_7974(damage);
            if (this.getSkin() == Skin.GOLDEN) {
                RepulsorItem.setGolden(itemStack);
            }
            this.method_5775(itemStack);
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.getAge() == 1) {
            this.setupAnimState.method_41322(this.field_6012);
            this.field_6011.method_12778(DATA_STATE, (Object)State.SETUP);
            this.field_6011.method_12778(DATA_CAN_RENDER, (Object)true);
            this.method_43077(DNLSounds.REPULSOR_PLACE.get());
        } else if (this.getAge() == 36) {
            this.method_43077(DNLSounds.REPULSOR_BARRIER_BUILD.get());
        } else if (this.getAge() == 76) {
            this.setupAnimState.method_41325();
            this.field_6011.method_12778(DATA_STATE, (Object)State.IDLE);
        }
        if ((float)this.getAge() >= 76.0f) {
            this.idleAnimState.method_41324(this.field_6012);
        }
        if (this.rechargeAnimDuration-- > 0) {
            this.rechargeAnimState.method_41324(this.field_6012);
            if (this.rechargeAnimDuration <= 0) {
                this.rechargeAnimState.method_41325();
            }
        }
        if (!this.method_37908().field_9236) {
            if (this.getAge() >= 36) {
                for (class_1297 entity : this.getNearbyProjectiles()) {
                    boolean aboveHalfHealth;
                    boolean discardEntity = false;
                    boolean bl = aboveHalfHealth = (float)((Integer)this.field_6011.method_12789(DATA_SHIELD_HEALTH)).intValue() > 50.0f;
                    if (entity instanceof class_1685) {
                        class_1685 thrownTrident = (class_1685)entity;
                        if (this.processedTridents.contains(thrownTrident) || thrownTrident.field_7588) continue;
                        this.processedTridents.add(thrownTrident);
                        class_243 motion = thrownTrident.method_18798();
                        thrownTrident.method_18799(new class_243(-motion.field_1352 * (double)0.1f, -motion.field_1351 * (double)0.1f, -motion.field_1350 * (double)0.1f));
                        thrownTrident.field_6007 = true;
                    } else if (entity instanceof class_1686) {
                        boolean flag;
                        class_1686 thrownPotion = (class_1686)entity;
                        class_1799 itemStack = thrownPotion.method_7495();
                        class_1842 potion = class_1844.method_8063((class_1799)itemStack);
                        List list = class_1844.method_8067((class_1799)itemStack);
                        boolean bl2 = flag = potion == class_1847.field_8991 && list.isEmpty();
                        if (flag) {
                            thrownPotion.method_7500();
                        } else if (!list.isEmpty()) {
                            if (itemStack.method_31574(class_1802.field_8150)) {
                                thrownPotion.method_7497(itemStack, potion);
                            } else {
                                thrownPotion.method_7498(list, null);
                            }
                        }
                        int i = potion.method_8050() ? 2007 : 2002;
                        this.method_37908().method_20290(i, thrownPotion.method_24515(), class_1844.method_8064((class_1799)itemStack));
                        discardEntity = true;
                    } else {
                        if (entity instanceof class_1665) {
                            class_1665 arrow = (class_1665)entity;
                            if (arrow.field_7588) continue;
                        }
                        discardEntity = true;
                    }
                    this.spawnRedstoneBeamParticle((class_3218)this.method_37908(), entity);
                    this.method_43077(DNLSounds.REPULSOR_FIZZLE.get());
                    int shieldDamage = 1;
                    if (entity.method_5864().method_20210(DNLTags.REPULSOR_HIGH_DAMAGE_PROJECTILES)) {
                        shieldDamage = 20;
                    } else if (entity.method_5864().method_20210(DNLTags.REPULSOR_LOW_DAMAGE_PROJECTILES)) {
                        shieldDamage = 5;
                    }
                    int updatedShieldHealth = (Integer)this.field_6011.method_12789(DATA_SHIELD_HEALTH) - shieldDamage;
                    this.field_6011.method_12778(DATA_SHIELD_HEALTH, (Object)updatedShieldHealth);
                    if (aboveHalfHealth && (float)this.getShieldHealth() <= 50.0f) {
                        this.method_43077(DNLSounds.REPULSOR_ALERT.get());
                    }
                    if (discardEntity) {
                        entity.method_31472();
                    }
                    if (!((float)updatedShieldHealth <= 0.0f)) continue;
                    ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), 1.0f);
                    this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15152, this.method_5634(), 1.0f, 2.0f);
                    ((class_3218)this.method_37908()).method_14199((class_2394)particleData, this.method_23317(), this.method_23318(), this.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
                    this.maybeDropScrapOnUsedUp();
                    this.method_31472();
                    return;
                }
                if ((float)this.getShieldHealth() <= 50.0f) {
                    float healthRatio = (float)this.getShieldHealth() / 50.0f;
                    float blinkCycle = 40.0f - 35.0f * (1.0f - healthRatio);
                    if (this.getAge() % (int)blinkCycle == 0) {
                        float normalizedSpeed = 1.0f - (blinkCycle - 5.0f) / 35.0f;
                        float pitch = 1.0f + normalizedSpeed;
                        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), DNLSounds.REPULSOR_BLINK.get(), class_3419.field_15245, 0.5f, pitch);
                    }
                }
            }
            this.field_6011.method_12778(DATA_AGE, (Object)(this.getAge() + 1));
        }
    }

    private void spawnRedstoneBeamParticle(class_3218 level, class_1297 target) {
        class_243 start = this.method_19538().method_1031(0.0, 1.0, 0.0);
        class_243 end = target.method_19538().method_1031(0.0, (double)target.method_17682() * 0.5, 0.0);
        class_243 direction = end.method_1020(start);
        double distance = direction.method_1033();
        double stepSize = 0.5;
        int particleCount = (int)(distance / stepSize);
        class_243 step = direction.method_1029().method_1021(stepSize);
        float particleScale = 0.1f + (float)Math.random() * 0.20000002f;
        ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), particleScale);
        for (int i = 0; i <= particleCount; ++i) {
            class_243 particlePos = start.method_1019(step.method_1021((double)i));
            if (i == particleCount) {
                particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), 0.5f);
            }
            level.method_14199((class_2394)particleData, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private List<class_1297> getNearbyProjectiles() {
        double centerX = this.method_23317();
        double centerY = this.method_23318();
        double centerZ = this.method_23321();
        class_238 detectionBox = new class_238(centerX - 4.5, centerY - 4.5, centerZ - 4.5, centerX + 4.5, centerY + 4.5, centerZ + 4.5);
        return this.method_37908().method_8333((class_1297)null, detectionBox, entity -> (entity instanceof class_1676 || entity.method_5864().method_20210(DNLTags.PROJECTILES) || entity instanceof class_1686) && !entity.method_5864().method_20210(DNLTags.REPULSOR_OMITTED_PROJECTILES));
    }

    public boolean canRender() {
        return (Boolean)this.field_6011.method_12789(DATA_CAN_RENDER);
    }

    public int getAge() {
        return (Integer)this.field_6011.method_12789(DATA_AGE);
    }

    public State getState() {
        return (State)((Object)this.field_6011.method_12789(DATA_STATE));
    }

    public int getShieldHealth() {
        return (Integer)this.field_6011.method_12789(DATA_SHIELD_HEALTH);
    }

    public void setShieldHealth(int health) {
        this.field_6011.method_12778(DATA_SHIELD_HEALTH, (Object)health);
    }

    public Skin getSkin() {
        return (Skin)((Object)this.field_6011.method_12789(DATA_SKIN));
    }

    public void setSkin(Skin skin) {
        this.field_6011.method_12778(DATA_SKIN, (Object)skin);
    }

    public void setCosmeticMode(String id) {
        this.setSkin(Skin.fromId(id));
    }

    public boolean getSkinValidation() {
        return (Boolean)this.field_6011.method_12789(DATA_SKIN_VALIDATION);
    }

    public void setSkinValidation(boolean v) {
        this.field_6011.method_12778(DATA_SKIN_VALIDATION, (Object)v);
    }

    public void setSourceStack(class_1799 stack) {
        this.sourceStack = stack.method_7972();
    }

    public class_1799 getSourceStack() {
        return this.sourceStack;
    }

    private void maybeDropScrapOnUsedUp() {
        if (!this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            return;
        }
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.sourceStack.method_7960()) {
            return;
        }
        if (class_1890.method_8225((class_1887)DNLEnchantments.BREAK_PROTECTION.get(), (class_1799)this.sourceStack) <= 0) {
            return;
        }
        class_1799 original = this.sourceStack.method_7972();
        original.method_7974(original.method_7936());
        class_1799 scrap = ScrapItem.ofOriginal(original);
        this.method_5775(scrap);
    }

    public static enum State {
        SETUP,
        IDLE;

    }

    public static enum Skin {
        DEFAULT("default"),
        GOLDEN("golden");

        public final String id;

        private Skin(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static Skin fromId(String id) {
            for (Skin s : Skin.values()) {
                if (!s.id.equalsIgnoreCase(id)) continue;
                return s;
            }
            return DEFAULT;
        }
    }
}

