/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.projectile;

import dev.hexnowloading.dungeonnowloading.entity.util.ProjectileUtils;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;

public class BorusArrowEntity
extends class_1665 {
    private final int DAMAGE = 10;
    private final int MAX_BLOCK_PENETRATION = 3;
    private final float KNOCKBACK = 3.0f;
    private final int DECELERATION_TICK = 2;
    private int arrowPhase;
    private int blockBreakCount;
    private class_243 constantDeltaMovement;

    public BorusArrowEntity(class_1299<? extends class_1665> entityType, class_1937 level) {
        super(entityType, level);
        this.constantDeltaMovement = class_243.field_1353;
        this.blockBreakCount = 0;
        this.arrowPhase = 0;
    }

    public BorusArrowEntity(class_1309 owner, class_1937 level) {
        super(DNLEntityTypes.BORUS_ARROW.get(), owner, level);
        this.method_7432((class_1297)owner);
        this.constantDeltaMovement = class_243.field_1353;
        this.blockBreakCount = 0;
        this.arrowPhase = 0;
    }

    public void method_5773() {
        ProjectileUtils.checkAndUnloadProjectile((class_1297)this);
        if (this.field_6012 > 100) {
            this.method_31472();
        }
        if (this.arrowPhase == 0) {
            this.method_5875(true);
            this.moving(1.0f);
        } else if (this.arrowPhase >= 1 && this.arrowPhase < 3) {
            this.moving(0.5f);
            ++this.arrowPhase;
        } else {
            this.method_5875(false);
        }
        super.method_5773();
    }

    private void moving(float scale) {
        if (this.field_6012 <= 1) {
            this.constantDeltaMovement = this.method_18798();
        } else {
            this.method_18799(this.constantDeltaMovement.method_1021((double)scale));
        }
    }

    protected class_1799 method_7445() {
        return null;
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        if (this.blockBreakCount >= 3) {
            return;
        }
        class_2680 blockState = this.method_37908().method_8320(blockHitResult.method_17777());
        if (!blockState.method_26164(class_3481.field_17754)) {
            if (!this.method_37908().field_9236) {
                this.method_37908().method_22352(blockHitResult.method_17777(), true);
            }
            this.method_18799(this.constantDeltaMovement);
            ++this.blockBreakCount;
            if (this.blockBreakCount >= 3) {
                ++this.arrowPhase;
            }
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1282 damageSource;
        int damage;
        if (this.method_37908().field_9236) {
            return;
        }
        class_1297 target = entityHitResult.method_17782();
        class_1297 owner = this.method_24921();
        if (owner instanceof class_1309) {
            class_1309 livingEntity = (class_1309)owner;
            v0 = (int)livingEntity.method_26825(class_5134.field_23721);
        } else {
            v0 = damage = 10;
        }
        if (owner == null) {
            damageSource = this.method_48923().method_48803((class_1665)this, (class_1297)this);
        } else {
            damageSource = this.method_48923().method_48803((class_1665)this, owner);
            if (owner instanceof class_1309 && target instanceof class_1309) {
                ((class_1309)owner).method_6015((class_1309)target);
            }
        }
        boolean isEnderman = target.method_5864() == class_1299.field_6091;
        int fireTick = target.method_20802();
        if (this.method_5809() && !isEnderman) {
            target.method_5639(15);
        }
        if (target.method_5643(damageSource, (float)damage)) {
            if (isEnderman) {
                return;
            }
            if (target instanceof class_1309) {
                class_1657 player;
                class_1309 livingEntity = (class_1309)target;
                double knockback = Math.max(0.0, 1.0 - livingEntity.method_26825(class_5134.field_23718));
                class_243 vec3 = this.method_18798().method_18805(1.0, 0.0, 1.0).method_1029().method_1021(1.7999999999999998 * knockback);
                if (vec3.method_1027() > 0.0) {
                    livingEntity.method_5762(vec3.field_1352, 0.1, vec3.field_1350);
                }
                if (livingEntity instanceof class_1657 && (player = (class_1657)livingEntity).method_6039()) {
                    player.method_7284(true);
                }
                if (!this.method_37908().field_9236 && owner instanceof class_1309) {
                    class_1890.method_8210((class_1309)livingEntity, (class_1297)owner);
                    class_1890.method_8213((class_1309)((class_1309)owner), (class_1297)livingEntity);
                }
            }
            this.method_5783(class_3417.field_15151, 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
        } else {
            target.method_20803(fireTick);
        }
    }
}

