/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.projectile;

import dev.hexnowloading.dungeonnowloading.entity.boss.ChaosSpawnerEntity;
import dev.hexnowloading.dungeonnowloading.entity.passive.SealedChaosEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.ProjectileUtils;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_5712;

public class ChaosSpawnerProjectileEntity
extends class_1297 {
    private UUID ownerUUID;
    private class_1297 cachedOwner;
    private boolean leftOwner;
    private boolean hasBeenShot;
    public double xPower;
    public double yPower;
    public double zPower;
    private final float INERTIA = 1.0f;
    private final class_2394 SPAWN_PARTICLE = class_2398.field_11203;
    private final class_2394 TRAIL_PARTICLE = class_2398.field_11216;

    public ChaosSpawnerProjectileEntity(class_1299<? extends ChaosSpawnerProjectileEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    public ChaosSpawnerProjectileEntity(double x, double y, double z, double xP, double yP, double zP, class_1937 level) {
        this(DNLEntityTypes.CHAOS_SPAWNER_PROJECTILE.get(), level);
        this.method_5808(x, y, z, this.method_36454(), this.method_36455());
        this.method_23311();
        double d0 = Math.sqrt(xP * xP + yP * yP + zP * zP);
        if (d0 != 0.0) {
            this.xPower = xP / d0 * 0.1;
            this.yPower = yP / d0 * 0.1;
            this.zPower = zP / d0 * 0.1;
        }
    }

    public ChaosSpawnerProjectileEntity(class_1309 owner, double xP, double yP, double zP) {
        this(owner.method_23317(), owner.method_23318(), owner.method_23321(), xP, yP, zP, owner.method_37908());
        this.setOwner((class_1297)owner);
        this.method_5710(owner.method_36454(), owner.method_36455());
    }

    public void method_5773() {
        ProjectileUtils.checkAndUnloadProjectile(this);
        if (!this.hasBeenShot) {
            this.method_32875(class_5712.field_28161, this.getOwner());
            this.hasBeenShot = true;
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        if (this.field_6012 > 400) {
            this.method_5650(class_1297.class_5529.field_26999);
        } else {
            class_1297 owner = this.getOwner();
            if (this.method_37908().field_9236 || (owner == null || !owner.method_31481()) && this.method_37908().method_22340(this.method_24515())) {
                super.method_5773();
                class_239 hitResult = class_1675.method_49997((class_1297)this, this::canHitEntity);
                if (hitResult.method_17783() != class_239.class_240.field_1333) {
                    this.onHit(hitResult);
                }
                this.method_5852();
                class_243 deltaMovement = this.method_18798();
                double d0 = this.method_23317() + deltaMovement.field_1352;
                double d1 = this.method_23318() + deltaMovement.field_1351;
                double d2 = this.method_23321() + deltaMovement.field_1350;
                float inertia = this.INERTIA;
                this.method_18799(deltaMovement.method_1031(this.xPower, this.yPower, this.zPower).method_1021((double)inertia));
                this.method_37908().method_8406(this.TRAIL_PARTICLE, d0, d1 + 0.5, d2, 0.0, 0.0, 0.0);
                this.method_5814(d0, d1, d2);
                class_1675.method_7484((class_1297)this, (float)1.0f);
                if (this.field_6012 == 3) {
                    for (int i = 0; i < 5; ++i) {
                        this.method_37908().method_8406(this.SPAWN_PARTICLE, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
                    }
                }
            } else {
                this.method_31472();
            }
        }
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        class_243 vector3d = new class_243(x, y, z).method_1029().method_1031(this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy).method_1021((double)velocity);
        this.method_18799(vector3d);
        float f = class_3532.method_15355((float)((float)vector3d.method_37268()));
        this.method_36456((float)(class_3532.method_15349((double)vector3d.field_1352, (double)vector3d.field_1350) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)vector3d.field_1351, (double)f) * 57.2957763671875));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    protected void onHit(class_239 hitResult) {
        class_239.class_240 hitresult$type = hitResult.method_17783();
        if (hitresult$type == class_239.class_240.field_1331) {
            this.onHitEntity((class_3966)hitResult);
            this.method_37908().method_32888(class_5712.field_28162, hitResult.method_17784(), class_5712.class_7397.method_43286((class_1297)this, (class_2680)null));
        } else if (hitresult$type == class_239.class_240.field_1332) {
            class_3965 blockhitresult = (class_3965)hitResult;
            this.onHitBlock(blockhitresult);
            class_2338 blockpos = blockhitresult.method_17777();
            this.method_37908().method_43276(class_5712.field_28162, blockpos, class_5712.class_7397.method_43286((class_1297)this, (class_2680)this.method_37908().method_8320(blockpos)));
        }
    }

    protected void onHitEntity(class_3966 entityHitResult) {
        if (!this.method_37908().field_9236) {
            boolean entityHurted;
            int damageAmount;
            class_1297 target = entityHitResult.method_17782();
            class_1297 owner = this.getOwner();
            if (owner instanceof ChaosSpawnerEntity && target instanceof class_1309) {
                damageAmount = 1;
                if (this.getOwner() instanceof ChaosSpawnerEntity) {
                    damageAmount = (int)(((ChaosSpawnerEntity)owner).getAttackDamage() * 0.5);
                }
                entityHurted = target.method_5643(this.method_48923().method_48800((class_1297)this, (class_1309)owner), (float)damageAmount);
                if (target instanceof class_1657) {
                    class_1657 player = (class_1657)target;
                    player.method_7284(player.method_6039());
                }
                if (entityHurted && target.method_5805()) {
                    this.method_5723((class_1309)owner, target);
                }
            }
            if (owner instanceof SealedChaosEntity) {
                if (target instanceof SealedChaosEntity) {
                    if (((SealedChaosEntity)owner).method_6139() != ((SealedChaosEntity)target).method_6139()) {
                        damageAmount = (int)((SealedChaosEntity)owner).method_26825(class_5134.field_23721);
                        entityHurted = target.method_5643(this.method_48923().method_48800((class_1297)this, (class_1309)this.getOwner()), (float)damageAmount);
                        if (entityHurted && target.method_5805()) {
                            this.method_5723((class_1309)owner, target);
                        }
                    }
                } else if (target instanceof class_1309) {
                    if (((SealedChaosEntity)owner).method_6139() != target.method_5667()) {
                        damageAmount = (int)((SealedChaosEntity)owner).method_26825(class_5134.field_23721);
                        entityHurted = target.method_5643(this.method_48923().method_48800((class_1297)this, (class_1309)this.getOwner()), (float)damageAmount);
                        if (entityHurted && target.method_5805()) {
                            this.method_5723((class_1309)owner, target);
                        }
                    }
                } else {
                    damageAmount = (int)((SealedChaosEntity)owner).method_26825(class_5134.field_23721);
                    entityHurted = target.method_5643(this.method_48923().method_48800((class_1297)this, (class_1309)this.getOwner()), (float)damageAmount);
                    if (entityHurted && target.method_5805()) {
                        this.method_5723((class_1309)owner, target);
                    }
                }
            }
        }
    }

    protected void onHitBlock(class_3965 blockHitResult) {
    }

    protected boolean canHitEntity(class_1297 entity) {
        if (!entity.field_5960) {
            if (!entity.method_49108()) {
                return false;
            }
            class_1297 owner = this.getOwner();
            if (owner instanceof SealedChaosEntity) {
                return true;
            }
            return owner == null || this.leftOwner || !owner.method_5794(entity);
        }
        return false;
    }

    public class_2596<class_2602> method_18002() {
        class_1297 entity = this.getOwner();
        int i = entity == null ? 0 : entity.method_5628();
        int n = this.method_5628();
        UUID uUID = this.method_5667();
        double d = this.method_23317();
        double d2 = this.method_23318();
        double d3 = this.method_23321();
        float f = this.method_36455();
        float f2 = this.method_36454();
        class_1299 class_12992 = this.method_5864();
        class_243 class_2432 = this.method_18798();
        Objects.requireNonNull(this);
        return new class_2604(n, uUID, d, d2, d3, f, f2, class_12992, i, new class_243(class_2432.method_1021(1.0).method_46409()), 0.0);
    }

    @Nullable
    public class_1297 getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.method_31481()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.method_37908() instanceof class_3218) {
            this.cachedOwner = ((class_3218)this.method_37908()).method_14190(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void setOwner(@Nullable class_1297 entity) {
        if (entity != null) {
            this.ownerUUID = entity.method_5667();
            this.cachedOwner = entity;
        }
    }

    private boolean checkLeftOwner() {
        class_1297 entity = this.getOwner();
        if (entity != null) {
            for (class_1297 entity1 : this.method_37908().method_8333((class_1297)this, this.method_5829().method_18804(this.method_18798()).method_1014(1.0), p_37272_ -> !p_37272_.method_7325() && p_37272_.method_5863())) {
                if (entity1.method_5668() != entity.method_5668()) continue;
                return false;
            }
        }
        return true;
    }

    public void method_5750(double x, double y, double z) {
        this.method_18800(x, y, z);
        if (this.field_6004 == 0.0f && this.field_5982 == 0.0f) {
            float f = class_3532.method_15355((float)((float)(x * x + z * z)));
            this.method_36457((float)(class_3532.method_15349((double)y, (double)f) * 57.2957763671875));
            this.method_36456((float)(class_3532.method_15349((double)x, (double)z) * 57.2957763671875));
            this.field_6004 = this.method_36455();
            this.field_5982 = this.method_36454();
            this.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
        }
    }

    public boolean method_5640(double distance) {
        double d0 = this.method_5829().method_995() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void method_31471(class_2604 clientboundAddEntityPacket) {
        super.method_31471(clientboundAddEntityPacket);
        double d0 = clientboundAddEntityPacket.method_11170();
        double d1 = clientboundAddEntityPacket.method_11172();
        double d2 = clientboundAddEntityPacket.method_11173();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        if (d3 != 0.0) {
            this.xPower = d0 / d3 * 0.1;
            this.yPower = d1 / d3 * 0.1;
            this.zPower = d2 / d3 * 0.1;
        }
    }

    protected void method_5693() {
    }

    protected void method_5749(class_2487 compoundTag) {
        class_2499 listtag;
        if (this.ownerUUID != null) {
            compoundTag.method_25927("Owner", this.ownerUUID);
        }
        if (this.leftOwner) {
            compoundTag.method_10556("LeftOwner", true);
        }
        compoundTag.method_10556("HasBeenShot", this.hasBeenShot);
        if (compoundTag.method_10573("power", 9) && (listtag = compoundTag.method_10554("power", 6)).size() == 3) {
            this.xPower = listtag.method_10611(0);
            this.yPower = listtag.method_10611(1);
            this.zPower = listtag.method_10611(2);
        }
    }

    protected void method_5652(class_2487 compoundTag) {
        if (compoundTag.method_25928("Owner")) {
            this.ownerUUID = compoundTag.method_25926("Owner");
            this.cachedOwner = null;
        }
        this.leftOwner = compoundTag.method_10577("LeftOwner");
        this.hasBeenShot = compoundTag.method_10577("HasBeenShot");
        compoundTag.method_10566("power", (class_2520)this.method_5846(new double[]{this.xPower, this.yPower, this.zPower}));
    }
}

