/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.projectile;

import dev.hexnowloading.dungeonnowloading.components.VertexNode;
import dev.hexnowloading.dungeonnowloading.potion.VertexTransmissionEffect;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLMobEffects;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.util.DNLMath;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3419;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;

public class VertexArrowProjectileEntity
extends class_1665 {
    private int powerLevel = 0;
    private VertexNode vertexNode = new VertexNode((class_1297)this);
    private int powerIncrementTimer = 0;
    private int life;
    private static final class_2940<Integer> POWER_LEVEL = class_2945.method_12791(VertexArrowProjectileEntity.class, (class_2941)class_2943.field_13327);
    private static final int ENTITY_DIRECT_HIT_EFFECT_DURATION_TICKS = 120;
    private static final int ADVANCE_POWER_LEVEL_THRESHOLD_TICKS = 8;
    private static final int MAX_POWER_LEVEL = 3;
    private static final int DESPAWN_TIME_TICKS = 400;

    public VertexArrowProjectileEntity(class_1299 entityType, class_1937 level) {
        super(entityType, level);
    }

    public VertexArrowProjectileEntity(class_1937 level, class_1309 shooter) {
        super(DNLEntityTypes.VERTEX_ARROW_PROJECTILE.get(), shooter, level);
    }

    public int getPowerLevel() {
        return (Integer)this.field_6011.method_12789(POWER_LEVEL);
    }

    public boolean isFullyPowered() {
        return this.powerLevel == 3;
    }

    public VertexNode getVertexNode() {
        return this.vertexNode;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(POWER_LEVEL, (Object)0);
    }

    public void method_5652(@NotNull class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10569("powerLevel", ((Integer)this.field_6011.method_12789(POWER_LEVEL)).intValue());
    }

    public void method_5749(@NotNull class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.field_6011.method_12778(POWER_LEVEL, (Object)compoundTag.method_10550("powerLevel"));
    }

    protected void method_7446() {
        ++this.life;
        if (this.life >= 400) {
            this.vertexNode.disconnect_all();
            this.method_31472();
        }
    }

    protected class_1799 method_7445() {
        return class_1799.field_8037;
    }

    protected void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        class_1297 class_12972 = entityHitResult.method_17782();
        if (class_12972 instanceof class_1309) {
            class_1309 entity = (class_1309)class_12972;
            int slownessDurationTicks = 120;
            int slownessAmplifier = this.vertexNode.getConnectionCount();
            int vertexTransDurationTicks = 120;
            int vertexTransAmplifier = 0;
            entity.method_6092(new class_1293(class_1294.field_5909, slownessDurationTicks, slownessAmplifier));
            boolean entityHasEffect = entity.method_6059(DNLMobEffects.VERTEX_TRANSMISSION.get());
            if (!entityHasEffect) {
                entity.method_6092(new class_1293(DNLMobEffects.VERTEX_TRANSMISSION.get(), vertexTransDurationTicks, vertexTransAmplifier));
            } else {
                entity.method_6092(new class_1293(DNLMobEffects.VERTEX_TRANSMISSION.get(), vertexTransDurationTicks, vertexTransAmplifier));
                VertexTransmissionEffect vertexTransmissionEffect = (VertexTransmissionEffect)entity.method_6112(DNLMobEffects.VERTEX_TRANSMISSION.get()).method_5579();
                vertexTransmissionEffect.markAsReconnectionCase(entity.method_5667());
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        if (!this.field_7588) {
            this.vertexNode.disconnect_all();
            this.powerIncrementTimer = 0;
            this.powerLevel = 0;
            this.field_6011.method_12778(POWER_LEVEL, (Object)0);
        } else {
            if (this.powerLevel == 0 && this.powerIncrementTimer == 0) {
                this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), DNLSounds.VERTEX_ARROW_BOOTUP.get(), class_3419.field_15248, 1.0f, 1.2f / (DNLMath.randomRange(0.0f, 1.0f) * 0.2f + 0.9f));
            }
            if (this.powerLevel < 3) {
                ++this.powerIncrementTimer;
                if (this.powerIncrementTimer >= 8) {
                    ++this.powerLevel;
                    this.field_6011.method_12778(POWER_LEVEL, (Object)this.powerLevel);
                    this.powerIncrementTimer = 0;
                }
            } else if (!this.method_37908().field_9236 && !this.vertexNode.attemptedConnection() && this.life != 400) {
                this.vertexNode.connectToNearbyNodes((class_1297)this);
            }
        }
        this.vertexNode.tick((class_1297)this);
    }
}

