/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.projectile;

import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.entity.util.ModelledProjectileEntity;
import dev.hexnowloading.dungeonnowloading.particle.type.AxisParticleType;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import dev.hexnowloading.dungeonnowloading.util.DNLLevelUtil;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import net.minecraft.class_8111;
import org.joml.Vector3f;

public class VertexDomainProjectileEntity
extends ModelledProjectileEntity {
    private static final class_2940<Integer> HURT_TIME = class_2945.method_12791(VertexDomainProjectileEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> HURT_TIME_DIRECT = class_2945.method_12791(VertexDomainProjectileEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> DAMAGE = class_2945.method_12791(VertexDomainProjectileEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Vector3f> VELOCITY = class_2945.method_12791(VertexDomainProjectileEntity.class, (class_2941)class_2943.field_42237);
    private static final class_2940<VertexDomainAnimationState> ANIMATION_STATE = class_2945.method_12791(VertexDomainProjectileEntity.class, EntityStates.VERTEX_DOMAIN_ANIMATION_STATE);
    private static final class_2940<Integer> DYING_TICK = class_2945.method_12791(VertexDomainProjectileEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> GROUND_COLLISION = class_2945.method_12791(VertexDomainProjectileEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> RADIUS = class_2945.method_12791(VertexDomainProjectileEntity.class, (class_2941)class_2943.field_13327);
    public final class_7094 spinAnimationState = new class_7094();
    public final class_7094 impactAnimationState = new class_7094();
    public final class_7094 idleAnimationState = new class_7094();
    private static final int BASE_DAMAGE = 20;
    private static final int SLOWNESS_AMPLIFIER = 4;
    private static final int SLOWNESS_DURATION = 100;
    public static final int DURATION_ON_GROUND = 1200;
    private static final float BASE_HEALTH = 100.0f;
    private static final int RANGE = 7;
    private static final double BEAM_INITIAL_PARTICLE_SPACING = 0.5;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MIN = 0.2f;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MAX = 0.4f;
    private double xPower;
    private double yPower;
    private double zPower;
    private int life;
    private float health = 100.0f;
    private boolean hasAppliedMovement;
    private boolean delayTick;
    private boolean explosionImmune;
    private int impactAnimationTimeOut;
    private int expansionTick;
    public static final int IMPACT_ANIMATION_DURATION = 5;
    public static final int EXPANSION_DURATION = 20;

    public VertexDomainProjectileEntity(class_1299<? extends VertexDomainProjectileEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    public VertexDomainProjectileEntity(class_1937 level, class_1309 owner, float health) {
        this((class_1299<? extends VertexDomainProjectileEntity>)DNLEntityTypes.VERTEX_DOMAIN_PROJECTILE.get(), level);
        this.setOwner((class_1297)owner);
        this.health = health;
        this.setRadius(7);
        this.setDyingTick(0);
    }

    @Override
    protected void method_5749(class_2487 compoundTag) {
        class_2499 listTag;
        super.method_5749(compoundTag);
        if (compoundTag.method_10573("power", 9) && (listTag = compoundTag.method_10554("power", 6)).size() == 3) {
            this.xPower = listTag.method_10611(0);
            this.yPower = listTag.method_10611(1);
            this.zPower = listTag.method_10611(2);
        }
        if (compoundTag.method_10573("life", 3)) {
            this.life = compoundTag.method_10550("life");
        }
        if (compoundTag.method_10573("health", 5)) {
            this.health = compoundTag.method_10583("health");
        }
    }

    @Override
    protected void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10566("power", (class_2520)this.method_5846(new double[]{this.xPower, this.yPower, this.zPower}));
        compoundTag.method_10569("life", this.life);
        compoundTag.method_10548("health", this.health);
    }

    protected void method_5693() {
        this.field_6011.method_12784(HURT_TIME, (Object)0);
        this.field_6011.method_12784(HURT_TIME_DIRECT, (Object)1);
        this.field_6011.method_12784(DAMAGE, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(VELOCITY, (Object)class_243.field_1353.method_46409());
        this.field_6011.method_12784(ANIMATION_STATE, (Object)VertexDomainAnimationState.IDLE);
        this.field_6011.method_12784(DYING_TICK, (Object)0);
        this.field_6011.method_12784(GROUND_COLLISION, (Object)false);
        this.field_6011.method_12784(RADIUS, (Object)0);
    }

    @Override
    protected void tickProjectile() {
        if (this.getDyingTick() > 0) {
            this.setDyingTick(this.getDyingTick() - 1);
            if (this.getDyingTick() <= 0) {
                this.method_31472();
            }
            return;
        }
        if (!this.hasAppliedMovement) {
            if (!this.method_37908().field_9236) {
                this.method_18800(this.xPower, this.yPower, this.zPower);
                this.setVelocity(new class_243(this.xPower, this.yPower, this.zPower));
            } else {
                double d = this.getVelocity().x * this.getVelocity().x + this.getVelocity().y * this.getVelocity().y + this.getVelocity().z * this.getVelocity().z;
                if (!this.delayTick && d < 1.0E-7) {
                    this.delayTick = true;
                    return;
                }
                this.method_18799(new class_243((double)this.getVelocity().x, (double)this.getVelocity().y, (double)this.getVelocity().z));
            }
            this.transitionTo(VertexDomainAnimationState.SPIN);
            this.hasAppliedMovement = true;
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        this.method_5852();
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (this.life <= 0) {
            for (int i = 0; i < 5; ++i) {
                double offsetX = (Math.random() - 0.5) * 2.0;
                double offsetY = (Math.random() - 0.5) * 2.0;
                double offsetZ = (Math.random() - 0.5) * 2.0;
                this.method_37908().method_8406((class_2394)class_2390.field_11188, this.method_23317() + offsetX, this.method_23318() + offsetY + (double)(this.method_17682() * 0.5f), this.method_23321() + offsetZ, 0.0, 0.0, 0.0);
            }
        }
        if ((this.method_24828() || this.field_5976) && this.life <= 0) {
            this.life = 1200;
            this.transitionTo(VertexDomainAnimationState.IMPACT);
            this.expansionTick = 20;
            if (!this.method_37908().field_9236) {
                this.field_6011.method_12778(GROUND_COLLISION, (Object)this.method_24828());
            }
            this.impactDamage();
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14816, this.method_5634(), 3.0f, 2.0f);
        }
        if (this.life > 0) {
            --this.life;
            if (this.expansionTick > 0) {
                --this.expansionTick;
            }
            this.applyEffect();
            if (this.life > 50) {
                this.spawnRedstoneParticle();
            }
            if (!(this.method_37908().field_9236 || this.life > 0 && ((Boolean)this.field_6011.method_12789(GROUND_COLLISION)).booleanValue() && !this.method_37908().method_8320(this.method_24515().method_10074()).method_26215())) {
                this.method_5650(class_1297.class_5529.field_26999);
            }
        }
        this.animationControl();
        if (this.life <= 0) {
            int DESTRUCTION_RANGE = 2;
            this.blockDestructionTick(-DESTRUCTION_RANGE, DESTRUCTION_RANGE, -1, 3, -DESTRUCTION_RANGE, DESTRUCTION_RANGE);
        }
    }

    private void applyEffect() {
        class_1937 level = this.method_37908();
        if (level.field_9236) {
            return;
        }
        int r = this.getRadius();
        class_238 effectBox = new class_238(this.method_23317() - (double)r, this.method_23318() - (double)r, this.method_23321() - (double)r, this.method_23317() + (double)r, this.method_23318() + (double)r, this.method_23321() + (double)r);
        List entities = this.method_37908().method_18467(class_1309.class, effectBox);
        for (class_1309 entity : entities) {
            if (entity instanceof FairkeeperSerpentEntity || !this.applyDamage((class_1297)entity, 20, 0.6f)) continue;
            entity.method_6092(new class_1293(class_1294.field_5909, 100, 4));
            this.spawnRedstoneBeamParticle((class_3218)level, entity);
        }
    }

    private void spawnInitialRedstoneParticles() {
        float particleScale = 0.2f + (float)Math.random() * 0.2f;
        ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), particleScale);
        for (int i = 0; i < 10; ++i) {
            this.method_37908().method_8406((class_2394)particleData, this.method_23317() + (double)(2.0f * (this.method_37908().method_8409().method_43057() - this.method_37908().method_8409().method_43057())), this.method_23318() + (double)(2.0f * (this.method_37908().method_8409().method_43057() - this.method_37908().method_8409().method_43057())), this.method_23321() + (double)(2.0f * (this.method_37908().method_8409().method_43057() - this.method_37908().method_8409().method_43057())), 0.0, 0.0, 0.0);
        }
        this.method_37908().method_8406((class_2394)class_2398.field_11236, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
    }

    private void spawnRedstoneParticle() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        if (this.method_37908().method_8409().method_43057() > 0.3f) {
            return;
        }
        int radius = this.getRadius();
        class_243 center = this.method_19538();
        double centerX = center.field_1352;
        double centerY = center.field_1351 - 0.5;
        double centerZ = center.field_1350;
        int side = this.method_37908().method_8409().method_43048(4);
        double x = centerX;
        double z = centerZ;
        float angleToSide = 0.0f;
        switch (side) {
            case 0: {
                x = centerX + (double)radius + 0.49;
                z = centerZ - (double)radius + this.method_37908().method_8409().method_43058() * (double)(radius * 2);
                angleToSide = 270.0f;
                break;
            }
            case 1: {
                x = centerX - (double)radius - 0.49;
                z = centerZ - (double)radius + this.method_37908().method_8409().method_43058() * (double)(radius * 2);
                angleToSide = 90.0f;
                break;
            }
            case 2: {
                z = centerZ + (double)radius + 0.49;
                x = centerX - (double)radius + this.method_37908().method_8409().method_43058() * (double)(radius * 2);
                angleToSide = 180.0f;
                break;
            }
            case 3: {
                z = centerZ - (double)radius - 0.49;
                x = centerX - (double)radius + this.method_37908().method_8409().method_43058() * (double)(radius * 2);
                angleToSide = 360.0f;
            }
        }
        angleToSide = (angleToSide + 360.0f) % 360.0f;
        serverLevel.method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.VERTEX_BOUNDARY_PARTICLE.get(), 1, angleToSide), x, centerY, z, 1, 0.0, 0.02, 0.0, 0.0);
    }

    public void method_18799(class_243 vec31) {
        class_243 vec3 = vec31;
        if (((Boolean)this.field_6011.method_12789(GROUND_COLLISION)).booleanValue()) {
            vec3 = class_243.field_1353;
        }
        super.method_18799(vec3);
    }

    private void impactDamage() {
        float particleScale = 0.2f + (float)Math.random() * 0.2f;
        ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), particleScale);
        for (int i = 0; i < 30; ++i) {
            this.method_37908().method_8406((class_2394)particleData, this.method_23317() + (double)(6.0f * (this.method_37908().method_8409().method_43057() - this.method_37908().method_8409().method_43057())), this.method_23318() + (double)(6.0f * (this.method_37908().method_8409().method_43057() - this.method_37908().method_8409().method_43057())), this.method_23321() + (double)(6.0f * (this.method_37908().method_8409().method_43057() - this.method_37908().method_8409().method_43057())), 0.0, 0.0, 0.0);
        }
        this.explosionImmune = true;
        if (!this.method_37908().field_9236) {
            this.method_37908().method_8437(null, this.method_23317(), this.method_23318(), this.method_23321(), 6.0f, class_1937.class_7867.field_40888);
        }
        this.explosionImmune = false;
    }

    private void blockDestructionTick(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        if (this.method_37908().field_9236) {
            return;
        }
        for (int ix = minX; ix <= maxX; ++ix) {
            for (int iz = minZ; iz <= maxZ; ++iz) {
                for (int iy = minY; iy <= maxY; ++iy) {
                    int dx = this.method_31477() + ix;
                    int dy = this.method_31478() + iy;
                    int dz = this.method_31479() + iz;
                    class_2338 blockPos = new class_2338(dx, dy, dz);
                    class_2680 blockState = this.method_37908().method_8320(blockPos);
                    if (blockState.method_26215() || blockState.method_26164(class_3481.field_17754) || blockState.method_26164(DNLTags.TORCH_BLOCKS)) continue;
                    DNLLevelUtil.destroyBlockMulti(this.method_37908(), blockPos, false, this, 3);
                }
            }
        }
    }

    private void animationControl() {
        if (!this.method_37908().field_9236) {
            return;
        }
        if (this.impactAnimationTimeOut-- > 0 && this.impactAnimationTimeOut <= 0) {
            this.transitionTo(VertexDomainAnimationState.IDLE);
        }
        if (this.impactAnimationState.method_41327() && this.impactAnimationTimeOut <= 0) {
            this.impactAnimationTimeOut = 5;
        }
    }

    @Override
    protected void onHitEntity(class_3966 entityHitResult) {
        this.applyDamage(entityHitResult.method_17782(), 20, 1.0f);
    }

    private boolean applyDamage(class_1297 targetEntity, int baseDamage, float ownerAttackPercentage) {
        class_1297 class_12972;
        class_1309 owner = null;
        int damage = baseDamage;
        if (this.method_24921() != null && (class_12972 = this.method_24921()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            damage = (int)(livingEntity.method_26825(class_5134.field_23721) * (double)ownerAttackPercentage);
            owner = livingEntity;
        }
        if (targetEntity instanceof class_1309) {
            class_1309 target = (class_1309)targetEntity;
            return target.method_5643(this.method_37908().method_48963().method_48800((class_1297)this, owner), (float)damage);
        }
        return false;
    }

    private void spawnRedstoneBeamParticle(class_3218 level, class_1309 target) {
        class_243 start = this.method_19538().method_1031(0.0, this.method_5829().method_17940() / 2.0, 0.0);
        class_243 end = target.method_19538().method_1031(0.0, (double)target.method_17682() * 0.5, 0.0);
        class_243 direction = end.method_1020(start);
        double distance = direction.method_1033();
        double stepSize = 0.5;
        int particleCount = (int)(distance / stepSize);
        class_243 step = direction.method_1029().method_1021(stepSize);
        float particleScale = 0.2f + (float)Math.random() * 0.2f;
        ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), particleScale);
        for (int i = 0; i <= particleCount; ++i) {
            class_243 particlePos = start.method_1019(step.method_1021((double)i));
            level.method_14199((class_2394)particleData, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            level.method_14199((class_2394)class_2390.field_11188, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void outlineCauseBlock(class_3218 level, class_2338 blockPos) {
        double x = (double)blockPos.method_10263() + 0.5;
        double y = (double)blockPos.method_10264() + 0.5;
        double z = (double)blockPos.method_10260() + 0.5;
        level.method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 270.0f), (double)((float)blockPos.method_10263() + 1.1f), y, z, 1, 0.0, 0.0, 0.0, 0.0);
        level.method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 90.0f), (double)((float)blockPos.method_10263() - 0.1f), y, z, 1, 0.0, 0.0, 0.0, 0.0);
        level.method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 0, 90.0f), x, (double)((float)blockPos.method_10264() + 1.1f), z, 1, 0.0, 0.0, 0.0, 0.0);
        level.method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 0, 270.0f), x, (double)((float)blockPos.method_10264() - 0.1f), z, 1, 0.0, 0.0, 0.0, 0.0);
        level.method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 180.0f), x, y, (double)((float)blockPos.method_10260() + 1.1f), 1, 0.0, 0.0, 0.0, 0.0);
        level.method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 0.0f), x, y, (double)((float)blockPos.method_10260() - 0.1f), 1, 0.0, 0.0, 0.0, 0.0);
    }

    public void spawnBoundaryParticles(int radius) {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        double centerX = (float)class_3532.method_15357((double)this.method_23317()) + 0.5f;
        double centerY = (float)class_3532.method_15357((double)this.method_23318()) + 0.5f;
        double centerZ = (float)class_3532.method_15357((double)this.method_23321()) + 0.5f;
        double halfSize = (float)radius - 0.5f;
        double minX = centerX - halfSize;
        double maxX = centerX + halfSize;
        double minY = centerY - halfSize;
        double maxY = centerY + halfSize;
        double minZ = centerZ - halfSize;
        double maxZ = centerZ + halfSize;
        float xy = (float)(1.0 - (double)((float)(maxX - minX)) * (maxY - minY) / 1024.0);
        float xz = (float)(1.0 - (double)((float)(maxX - minX)) * (maxZ - minZ) / 1024.0);
        float yz = (float)(1.0 - (double)((float)(maxY - minY)) * (maxZ - minZ) / 1024.0);
        double x = minX + (maxX - minX) * (double)this.method_37908().field_9229.method_43057();
        double y = minY + (maxY - minY) * (double)this.method_37908().field_9229.method_43057();
        double z = minZ + (maxZ - minZ) * (double)this.method_37908().field_9229.method_43057();
        float r = this.method_37908().field_9229.method_43057();
        if (r + 0.2f > yz) {
            serverLevel.method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 90.0f), minX + (double)((this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.1f), y, z, 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 270.0f), maxX + (double)((this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.1f), y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (r + 0.2f > xz) {
            serverLevel.method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 0, 270.0f), x, minY + (double)((this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.1f), z, 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 0, 90.0f), x, maxY + (double)((this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.1f), z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (r + 0.2f > xy) {
            serverLevel.method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 0.0f), x, y, minZ + (double)((this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.1f), 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 180.0f), x, y, maxZ + (double)((this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.1f), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public boolean method_30949(class_1297 entity) {
        return entity.method_30948() || entity.method_5810();
    }

    public boolean method_30948() {
        return this.getDyingTick() <= 0;
    }

    public boolean method_5810() {
        return false;
    }

    public void method_5697(class_1297 $$0) {
    }

    public void method_5762(double $$0, double $$1, double $$2) {
    }

    public boolean method_5679(class_1282 damageSource) {
        if (damageSource.method_49708(class_8111.field_42331)) {
            return true;
        }
        return super.method_5679(damageSource);
    }

    public boolean method_5675() {
        return false;
    }

    public void shootTowardsTarget(double x, double y, double z, class_1309 target, float speed, float inaccuracy) {
        this.method_5808(x, y, z, this.method_36454(), this.method_36455());
        this.method_23311();
        class_243 direction = new class_243(target.method_23317() - this.method_23317(), target.method_23318() - this.method_23318(), target.method_23321() - this.method_23321()).method_1029();
        double randX = class_3532.method_15366((class_5819)this.field_5974, (double)-1.0, (double)1.0) * (double)inaccuracy;
        double randY = class_3532.method_15366((class_5819)this.field_5974, (double)-1.0, (double)1.0) * (double)inaccuracy;
        double randZ = class_3532.method_15366((class_5819)this.field_5974, (double)-1.0, (double)1.0) * (double)inaccuracy;
        class_243 inaccurateDirection = new class_243(direction.field_1352 + randX, direction.field_1351 + randY, direction.field_1350 + randZ).method_1029();
        this.xPower = inaccurateDirection.field_1352 * (double)speed;
        this.yPower = inaccurateDirection.field_1351 * (double)speed;
        this.zPower = inaccurateDirection.field_1350 * (double)speed;
    }

    public void shoot(double x, double y, double z, double targetX, double targetY, double targetZ, float speed, float inaccuracy) {
        this.method_5808(x, y, z, this.method_36454(), this.method_36455());
        this.method_23311();
        class_243 direction = new class_243(targetX - this.method_23317(), targetY - this.method_23318(), targetZ - this.method_23321()).method_1029();
        double randX = class_3532.method_15366((class_5819)this.field_5974, (double)-1.0, (double)1.0) * (double)inaccuracy;
        double randY = class_3532.method_15366((class_5819)this.field_5974, (double)-1.0, (double)1.0) * (double)inaccuracy;
        double randZ = class_3532.method_15366((class_5819)this.field_5974, (double)-1.0, (double)1.0) * (double)inaccuracy;
        class_243 inaccurateDirection = new class_243(direction.field_1352 + randX, direction.field_1351 + randY, direction.field_1350 + randZ).method_1029();
        this.xPower = inaccurateDirection.field_1352 * (double)speed;
        this.yPower = inaccurateDirection.field_1351 * (double)speed;
        this.zPower = inaccurateDirection.field_1350 * (double)speed;
        this.method_18800(this.xPower, this.yPower, this.zPower);
        this.setVelocity(new class_243(this.xPower, this.yPower, this.zPower));
        this.transitionTo(VertexDomainAnimationState.SPIN);
        this.hasAppliedMovement = true;
    }

    public boolean method_5643(class_1282 damageSource, float f) {
        boolean bl;
        if (this.method_5679(damageSource)) {
            return false;
        }
        if (this.getDyingTick() > 0) {
            return false;
        }
        if (this.method_37908().field_9236 || this.method_31481()) {
            return true;
        }
        if (this.explosionImmune) {
            return false;
        }
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + f);
        this.method_5785();
        this.method_32875(class_5712.field_28736, damageSource.method_5529());
        boolean bl2 = bl = damageSource.method_5529() instanceof class_1657 && ((class_1657)damageSource.method_5529()).method_31549().field_7477;
        if (bl || this.getDamage() > this.health) {
            if (this.getLife() > 0) {
                this.setDyingTick(20);
                this.method_18382();
            } else {
                this.method_31472();
            }
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), 3.0f);
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15152, this.method_5634(), 1.0f, 2.0f);
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), DNLSounds.OVERCHARGED_REDSTONE_BLOCK_TNT_EXPLOSION.get(), this.method_5634(), 1.0f, 2.0f);
            ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11236, this.method_23317(), this.method_23318(), this.method_23321(), 5, 2.0, 2.0, 2.0, 0.0);
            ((class_3218)this.method_37908()).method_14199((class_2394)particleData, this.method_23317(), this.method_23318(), this.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        return true;
    }

    public class_4048 method_18377(class_4050 pose) {
        if (this.getDyingTick() > 0) {
            return class_4048.method_18385((float)0.0f, (float)0.0f);
        }
        return class_4048.method_18384((float)1.0f, (float)1.0f);
    }

    public void method_5879(float f) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        if (ANIMATION_STATE.equals(entityDataAccessor)) {
            VertexDomainAnimationState animationState = this.getAnimationState();
            this.resetAnimations();
            switch (animationState) {
                case IDLE: {
                    this.idleAnimationState.method_41324(this.field_6012);
                    break;
                }
                case SPIN: {
                    this.spinAnimationState.method_41324(this.field_6012);
                    break;
                }
                case IMPACT: {
                    this.impactAnimationState.method_41324(this.field_6012);
                }
            }
        }
        super.method_5674(entityDataAccessor);
    }

    private void resetAnimations() {
        this.idleAnimationState.method_41325();
        this.spinAnimationState.method_41325();
        this.impactAnimationState.method_41325();
    }

    public VertexDomainProjectileEntity transitionTo(VertexDomainAnimationState state) {
        switch (state) {
            case IDLE: {
                this.setAnimationState(VertexDomainAnimationState.IDLE);
                break;
            }
            case SPIN: {
                this.setAnimationState(VertexDomainAnimationState.SPIN);
                break;
            }
            case IMPACT: {
                this.setAnimationState(VertexDomainAnimationState.IMPACT);
            }
        }
        return this;
    }

    public Vector3f getVelocity() {
        return (Vector3f)this.field_6011.method_12789(VELOCITY);
    }

    public void setVelocity(class_243 vec3) {
        this.field_6011.method_12778(VELOCITY, (Object)vec3.method_46409());
    }

    public void setDamage(float f) {
        this.field_6011.method_12778(DAMAGE, (Object)Float.valueOf(f));
    }

    public float getDamage() {
        return ((Float)this.field_6011.method_12789(DAMAGE)).floatValue();
    }

    public void setHurtTime(int i) {
        this.field_6011.method_12778(HURT_TIME, (Object)i);
    }

    public int getHurtTime() {
        return (Integer)this.field_6011.method_12789(HURT_TIME);
    }

    public void setHurtDir(int i) {
        this.field_6011.method_12778(HURT_TIME_DIRECT, (Object)i);
    }

    public int getHurtDir() {
        return (Integer)this.field_6011.method_12789(HURT_TIME_DIRECT);
    }

    public float getHealth() {
        return this.health;
    }

    public void setHealth(float health) {
        this.health = health;
    }

    public void setDyingTick(int tick) {
        this.field_6011.method_12778(DYING_TICK, (Object)tick);
    }

    public int getDyingTick() {
        return (Integer)this.field_6011.method_12789(DYING_TICK);
    }

    public int getLife() {
        return this.life;
    }

    public int getImpactAnimationTimeOut() {
        return this.impactAnimationTimeOut;
    }

    public int getExpansionTick() {
        return this.expansionTick;
    }

    public void setRadius(int radius) {
        this.field_6011.method_12778(RADIUS, (Object)radius);
    }

    public int getRadius() {
        return (Integer)this.field_6011.method_12789(RADIUS);
    }

    public VertexDomainAnimationState getAnimationState() {
        return (VertexDomainAnimationState)((Object)this.field_6011.method_12789(ANIMATION_STATE));
    }

    public void setAnimationState(VertexDomainAnimationState state) {
        this.field_6011.method_12778(ANIMATION_STATE, (Object)state);
    }

    public static enum VertexDomainAnimationState {
        IDLE,
        SPIN,
        IMPACT;

    }
}

