/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.projectile;

import dev.hexnowloading.dungeonnowloading.block.VertexPillarBlock;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexOrbProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.ModelledProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.ProjectileUtils;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableAxisParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5134;

public class VertexPillarProjectileEntity
extends ModelledProjectileEntity {
    private static final float IMPACT_RANGE = 3.0f;
    private static final float DAMAGE = 5.0f;
    private static final float SHILED_DAMAGE_REDUCTION = 0.55f;
    private static final boolean SHIELD_PENETRATION = true;
    private static final int LIFETIME = 1000;
    private static final int LIFETIME_AFTER_LANDING = 3;
    private int tickCount = 1000;
    private int destroyCount;
    private boolean hasLanded = false;
    private boolean canSummonVertexOrb;
    private float damagePercentage;

    public VertexPillarProjectileEntity(class_1299<? extends VertexPillarProjectileEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    public VertexPillarProjectileEntity(class_1937 level, class_1309 livingEntity, float damagePercentage) {
        this((class_1299<? extends VertexPillarProjectileEntity>)DNLEntityTypes.VERTEX_PILLAR_PROJECTILE.get(), level);
        this.setOwner((class_1297)livingEntity);
        this.damagePercentage = damagePercentage;
        this.canSummonVertexOrb = false;
    }

    public VertexPillarProjectileEntity(class_1937 level, class_1309 livingEntity, float damagePercentage, boolean canSummonVertexOrb) {
        this((class_1299<? extends VertexPillarProjectileEntity>)DNLEntityTypes.VERTEX_PILLAR_PROJECTILE.get(), level);
        this.setOwner((class_1297)livingEntity);
        this.damagePercentage = damagePercentage;
        this.canSummonVertexOrb = canSummonVertexOrb;
    }

    protected void method_5693() {
    }

    @Override
    protected void tickProjectile() {
        ProjectileUtils.checkAndUnloadProjectile(this);
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1031(0.0, -0.04, 0.0));
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (this.method_24828()) {
            if (this.method_37908().field_9236) {
                return;
            }
            if (!this.hasLanded && !this.method_37908().method_8320(this.method_24515().method_10074()).method_26164(class_3481.field_17754) && this.destroyCount < 5 && this.method_37908().method_8651(this.method_24515().method_10074(), false, (class_1297)this)) {
                ++this.destroyCount;
                return;
            }
            if (!this.hasLanded) {
                class_238 aabb = this.method_5829().method_1014(3.0);
                List targets = this.method_37908().method_18467(class_1309.class, aabb);
                for (class_1309 mob : targets) {
                    this.pushNearbyMobs(mob);
                }
                if (this.method_37908().method_8320(this.method_24515().method_10074()).method_27852(this.getPillarBlock())) {
                    this.breakLogic();
                    this.method_31472();
                    return;
                }
                this.placePillarBlock();
                this.tickCount = 3;
                this.hasLanded = true;
            }
            if (this.tickCount <= 0) {
                this.method_31472();
                return;
            }
            --this.tickCount;
        } else {
            if (this.tickCount <= 0) {
                this.method_31472();
            }
            --this.tickCount;
        }
        this.method_18799(this.method_18798().method_1021(0.98));
    }

    private void breakLogic() {
        if (this.method_37908().field_9236) {
            return;
        }
        this.method_37908().method_22352(this.method_24515().method_10074(), false);
        if (this.canSummonVertexOrb) {
            VertexOrbProjectileEntity vertexOrbProjectileEntity = new VertexOrbProjectileEntity(this.method_37908(), (class_1309)this.method_24921(), 2);
            vertexOrbProjectileEntity.shoot(this.method_23317(), this.method_23318() - 2.0, this.method_23321(), this.method_23317(), vertexOrbProjectileEntity.method_23318() - 1.0, this.method_23321(), 1.0f, 0.02f);
            this.method_37908().method_8649((class_1297)vertexOrbProjectileEntity);
        }
    }

    private void pushNearbyMobs(class_1309 mob) {
        class_1657 player;
        float actualDamage = 5.0f;
        if (mob instanceof FairkeeperSerpentEntity) {
            return;
        }
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1309) {
            class_1309 owner = (class_1309)class_12972;
            actualDamage = (float)owner.method_26825(class_5134.field_23721) * this.damagePercentage;
        }
        if (mob instanceof class_1657 && (player = (class_1657)mob).method_6039()) {
            player.method_7284(true);
            actualDamage *= 0.45f;
        }
        double x = mob.method_23317() - this.method_23317();
        double z = mob.method_23321() - this.method_23321();
        double a = x * x + z * z;
        mob.method_5762(x / a * 6.0, (double)0.2f, z / a * 6.0);
        mob.method_5643(this.method_48923().method_48800((class_1297)this, (class_1309)this.method_24921()), actualDamage);
    }

    protected class_2248 getPillarBlock() {
        return DNLBlocks.VERTEX_PILLAR.get();
    }

    protected void placePillarBlock() {
        this.method_37908().method_8652(this.method_24515(), DNLBlocks.VERTEX_PILLAR.get().method_9564(), 3);
        this.method_37908().method_8652(this.method_24515().method_10084(), (class_2680)DNLBlocks.VERTEX_PILLAR.get().method_9564().method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609), 3);
        VertexPillarBlock.linkOnPlaced(this.method_37908(), this.method_24515());
        ((class_3218)this.method_37908()).method_14199((class_2394)new ScalableAxisParticleType.ScalableAxisParticleData(DNLParticleTypes.WHITE_SHOCKWAVE_PARTICLE.get(), 0, 90.0f, 5.0f), (double)((float)this.method_24515().method_10263() + 0.5f), (double)((float)this.method_24515().method_10264() + 0.01f), (double)((float)this.method_24515().method_10260() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), DNLSounds.FAIRKEEPER_OUROS_PILLAR_LAND.get(), this.method_5634(), 3.0f, 1.0f);
    }
}

