/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TickBaseMoveSet<T> {
    private int LOWEST_PRIORITY = 5;
    List<Move> moveSet = new ArrayList<Move>();

    public void addMove(T object, int priority, int cooldown, int initialCooldown) {
        Move move = new Move();
        move.object = object;
        move.priority = priority;
        move.cooldown = cooldown;
        move.currentCooldownTick = initialCooldown;
        this.moveSet.add(move);
    }

    public void removeMove(T removeObject) {
        this.moveSet.removeIf(move -> move.object.equals(removeObject));
    }

    public void tick() {
        for (Move move : this.moveSet) {
            if (move.currentCooldownTick <= 0) continue;
            --move.currentCooldownTick;
        }
    }

    public T selectMove() {
        Move choosenMove = new Move();
        choosenMove.priority = this.LOWEST_PRIORITY + 1;
        int i = 0;
        ArrayList<Move> moveList = new ArrayList<Move>(this.moveSet.stream().filter(move -> move.currentCooldownTick == 0).toList());
        if (moveList.isEmpty()) {
            moveList.addAll(this.moveSet);
        }
        Collections.shuffle(moveList);
        for (Move move2 : moveList) {
            if (choosenMove.priority <= move2.priority) continue;
            choosenMove = move2;
            i = this.moveSet.indexOf(move2);
        }
        this.moveSet.get((int)i).currentCooldownTick = this.moveSet.get((int)i).cooldown;
        return choosenMove.object;
    }

    public boolean isEmpty() {
        return this.moveSet.isEmpty();
    }

    public void clear() {
        this.moveSet.clear();
    }

    private class Move {
        T object;
        int priority;
        int cooldown;
        int currentCooldownTick;

        private Move() {
        }
    }
}

