/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.item;

import dev.hexnowloading.dungeonnowloading.config.GeneralConfig;
import dev.hexnowloading.dungeonnowloading.entity.passive.CopperCreepEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.supporter.DNLSupporters;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5244;
import org.jetbrains.annotations.Nullable;

public class CopperDetonatorItem
extends class_1792 {
    private static final double TRIGGER_RADIUS = 32.0;
    private static final int SUMMON_COOLDOWN = 5;
    private static final int IGNITE_COOLDOWN_PER_CREEP = 100;
    public static final int MODE_SWITCH_TIMING = 10;
    private static final String TAG_COSMETIC_MODE = "CosmeticMode";
    private static final String MODE_DEFAULT = "default";
    private static final String MODE_BUTLER = "butler";
    private static final String MODE_MIX = "mix";

    public CopperDetonatorItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 level = context.method_8045();
        class_2338 blockPos = context.method_8037();
        class_2680 blockState = level.method_8320(blockPos);
        class_1799 stack = context.method_8041();
        class_1657 player = context.method_8036();
        if (blockState.method_27852(class_2246.field_10302)) {
            if (!level.field_9236 && player != null && DNLSupporters.hasSkin(player.method_5667(), "copper_creep_butler")) {
                this.cycleCosmeticMode(stack);
                String modeName = CopperDetonatorItem.getCosmeticMode(stack);
                String capitalizedMode = modeName.substring(0, 1).toUpperCase() + modeName.substring(1);
                player.method_7353((class_2561)class_2561.method_43470((String)("Current Mode: " + capitalizedMode)).method_27692(class_124.field_1054), true);
            }
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    private void cycleCosmeticMode(class_1799 stack) {
        String current = CopperDetonatorItem.getCosmeticMode(stack);
        String next = current.equals(MODE_DEFAULT) ? MODE_BUTLER : (current.equals(MODE_BUTLER) ? MODE_MIX : MODE_DEFAULT);
        stack.method_7948().method_10582(TAG_COSMETIC_MODE, next);
    }

    public static String getCosmeticMode(class_1799 stack) {
        return stack.method_7948().method_10558(TAG_COSMETIC_MODE).isEmpty() ? MODE_DEFAULT : stack.method_7948().method_10558(TAG_COSMETIC_MODE);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        player.method_6019(hand);
        return class_1271.method_22431((Object)itemStack);
    }

    public void method_7852(class_1937 level, class_1309 livingEntity, class_1799 itemStack, int remainingUseTick) {
        int usedTime = itemStack.method_7935() - remainingUseTick;
        if (usedTime == 10) {
            livingEntity.method_43077(DNLSounds.COPPER_DETONATOR_READY.get());
        } else if (usedTime > 10 && (usedTime - 10) % 20 == 0) {
            livingEntity.method_43077(DNLSounds.COPPER_DETONATOR_BEEP.get());
        }
        super.method_7852(level, livingEntity, itemStack, remainingUseTick);
    }

    public class_1839 method_7853(class_1799 $$0) {
        return super.method_7853($$0);
    }

    public void method_7840(class_1799 itemStack, class_1937 level, class_1309 livingEntity, int remainingTicks) {
        int usedTime = itemStack.method_7935() - remainingTicks;
        if (!(livingEntity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)livingEntity;
        class_1268 hand = player.method_6058();
        List<CopperCreepEntity> creepsInRange = this.findNearbyCreeps(player, 32.0);
        if (usedTime <= 10) {
            if (creepsInRange.size() < 3 && this.consumeCopperBlockIfAvailable(player)) {
                this.launchCreep(level, player);
                player.method_7357().method_7906((class_1792)this, 5);
                itemStack.method_7956(1, (class_1309)player, player1 -> player1.method_20236(player1.method_6058()));
                player.method_6104(hand);
            }
        } else if (!creepsInRange.isEmpty()) {
            this.igniteCreeps(creepsInRange);
            player.method_7357().method_7906((class_1792)this, creepsInRange.size() * 100);
            player.method_6104(hand);
        }
        super.method_7840(itemStack, level, livingEntity, remainingTicks);
    }

    public int method_7881(class_1799 itemStack) {
        return 72000;
    }

    private void launchCreep(class_1937 level, class_1657 player) {
        CopperCreepEntity creep = (CopperCreepEntity)DNLEntityTypes.COPPER_CREEP.get().method_5883(level);
        if (creep == null) {
            return;
        }
        double offset = 1.0;
        double launchX = player.method_23317() - Math.sin(Math.toRadians(player.method_36454())) * offset;
        double launchY = player.method_23318() + (double)player.method_5751() * 0.6;
        double launchZ = player.method_23321() + Math.cos(Math.toRadians(player.method_36454())) * offset;
        creep.method_5808(launchX, launchY, launchZ, player.method_36454(), player.method_36455());
        double velocity = 1.0;
        double motionX = -Math.sin(Math.toRadians(player.method_36454())) * Math.cos(Math.toRadians(player.method_36455())) * velocity;
        double motionY = -Math.sin(Math.toRadians(player.method_36455())) * velocity;
        double motionZ = Math.cos(Math.toRadians(player.method_36454())) * Math.cos(Math.toRadians(player.method_36455())) * velocity;
        creep.method_18800(motionX, motionY, motionZ);
        creep.setSummonerUUID(player.method_5667());
        if (DNLSupporters.hasSkin(player.method_5667(), "copper_creep_butler")) {
            if (CopperDetonatorItem.getCosmeticMode(player.method_5998(class_1268.field_5808)).equals(MODE_MIX)) {
                if (Math.random() < 0.5) {
                    creep.setCosmeticMode(MODE_BUTLER);
                } else {
                    creep.setCosmeticMode(MODE_DEFAULT);
                }
            } else {
                creep.setCosmeticMode(CopperDetonatorItem.getCosmeticMode(player.method_5998(class_1268.field_5808)));
            }
        }
        creep.setSkinValidation(true);
        level.method_8649((class_1297)creep);
    }

    private List<CopperCreepEntity> findNearbyCreeps(class_1657 player, double radius) {
        return player.method_37908().method_18467(CopperCreepEntity.class, player.method_5829().method_1014(radius)).stream().filter(creep -> !creep.isDefused() && !creep.method_29504() && creep.getSummonerUUID().filter(uuid -> uuid.equals(player.method_5667())).isPresent() && player.method_5858((class_1297)creep) <= radius * radius).toList();
    }

    private boolean consumeCopperBlockIfAvailable(class_1657 player) {
        if (player.method_7337()) {
            return true;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7909() != class_1802.field_27071 || stack.method_7947() <= 0) continue;
            stack.method_7934(1);
            return true;
        }
        return false;
    }

    private void igniteCreeps(List<CopperCreepEntity> creeps) {
        creeps.forEach(CopperCreepEntity::ignite);
    }

    public void method_7851(class_1799 itemStack, @Nullable class_1937 level, List<class_2561> components, class_1836 tooltipFlag) {
        super.method_7851(itemStack, level, components, tooltipFlag);
        if (((Boolean)GeneralConfig.TOGGLE_HELPFUL_ITEM_TOOLTIP.get()).booleanValue()) {
            components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.copper_detonator.tooltip.ability_name").method_27692(class_124.field_1080));
            components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.copper_detonator.tooltip.ability_description").method_27692(class_124.field_1063));
            components.add(class_5244.field_39003);
            components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.copper_detonator.tooltip.right_click").method_27692(class_124.field_1080));
            components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.copper_detonator.tooltip.right_click.description").method_27692(class_124.field_1077));
            components.add(class_5244.field_39003);
            components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.copper_detonator.tooltip.hold_right_mouse_button").method_27692(class_124.field_1080));
            components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.copper_detonator.tooltip.hold_right_mouse_button.description").method_27692(class_124.field_1077));
        }
    }
}

