/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.item;

import dev.hexnowloading.dungeonnowloading.config.GeneralConfig;
import dev.hexnowloading.dungeonnowloading.entity.misc.RepulsorEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.supporter.DNLSupporters;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5244;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class RepulsorItem
extends class_1792 {
    private static final String TAG_COSMETIC_MODE = "CosmeticMode";
    private static final String MODE_DEFAULT = "default";
    private static final String MODE_GOLDEN = "golden";

    public RepulsorItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1269 method_7884(class_1838 ctx) {
        class_2350 face = ctx.method_8038();
        class_1937 level = ctx.method_8045();
        class_1799 stack = ctx.method_8041();
        class_1657 player = ctx.method_8036();
        class_2338 clickedPos = ctx.method_8037();
        if (level.method_8320(clickedPos).method_27852(class_2246.field_10205)) {
            if (!level.field_9236 && player != null) {
                boolean allowed;
                UUID uuid = player.method_5667();
                boolean bl = allowed = DNLSupporters.hasSkin(uuid, "repulsor_golden") || DNLSupporters.isSupporter(uuid);
                if (allowed) {
                    RepulsorItem.cycleCosmeticMode(stack);
                    String mode = RepulsorItem.getCosmeticMode(stack);
                    String nice = Character.toUpperCase(mode.charAt(0)) + mode.substring(1);
                    player.method_7353((class_2561)class_2561.method_43470((String)("Current Repulsor: " + nice)).method_27692(class_124.field_1054), true);
                }
            }
            return class_1269.field_5812;
        }
        if (face == class_2350.field_11033) {
            return class_1269.field_5814;
        }
        class_1750 placeCtx = new class_1750(ctx);
        class_2338 placePos = placeCtx.method_8037();
        class_243 center = class_243.method_24955((class_2382)placePos);
        class_238 aabb = DNLEntityTypes.REPULSOR.get().method_18386().method_30231(center.method_10216(), center.method_10214(), center.method_10215());
        if (!level.method_8587((class_1297)null, aabb) || !level.method_8335((class_1297)null, aabb).isEmpty()) {
            return class_1269.field_5814;
        }
        if (level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            Consumer consumer = class_1299.method_48009((class_3218)server, (class_1799)stack, (class_1657)ctx.method_8036());
            RepulsorEntity rep = (RepulsorEntity)DNLEntityTypes.REPULSOR.get().method_5888(server, stack.method_7969(), consumer, placePos, class_3730.field_16465, true, true);
            if (rep == null) {
                return class_1269.field_5814;
            }
            rep.method_5808(rep.method_23317(), rep.method_23318(), rep.method_23321(), 0.0f, 0.0f);
            rep.method_36456(0.0f);
            rep.method_5847(0.0f);
            rep.setShieldHealth(this.method_7841() - stack.method_7919());
            rep.setSourceStack(stack);
            boolean canGolden = player != null && (DNLSupporters.hasSkin(player.method_5667(), "repulsor_golden") || DNLSupporters.isSupporter(player.method_5667()));
            rep.setSkin(canGolden && RepulsorItem.isGoldenMode(stack) ? RepulsorEntity.Skin.GOLDEN : RepulsorEntity.Skin.DEFAULT);
            rep.setSkinValidation(true);
            server.method_30771((class_1297)rep);
            level.method_43128(null, rep.method_23317(), rep.method_23318(), rep.method_23321(), class_3417.field_14969, class_3419.field_15245, 0.75f, 0.8f);
            rep.method_32875(class_5712.field_28738, (class_1297)player);
        }
        stack.method_7934(1);
        return class_1269.method_29236((boolean)level.field_9236);
    }

    private static void cycleCosmeticMode(class_1799 stack) {
        String current = RepulsorItem.getCosmeticMode(stack);
        String next = current.equals(MODE_DEFAULT) ? MODE_GOLDEN : MODE_DEFAULT;
        stack.method_7948().method_10582(TAG_COSMETIC_MODE, next);
    }

    public static String getCosmeticMode(class_1799 stack) {
        String v = stack.method_7948().method_10558(TAG_COSMETIC_MODE);
        return v.isEmpty() ? MODE_DEFAULT : v;
    }

    public static boolean isGoldenMode(class_1799 stack) {
        return MODE_GOLDEN.equals(RepulsorItem.getCosmeticMode(stack));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> components, class_1836 flag) {
        super.method_7851(stack, level, components, flag);
        if (((Boolean)GeneralConfig.TOGGLE_HELPFUL_ITEM_TOOLTIP.get()).booleanValue()) {
            components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.repulsor.tooltip.ability_name").method_27692(class_124.field_1080));
            components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.repulsor.tooltip.ability_description").method_27692(class_124.field_1063));
            components.add(class_5244.field_39003);
            components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.repulsor.tooltip.right_click").method_27692(class_124.field_1080));
            components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.repulsor.tooltip.right_click.description").method_27692(class_124.field_1077));
            components.add(class_5244.field_39003);
            components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.repulsor.tooltip.right_click_with_redstone_dust").method_27692(class_124.field_1080));
            components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.repulsor.tooltip.right_click_with_redstone_dust.description").method_27692(class_124.field_1077));
        }
    }

    public static void setCosmeticMode(class_1799 stack, String mode) {
        stack.method_7948().method_10582(TAG_COSMETIC_MODE, mode);
    }

    public static void setGolden(class_1799 stack) {
        RepulsorItem.setCosmeticMode(stack, MODE_GOLDEN);
    }

    public static void setDefault(class_1799 stack) {
        RepulsorItem.setCosmeticMode(stack, MODE_DEFAULT);
    }

    public boolean method_7878(class_1799 stack, class_1799 repairItem) {
        return repairItem.method_31574(class_1802.field_8725) || super.method_7878(stack, repairItem);
    }
}

