/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.item.client.renderer;

import dev.hexnowloading.dungeonnowloading.item.ScorcherItem;
import dev.hexnowloading.dungeonnowloading.item.client.ItemAnimationState;
import dev.hexnowloading.dungeonnowloading.item.client.animation.ScorcherAnimation;
import dev.hexnowloading.dungeonnowloading.item.client.model.ScorcherModel;
import dev.hexnowloading.dungeonnowloading.network.ClientUtil;
import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_756;
import net.minecraft.class_811;

public class ScorcherRenderer
extends class_756 {
    private static final class_2960 TEXTURE_EMISSIVE_FLAME = new class_2960("dungeonnowloading", "textures/item/scorcher/scorcher_emissive_flame.png");
    private static final class_2960 TEXTURE_EMISSIVE_SOUL_FLAME = new class_2960("dungeonnowloading", "textures/item/scorcher/scorcher_emissive_soul_flame.png");
    private static final class_2960 TEXTURE_EMISSIVE_HEAT = new class_2960("dungeonnowloading", "textures/item/scorcher/scorcher_emissive_heat.png");
    private static final class_1921 RENDER_TYPE_EMISSIVE_FLAME = class_1921.method_23580((class_2960)TEXTURE_EMISSIVE_FLAME);
    private static final class_1921 RENDER_TYPE_EMISSIVE_SOUL_FLAME = class_1921.method_23580((class_2960)TEXTURE_EMISSIVE_SOUL_FLAME);
    private static final class_1921 RENDER_TYPE_EMISSIVE_HEAT = class_1921.method_23580((class_2960)TEXTURE_EMISSIVE_HEAT);
    private ScorcherModel model;

    public ScorcherRenderer() {
        super(ClientUtil.getClient().method_31975(), ClientUtil.getClient().method_31974());
    }

    public void method_3166(class_1799 itemStack, class_811 itemDisplayContext, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_1792 class_17922;
        poseStack.method_22903();
        if (this.model == null) {
            this.model = new ScorcherModel(ClientUtil.getClient().method_31974().method_32072(ScorcherModel.LAYER_LOCATION));
        }
        poseStack.method_22904(0.5, 1.5, 0.5);
        poseStack.method_22904(0.0, 0.0, 0.0);
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        float flameAlpha = 0.0f;
        float heatAlpha = 0.0f;
        class_4588 vertexConsumer = bufferSource.getBuffer(this.model.method_23500(ScorcherModel.TEXTURE));
        if (itemStack.method_31574(DNLItems.SOUL_SCORCHER.get())) {
            vertexConsumer = bufferSource.getBuffer(this.model.method_23500(ScorcherModel.TEXTURE_SOUL));
        }
        if ((class_17922 = itemStack.method_7909()) instanceof ScorcherItem) {
            ScorcherItem scorcherItem = (ScorcherItem)class_17922;
            class_1657 player = ClientUtil.getClientPlayer();
            if (player == null) {
                return;
            }
            this.animateOutsideInventory(player, itemStack, itemDisplayContext);
            this.model.setUpAnim(scorcherItem, player, itemStack, this.getPartialTick());
            flameAlpha = this.getFlameAlpha(player, itemStack);
            heatAlpha = this.getHeat(player, itemStack);
        }
        this.model.method_2828(poseStack, vertexConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        if (flameAlpha > 0.0f) {
            class_4588 emissiveFlame = bufferSource.getBuffer(RENDER_TYPE_EMISSIVE_FLAME);
            if (itemStack.method_31574(DNLItems.SOUL_SCORCHER.get())) {
                emissiveFlame = bufferSource.getBuffer(RENDER_TYPE_EMISSIVE_SOUL_FLAME);
            }
            this.model.method_2828(poseStack, emissiveFlame, 0xF000F0, packedOverlay, 1.0f, 1.0f, 1.0f, flameAlpha);
        }
        if (heatAlpha > 0.0f) {
            class_4588 emissiveHeat = bufferSource.getBuffer(RENDER_TYPE_EMISSIVE_HEAT);
            this.model.method_2828(poseStack, emissiveHeat, 0xF000F0, packedOverlay, 1.0f, 1.0f, 1.0f, heatAlpha);
        }
        poseStack.method_22909();
    }

    private boolean onlyRenderInHands(class_811 itemDisplayContext) {
        return itemDisplayContext == class_811.field_4321 || itemDisplayContext == class_811.field_4322 || itemDisplayContext == class_811.field_4323 || itemDisplayContext == class_811.field_4320;
    }

    private void animateOutsideInventory(class_1657 player, class_1799 stack, class_811 itemDisplayContext) {
        long currentGameTime;
        long storedGameTime = ScorcherItem.getTimeStamp(stack);
        if (storedGameTime == (currentGameTime = player.method_37908().method_8510())) {
            return;
        }
        if (itemDisplayContext != class_811.field_4318) {
            return;
        }
        if (!ItemAnimationState.isAnimating(stack, ScorcherItem.ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), currentGameTime)) {
            if (ItemAnimationState.isAnimating(stack, ScorcherItem.ScorcherAnimationState.SCORCHER_SHOOT.getName(), currentGameTime)) {
                ItemAnimationState.start(stack, ScorcherItem.ScorcherAnimationState.SCORCHER_STOP.getName(), currentGameTime, (long)(ScorcherAnimation.SCORCHER_STOP.comp_597() * 20.0f), false, true);
            } else if (!ItemAnimationState.isAnimating(stack, ScorcherItem.ScorcherAnimationState.SCORCHER_STOP.getName(), currentGameTime)) {
                ItemAnimationState.stopAll(stack);
            }
        }
    }

    private float getHeat(class_1657 player, class_1799 itemStack) {
        long storedGameTime = ScorcherItem.getTimeStamp(itemStack);
        long currentGameTime = player.method_37908().method_8510();
        float heatLevel = ScorcherItem.getHeatLevel(itemStack);
        if (storedGameTime == currentGameTime) {
            return Math.min(heatLevel, 1.0f);
        }
        long timeElapsed = currentGameTime - storedGameTime;
        float heatDecayPerTick = 0.008333334f;
        float newHeatLevel = Math.max(0.0f, heatLevel - (float)timeElapsed * heatDecayPerTick);
        return Math.min(newHeatLevel, 1.0f);
    }

    private float getFlameAlpha(class_1657 player, class_1799 itemStack) {
        long gameTime = player.method_37908().method_8510();
        float partialTick = this.getPartialTick();
        if (ItemAnimationState.isAnimatingOrHanging(itemStack, ScorcherItem.ScorcherAnimationState.SCORCHER_ACTIVATED.getName(), gameTime)) {
            return Math.min(ItemAnimationState.getProgress(itemStack, ScorcherItem.ScorcherAnimationState.SCORCHER_ACTIVATED.getName(), gameTime, this.getPartialTick()), 1.0f);
        }
        if (ItemAnimationState.isAnimatingOrHanging(itemStack, ScorcherItem.ScorcherAnimationState.SCORCHER_STOP.getName(), gameTime)) {
            return 1.0f - ItemAnimationState.getProgress(itemStack, ScorcherItem.ScorcherAnimationState.SCORCHER_STOP.getName(), gameTime, this.getPartialTick());
        }
        if (ItemAnimationState.isAnimatingOrHanging(itemStack, ScorcherItem.ScorcherAnimationState.SCORCHER_SHOOT.getName(), gameTime)) {
            return 1.0f;
        }
        if (ItemAnimationState.isAnimating(itemStack, ScorcherItem.ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), gameTime)) {
            float totalOverheatDuration = 160.0f;
            float fadeStartTime = 135.0f;
            float progress = ItemAnimationState.getProgress(itemStack, ScorcherItem.ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), gameTime, partialTick);
            float totalTicksElapsed = progress * totalOverheatDuration;
            if (totalTicksElapsed < fadeStartTime) {
                return 1.0f;
            }
            float fadeProgress = (totalTicksElapsed - fadeStartTime) / (totalOverheatDuration - fadeStartTime);
            return Math.max(0.0f, 1.0f - fadeProgress);
        }
        return 0.0f;
    }

    private float getPartialTick() {
        return ClientUtil.getClientLevel() != null ? ClientUtil.getClient().method_1488() : 0.0f;
    }

    public static ScorcherRenderer getInstance() {
        return new ScorcherRenderer();
    }
}

