/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.mixin.structures;

import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2810;
import net.minecraft.class_3195;
import net.minecraft.class_3233;
import net.minecraft.class_3449;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5588;
import net.minecraft.class_5589;
import net.minecraft.class_5821;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_5588.class})
public class NoGeodesInStructuresMixin {
    @Inject(method={"place(Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void dungeonnowloading_noGeodesInStructures(class_5821<class_5589> context, CallbackInfoReturnable<Boolean> cir) {
        class_5281 class_52812 = context.method_33652();
        if (!(class_52812 instanceof class_3233)) {
            return;
        }
        class_3233 worldGenRegion = (class_3233)class_52812;
        class_2378 structureRegistry = worldGenRegion.method_30349().method_30530(class_7924.field_41246);
        List<class_3449> starts = NoGeodesInStructuresMixin.getValidStructureStarts(worldGenRegion, context.method_33655(), structure -> structureRegistry.method_40264((class_5321)structureRegistry.method_29113(structure).get()).map(holder -> holder.method_40220(DNLTags.NO_GEODES_TAG)).orElse(false));
        if (!starts.isEmpty()) {
            cir.setReturnValue((Object)false);
        }
    }

    private static List<class_3449> getValidStructureStarts(class_3233 level, class_2338 pos, Predicate<class_3195> structureMatch) {
        class_5138 structureManager = level.method_8410().method_27056();
        class_4076 sectionPos = class_4076.method_18682((class_2338)pos);
        class_2791 chunk = level.method_22342(sectionPos.method_18674(), sectionPos.method_18687(), class_2806.field_16422);
        if (!chunk.method_51526().method_12165(class_2806.field_16422)) {
            return List.of();
        }
        Map references = chunk.method_12179();
        ArrayList<class_3449> list = new ArrayList<class_3449>();
        for (Map.Entry entry : references.entrySet()) {
            class_3195 structure = (class_3195)entry.getKey();
            LongSet refs = (LongSet)entry.getValue();
            if (!structureMatch.test(structure)) continue;
            NoGeodesInStructuresMixin.fillStartsForStructure((class_4538)level, structureManager, structure, refs, pos, list::add);
        }
        return list;
    }

    private static void fillStartsForStructure(class_4538 level, class_5138 structureManager, class_3195 structure, LongSet references, class_2338 pos, Consumer<class_3449> consumer) {
        LongIterator longIterator = references.iterator();
        while (longIterator.hasNext()) {
            class_3449 start;
            long ref = (Long)longIterator.next();
            class_4076 sectionPos = class_4076.method_18681((class_1923)new class_1923(ref), (int)level.method_32891());
            if (!level.method_8393(sectionPos.method_18674(), sectionPos.method_18687()) || (start = structureManager.method_26975(sectionPos, structure, (class_2810)level.method_22342(sectionPos.method_18674(), sectionPos.method_18687(), class_2806.field_16423))) == null || !start.method_16657() || !start.method_14969().method_14662((class_2382)pos)) continue;
            consumer.accept(start);
        }
    }
}

