/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.network.packets;

import dev.hexnowloading.dungeonnowloading.block.entity.PlayerStatueBlockEntity;
import dev.hexnowloading.dungeonnowloading.network.DNLPacket;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public class C2SPedestalUpdatePacket
implements DNLPacket {
    private static final int MAX_LINES = 4;
    private static final int MAX_CHARS_PER_LINE = 16;
    private static final double MAX_EDIT_DISTANCE_SQ = 4096.0;
    private final class_2338 pos;
    private final List<class_2561> lines;
    private final class_1767 color;
    private final boolean glowing;

    public C2SPedestalUpdatePacket(class_2338 pos, List<class_2561> lines, class_1767 color, boolean glowing) {
        this.pos = pos.method_10062();
        this.lines = C2SPedestalUpdatePacket.sanitize(lines);
        this.color = color != null ? color : class_1767.field_7963;
        this.glowing = glowing;
    }

    public C2SPedestalUpdatePacket(class_2540 buf) {
        this.pos = buf.method_10811();
        int n = Math.min(buf.method_10816(), 4);
        ArrayList<class_2561> tmp = new ArrayList<class_2561>(4);
        for (int i = 0; i < n; ++i) {
            tmp.add(buf.method_10808());
        }
        this.lines = C2SPedestalUpdatePacket.sanitize(tmp);
        int colorId = buf.method_10816();
        class_1767 c = class_1767.method_7791((int)colorId);
        this.color = c != null ? c : class_1767.field_7963;
        this.glowing = buf.readBoolean();
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10807(this.pos);
        buf.method_10804(this.lines.size());
        for (class_2561 c : this.lines) {
            buf.method_10805(c);
        }
        buf.method_10804(this.color.method_7789());
        buf.writeBoolean(this.glowing);
    }

    public static C2SPedestalUpdatePacket decode(class_2540 buf) {
        return new C2SPedestalUpdatePacket(buf);
    }

    @Override
    public void handle(@Nullable class_3222 sender) {
        System.out.println("[C2S Update] recv from " + sender.method_7334().getName() + " @ " + this.pos);
        if (sender == null) {
            return;
        }
        sender.field_13995.execute(() -> {
            class_1937 level = sender.method_37908();
            if (!level.method_8477(this.pos)) {
                return;
            }
            class_2586 be = level.method_8321(this.pos);
            if (!(be instanceof PlayerStatueBlockEntity)) {
                return;
            }
            PlayerStatueBlockEntity statue = (PlayerStatueBlockEntity)be;
            statue.applyTextUpdateFromClient(sender, this.lines, this.color, this.glowing);
        });
    }

    private static List<class_2561> sanitize(List<class_2561> in) {
        ArrayList<class_2561> out = new ArrayList<class_2561>(4);
        int n = Math.min(in != null ? in.size() : 0, 4);
        for (int i = 0; i < n; ++i) {
            String s;
            String string = s = in.get(i) != null ? in.get(i).getString() : "";
            if (s.length() > 16) {
                s = s.substring(0, 16);
            }
            out.add((class_2561)class_2561.method_43470((String)s));
        }
        while (out.size() < 4) {
            out.add((class_2561)class_2561.method_43473());
        }
        return out;
    }
}

