/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.network.packets;

import dev.hexnowloading.dungeonnowloading.network.ClientUtil;
import dev.hexnowloading.dungeonnowloading.network.DNLPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class S2CStructureDetectionPacket
implements DNLPacket {
    private final boolean insideStructure;
    private final int playerId;
    private static final Map<UUID, Boolean> playerStructureStatus = new HashMap<UUID, Boolean>();

    public S2CStructureDetectionPacket(boolean insideStructure, int playerId) {
        this.insideStructure = insideStructure;
        this.playerId = playerId;
    }

    @Override
    public void encode(class_2540 buffer) {
        buffer.writeBoolean(this.insideStructure);
        buffer.writeInt(this.playerId);
    }

    public static S2CStructureDetectionPacket decode(class_2540 buffer) {
        return new S2CStructureDetectionPacket(buffer.readBoolean(), buffer.readInt());
    }

    @Override
    public void handle(@Nullable class_3222 sender) {
        if (sender != null) {
            return;
        }
        if (ClientUtil.onClient()) {
            if (ClientUtil.getClientLevel() == null) {
                return;
            }
            class_1297 entity = ClientUtil.getClientLevel().method_8469(this.playerId);
            if (entity != null) {
                playerStructureStatus.put(entity.method_5667(), this.insideStructure);
            }
        }
    }

    public static boolean isClientInStructure() {
        if (ClientUtil.getClientPlayer() == null) {
            return false;
        }
        UUID clientUUID = ClientUtil.getClientPlayer().method_5667();
        return playerStructureStatus.getOrDefault(clientUUID, false);
    }
}

