/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.particle;

import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_310;

public class MendstonePickaxeParticleLogic {
    private static final int RADIUS = 10;
    private static final int INTERVAL_TICKS = 10;
    private static final int MAX_BLOCKS_PER_SCAN = 100;
    private static final int PARTICLES_PER_FACE = 1;

    public static void handleClientTick(class_310 mc) {
        if (mc == null || mc.field_1724 == null || mc.field_1687 == null) {
            return;
        }
        if (!mc.field_1724.method_6047().method_31574(DNLItems.MENDSTONE_PICKAXE.get())) {
            return;
        }
        if (mc.field_1687.method_8510() % 10L != 0L) {
            return;
        }
        class_2338 playerPos = mc.field_1724.method_24515();
        List<class_2338> targets = MendstonePickaxeParticleLogic.findNearbyDiamondOres((class_1937)mc.field_1687, playerPos, 10, 100);
        for (class_2338 pos : targets) {
            MendstonePickaxeParticleLogic.spawnParticlesOnExposedFaces((class_1937)mc.field_1687, pos, 1);
        }
    }

    private static List<class_2338> findNearbyDiamondOres(class_1937 level, class_2338 center, int radius, int limit) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        int r2 = radius * radius;
        for (int dx = -radius; dx <= radius && list.size() < limit; ++dx) {
            for (int dy = -radius; dy <= radius && list.size() < limit; ++dy) {
                for (int dz = -radius; dz <= radius && list.size() < limit; ++dz) {
                    class_2338 pos;
                    class_2680 state;
                    if (dx * dx + dy * dy + dz * dz > r2 || !(state = level.method_8320(pos = center.method_10069(dx, dy, dz))).method_27852(class_2246.field_10442) && !state.method_27852(class_2246.field_29029)) continue;
                    list.add(pos);
                }
            }
        }
        return list;
    }

    private static void spawnParticlesOnExposedFaces(class_1937 level, class_2338 pos, int perFace) {
        class_2680 state = level.method_8320(pos);
        if (!state.method_27852(class_2246.field_10442) && !state.method_27852(class_2246.field_29029)) {
            return;
        }
        for (class_2350 dir : class_2350.values()) {
            if (!MendstonePickaxeParticleLogic.isFaceExposed(level, pos, dir)) continue;
            for (int i = 0; i < perFace; ++i) {
                MendstonePickaxeParticleLogic.spawnFaceParticle(level, pos, dir);
            }
        }
    }

    private static boolean isFaceExposed(class_1937 level, class_2338 pos, class_2350 face) {
        class_2338 adjacent = pos.method_10093(face);
        class_2680 neighbor = level.method_8320(adjacent);
        return neighbor.method_26215() || !neighbor.method_26216((class_1922)level, adjacent);
    }

    private static void spawnFaceParticle(class_1937 level, class_2338 pos, class_2350 face) {
        double x = pos.method_10263();
        double y = pos.method_10264();
        double z = pos.method_10260();
        double u = level.field_9229.method_43058();
        double v = level.field_9229.method_43058();
        double OUT = 0.02;
        double px = 0.0;
        double py = 0.0;
        double pz = 0.0;
        switch (face) {
            case field_11036: {
                px = x + u;
                py = y + 1.0 + 0.02;
                pz = z + v;
                break;
            }
            case field_11033: {
                px = x + u;
                py = y - 0.02;
                pz = z + v;
                break;
            }
            case field_11043: {
                px = x + u;
                py = y + v;
                pz = z - 0.02;
                break;
            }
            case field_11035: {
                px = x + u;
                py = y + v;
                pz = z + 1.0 + 0.02;
                break;
            }
            case field_11039: {
                px = x - 0.02;
                py = y + u;
                pz = z + v;
                break;
            }
            case field_11034: {
                px = x + 1.0 + 0.02;
                py = y + u;
                pz = z + v;
            }
        }
        level.method_8406((class_2394)DNLParticleTypes.MENDING_RUNE_SHORT_PARTICLE.get(), px, py, pz, 0.0, 0.0, 0.0);
    }
}

