/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.platform;

import dev.hexnowloading.dungeonnowloading.DungeonNowLoading;
import dev.hexnowloading.dungeonnowloading.network.DNLPacket;
import dev.hexnowloading.dungeonnowloading.platform.services.NetworkHelper;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class FabricNetworkHelper
implements NetworkHelper {
    private final Map<Class<? extends DNLPacket>, class_2960> ids = new HashMap<Class<? extends DNLPacket>, class_2960>();

    private class_2960 getId(DNLPacket packet) {
        return Objects.requireNonNull(this.ids.get(packet.getClass()), "Used unregistered message!");
    }

    @Override
    public <T extends DNLPacket> void register(String name, Class<T> clazz, Function<class_2540, T> constructor) {
        class_2960 id = DungeonNowLoading.id(name);
        this.ids.put(clazz, id);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)id, (server, player, handler, buf, responseSender) -> {
            DNLPacket packet = (DNLPacket)constructor.apply(buf);
            server.execute(() -> packet.handle(player));
        });
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientProxy.register(id, constructor);
        }
    }

    @Override
    public void sendToPlayer(DNLPacket packet, class_3222 player) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        packet.encode(buffer);
        ServerPlayNetworking.send((class_3222)player, (class_2960)this.getId(packet), (class_2540)buffer);
    }

    @Override
    public void sendToAllPlayers(DNLPacket packet, MinecraftServer server) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        packet.encode(buffer);
        for (class_3222 player : PlayerLookup.all((MinecraftServer)server)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)this.getId(packet), (class_2540)buffer);
        }
    }

    @Override
    public void sendToServer(DNLPacket packet) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        packet.encode(buffer);
        ClientPlayNetworking.send((class_2960)this.getId(packet), (class_2540)buffer);
    }

    private static final class ClientProxy {
        private ClientProxy() {
        }

        public static <T extends DNLPacket> void register(class_2960 id, Function<class_2540, T> constructor) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)id, (client, ignore1, buffer, ignore2) -> {
                DNLPacket packet = (DNLPacket)constructor.apply(buffer);
                client.execute(() -> packet.handle(null));
            });
        }
    }
}

