/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.sound;

import dev.hexnowloading.dungeonnowloading.sound.DNLTickingSound;
import dev.hexnowloading.dungeonnowloading.sound.EntityTickingSound;
import dev.hexnowloading.dungeonnowloading.sound.TickingSoundTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;

public class DNLClientSoundHandler {
    private static final Map<class_2960, Map<Integer, Map<Integer, List<class_1101>>>> activeSounds = new HashMap<class_2960, Map<Integer, Map<Integer, List<class_1101>>>>();

    public static void playTickingSound(class_2960 soundId, class_3419 soundSource, class_1297 entity, int tagId, float volume, float pitch, boolean stopWhenOutOfRange, float range, float fadeStartDistance) {
        class_3414 sound = (class_3414)class_7923.field_41172.method_10223(soundId);
        if (sound == null) {
            return;
        }
        int entityId = entity.method_5628();
        Map entityMap = activeSounds.computeIfAbsent(soundId, k -> new HashMap());
        Map tagMap = entityMap.computeIfAbsent(entityId, k -> new HashMap());
        if (tagId == -1) {
            tagId = tagMap.keySet().stream().mapToInt(i -> i).max().orElse(-1) + 1;
        }
        EntityTickingSound instance = new EntityTickingSound(sound, soundSource, entity, volume, pitch, stopWhenOutOfRange, range, fadeStartDistance);
        class_310.method_1551().method_1483().method_4873((class_1113)instance);
        tagMap.computeIfAbsent(tagId, k -> new ArrayList()).add(instance);
    }

    public static void fadeInTickingSound(class_2960 soundId, int entityId, TickingSoundTarget target, int specificTagId, float maxVolume, int fadeInTicks) {
        Map<Integer, Map<Integer, List<class_1101>>> entityMap = activeSounds.get(soundId);
        if (entityMap == null) {
            return;
        }
        Map<Integer, List<class_1101>> tagMap = entityMap.get(entityId);
        if (tagMap == null || tagMap.isEmpty()) {
            return;
        }
        if (target == TickingSoundTarget.ALL) {
            for (List<class_1101> list : tagMap.values()) {
                for (class_1101 instance : list) {
                    if (!(instance instanceof DNLTickingSound)) continue;
                    DNLTickingSound dnl = (DNLTickingSound)instance;
                    dnl.startFadingIn(maxVolume, fadeInTicks);
                }
            }
            return;
        }
        int tagId = DNLClientSoundHandler.resolveTagId(target, tagMap, specificTagId);
        if (tagId == -1) {
            return;
        }
        List<class_1101> list = tagMap.get(tagId);
        if (list == null) {
            return;
        }
        for (class_1101 instance : list) {
            if (!(instance instanceof DNLTickingSound)) continue;
            DNLTickingSound dnl = (DNLTickingSound)instance;
            dnl.startFadingIn(maxVolume, fadeInTicks);
        }
    }

    public static void fadeOutTickingSound(class_2960 soundId, int entityId, TickingSoundTarget target, int specificTagId, int fadeTicks, boolean shouldStop) {
        Map<Integer, Map<Integer, List<class_1101>>> entityMap = activeSounds.get(soundId);
        if (entityMap == null) {
            return;
        }
        Map<Integer, List<class_1101>> tagMap = entityMap.get(entityId);
        if (tagMap == null || tagMap.isEmpty()) {
            return;
        }
        if (target == TickingSoundTarget.ALL) {
            for (List<class_1101> list : tagMap.values()) {
                for (class_1101 instance : list) {
                    if (!(instance instanceof DNLTickingSound)) continue;
                    DNLTickingSound dnl = (DNLTickingSound)instance;
                    dnl.startFadingOut(shouldStop, fadeTicks);
                }
            }
            entityMap.remove(entityId);
            if (entityMap.isEmpty()) {
                activeSounds.remove(soundId);
            }
            return;
        }
        int tagId = DNLClientSoundHandler.resolveTagId(target, tagMap, specificTagId);
        if (tagId == -1) {
            return;
        }
        List<class_1101> list = tagMap.remove(tagId);
        if (list == null) {
            return;
        }
        for (class_1101 instance : list) {
            if (!(instance instanceof DNLTickingSound)) continue;
            DNLTickingSound dnl = (DNLTickingSound)instance;
            dnl.startFadingOut(shouldStop, fadeTicks);
        }
        if (tagMap.isEmpty()) {
            entityMap.remove(entityId);
        }
        if (entityMap.isEmpty()) {
            activeSounds.remove(soundId);
        }
    }

    private static int resolveTagId(TickingSoundTarget target, Map<Integer, List<class_1101>> tagMap, int specificTagId) {
        return switch (target) {
            default -> throw new IncompatibleClassChangeError();
            case TickingSoundTarget.OLDEST -> tagMap.keySet().stream().min(Integer::compareTo).orElse(-1);
            case TickingSoundTarget.NEWEST -> tagMap.keySet().stream().max(Integer::compareTo).orElse(-1);
            case TickingSoundTarget.SPECIFIC -> specificTagId;
            case TickingSoundTarget.ALL -> throw new IllegalStateException("ALL is not a valid target for resolveTagId");
        };
    }

    public static boolean isTickingSoundActive(class_2960 soundId) {
        Map<Integer, Map<Integer, List<class_1101>>> entityMap = activeSounds.get(soundId);
        if (entityMap == null || entityMap.isEmpty()) {
            return false;
        }
        for (Map<Integer, List<class_1101>> tagMap : entityMap.values()) {
            for (List<class_1101> instances : tagMap.values()) {
                for (class_1101 instance : instances) {
                    if (instance.method_4793()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

