/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.sound;

import dev.hexnowloading.dungeonnowloading.sound.DNLTickingSound;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_746;

public class EntityTickingSound
extends class_1101
implements DNLTickingSound {
    private static final float MINIMUM_AUDIBLE_VOLUME = 0.01f;
    protected final class_1297 entity;
    private boolean fadingOut = false;
    private boolean fadingIn = false;
    private final float fadeStartDistance;
    private boolean stopWhenOutOfRange = true;
    private boolean shouldStop = false;
    private int fadeTicks = 20;
    private int currentFade = 0;
    private final float range;
    private float maxVolume;
    private float fadeVolume = 1.0f;
    private float distanceVolume = 1.0f;

    public EntityTickingSound(class_3414 sound, class_3419 soundSource, class_1297 entity, float maxVolume, float pitch, boolean stopWhenOutOfRange, float range, float fadeStartDistance) {
        super(sound, soundSource, class_1113.method_43221());
        this.entity = entity;
        this.field_5446 = false;
        this.maxVolume = maxVolume;
        this.field_5441 = pitch;
        this.stopWhenOutOfRange = stopWhenOutOfRange;
        this.range = range;
        this.fadeStartDistance = fadeStartDistance;
        this.field_5439 = entity.method_23317();
        this.field_5450 = entity.method_23318();
        this.field_5449 = entity.method_23321();
        this.field_5442 = this.maxVolume == 0.0f ? 0.01f : this.maxVolume;
    }

    public EntityTickingSound(class_3414 sound, class_3419 soundSource, class_1297 entity, float maxVolume, float pitch, boolean stopWhenOutOfRange, float range) {
        this(sound, soundSource, entity, maxVolume, pitch, stopWhenOutOfRange, range, 0.0f);
    }

    public void method_16896() {
        this.field_5439 = this.entity.method_23317();
        this.field_5450 = this.entity.method_23318();
        this.field_5449 = this.entity.method_23321();
        class_746 localPlayer = class_310.method_1551().field_1724;
        if (localPlayer != null && !localPlayer.equals((Object)this.entity)) {
            float distance = localPlayer.method_5739(this.entity);
            if (this.stopWhenOutOfRange && distance > this.range) {
                this.method_24876();
                return;
            }
            if (distance <= this.fadeStartDistance) {
                this.distanceVolume = 1.0f;
            } else {
                float maxFadeDistance = 2.0f * this.range - this.fadeStartDistance;
                float fadeDistance = Math.min(distance - this.fadeStartDistance, maxFadeDistance);
                this.distanceVolume = Math.max(0.0f, 1.0f - fadeDistance / maxFadeDistance);
            }
        } else {
            this.distanceVolume = 1.0f;
        }
        if (this.fadingIn) {
            ++this.currentFade;
            this.fadeVolume = (float)this.currentFade / (float)this.fadeTicks;
            if (this.currentFade >= this.fadeTicks) {
                this.fadeVolume = 1.0f;
                this.fadingIn = false;
            }
        }
        if (this.fadingOut) {
            ++this.currentFade;
            this.fadeVolume = 1.0f - (float)this.currentFade / (float)this.fadeTicks;
            if ((this.shouldStop || this.stopWhenOutOfRange) && this.currentFade >= this.fadeTicks) {
                this.method_24876();
                return;
            }
        }
        this.field_5442 = this.maxVolume * this.fadeVolume * this.distanceVolume;
        if (!this.entity.method_5805()) {
            this.method_24876();
        }
    }

    @Override
    public void startFadingOut(boolean shouldStop, int fadeTicks) {
        this.fadingOut = true;
        this.shouldStop = shouldStop;
        this.fadeTicks = fadeTicks;
        this.currentFade = 0;
    }

    @Override
    public void startFadingIn(float maxVolume, int fadeTicks) {
        this.fadingIn = true;
        this.maxVolume = maxVolume;
        this.fadeTicks = fadeTicks;
        this.currentFade = 0;
    }

    @Override
    public void stopExternally() {
        this.method_24876();
    }
}

